/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.list.ListCardView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.pc.helper.UserAdvertRelHelper;

public class FavoriteAdvertCollectList
extends HRDataBaseList {
    private List<Long> collectIds;
    private List<Long> noWorkAddrIds;
    private Map<Long, String> workCity;

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObject[] adverts;
        this.collectIds = UserAdvertRelHelper.getCollectionAdvert();
        DynamicObjectCollection pageData = event.getPageData();
        List advertIds = pageData.stream().map(data -> data.getLong("advert.id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", advertIds);
        for (DynamicObject data2 : adverts = AdvertDetailExDataHelper.getInstance().getAdvertListByFilter(new QFilter[]{idFilter}, "id,workaddr")) {
            String cityName;
            DynamicObjectCollection workaddrs = data2.getDynamicObjectCollection("workaddr");
            if (workaddrs == null || workaddrs.size() == 0) {
                if (this.noWorkAddrIds == null) {
                    this.noWorkAddrIds = Lists.newArrayListWithCapacity((int)16);
                }
                this.noWorkAddrIds.add(data2.getLong("id"));
                continue;
            }
            Set cities = workaddrs.stream().filter(workaddr -> workaddr.getDynamicObject("fbasedataid") != null).map(workaddr -> workaddr.getDynamicObject("fbasedataid").getString("city.name")).collect(Collectors.toSet());
            StringBuilder stringBuilder = new StringBuilder();
            for (String city : cities) {
                stringBuilder.append(city).append(",");
            }
            if (this.workCity == null) {
                this.workCity = Maps.newHashMapWithExpectedSize((int)16);
            }
            if (HRStringUtils.isEmpty((String)(cityName = HRStringUtils.substringBeforeLast((String)stringBuilder.toString(), (String)",")))) {
                if (this.noWorkAddrIds == null) {
                    this.noWorkAddrIds = Lists.newArrayListWithCapacity((int)16);
                }
                this.noWorkAddrIds.add(data2.getLong("id"));
                continue;
            }
            this.workCity.put(data2.getLong("id"), cityName);
        }
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = event.getRowData();
        Long id = rowData.getLong("advert.id");
        if (HRStringUtils.equals((String)fieldKey, (String)"advert.isreward")) {
            if (this.collectIds != null && this.collectIds.contains(id)) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"advert.issalarynego")) {
            if (this.noWorkAddrIds != null && this.noWorkAddrIds.contains(id)) {
                event.setFormatValue((Object)false);
            } else {
                event.setFormatValue((Object)true);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"advert.iseduempty")) {
            if (rowData.get("advert.education") == null) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"advert.isworkyearempty")) {
            int workexpdown = rowData.getInt("advert.workexpdown");
            int workexpup = rowData.getInt("advert.workexpup");
            if (workexpup == 0 && workexpdown == 0) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"bar_collect", "bar_uncollect"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void click(EventObject evt) {
        super.click(evt);
        ListCardView cardview = (ListCardView)this.getView().getControl("cardview");
        Control vector = (Control)evt.getSource();
        String key = vector.getKey();
        IFormView view = ((Control)cardview.getItems().get(0)).getView();
        Long relId = (Long)((ListView)view).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_useradvertrel");
        DynamicObject advert = serviceHelper.queryOriginalOne("advert", (Object)relId);
        Long advertId = advert.getLong("advert");
        if (HRStringUtils.equals((String)key, (String)"bar_collect")) {
            boolean result = UserAdvertRelHelper.collectionAdvert((Long)advertId);
            if (result) {
                view.setVisible(Boolean.FALSE, new String[]{"collect"});
                view.setVisible(Boolean.TRUE, new String[]{"uncollect"});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002\u8bf7\u5728\u201c\u6211\u7684\u6536\u85cf\u201d\u4e2d\u67e5\u770b\u3002", (String)"OpenAdvertCollectList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u4e0b\u7ebf", (String)"OpenAdvertCollectList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)key, (String)"bar_uncollect")) {
            UserAdvertRelHelper.unCollectionAdvert((Long)advertId);
            view.setVisible(Boolean.TRUE, new String[]{"collect"});
            view.setVisible(Boolean.FALSE, new String[]{"uncollect"});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf", (String)"OpenAdvertCollectList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.getCustomParams().remove("searchkey");
        Button button = (Button)this.getControl("buttonap");
        if (button != null) {
            button.click();
        }
    }
}

