/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.pc.helper.UserAdvertRelHelper;
import kd.tsc.tsirm.common.enums.pc.UserAdvertRelTypeEnum;
import org.apache.commons.lang3.ObjectUtils;

public class FavoriteAdvertList
extends HRDataBaseList {
    private static Map<Long, DynamicObject> workAddrMap = new HashMap<Long, DynamicObject>(16);

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        List collectionAdvert = UserAdvertRelHelper.getCollectionAdvert();
        if (collectionAdvert == null || collectionAdvert.size() == 0) {
            FormShowParameter formShowParameter = this.createFormShowParameter("tsirm_favoriteadvertempty", "favoriteadvertpanel", null);
            this.getView().showForm(formShowParameter);
        }
    }

    public void setFilter(SetFilterEvent event) {
        List collectionAdvert = UserAdvertRelHelper.getCollectionAdvert();
        QFilter idFilter = new QFilter("advert", "in", (Object)collectionAdvert);
        long userId = RequestContext.get().getCurrUserId();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter typeFilter = new QFilter("type", "=", (Object)UserAdvertRelTypeEnum.COLLECTION.getType());
        event.getQFilters().add(idFilter);
        event.getQFilters().add(userFilter);
        event.getQFilters().add(typeFilter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        Long relId = (Long)((ListView)this.getView()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_useradvertrel");
        DynamicObject advert = serviceHelper.queryOriginalOne("advert", (Object)relId);
        Long advertId = advert.getLong("advert");
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_openadvertnew");
        showParameter.setPkId((Object)advertId);
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FavoriteAdvertList"));
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
        this.getView().showForm((FormShowParameter)showParameter);
        event.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }

    private FormShowParameter createFormShowParameter(String formId, String target, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        if (params != null && params.size() > 0) {
            params.forEach((arg_0, arg_1) -> ((FormShowParameter)showParameter).setCustomParam(arg_0, arg_1));
        }
        return showParameter;
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        ColumnDesc source = (ColumnDesc)e.getSource();
        String fieldKey = source.getFieldKey();
        if ("advert.workaddr.name".equals(fieldKey)) {
            DynamicObjectCollection workAddrColl = rowData.getDynamicObject("advert").getDynamicObjectCollection("workaddr");
            if (ObjectUtils.isNotEmpty((Object)workAddrColl)) {
                HashSet<Long> cityIdSet = new HashSet<Long>(16);
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < workAddrColl.size(); ++i) {
                    long workAddrId = ((DynamicObject)workAddrColl.get(i)).getLong("fbasedataid.id");
                    if (workAddrMap.get(workAddrId) == null || !cityIdSet.add(workAddrMap.get(workAddrId).getLong("city.id"))) continue;
                    stringBuilder.append(workAddrMap.get(workAddrId).getString("city.name"));
                    if (i == workAddrColl.size() - 1) continue;
                    stringBuilder.append(";");
                }
                e.setFormatValue((Object)stringBuilder.toString());
            } else {
                e.setFormatValue((Object)"");
            }
        }
    }

    static {
        DynamicObject[] workplaceDys = HRBaseServiceHelper.create((String)"hbss_workplace").loadDynamicObjectArray(null);
        if (ObjectUtils.isNotEmpty((Object)workplaceDys)) {
            for (DynamicObject workplaceDy : workplaceDys) {
                workAddrMap.put(workplaceDy.getLong("id"), workplaceDy);
            }
        }
    }
}

