/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.list.ListCardView;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.pc.helper.UserAdvertRelHelper;

public class OpenAdvertCollectList
extends HRDataBaseList {
    private List<Long> collectIds;
    private List<Long> noWorkAddrIds;
    private Map<Long, String> workCity;

    public void beforePackageData(BeforePackageDataEvent event) {
        this.collectIds = UserAdvertRelHelper.getCollectionAdvert();
        DynamicObjectCollection pageData = event.getPageData();
        for (DynamicObject data : pageData) {
            DynamicObjectCollection workaddrs = data.getDynamicObjectCollection("workaddr");
            if (workaddrs == null || workaddrs.size() == 0) {
                if (this.noWorkAddrIds == null) {
                    this.noWorkAddrIds = Lists.newArrayListWithCapacity((int)16);
                }
                this.noWorkAddrIds.add(data.getLong("id"));
                continue;
            }
            Set cities = workaddrs.stream().map(workaddr -> workaddr.getDynamicObject("fbasedataid").getString("city.name")).collect(Collectors.toSet());
            StringBuilder stringBuilder = new StringBuilder();
            for (String city : cities) {
                stringBuilder.append(city).append(",");
            }
            if (this.workCity == null) {
                this.workCity = Maps.newHashMapWithExpectedSize((int)16);
            }
            this.workCity.put(data.getLong("id"), HRStringUtils.substringBeforeLast((String)stringBuilder.toString(), (String)","));
        }
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = event.getRowData();
        Long id = (Long)rowData.getPkValue();
        if (HRStringUtils.equals((String)fieldKey, (String)"isreward")) {
            if (this.collectIds != null && this.collectIds.contains(id)) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"issalarynego")) {
            if (this.noWorkAddrIds != null && this.noWorkAddrIds.contains(id)) {
                event.setFormatValue((Object)false);
            } else {
                event.setFormatValue((Object)true);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"workaddr.city.name")) {
            String city;
            if (this.workCity != null && HRStringUtils.isNotEmpty((String)(city = this.workCity.get(id)))) {
                event.setFormatValue((Object)city);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"iseduempty")) {
            if (rowData.get("education") == null) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        } else if (HRStringUtils.equals((String)fieldKey, (String)"isworkyearempty")) {
            int workexpdown = rowData.getInt("workexpdown");
            int workexpup = rowData.getInt("workexpup");
            if (workexpup == 0 && workexpdown == 0) {
                event.setFormatValue((Object)true);
            } else {
                event.setFormatValue((Object)false);
            }
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"bar_collect", "bar_uncollect"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void click(EventObject evt) {
        super.click(evt);
        ListCardView cardview = (ListCardView)this.getView().getControl("cardview");
        Control vector = (Control)evt.getSource();
        String key = vector.getKey();
        IFormView view = ((Control)cardview.getItems().get(0)).getView();
        Long advertId = (Long)((ListView)view).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        if (HRStringUtils.equals((String)key, (String)"bar_collect")) {
            boolean result = UserAdvertRelHelper.collectionAdvert((Long)advertId);
            if (result) {
                view.setVisible(Boolean.FALSE, new String[]{"collect"});
                view.setVisible(Boolean.TRUE, new String[]{"uncollect"});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002\u8bf7\u5728\u201c\u6211\u7684\u6536\u85cf\u201d\u4e2d\u67e5\u770b\u3002", (String)"OpenAdvertCollectList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u4e0b\u7ebf", (String)"OpenAdvertCollectList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)key, (String)"bar_uncollect")) {
            UserAdvertRelHelper.unCollectionAdvert((Long)advertId);
            view.setVisible(Boolean.TRUE, new String[]{"collect"});
            view.setVisible(Boolean.FALSE, new String[]{"uncollect"});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf", (String)"OpenAdvertCollectList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.remove("searchkey");
        this.getView().updateView("billlistap");
    }
}

