/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intreco.service.IntrecoPageHelper;

public class OpenAdvertEdit
extends HRDataBaseEdit {
    private static final String TITLE_NAME_OPEN_COLOR = "#212121";
    private static final String COMMON_CLOSE_COLOR = "#999999";
    private static final String COMMON_OPEN_COLOR = "#666666";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        Long advertId = (Long)((BaseShowParameter)args.getFormShowParameter()).getPkId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertdetailex");
        DynamicObject fullname = serviceHelper.queryOne("fullname", (Object)advertId);
        args.getFormShowParameter().setCaption(fullname.getString("fullname"));
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.renderHeadData();
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.setRecruitNum();
        this.setEducation();
        this.setWorkExp();
        this.setWorkCity();
        this.setAdminorgsdpt();
        IntrecoPageHelper.isShowElement((IFormView)this.getView(), (String)"istop", (String[])new String[]{"title_istop"});
        IntrecoPageHelper.isShowElement((IFormView)this.getView(), (String)"isurgent", (String[])new String[]{"title_isurgent"});
        OrmLocaleValue poshighlight = (OrmLocaleValue)this.getModel().getValue("poshighlight");
        String localeValue = poshighlight.getLocaleValue();
        if (HRStringUtils.isEmpty((String)localeValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap3"});
        }
        this.getModel().setDataChanged(false);
        this.setColorByAdvertStatus("title_name", TITLE_NAME_OPEN_COLOR, COMMON_CLOSE_COLOR);
        this.setColorByAdvertStatus("refreshtime", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
    }

    private void setAdminorgsdpt() {
        DynamicObjectCollection adminorgsdpt = (DynamicObjectCollection)this.getModel().getValue("adminorgsdpt");
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject org : adminorgsdpt) {
            DynamicObject dyn = org.getDynamicObject("fbasedataid");
            if (dyn == null) continue;
            String city = dyn.getString("name");
            orgSet.add(city);
        }
        Label lbl_org = (Label)this.getView().getControl("lbl_org");
        if (orgSet.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap999"});
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String org : orgSet) {
            stringBuilder.append(org).append(",");
        }
        lbl_org.setText(HRStringUtils.substringBeforeLast((String)stringBuilder.toString(), (String)","));
        this.setColorByAdvertStatus("lbl_org", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
    }

    private void setColorByAdvertStatus(String controlKey, String openColor, String closeColor) {
        String status = (String)this.getModel().getValue("advertstatus");
        if (HRStringUtils.equals((String)status, (String)"D")) {
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
            fieldMap.put("fc", closeColor);
            this.getView().updateControlMetadata(controlKey, (Map)fieldMap);
        } else {
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
            fieldMap.put("fc", openColor);
            this.getView().updateControlMetadata(controlKey, (Map)fieldMap);
        }
    }

    private void renderHeadData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        OrmLocaleValue advName = (OrmLocaleValue)dataEntity.get("fullname");
        this.getModel().setValue("title_name", (Object)advName);
    }

    private void setEducation() {
        DynamicObject education = (DynamicObject)this.getModel().getValue("education");
        if (education != null) {
            Label lbl_education = (Label)this.getView().getControl("lbl_education");
            lbl_education.setText(education.getString("name"));
        } else {
            boolean isedulimit = this.getModel().getDataEntity().getBoolean("isedulimit");
            if (!isedulimit) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap911"});
            }
        }
        this.setColorByAdvertStatus("lbl_education", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
        this.setColorByAdvertStatus("lbl_isedulimit", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
    }

    private void setRecruitNum() {
        BigDecimal recruitnum = (BigDecimal)this.getModel().getValue("recruitnum");
        Label lbl_recruitnum = (Label)this.getView().getControl("lbl_recruitnum");
        String msg = ResManager.loadKDString((String)"\u62db\u8058%s\u4eba", (String)"OpenAdvertEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        lbl_recruitnum.setText(String.format(Locale.ROOT, msg, recruitnum));
    }

    private void setWorkExp() {
        Integer workexpdown = (Integer)this.getModel().getValue("workexpdown");
        Integer workexpup = (Integer)this.getModel().getValue("workexpup");
        Label lbl_workexp = (Label)this.getView().getControl("lbl_workexp");
        if (!workexpdown.equals(0) && !workexpup.equals(0)) {
            String workMsg = ResManager.loadKDString((String)"%s-%s\u5e74", (String)"OpenAdvertEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            lbl_workexp.setText(String.format(Locale.ROOT, workMsg, workexpdown, workexpup));
        } else if (!workexpdown.equals(0)) {
            String workMsg = ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0a", (String)"OpenAdvertEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            lbl_workexp.setText(String.format(Locale.ROOT, workMsg, workexpdown));
        } else if (!workexpup.equals(0)) {
            String workMsg = ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0b", (String)"OpenAdvertEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            lbl_workexp.setText(String.format(Locale.ROOT, workMsg, workexpup));
        } else if (!this.getModel().getDataEntity().getBoolean("isworkexplimit")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap9111"});
        }
        this.setColorByAdvertStatus("lbl_workexp", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
        this.setColorByAdvertStatus("lbl_isworkexplimit", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
    }

    private void setWorkCity() {
        DynamicObjectCollection workaddrs = (DynamicObjectCollection)this.getModel().getValue("workaddr");
        HashSet cities = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject workaddr : workaddrs) {
            DynamicObject dyn = workaddr.getDynamicObject("fbasedataid");
            if (dyn == null) continue;
            String city = dyn.getString("city.name");
            cities.add(city);
        }
        Label lbl_workcity = (Label)this.getView().getControl("lbl_workcity");
        if (cities.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap91"});
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String city : cities) {
            stringBuilder.append(city).append(",");
        }
        lbl_workcity.setText(HRStringUtils.substringBeforeLast((String)stringBuilder.toString(), (String)","));
        this.setColorByAdvertStatus("lbl_workcity", COMMON_OPEN_COLOR, COMMON_CLOSE_COLOR);
    }
}

