/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsrbd.business.application.external.org.BizOrgUnitService;
import kd.tsc.tsrbd.common.constants.ChannelConstants;
import kd.tsc.tsrbs.common.utils.PageUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OpenAdvertFilterList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(OpenAdvertFilterList.class);

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("adminorgsdpt.fbasedataid.id".equals(args.getFieldName())) {
            QFilter idFilter = new QFilter("parentorg.id", "=", (Object)0L);
            idFilter.or(new QFilter("parentorg.id", "=", (Object)BizOrgUnitService.getRootOrgId()));
            args.getCustomParams().put("bizQFilterKey", idFilter.toSerializedString());
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent event) {
        BillShowParameter parameter = event.getParameter();
        String pageId = PageUtils.getPageId((String)String.valueOf(parameter.getPkId()), (String)parameter.getAppId(), (String)parameter.getFormId(), (String)parameter.getRootPageId());
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setPageId(pageId);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.updateTabName();
    }

    public void setFilter(SetFilterEvent filterEvent) {
        filterEvent.setMainOrgQFilter(null);
        List qFilters = filterEvent.getQFilters();
        List qFilterList = qFilters.stream().filter(qFilter -> HRStringUtils.equals((String)qFilter.getProperty(), (String)"adminorgsdpt.fbasedataid.id")).collect(Collectors.toList());
        if (qFilterList.size() > 0) {
            logger.info("OpenAdvertFilterList.setFilter.qFilterList>0");
            QFilter adminOrgFilter = (QFilter)qFilterList.get(0);
            Object value = adminOrgFilter.getValue();
            if (value instanceof Long && value.equals(BizOrgUnitService.getRootOrgId())) {
                qFilters.remove(adminOrgFilter);
            } else if (value instanceof Long || value instanceof Integer) {
                Long orgId = value instanceof Integer ? Long.valueOf(Long.parseLong(value.toString())) : (Long)value;
                ArrayList<Long> orgIdList = new ArrayList<Long>();
                orgIdList.add(orgId);
                List result = (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{orgIdList, new Date()});
                HashSet subOrgIds = Sets.newHashSetWithExpectedSize((int)result.size());
                for (Map orgMap : result) {
                    Object subOrgId = orgMap.get("orgId");
                    subOrgIds.add(Long.valueOf(subOrgId.toString()));
                }
                orgIdList.addAll(subOrgIds);
                qFilters.remove(adminOrgFilter);
                adminOrgFilter = new QFilter("adminorgsdpt.fbasedataid.id", "in", (Object)subOrgIds);
                qFilters.add(adminOrgFilter);
            }
        }
        qFilters.add(new QFilter("channel", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID));
        qFilters.add(new QFilter("advertstatus", "=", (Object)"S"));
        logger.info("OpenAdvertFilterList.setFilter.qFilters->{}", (Object)qFilters.toString());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"adminorgsdpt.fbasedataid.name")) {
            QFilter idFilter = new QFilter("parent", "=", (Object)0L);
            idFilter.or(new QFilter("parent", "=", (Object)BizOrgUnitService.getRootOrgId()));
            args.getQFilters().add(idFilter);
        } else if (HRStringUtils.equals((String)fieldName, (String)"workaddr.fbasedataid.city.name")) {
            DynamicObject[] workplaceDys = HRBaseServiceHelper.create((String)"hbss_workplace").loadDynamicObjectArray(null);
            HashMap<Long, Long> workplaceCityMap = new HashMap<Long, Long>(16);
            if (ObjectUtils.isNotEmpty((Object)workplaceDys)) {
                for (DynamicObject workplaceDy : workplaceDys) {
                    workplaceCityMap.put(workplaceDy.getLong("id"), workplaceDy.getLong("city.id"));
                }
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_advertdetailex");
            QFilter channel = new QFilter("channel", "=", (Object)ChannelConstants.INTRECO_CHANNEL_ID);
            QFilter advertStatus = new QFilter("advertstatus", "=", (Object)"S");
            DynamicObject[] adverts = serviceHelper.loadDynamicObjectArray(new QFilter[]{channel, advertStatus});
            HashSet cityIds = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject advert : adverts) {
                DynamicObjectCollection workaddrs = advert.getDynamicObjectCollection("workaddr");
                if (!ObjectUtils.isNotEmpty((Object)workaddrs)) continue;
                for (DynamicObject workaddr : workaddrs) {
                    Long cityId = workaddr.getLong("fbasedataid.id");
                    cityIds.add(workplaceCityMap.get(cityId));
                }
            }
            args.getQFilters().add(new QFilter("id", "in", (Object)cityIds));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        Object focusRowPkId = this.getFocusRowPkId();
        if ("cardlistcolumnap".equals(fieldName)) {
            args.setCancel(true);
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("tsirm_openadvertnew");
            bsp.setPkId(focusRowPkId);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setBillStatus(BillOperationStatus.VIEW);
            bsp.setStatus(OperationStatus.VIEW);
            bsp.setAppId("hssc");
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    private void updateTabName() {
        String appId = this.getView().getFormShowParameter().getAppId();
        IFormView mainView = this.getView().getMainView();
        if (appId != null && mainView != null) {
            IFormView appView = SessionManager.getCurrent().getViewNoPlugin(this.getView().getFormShowParameter().getAppId() + this.getView().getMainView().getPageId());
            if (appView == null) {
                return;
            }
            Tab tab = (Tab)appView.getControl("_submaintab_");
            if (tab == null) {
                return;
            }
            tab.updateTabName(this.getView().getPageId(), ResManager.loadKDString((String)"\u6211\u8981\u5e94\u8058-\u5728\u62db\u804c\u4f4d\u5217\u8868", (String)"OpenAdvertFilterList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(appView);
        }
    }
}

