/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc.openadvert;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class OpenAdvertSerarchList
extends HRDataBaseList
implements SearchEnterListener {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Search search = (Search)this.getView().getControl("searchap");
        if (search == null) {
            return;
        }
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)"buttonap")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Search searchap = (Search)this.getControl("searchap");
            String text = searchap.getSearchKey();
            this.getView().getPageCache().put("pageClick", "1");
            this.filterList(text);
            if (HRStringUtils.isBlank((CharSequence)text) || !text.equals(formShowParameter.getCustomParams().get("searchkey"))) {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refreshData();
            }
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.remove("searchkey");
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        Search searchap = (Search)this.getControl("searchap");
        IPageCache pageCache = this.getView().getPageCache();
        if (null == searchap && HRStringUtils.isBlank((CharSequence)pageCache.get("homePage"))) {
            pageCache.put("homePage", "1");
            this.filterList("");
            return;
        }
        if (null == searchap) {
            return;
        }
        String searchKey = searchap.getSearchKey();
        String result = pageCache.get("searchkey");
        if (HRStringUtils.isBlank((CharSequence)result)) {
            pageCache.put("searchkey", "1");
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String firstOpenKey = (String)formShowParameter.getCustomParam("firstOpenKey");
        if (HRStringUtils.isBlank((CharSequence)result) && HRStringUtils.isBlank((CharSequence)searchKey) && HRStringUtils.isNotEmpty((String)firstOpenKey) && HRStringUtils.isBlank((CharSequence)this.getView().getPageCache().get("pageClick"))) {
            searchap.setSearchKey(firstOpenKey);
            formShowParameter.getCustomParams().remove("firstOpenKey");
            this.filterList(firstOpenKey);
            return;
        }
        if (!HRStringUtils.isEmpty((String)searchKey) && HRStringUtils.isEmpty((String)result)) {
            searchap.setSearchKey(searchKey);
            this.filterList(searchKey);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText();
        this.filterList(text);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Search searchap = (Search)this.getControl("searchap");
        String text = searchap.getSearchKey();
        this.filterList(text);
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    private void filterList(String text) {
        if (HRStringUtils.isEmpty((String)text)) {
            text = "";
        }
        String[] searchKeys = text.split(" ");
        ArrayList filters = Lists.newArrayListWithCapacity((int)16);
        Map<String, List<Long>> workAddrIds = this.getWorkAddrIds(searchKeys);
        Arrays.stream(searchKeys).forEach(searchKey -> {
            if (HRStringUtils.isBlank((CharSequence)searchKey)) {
                return;
            }
            QFilter qFilter = new QFilter("name", "like", (Object)("%" + searchKey + "%"));
            qFilter.or("position.number", "like", (Object)("%" + searchKey + "%"));
            qFilter.or("adminorgsdpt.fbasedataid.name", "like", (Object)("%" + searchKey + "%"));
            workAddrIds.forEach((key, list) -> {
                if (key.contains((CharSequence)searchKey)) {
                    qFilter.or("workaddr.fbasedataid", "in", list);
                }
            });
            filters.add(qFilter);
        });
        ListFilterParameter filterParameter = ((ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter();
        if (!kd.bos.orm.util.CollectionUtils.isEmpty((Collection)filters)) {
            QFilter qFilter = (QFilter)filters.get(0);
            for (int i = 1; i < filters.size(); ++i) {
                qFilter.and((QFilter)filters.get(i));
            }
            filterParameter.setFilter(qFilter);
        }
        if (!HRStringUtils.isBlank((CharSequence)text)) {
            this.getView().updateView("billlistap");
        }
    }

    private Map<String, List<Long>> getWorkAddrIds(String[] searchKeys) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workplace");
        ArrayList filterList = Lists.newArrayList();
        Arrays.stream(searchKeys).forEach(searchKey -> {
            QFilter qFilter = new QFilter("city.name", "like", (Object)("%" + searchKey + "%"));
            filterList.add(qFilter);
        });
        QFilter qFilter = (QFilter)filterList.get(0);
        for (int i = 1; i < filterList.size(); ++i) {
            qFilter.or((QFilter)filterList.get(i));
        }
        DynamicObject[] workAddrs = serviceHelper.query("id, city", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)workAddrs.length);
        for (DynamicObject workAddr : workAddrs) {
            String key = workAddr.getString("city.name");
            long id = workAddr.getLong("id");
            List ids = (List)result.get(key);
            if (CollectionUtils.isEmpty((Collection)ids)) {
                ids = Lists.newArrayListWithCapacity((int)16);
            }
            ids.add(id);
            result.put(key, ids);
        }
        return result;
    }
}

