/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import org.apache.commons.lang3.tuple.Pair;

public class PosListPublishBillList
extends HRDataBaseList {
    private static final String CUSTOM_STYLE = "eyJ0eXBlIjowLCJjb250ZW50IjoiW2RhdGEtY29kZT0nbWVyZ2VsaXN0Y29sdW1uYXAnXSBpbWd7XG4gICAgIG1heC1oZWlnaHQ6IDE2cHggIWltcG9ydGFudDtcbiAgICAgbWFyZ2luLXJpZ2h0OiAtM3B4ICFpbXBvcnRhbnQ7XG4gICAgIH1cbltkYXRhLWNvZGU9J21lcmdlbGlzdGNvbHVtbmFwJ10gLl8zZUdKSF9scXtcbiAgICBmbGV4LXNocmluazogMDtcbiAgICB3aWR0aDogMjBweCAhaW1wb3J0YW50O1xufSJ9";
    private Map<Long, LinkedList<Pair<String, Integer>>> MAP_COUNT = new HashMap<Long, LinkedList<Pair<String, Integer>>>(16);
    private Map<Long, LinkedList<Pair<String, String>>> MAP_ICON = new HashMap<Long, LinkedList<Pair<String, String>>>(16);
    private static final HashMap<String, String> POSITION_ADVICON_MAP = new HashMap(16);
    private static final HashMap<String, String> POSITION_ADVICONSTATUS_MAP;

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        HashMap<String, String> ctrl = new HashMap<String, String>(16);
        ctrl.put("cstyles", CUSTOM_STYLE);
        this.getView().updateControlMetadata("flexpanelap1", ctrl);
    }

    public void packageData(PackageDataEvent evt) {
        Object pop;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = evt.getRowData();
        long id = rowData.getLong("id");
        if (HRStringUtils.equals((String)"erroricon", (String)fieldKey) || HRStringUtils.equals((String)"successicon", (String)fieldKey) || HRStringUtils.equals((String)"stopicon", (String)fieldKey)) {
            LinkedList<Pair<String, String>> QUEUE_ICON = this.MAP_ICON.get(id);
            if (!HRObjectUtils.isEmpty(QUEUE_ICON) && !QUEUE_ICON.isEmpty()) {
                pop = QUEUE_ICON.pop();
                evt.setFormatValue(pop.getRight());
            } else {
                evt.setFormatValue((Object)"");
            }
        }
        if (HRStringUtils.equals((String)"erradvcount", (String)fieldKey) || HRStringUtils.equals((String)"succadvcount", (String)fieldKey) || HRStringUtils.equals((String)"stopadvcount", (String)fieldKey)) {
            LinkedList<Pair<String, Integer>> QUEUE_COUNT = this.MAP_COUNT.get(id);
            if (!HRObjectUtils.isEmpty(QUEUE_COUNT) && !QUEUE_COUNT.isEmpty()) {
                pop = QUEUE_COUNT.pop();
                this.setFormatValue((Integer)pop.getRight(), evt);
            } else {
                evt.setFormatValue(null);
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        DynamicObjectCollection pageData = evt.getPageData();
        for (DynamicObject dyo : pageData) {
            LinkedList QUEUE_COUNT = Lists.newLinkedList();
            LinkedList QUEUE_ICON = Lists.newLinkedList();
            int errCount = 0;
            if (dyo.containsProperty("erradvcount")) {
                errCount = dyo.getInt("erradvcount");
            }
            int successCount = 0;
            if (dyo.containsProperty("succadvcount")) {
                successCount = dyo.getInt("succadvcount");
            }
            int stopCount = 0;
            if (dyo.containsProperty("stopadvcount")) {
                stopCount = dyo.getInt("stopadvcount");
            }
            long id = dyo.getLong("id");
            QUEUE_COUNT.offer(Pair.of((Object)"erradvcount", (Object)errCount));
            QUEUE_ICON.offer(Pair.of((Object)"erroricon", (Object)"E"));
            QUEUE_COUNT.offer(Pair.of((Object)"succadvcount", (Object)successCount));
            QUEUE_ICON.offer(Pair.of((Object)"successicon", (Object)"S"));
            QUEUE_COUNT.offer(Pair.of((Object)"stopadvcount", (Object)stopCount));
            QUEUE_ICON.offer(Pair.of((Object)"stopicon", (Object)"D"));
            if (!QUEUE_COUNT.isEmpty()) {
                this.MAP_COUNT.put(id, QUEUE_COUNT);
            }
            if (QUEUE_ICON.isEmpty()) continue;
            this.MAP_ICON.put(id, QUEUE_ICON);
        }
    }

    private void setFormatValue(int count, PackageDataEvent evt) {
        if (count > 99) {
            evt.setFormatValue((Object)"99+");
        } else if (count < 0) {
            evt.setFormatValue((Object)"");
        } else {
            evt.setFormatValue((Object)count);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"successicon") || HRStringUtils.equals((String)fieldName, (String)"erroricon") || HRStringUtils.equals((String)fieldName, (String)"stopicon")) {
            BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
            Object pkId = source.getFocusRowPkId();
            args.setCancel(true);
            if (!this.IsHasAdv(fieldName, (Long)pkId).booleanValue()) {
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setBillFormId("tsirm_adverttplexlistb");
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("positionid", pkId);
            param.put("advertstatus", POSITION_ADVICONSTATUS_MAP.get(fieldName));
            param.put("createorg", this.getCreateOrg((Long)pkId));
            showParameter.setCustomParams(param);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private Boolean IsHasAdv(String advType, Long positionId) {
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsirm_position");
        DynamicObject positionDyn = HELPER.loadSingle((Object)positionId);
        if (positionDyn == null) {
            return false;
        }
        return positionDyn.getLong(POSITION_ADVICON_MAP.get(advType)) > 0L;
    }

    private Long getCreateOrg(Long positionId) {
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper("tsirm_position");
        DynamicObject positionDyn = HELPER.loadSingle((Object)positionId);
        if (positionDyn == null) {
            return 0L;
        }
        return positionDyn.getLong("createorg.id");
    }

    static {
        POSITION_ADVICON_MAP.put("erroricon", "erradvcount");
        POSITION_ADVICON_MAP.put("successicon", "succadvcount");
        POSITION_ADVICON_MAP.put("stopicon", "stopadvcount");
        POSITION_ADVICONSTATUS_MAP = new HashMap(16);
        POSITION_ADVICONSTATUS_MAP.put("erroricon", "E");
        POSITION_ADVICONSTATUS_MAP.put("successicon", "S");
        POSITION_ADVICONSTATUS_MAP.put("stopicon", "D");
    }
}

