/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.business.domain.position.service.PositionLabelServiceHelper;

public class PosPorCustomControlUtils {
    private static final Log logger = LogFactory.getLog(PosPorCustomControlUtils.class);
    private static final Map<String, BiConsumer<CustomControl, String>> CUSTOM_CONTROL_INIT_MAP = new HashMap<String, BiConsumer<CustomControl, String>>(16);

    public PosPorCustomControlUtils() {
        CUSTOM_CONTROL_INIT_MAP.put("school_title", (customControl, secTitle) -> this.setTaskList((CustomControl)customControl, (String)secTitle, "", ""));
        CUSTOM_CONTROL_INIT_MAP.put("school_type", (customControl, secTitle) -> this.setTaskList((CustomControl)customControl, (String)secTitle, "", ""));
        CUSTOM_CONTROL_INIT_MAP.put("work_address", (customControl, secTitle) -> this.setTaskList((CustomControl)customControl, (String)secTitle, "second_class", ""));
        CUSTOM_CONTROL_INIT_MAP.put("major", (customControl, secTitle) -> this.setTaskList((CustomControl)customControl, (String)secTitle, "third_class", ""));
        CUSTOM_CONTROL_INIT_MAP.put("industry", (customControl, secTitle) -> this.setTaskList((CustomControl)customControl, (String)secTitle, "fourth_class", ""));
    }

    public void init(CustomControl customcontrol, String secTitle) {
        BiConsumer<CustomControl, String> biConsumer = CUSTOM_CONTROL_INIT_MAP.get(secTitle);
        if (null == biConsumer) {
            return;
        }
        biConsumer.accept(customcontrol, secTitle);
    }

    private void setTaskList(CustomControl customcontrol, String secTitle, String queryField, String taskList) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)1);
        try {
            JSONArray jsonArray = PositionLabelServiceHelper.getInstance().getLabelByPCode(secTitle, "", queryField, null, null, null);
            taskList = jsonArray.toJSONString();
        }
        catch (Exception ex) {
            logger.error("PosPorCustomControlUtils.setTaskList.getLabelByPCode.secTitle:{} exception:{}", (Object)secTitle, (Object)ex.getMessage());
        }
        data.put("setTaskList", taskList);
        customcontrol.setData((Object)data);
    }
}

