/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.position.service.PosPortraitConvertHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionLabelServiceHelper;
import kd.tsc.tsirm.formplugin.web.position.PosPorCustomControlUtils;
import kd.tsc.tsrbd.business.domain.label.service.DrawLabelUnits;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;

public class PosPortraitEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(PosPortraitEditPlugin.class);
    private PosPorCustomControlUtils posPorCustomControlUtils = new PosPorCustomControlUtils();
    private static final String KEY_LABEL_SHOW_PANEL = "labelshowpanel";
    private static final String COLOR_AI_LABEL = "#2386EE";
    private static final String CLASS_PERSONAL_LABEL = "kdfont kdfont-guanbi6";
    private static final String KEY_PREFIX_VECTOR = "lvector";
    private static final String KEY_PREFIX_LABEL = "label";
    private static final String KEY_PREFIX_LABEL_PANEL = "completelabelpanel";
    private static final Map<String, Consumer<ChangeData[]>> VALUE_UPDATE_MAP = Maps.newHashMapWithExpectedSize((int)33);
    private static final String[] yesNos = new String[]{"job_similar", "work_address", "benchmark_school", "school_title", "school_type", "major", "industry", "benchmark_company", "avoid_company", "bonus", "job_skill", "language_skill", "ability", "quality", "project"};

    public PosPortraitEditPlugin() {
        VALUE_UPDATE_MAP.put("job_level", changes -> this.updateComboEdit("positions", "job_level", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("position_type", changes -> this.updateComboEdit("positions", "position_type", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("is_oversea_education", changes -> this.updateFieldEdit("educations", "is_oversea_education", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("is_full_time", changes -> this.updateFieldEdit("educations", "is_full_time", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("minimum_education", changes -> this.updateComboEdit("educations", "minimum_education", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("first_education", changes -> this.updateComboEdit("educations", "first_education", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("work_duration_up", changes -> this.updateScopeEdit("employments", "work_duration", (ChangeData[])changes, "work_duration_up", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"PosPortraitEditPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("work_duration_down", changes -> this.updateScopeEdit("employments", "work_duration", (ChangeData[])changes, "work_duration_down", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"PosPortraitEditPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("work_duration_nolimit", changes -> this.updateScopeEdit("employments", "work_duration", (ChangeData[])changes, "work_duration_nolimit", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650", (String)"PosPortraitEditPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("salary_up", changes -> this.updateScopeEdit("employments", "salary", (ChangeData[])changes, "salary_up", ResManager.loadKDString((String)"\u85aa\u8d44\u8303\u56f4", (String)"PosPortraitEditPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("salary_down", changes -> this.updateScopeEdit("employments", "salary", (ChangeData[])changes, "salary_down", ResManager.loadKDString((String)"\u85aa\u8d44\u8303\u56f4", (String)"PosPortraitEditPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("salary_nolimit", changes -> this.updateScopeEdit("employments", "salary", (ChangeData[])changes, "salary_nolimit", ResManager.loadKDString((String)"\u85aa\u8d44\u8303\u56f4", (String)"PosPortraitEditPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("project_count", changes -> this.updateBigintEdit("employments", "project_count", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("is_oversea_employment", changes -> this.updateFieldEdit("employments", "is_oversea_employment", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("is_management", changes -> this.updateFieldEdit("employments", "is_management", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("age_up", changes -> this.updateScopeEdit("others", "age", (ChangeData[])changes, "age_up", ResManager.loadKDString((String)"\u5e74\u9f84\u8303\u56f4", (String)"PosPortraitEditPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("age_down", changes -> this.updateScopeEdit("others", "age", (ChangeData[])changes, "age_down", ResManager.loadKDString((String)"\u5e74\u9f84\u8303\u56f4", (String)"PosPortraitEditPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("age_nolimit", changes -> this.updateScopeEdit("others", "age", (ChangeData[])changes, "age_nolimit", ResManager.loadKDString((String)"\u5e74\u9f84\u8303\u56f4", (String)"PosPortraitEditPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        VALUE_UPDATE_MAP.put("duty_time", changes -> this.updateComboEdit("others", "duty_time", (ChangeData[])changes));
        VALUE_UPDATE_MAP.put("is_avoid_relatives", changes -> this.updateFieldEdit("others", "is_avoid_relatives", (ChangeData[])changes));
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String ekey = evt.getKey();
        String input = evt.getEventArgs();
        String secTitle = ekey.substring(0, ekey.length() - 6);
        if (HRStringUtils.equals((String)eventName, (String)"searchKey")) {
            HashSet multiSet = Sets.newHashSetWithExpectedSize((int)5);
            multiSet.add("benchmark_school");
            multiSet.add("school_title");
            multiSet.add("school_type");
            multiSet.add("benchmark_company");
            multiSet.add("avoid_company");
            if (multiSet.contains(secTitle)) {
                CustomControl customcontrol = (CustomControl)this.getView().getControl(secTitle + "_input");
                HashMap data = Maps.newHashMapWithExpectedSize((int)5);
                String taskList = "";
                try {
                    JSONArray jsonArray = PositionLabelServiceHelper.getInstance().getLabelByPCode(secTitle, input, "", null, null, null);
                    taskList = jsonArray.toJSONString();
                }
                catch (Exception ex) {
                    logger.error("PosPortraitEditPlugin.customEvent.getLabelByPCode.multi exception", (Throwable)ex);
                }
                data.put("setTaskList", taskList);
                customcontrol.setData((Object)data);
            }
        }
        if (HRStringUtils.equals((String)eventName, (String)"selectedData")) {
            Map sec2Fir = (Map)JSONObject.parseObject((String)this.getPageCache().get("sec2Fir"), Map.class);
            String firTitle = (String)sec2Fir.get(secTitle);
            Map secMap = (Map)JSON.parseObject((String)this.getPageCache().get("sec.label.map"), Map.class);
            Map sec2Labels = (Map)JSONObject.parseObject((String)this.getPageCache().get("sec2Labels"), Map.class);
            switch (secTitle) {
                case "job_category": {
                    this.updateDataWhenAdd(firTitle, secTitle, input);
                    break;
                }
                case "work_address": {
                    JSONArray workAddresses = (JSONArray)secMap.get(secTitle);
                    if (HRStringUtils.isEmpty((String)input)) break;
                    JSONArray labelArray = (JSONArray)sec2Labels.get(secTitle);
                    if (null == labelArray) {
                        labelArray = new JSONArray(3);
                    }
                    HashSet labels = Sets.newHashSetWithExpectedSize((int)labelArray.size());
                    for (int i = 0; i < labelArray.size(); ++i) {
                        labels.add(labelArray.getString(i));
                    }
                    JSONArray inputArray = JSON.parseArray((String)input);
                    JSONArray citys = new JSONArray(3);
                    for (int i = 0; i < inputArray.size(); ++i) {
                        String name = inputArray.getJSONObject(i).getString("first_class") + "-" + inputArray.getJSONObject(i).getString("second_class");
                        if (labels.contains(name)) continue;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("name", (Object)name);
                        jsonObject.put("labelCategory", (Object)(firTitle + "-" + secTitle + "-" + workAddresses.size()));
                        workAddresses.add((Object)jsonObject);
                        JSONObject city = new JSONObject();
                        city.put("country", (Object)inputArray.getJSONObject(i).getString("first_class"));
                        city.put("city", (Object)inputArray.getJSONObject(i).getString("second_class"));
                        citys.add((Object)city);
                        labelArray.add((Object)name);
                    }
                    sec2Labels.put(secTitle, labelArray);
                    this.getPageCache().put("sec2Labels", JSON.toJSONString((Object)sec2Labels));
                    this.getPageCache().put("sec.label.map", JSON.toJSONString((Object)secMap));
                    this.drawLabel(secTitle, firTitle, workAddresses);
                    JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
                    JSONObject firJson = data.getJSONObject(firTitle);
                    JSONArray jsonArray = firJson.getJSONArray(secTitle);
                    if (null == jsonArray) {
                        jsonArray = new JSONArray();
                        firJson.put(secTitle, (Object)jsonArray);
                    }
                    for (int i = 0; i < citys.size(); ++i) {
                        jsonArray.add((Object)citys.getJSONObject(i));
                    }
                    this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
                    break;
                }
                case "benchmark_school": 
                case "school_title": 
                case "school_type": 
                case "benchmark_company": 
                case "avoid_company": {
                    JSONArray jsonArray11 = (JSONArray)secMap.get(secTitle);
                    if (HRStringUtils.isEmpty((String)input)) break;
                    JSONArray labelArray1 = (JSONArray)sec2Labels.get(secTitle);
                    if (null == labelArray1) {
                        labelArray1 = new JSONArray(3);
                    }
                    HashSet labels1 = Sets.newHashSetWithExpectedSize((int)labelArray1.size());
                    for (int i = 0; i < labelArray1.size(); ++i) {
                        labels1.add(labelArray1.getString(i));
                    }
                    JSONArray inputArray1 = JSON.parseArray((String)input);
                    JSONArray inputArray11 = new JSONArray();
                    for (int i = 0; i < inputArray1.size(); ++i) {
                        String name = inputArray1.getString(i);
                        if (labels1.contains(name)) continue;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("name", (Object)name);
                        jsonObject.put("labelCategory", (Object)(firTitle + "-" + secTitle + "-" + jsonArray11.size()));
                        jsonArray11.add((Object)jsonObject);
                        labelArray1.add((Object)name);
                        inputArray11.add(inputArray1.get(i));
                    }
                    sec2Labels.put(secTitle, labelArray1);
                    this.getPageCache().put("sec2Labels", JSON.toJSONString((Object)sec2Labels));
                    this.getPageCache().put("sec.label.map", JSON.toJSONString((Object)secMap));
                    this.drawLabel(secTitle, firTitle, jsonArray11);
                    this.updateDataWhenAdd(firTitle, secTitle, inputArray11.toJSONString());
                    break;
                }
                case "major": 
                case "bonus": {
                    this.cascaderEnsureClick(input, secTitle, firTitle, secMap, "third_class", sec2Labels);
                    break;
                }
                case "industry": {
                    this.cascaderEnsureClick(input, secTitle, firTitle, secMap, "fourth_class", sec2Labels);
                    break;
                }
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject data = (JSONObject)formShowParameter.getCustomParam("portrait.data");
        Map map = (Map)formShowParameter.getCustomParam("sec.label.map");
        Map sec2Fir = (Map)formShowParameter.getCustomParam("sec2Fir");
        Map sec2Labels = (Map)formShowParameter.getCustomParam("sec2Labels");
        this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
        this.getPageCache().put("sec.label.map", JSON.toJSONString((Object)map));
        this.getPageCache().put("sec2Fir", JSON.toJSONString((Object)sec2Fir));
        this.getPageCache().put("sec2Labels", JSON.toJSONString((Object)sec2Labels));
        this.initEdit(data);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        Consumer<ChangeData[]> consumer = VALUE_UPDATE_MAP.get(fieldName);
        if (null != consumer) {
            consumer.accept(evt.getChangeSet());
        }
    }

    public void registerListener(EventObject event) {
        for (String secTitle : yesNos) {
            Vector yes = (Vector)this.getView().getControl(secTitle + "_yes");
            yes.addClickListener((ClickListener)this);
            Vector close = (Vector)this.getView().getControl(secTitle + "_close");
            close.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject evt) {
        String secTitle;
        Control control = (Control)evt.getSource();
        String ckey = control.getKey();
        if (ckey.startsWith(KEY_PREFIX_VECTOR)) {
            this.deleteLabel(ckey);
        }
        if (ckey.endsWith("-+")) {
            this.addClick(ckey);
        }
        if (ckey.endsWith("_yes")) {
            secTitle = ckey.substring(0, ckey.length() - 4);
            this.getView().setVisible(Boolean.FALSE, new String[]{secTitle + "_area"});
            this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "-+"});
            Map sec2Fir = (Map)JSONObject.parseObject((String)this.getPageCache().get("sec2Fir"), Map.class);
            String firTitle = (String)sec2Fir.get(secTitle);
            Map secMap = (Map)JSON.parseObject((String)this.getPageCache().get("sec.label.map"), Map.class);
            Map sec2Labels = (Map)JSONObject.parseObject((String)this.getPageCache().get("sec2Labels"), Map.class);
            JSONArray jsonArray1122 = (JSONArray)secMap.get(secTitle);
            if (HRStringUtils.equals((String)secTitle, (String)"job_skill")) {
                String confirmTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6280\u80fd", (String)"PosPortraitEditPlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.yesTwo(secTitle, firTitle, secMap, sec2Labels, jsonArray1122, "job_skill_name", "job_skill_skill_level", "skill_name", "skill_level", confirmTip);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"language_skill")) {
                this.yesLanguageSkill(secTitle, firTitle, secMap, sec2Labels, jsonArray1122);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"ability")) {
                String confirmTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u80fd\u529b", (String)"PosPortraitEditPlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.yesTwo(secTitle, firTitle, secMap, sec2Labels, jsonArray1122, "ability_name", "ability_level", "name", "level", confirmTip);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"quality")) {
                String confirmTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u804c\u4e1a\u7d20\u517b\u540d\u79f0", (String)"PosPortraitEditPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.yesTwo(secTitle, firTitle, secMap, sec2Labels, jsonArray1122, "quality_name", "quality_level", "name", "level", confirmTip);
                return;
            }
            if (this.ensureClick(ckey)) {
                return;
            }
        }
        if (ckey.endsWith("_close")) {
            FieldTip rangeDownTip;
            secTitle = ckey.substring(0, ckey.length() - 6);
            this.getView().setVisible(Boolean.FALSE, new String[]{secTitle + "_area"});
            this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "-+"});
            if (HRStringUtils.equals((String)secTitle, (String)"project")) {
                this.getModel().setValue("project_input", (Object)"");
            }
            if (HRStringUtils.equals((String)secTitle, (String)"job_skill")) {
                this.getModel().setValue("job_skill_name", (Object)"");
                this.getModel().setValue("job_skill_skill_level", (Object)"");
                rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "job_skill_name", null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"language_skill")) {
                this.getModel().setValue("language_skill_name", (Object)"");
                this.getModel().setValue("language_skill_prop", (Object)"");
                this.getModel().setValue("language_skill_level", (Object)"");
                rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "language_skill_name", null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"ability")) {
                this.getModel().setValue("ability_name", (Object)"");
                this.getModel().setValue("ability_level", (Object)"");
                rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "ability_name", null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
                return;
            }
            if (HRStringUtils.equals((String)secTitle, (String)"quality")) {
                this.getModel().setValue("quality_name", (Object)"");
                this.getModel().setValue("quality_level", (Object)"");
                rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "quality_name", null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
                return;
            }
            HashSet inputSet = Sets.newHashSetWithExpectedSize((int)1);
            inputSet.add("job_similar");
            if (inputSet.contains(secTitle)) {
                this.getModel().setValue(secTitle + "_input", (Object)"");
            }
            HashSet CustomSet = Sets.newHashSetWithExpectedSize((int)9);
            CustomSet.add("benchmark_school");
            CustomSet.add("work_address");
            CustomSet.add("school_title");
            CustomSet.add("school_type");
            CustomSet.add("benchmark_company");
            CustomSet.add("avoid_company");
            CustomSet.add("major");
            CustomSet.add("bonus");
            CustomSet.add("industry");
            if (CustomSet.contains(secTitle)) {
                CustomControl customcontrol = (CustomControl)this.getView().getControl(secTitle + "_input");
                HashMap data = Maps.newHashMapWithExpectedSize((int)1);
                data.put("getSelected", "false" + ID.genStringId());
                customcontrol.setData((Object)data);
            }
        }
    }

    private void label(String secTitle, String firTitle, Map<String, JSONArray> secMap, JSONArray jsonArray1122, String name) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        jsonObject.put("labelCategory", (Object)(firTitle + "-" + secTitle + "-" + jsonArray1122.size()));
        jsonArray1122.add((Object)jsonObject);
        this.getPageCache().put("sec.label.map", JSON.toJSONString(secMap));
        this.drawLabel(secTitle, firTitle, jsonArray1122);
    }

    private void addClick(String addKey) {
        String secTitle = addKey.substring(0, addKey.length() - 2);
        this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "_area"});
        this.getView().setVisible(Boolean.FALSE, new String[]{addKey});
        HashSet customSet = Sets.newHashSetWithExpectedSize((int)5);
        customSet.add("school_title");
        customSet.add("school_type");
        customSet.add("work_address");
        customSet.add("major");
        customSet.add("industry");
        if (customSet.contains(secTitle)) {
            CustomControl customControl = (CustomControl)this.getView().getControl(secTitle + "_input");
            this.posPorCustomControlUtils.init(customControl, secTitle);
        }
        if (HRStringUtils.equals((String)"bonus", (String)secTitle)) {
            CustomControl customcontrol = (CustomControl)this.getView().getControl(secTitle + "_input");
            HashMap data = Maps.newHashMapWithExpectedSize((int)1);
            PosPortraitConvertHelper posPortraitConvertHelper = new PosPortraitConvertHelper();
            JSONArray taskList = new JSONArray(3);
            JSONObject data1 = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
            for (String fir : posPortraitConvertHelper.getOrderFirTitles()) {
                if (HRStringUtils.equals((String)fir, (String)"positions") || HRStringUtils.equals((String)fir, (String)"ability_quality") || HRStringUtils.equals((String)fir, (String)"others")) continue;
                JSONObject json = data1.getJSONObject(fir);
                List secs = (List)posPortraitConvertHelper.getOrderSecTitles().get(fir);
                for (String sec : secs) {
                    String value = json.getString(sec);
                    if (HRStringUtils.isEmpty((String)value) || HRStringUtils.equals((String)"null", (String)value)) continue;
                    List names = posPortraitConvertHelper.viewConvert(sec, value);
                    Map code2Name = posPortraitConvertHelper.getCode2Name();
                    if (names.size() <= 0) continue;
                    this.doNotWorryBeHappy(names, code2Name, sec, fir, taskList);
                }
            }
            data.put("setTaskList", taskList.toString());
            customcontrol.setData((Object)data);
        }
    }

    private void doNotWorryBeHappy(List<String> names, Map<String, String> code2Name, String sec, String fir, JSONArray taskList) {
        for (int i = 0; i < names.size(); ++i) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("first_class", (Object)code2Name.get(fir));
            jsonObject.put("second_class", (Object)code2Name.get(sec));
            jsonObject.put("third_class", (Object)names.get(i));
            taskList.add((Object)jsonObject);
        }
    }

    private void reloadLabelData(String mataKey, List<LabelBO> labelBOS) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)labelBOS.size());
        paramMap.put("items", DrawLabelUnits.createLabelShowPanel(labelBOS, (String)KEY_LABEL_SHOW_PANEL, (String)KEY_PREFIX_LABEL_PANEL, (String)CLASS_PERSONAL_LABEL, (String)COLOR_AI_LABEL, (String)KEY_PREFIX_VECTOR, (String)KEY_PREFIX_LABEL, (String)mataKey).createControl().get("items"));
        this.getView().updateControlMetadata(mataKey, (Map)paramMap);
    }

    public void onGetControl(OnGetControlArgs evt) {
        String conKey = evt.getKey();
        if (conKey.contains(KEY_PREFIX_VECTOR)) {
            Vector vector = new Vector();
            vector.setKey(conKey);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            evt.setControl((Control)vector);
        }
        if (HRStringUtils.endsWithIgnoreCase((String)conKey, (String)"+")) {
            Label tagLabel = new Label();
            tagLabel.setKey(conKey);
            tagLabel.setView(this.getView());
            tagLabel.addClickListener((ClickListener)this);
            evt.setControl((Control)tagLabel);
        }
    }

    private boolean ensureClick(String ensureKey) {
        String secTitle = ensureKey.substring(0, ensureKey.length() - 4);
        Map sec2Fir = (Map)JSONObject.parseObject((String)this.getPageCache().get("sec2Fir"), Map.class);
        String fir = (String)sec2Fir.get(secTitle);
        Map map = (Map)JSON.parseObject((String)this.getPageCache().get("sec.label.map"), Map.class);
        JSONArray jsonArray = (JSONArray)map.get(secTitle);
        this.getView().setVisible(Boolean.FALSE, new String[]{secTitle + "_area"});
        this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "-+"});
        HashSet CustomSet = Sets.newHashSetWithExpectedSize((int)9);
        CustomSet.add("benchmark_school");
        CustomSet.add("work_address");
        CustomSet.add("school_title");
        CustomSet.add("school_type");
        CustomSet.add("benchmark_company");
        CustomSet.add("avoid_company");
        CustomSet.add("major");
        CustomSet.add("bonus");
        CustomSet.add("industry");
        if (CustomSet.contains(secTitle)) {
            CustomControl customcontrol = (CustomControl)this.getView().getControl(secTitle + "_input");
            HashMap data = Maps.newHashMapWithExpectedSize((int)1);
            data.put("getSelected", "true" + ID.genStringId());
            customcontrol.setData((Object)data);
            return true;
        }
        String input = (String)this.getModel().getValue(secTitle + "_input");
        if (HRStringUtils.equals((String)"job_similar", (String)secTitle) && HRStringUtils.isEmpty((String)input)) {
            return true;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!HRStringUtils.equals((String)jsonObject.getString("name"), (String)input)) continue;
            if (HRStringUtils.equals((String)secTitle, (String)"project")) {
                this.getModel().setValue("project_input", (Object)"");
            }
            return true;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)input);
        jsonObject.put("labelCategory", (Object)(fir + "-" + secTitle + "-" + jsonArray.size()));
        jsonArray.add((Object)jsonObject);
        this.getPageCache().put("sec.label.map", JSON.toJSONString((Object)map));
        this.drawLabel(secTitle, fir, jsonArray);
        if (HRStringUtils.equals((String)"job_similar", (String)secTitle)) {
            JSONArray jsonArray11 = new JSONArray(1);
            jsonArray11.add((Object)input);
            input = jsonArray11.toJSONString();
        }
        if (HRStringUtils.equals((String)secTitle, (String)"project")) {
            JSONArray jsonArray1 = new JSONArray();
            jsonArray1.add((Object)input);
            input = jsonArray1.toJSONString();
            this.getModel().setValue("project_input", (Object)"");
        }
        this.updateDataWhenAdd((String)sec2Fir.get(secTitle), secTitle, input);
        HashSet inputSet = Sets.newHashSetWithExpectedSize((int)1);
        inputSet.add("job_similar");
        if (inputSet.contains(secTitle)) {
            this.getModel().setValue(secTitle + "_input", (Object)"");
        }
        return false;
    }

    private void deleteLabel(String deleteKey) {
        String keys = deleteKey.substring(KEY_PREFIX_VECTOR.length());
        String[] keyArray = keys.split("-");
        String firstTitle = keyArray[0];
        String secTitle = keyArray[1];
        String index = keyArray[2];
        int inde = Integer.parseInt(index);
        Map map = (Map)JSON.parseObject((String)this.getPageCache().get("sec.label.map"), Map.class);
        JSONArray sec = (JSONArray)map.get(secTitle);
        sec.getJSONObject(inde).getString("name");
        sec.remove(inde);
        map.put(secTitle, sec);
        this.getPageCache().put("sec.label.map", JSON.toJSONString((Object)map));
        ArrayList labelBOS = Lists.newArrayListWithExpectedSize((int)sec.size());
        for (int i = 0; i < sec.size(); ++i) {
            LabelBO labelBO = new LabelBO();
            labelBO.setName(sec.getJSONObject(i).getString("name"));
            labelBO.setLabelCategory(firstTitle + "-" + secTitle + "-" + i);
            labelBOS.add(labelBO);
        }
        this.reloadLabelData(secTitle, labelBOS);
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        JSONObject firData = data.getJSONObject(firstTitle);
        String secData = firData.getString(secTitle);
        if (secData.endsWith("]")) {
            JSONArray jsonArray11 = firData.getJSONArray(secTitle);
            jsonArray11.remove(Integer.parseInt(index));
        } else if (secData.endsWith("}")) {
            firData.put(secTitle, (Object)new JSONObject());
        } else {
            firData.put(secTitle, (Object)"");
        }
        this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
    }

    private void updateDataWhenAdd(String fir, String sec, String addValue) {
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        JSONObject firJson = data.getJSONObject(fir);
        try {
            JSONArray firArray = firJson.getJSONArray(sec);
            if (null == firArray) {
                firArray = new JSONArray();
                firJson.put(sec, (Object)firArray);
            }
            JSONArray addArray = JSON.parseArray((String)addValue);
            for (int i = 0; i < addArray.size(); ++i) {
                firArray.add(addArray.get(i));
            }
        }
        catch (JSONException | ClassCastException ex) {
            try {
                JSONObject jsonObj = JSON.parseObject((String)addValue);
                firJson.put(sec, (Object)jsonObj);
            }
            catch (JSONException evt) {
                String str = addValue;
                firJson.put(sec, (Object)str);
            }
        }
        this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
    }

    private void updateScopeEdit(String key1, String key2, ChangeData[] changes, String identify, String cn) {
        FieldTip rangeDownTip;
        FieldTip rangeUpTip;
        FieldTip tip;
        String confirmTip;
        JSONObject json;
        JSONObject jsonObject;
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        ChangeData changeData = changes[0];
        if (identify.contains("_nolimit")) {
            jsonObject = data.getJSONObject(key1);
            json = jsonObject.getJSONObject(key2);
            Boolean newValue = (Boolean)changeData.getNewValue();
            json.put("is_unlimited", (Object)newValue);
            if (newValue.booleanValue()) {
                this.getModel().setValue(key2 + "_up", null);
                this.getModel().setValue(key2 + "_down", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{key2 + "_up"});
                this.getView().setEnable(Boolean.FALSE, new String[]{key2 + "_down"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{key2 + "_up"});
                this.getView().setEnable(Boolean.TRUE, new String[]{key2 + "_down"});
            }
            this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
        }
        if (identify.contains("_up")) {
            if (((Boolean)this.getModel().getValue(key2 + "_nolimit")).booleanValue()) {
                this.getModel().setValue(key2 + "_up", null);
            } else {
                jsonObject = data.getJSONObject(key1);
                json = jsonObject.getJSONObject(key2);
                Long up = (Long)changeData.getNewValue();
                Long down = (Long)this.getModel().getValue(key2 + "_down");
                json.put("up", (Object)up);
                json.put("is_unlimited", (Object)Boolean.FALSE);
                this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
                if (down != null && down.compareTo(0L) != 0 && (up.compareTo(down) < 0 || up.compareTo(down) == 0)) {
                    confirmTip = ResManager.loadKDString((String)"\u4e0a\u9650\u5fc5\u987b\u5927\u4e8e\u4e0b\u9650", (String)"PosPortraitEditPlugin_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, key2 + "_up", confirmTip);
                    tip.setSuccess(false);
                    this.getView().showFieldTip(tip);
                } else {
                    rangeUpTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, key2 + "_up", null);
                    rangeUpTip.setSuccess(true);
                    this.getView().showFieldTip(rangeUpTip);
                    rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, key2 + "_down", null);
                    rangeDownTip.setSuccess(true);
                    this.getView().showFieldTip(rangeDownTip);
                }
            }
        }
        if (identify.contains("_down")) {
            if (((Boolean)this.getModel().getValue(key2 + "_nolimit")).booleanValue()) {
                this.getModel().setValue(key2 + "_down", null);
            } else {
                jsonObject = data.getJSONObject(key1);
                json = jsonObject.getJSONObject(key2);
                Long down = (Long)changeData.getNewValue();
                json.put("down", (Object)down);
                json.put("is_unlimited", (Object)Boolean.FALSE);
                this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
                Long up = (Long)this.getModel().getValue(key2 + "_up");
                if (up != null && up.compareTo(0L) != 0 && (up.compareTo(down) < 0 || up.compareTo(down) == 0)) {
                    confirmTip = ResManager.loadKDString((String)"\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u9650", (String)"PosPortraitEditPlugin_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, key2 + "_down", confirmTip);
                    tip.setSuccess(false);
                    this.getView().showFieldTip(tip);
                } else {
                    rangeUpTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, key2 + "_up", null);
                    rangeUpTip.setSuccess(true);
                    this.getView().showFieldTip(rangeUpTip);
                    rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, key2 + "_down", null);
                    rangeDownTip.setSuccess(true);
                    this.getView().showFieldTip(rangeDownTip);
                }
            }
        }
    }

    private void updateBigintEdit(String key1, String key2, ChangeData[] changes) {
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        ChangeData changeData = changes[0];
        Long newValue = (Long)changeData.getNewValue();
        if (null != newValue && !newValue.equals(0L)) {
            JSONObject jsonObject = data.getJSONObject(key1);
            jsonObject.put(key2, (Object)newValue);
            this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
        }
    }

    private void updateFieldEdit(String key1, String key2, ChangeData[] changes) {
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        ChangeData changeData = changes[0];
        String newStr = "N";
        boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue) {
            newStr = "Y";
        }
        JSONObject jsonObject = data.getJSONObject(key1);
        jsonObject.put(key2, (Object)newStr);
        this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
    }

    private void updateComboEdit(String key1, String key2, ChangeData[] changes) {
        JSONObject data = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
        ChangeData changeData = changes[0];
        String newValue = (String)changeData.getNewValue();
        JSONObject jsonObject = data.getJSONObject(key1);
        jsonObject.put(key2, (Object)newValue);
        this.getView().getParentView().getPageCache().put("portrait.data", data.toString());
    }

    private void initEdit(JSONObject data) {
        JSONArray jsonArray;
        CustomControl customcontrol = (CustomControl)this.getView().getControl("job_category_input");
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        String taskList = "";
        try {
            jsonArray = PositionLabelServiceHelper.getInstance().getLabelByPCode("job_category", "", "third_class", null, null, null);
            taskList = jsonArray.toJSONString();
        }
        catch (Exception ex) {
            logger.error("PosPortraitEditPlugin.initEdit.getLabelByPCode.job_category exception", (Throwable)ex);
        }
        map.put("setTaskList", taskList);
        jsonArray = new JSONArray();
        JSONObject positions = data.getJSONObject("positions");
        JSONObject category = positions.getJSONObject("job_category");
        if (null != category) {
            jsonArray.add((Object)category.getString("first_class"));
            jsonArray.add((Object)category.getString("second_class"));
            jsonArray.add((Object)category.getString("third_class"));
        }
        map.put("initSelected", jsonArray.toString());
        customcontrol.setData((Object)map);
        this.initComboEdit("job_level", data.getJSONObject("positions"));
        this.initComboEdit("position_type", data.getJSONObject("positions"));
        this.initComboEdit("minimum_education", data.getJSONObject("educations"));
        this.initComboEdit("first_education", data.getJSONObject("educations"));
        this.initFieldEdit("is_oversea_education", data.getJSONObject("educations"));
        this.initFieldEdit("is_full_time", data.getJSONObject("educations"));
        this.initScopeEdit("work_duration", data.getJSONObject("employments"));
        this.initScopeEdit("salary", data.getJSONObject("employments"));
        this.initBigintEdit("project_count", data.getJSONObject("employments"));
        this.initFieldEdit("is_oversea_employment", data.getJSONObject("employments"));
        this.initFieldEdit("is_management", data.getJSONObject("employments"));
        JSONObject skills = data.getJSONObject("skills");
        this.initComboEdit("job_skill_name", skills);
        this.initComboEdit("job_skill_skill_level", skills);
        this.initComboEdit("language_skill_name", skills);
        this.initComboEdit("language_skill_prop", skills);
        this.initComboEdit("language_skill_level", skills);
        JSONObject abilityQuality = data.getJSONObject("ability_quality");
        this.initComboEdit("ability_name", abilityQuality);
        this.initComboEdit("ability_level", abilityQuality);
        this.initComboEdit("quality_name", abilityQuality);
        this.initComboEdit("quality_level", abilityQuality);
        this.initScopeEdit("age", data.getJSONObject("others"));
        this.initComboEdit("duty_time", data.getJSONObject("others"));
        this.initFieldEdit("is_avoid_relatives", data.getJSONObject("others"));
    }

    private void initBigintEdit(String identify, JSONObject data) {
        String value = data.getString(identify);
        this.getModel().setValue(identify, (Object)value);
    }

    private void initScopeEdit(String identify, JSONObject data) {
        JSONObject json = data.getJSONObject(identify);
        if (null == json) {
            this.getModel().setValue(identify + "_nolimit", (Object)Boolean.FALSE);
            return;
        }
        String down = json.getString("down");
        String up = json.getString("up");
        String isUnlimited = json.getString("is_unlimited");
        if (HRStringUtils.equals((String)"true", (String)isUnlimited)) {
            this.getModel().setValue(identify + "_nolimit", (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{identify + "_up"});
            this.getView().setEnable(Boolean.FALSE, new String[]{identify + "_down"});
            return;
        }
        if (!HRStringUtils.equals((String)"0", (String)down)) {
            this.getModel().setValue(identify + "_down", (Object)down);
        }
        if (!HRStringUtils.equals((String)"0", (String)up)) {
            this.getModel().setValue(identify + "_up", (Object)up);
        }
    }

    private void initFieldEdit(String identify, JSONObject data) {
        String value = data.getString(identify);
        Boolean isOpen = Boolean.TRUE;
        if (!HRStringUtils.equals((String)"Y", (String)value)) {
            isOpen = Boolean.FALSE;
        }
        this.getModel().setValue(identify, (Object)isOpen);
    }

    private void initComboEdit(String identify, JSONObject data) {
        JSONArray jsonArray;
        ComboEdit comboEdit = (ComboEdit)this.getControl(identify);
        ArrayList comboItems = Lists.newArrayListWithExpectedSize((int)4);
        String taskList = ResManager.loadKDString((String)"[\"\u517c\u804c\", \"\u5168\u804c\", \"\u5b9e\u4e60\"]", (String)"PosPortraitEditPlugin_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        String mataKey = identify;
        if (HRStringUtils.equals((String)identify, (String)"job_skill_name")) {
            mataKey = "job_skill";
        }
        if (HRStringUtils.equals((String)identify, (String)"job_skill_skill_level")) {
            mataKey = "job_skill_level";
        }
        if (HRStringUtils.equals((String)identify, (String)"language_skill_name")) {
            mataKey = "language_skill";
        }
        if (HRStringUtils.equals((String)identify, (String)"language_skill_prop")) {
            mataKey = "language_prop";
        }
        if (HRStringUtils.equals((String)identify, (String)"language_skill_level")) {
            mataKey = "language_level";
        }
        if (HRStringUtils.equals((String)identify, (String)"ability_name")) {
            mataKey = "ability";
        }
        if (HRStringUtils.equals((String)identify, (String)"quality_name")) {
            mataKey = "quality";
        }
        String title = null;
        String jobThirdClass = null;
        if (HRStringUtils.equals((String)mataKey, (String)"job_skill")) {
            JSONObject data1 = JSON.parseObject((String)this.getView().getParentView().getPageCache().get("portrait.data"));
            JSONObject pos = data1.getJSONObject("positions");
            JSONObject jsonObj = pos.getJSONObject("job_category");
            title = pos.getString("title");
            jobThirdClass = jsonObj.getString("third_class");
        }
        try {
            jsonArray = PositionLabelServiceHelper.getInstance().getLabelByPCode(mataKey, "", "", title, null, jobThirdClass);
            taskList = jsonArray.toJSONString();
        }
        catch (Exception ex) {
            logger.error("PositionAPI queryTag fail {}", (Object)ex.getMessage());
        }
        jsonArray = JSON.parseArray((String)taskList);
        HashMap caption2Value = Maps.newHashMapWithExpectedSize((int)jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            ComboItem comboItem = new ComboItem();
            String value = jsonArray.getString(i);
            comboItem.setCaption(new LocaleString(value));
            comboItem.setValue(value);
            comboItems.add(comboItem);
            caption2Value.put(new LocaleString(value), value);
        }
        comboEdit.setComboItems((List)comboItems);
        String name = data.getString(identify);
        if (name == null || HRStringUtils.isEmpty((String)((String)caption2Value.get(new LocaleString(name))))) {
            this.getModel().setValue(identify, (Object)"");
        } else {
            this.getModel().setValue(identify, caption2Value.get(new LocaleString(name)));
        }
    }

    private void drawLabel(String secTitle, String firTitle, JSONArray labelArray) {
        ArrayList labelBOs = Lists.newArrayListWithExpectedSize((int)labelArray.size());
        for (int i = 0; i < labelArray.size(); ++i) {
            LabelBO labelBO = new LabelBO();
            labelBO.setName(labelArray.getJSONObject(i).getString("name"));
            labelBO.setLabelCategory(firTitle + "-" + secTitle + "-" + i);
            labelBOs.add(labelBO);
        }
        HashMap paramMap1 = Maps.newHashMapWithExpectedSize((int)1);
        paramMap1.put("items", DrawLabelUnits.createLabelShowPanel((List)labelBOs, (String)KEY_LABEL_SHOW_PANEL, (String)KEY_PREFIX_LABEL_PANEL, (String)CLASS_PERSONAL_LABEL, (String)COLOR_AI_LABEL, (String)KEY_PREFIX_VECTOR, (String)KEY_PREFIX_LABEL, (String)secTitle).createControl().get("items"));
        this.getView().updateControlMetadata(secTitle, (Map)paramMap1);
    }

    private void cascaderEnsureClick(String input, String secTitle, String firTitle, Map<String, JSONArray> secMap, String classNum, Map<String, JSONArray> sec2Labels) {
        JSONArray jsonArray1122 = secMap.get(secTitle);
        if (HRStringUtils.isEmpty((String)input)) {
            return;
        }
        JSONArray labelArray1 = sec2Labels.get(secTitle);
        if (null == labelArray1) {
            labelArray1 = new JSONArray(3);
        }
        HashSet labels1 = Sets.newHashSetWithExpectedSize((int)labelArray1.size());
        for (int i = 0; i < labelArray1.size(); ++i) {
            labels1.add(labelArray1.getString(i));
        }
        JSONArray inputArray = new JSONArray();
        JSONArray inputArray1 = new JSONArray();
        JSONArray inputArray133 = JSON.parseArray((String)input);
        for (int i = 0; i < inputArray133.size(); ++i) {
            String name = inputArray133.getJSONObject(i).getString(classNum);
            if (labels1.contains(name)) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)name);
            jsonObject.put("labelCategory", (Object)(firTitle + "-" + secTitle + "-" + jsonArray1122.size()));
            jsonArray1122.add((Object)jsonObject);
            labelArray1.add((Object)name);
            inputArray.add((Object)name);
            inputArray1.add(inputArray133.get(i));
        }
        sec2Labels.put(secTitle, labelArray1);
        this.getPageCache().put("sec2Labels", JSON.toJSONString(sec2Labels));
        this.getPageCache().put("sec.label.map", JSON.toJSONString(secMap));
        this.drawLabel(secTitle, firTitle, jsonArray1122);
        if (HRStringUtils.equals((String)"bonus", (String)secTitle)) {
            input = inputArray.toJSONString();
        }
        if (HRStringUtils.equals((String)"industry", (String)secTitle)) {
            input = inputArray1.toJSONString();
        }
        this.updateDataWhenAdd(firTitle, secTitle, input);
    }

    private void yesLanguageSkill(String secTitle, String firTitle, Map<String, JSONArray> secMap, Map<String, JSONArray> sec2Labels, JSONArray jsonArray1122) {
        String value1 = (String)this.getModel().getValue("language_skill_name");
        String value2 = (String)this.getModel().getValue("language_skill_prop");
        String value3 = (String)this.getModel().getValue("language_skill_level");
        if (HRStringUtils.isEmpty((String)value1) && HRStringUtils.isEmpty((String)value2) && HRStringUtils.isEmpty((String)value3)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)value1) && (HRStringUtils.isNotEmpty((String)value2) || HRStringUtils.isNotEmpty((String)value3))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "_area"});
            this.getView().setVisible(Boolean.FALSE, new String[]{secTitle + "-+"});
            String confirmTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bed\u8a00\u540d\u79f0", (String)"PosPortraitEditPlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, "language_skill_name", confirmTip);
            tip.setSuccess(false);
            this.getView().showFieldTip(tip);
            return;
        }
        FieldTip rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "language_skill_name", null);
        rangeDownTip.setSuccess(true);
        this.getView().showFieldTip(rangeDownTip);
        JSONArray labelArray = sec2Labels.get(secTitle);
        if (null == labelArray) {
            labelArray = new JSONArray(3);
        }
        HashSet labels = Sets.newHashSetWithExpectedSize((int)labelArray.size());
        for (int i = 0; i < labelArray.size(); ++i) {
            labels.add(labelArray.getString(i));
        }
        String name0 = value1;
        if (HRStringUtils.isNotEmpty((String)value2)) {
            name0 = name0 + "-" + value2;
        }
        if (HRStringUtils.isNotEmpty((String)value3)) {
            name0 = name0 + "-" + value3;
        }
        if (labels.contains(name0)) {
            return;
        }
        labelArray.add((Object)name0);
        sec2Labels.put(secTitle, labelArray);
        this.getPageCache().put("sec2Labels", JSON.toJSONString(sec2Labels));
        this.label(secTitle, firTitle, secMap, jsonArray1122, name0);
        JSONObject job_skill = new JSONObject();
        job_skill.put("name", (Object)value1);
        job_skill.put("prop", (Object)value2);
        job_skill.put("level", (Object)value3);
        JSONArray job_skill_array = new JSONArray(3);
        job_skill_array.add((Object)job_skill);
        this.updateDataWhenAdd(firTitle, secTitle, job_skill_array.toString());
        this.getModel().setValue("language_skill_name", (Object)"");
        this.getModel().setValue("language_skill_prop", (Object)"");
        this.getModel().setValue("language_skill_level", (Object)"");
    }

    private void yesTwo(String secTitle, String firTitle, Map<String, JSONArray> secMap, Map<String, JSONArray> sec2Labels, JSONArray jsonArray1122, String id1, String id2, String key1, String key2, String confirmTip) {
        String value1 = (String)this.getModel().getValue(id1);
        String value2 = (String)this.getModel().getValue(id2);
        if (HRStringUtils.isEmpty((String)value1) && HRStringUtils.isEmpty((String)value2)) {
            return;
        }
        if (HRStringUtils.isEmpty((String)value1) && HRStringUtils.isNotEmpty((String)value2)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{secTitle + "_area"});
            this.getView().setVisible(Boolean.FALSE, new String[]{secTitle + "-+"});
            FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, id1, confirmTip);
            tip.setSuccess(false);
            this.getView().showFieldTip(tip);
            return;
        }
        FieldTip rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, id1, null);
        rangeDownTip.setSuccess(true);
        this.getView().showFieldTip(rangeDownTip);
        JSONArray labelArray = sec2Labels.get(secTitle);
        if (null == labelArray) {
            labelArray = new JSONArray(3);
        }
        HashSet labels = Sets.newHashSetWithExpectedSize((int)labelArray.size());
        for (int i = 0; i < labelArray.size(); ++i) {
            labels.add(labelArray.getString(i));
        }
        String name0 = value1;
        if (HRStringUtils.isNotEmpty((String)value2)) {
            name0 = name0 + "-" + value2;
        }
        if (labels.contains(name0)) {
            return;
        }
        labelArray.add((Object)name0);
        sec2Labels.put(secTitle, labelArray);
        this.getPageCache().put("sec2Labels", JSON.toJSONString(sec2Labels));
        this.label(secTitle, firTitle, secMap, jsonArray1122, name0);
        JSONObject job_skill = new JSONObject();
        job_skill.put(key1, (Object)value1);
        job_skill.put(key2, (Object)value2);
        JSONArray job_skill_array = new JSONArray(3);
        job_skill_array.add((Object)job_skill);
        this.updateDataWhenAdd(firTitle, secTitle, job_skill_array.toString());
        this.getModel().setValue(id1, (Object)"");
        this.getModel().setValue(id2, (Object)"");
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        FormShowParameter formShowParameter = (FormShowParameter)evt.getSource();
        Map map = (Map)formShowParameter.getCustomParam("sec.label.map");
        for (Map.Entry entry : map.entrySet()) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            FlexPanelAp labelShowPanel = DrawLabelUnits.createLabelShowPanel((List)((List)entry.getValue()), (String)KEY_LABEL_SHOW_PANEL, (String)KEY_PREFIX_LABEL_PANEL, (String)CLASS_PERSONAL_LABEL, (String)COLOR_AI_LABEL, (String)KEY_PREFIX_VECTOR, (String)KEY_PREFIX_LABEL, (String)((String)entry.getKey()));
            params.put("id", entry.getKey());
            params.put("items", labelShowPanel.createControl().get("items"));
            evt.getItems().add(params);
        }
    }
}

