/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.position.service.PosPortraitConvertHelper;
import kd.tsc.tsirm.business.domain.position.service.PosPortraitHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionLabelServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.enums.PosPortraitOperateEnum;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;

public class PosPortraitPlugin
extends HRDynamicFormBasePlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(PosPortraitPlugin.class);
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private PosPortraitHelper posPortraitHelper = new PosPortraitHelper();
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_SAVE = "btnsave";
    private static final String BTN_RESET = "btnreset";
    private static final String MATA_TSIRM_POSPORTRAITEDIT = "tsirm_posportraitedit";
    private static final String MATA_TSIRM_POSPORTRAITVIEW = "tsirm_posportraitview";
    private static final String FLEX_POSPORTRAITFLEX = "posportraitflex";
    private static final String MATA_POSNAME = "posname";
    private static final String POS_ID = "posId";
    private static final String POS_NAME = "posName";
    private static final String POS_INFO = "positionInfo";
    private static final Map<String, Consumer> CLICK_EVENT_MAP = new HashMap<String, Consumer>(16);

    public PosPortraitPlugin() {
        CLICK_EVENT_MAP.put(BTN_EDIT, evt -> this.editClick());
        CLICK_EVENT_MAP.put(BTN_SAVE, evt -> this.saveClick());
        CLICK_EVENT_MAP.put(BTN_RESET, evt -> this.resetClick());
    }

    public void registerListener(EventObject evt) {
        Label editLabel = (Label)this.getView().getControl(BTN_EDIT);
        editLabel.addClickListener((ClickListener)this);
        Label saveLabel = (Label)this.getView().getControl(BTN_SAVE);
        saveLabel.addClickListener((ClickListener)this);
        Label resetLabel = (Label)this.getView().getControl(BTN_RESET);
        resetLabel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        Consumer consumer = CLICK_EVENT_MAP.get(control.getKey());
        if (null == consumer) {
            return;
        }
        consumer.accept(evt);
    }

    public void afterCreateNewData(EventObject evt) {
        JSONObject jsonObject;
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long posId = (Long)formShowParameter.getCustomParam(POS_ID);
        String posName = (String)formShowParameter.getCustomParam(POS_NAME);
        String posInfo = (String)formShowParameter.getCustomParam(POS_INFO);
        Boolean isClickedPortraitBtn = (Boolean)formShowParameter.getCustomParam("isClickedPortraitBtn");
        this.getView().getPageCache().put(POS_ID, posId.toString());
        this.getView().getPageCache().put(POS_NAME, posName);
        this.getView().getPageCache().put(POS_INFO, posInfo);
        CACHE.put("portrait_status_" + posId, (Object)"view", Integer.MAX_VALUE, TimeUnit.DAYS);
        Label posNameLabel = (Label)this.getView().getControl(MATA_POSNAME);
        posNameLabel.setText(ResManager.loadKDString((String)"{0}\u804c\u4f4d\u753b\u50cf", (String)"PosPortraitPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{posName}));
        String porInfo = "";
        if (isClickedPortraitBtn.booleanValue()) {
            try {
                BizResult bizResult = this.posPortraitHelper.operate(posId, posInfo, PosPortraitOperateEnum.POS_PORTRAIT_BTN);
                porInfo = (String)bizResult.getData();
            }
            catch (Exception ex) {
                logger.error("PosPortraitPlugin.afterCreateNewData.operate() exception", (Throwable)ex);
            }
        }
        if (!isClickedPortraitBtn.booleanValue() && HRStringUtils.isEmpty((String)(porInfo = (String)CACHE.get("portrait_id_" + posId))) && null != (jsonObject = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(posInfo))) {
            porInfo = jsonObject.toJSONString();
            CACHE.put("portrait_id_" + posId, (Object)porInfo);
        }
        if (HRStringUtils.isNotEmpty((String)porInfo)) {
            double rate = this.getRate(porInfo);
            Label rateLabel = (Label)this.getView().getControl("rate");
            rateLabel.setText(rate + "%");
        }
        this.setFlexShowForm(posName, MATA_TSIRM_POSPORTRAITVIEW, porInfo);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)BTN_RESET) && (result = messageBoxClosedEvent.getResult()) == MessageBoxResult.Yes) {
            String posId = this.getView().getPageCache().get(POS_ID);
            String posInfo = this.getView().getPageCache().get(POS_INFO);
            String posName = this.getView().getPageCache().get(POS_NAME);
            try {
                JSONObject jsonObject = PositionLabelServiceHelper.getInstance().getLabelByPositionInfo(posInfo);
                String sour = jsonObject.toJSONString();
                this.getPageCache().put("portrait.data", sour);
                this.setFlexShowForm(posName, MATA_TSIRM_POSPORTRAITEDIT, sour);
                if (HRStringUtils.isNotEmpty((String)sour)) {
                    double rate = this.getRate(sour);
                    Label rateLabel = (Label)this.getView().getControl("rate");
                    rateLabel.setText(rate + "%");
                }
                PositionLabelServiceHelper.getInstance().savePositionLabelToAi(Long.valueOf(Long.parseLong(posId)), posInfo, Boolean.FALSE);
            }
            catch (Exception ex) {
                logger.error("PosPortraitPlugin.confirmCallBack() exception", (Throwable)ex);
            }
        }
    }

    private void setFlexShowForm(String positionName, String formId, String sour) {
        if (HRStringUtils.isEmpty((String)sour)) {
            sour = new JSONObject().toJSONString();
        }
        FormShowParameter showParameter = new FormShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setTargetKey(FLEX_POSPORTRAITFLEX);
        showParameter.setFormId(formId);
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)3);
        paramMap.put("positionid", positionName);
        JSONObject data = JSON.parseObject((String)sour);
        paramMap.put("portrait.data", data);
        HashMap firMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap secMap = Maps.newHashMapWithExpectedSize((int)3);
        HashMap sec2Labels = Maps.newHashMapWithExpectedSize((int)3);
        HashMap sec2Fir = Maps.newHashMapWithExpectedSize((int)3);
        PosPortraitConvertHelper posPortraitConvertHelper = new PosPortraitConvertHelper();
        for (String fir : posPortraitConvertHelper.getOrderFirTitles()) {
            ArrayList firValues = Lists.newArrayListWithExpectedSize((int)3);
            JSONObject json = data.getJSONObject(fir);
            for (String sec : (List)posPortraitConvertHelper.getOrderSecTitles().get(fir)) {
                sec2Fir.put(sec, fir);
                ArrayList secValues = Lists.newArrayListWithExpectedSize((int)3);
                if (null == json) continue;
                String value = json.getString(sec);
                if (HRStringUtils.isEmpty((String)value) || HRStringUtils.equals((String)"null", (String)value)) {
                    secMap.put(sec, new ArrayList());
                    continue;
                }
                List names = posPortraitConvertHelper.viewConvert(sec, value);
                if (names.size() > 0) {
                    Set<String> labels = this.beGoodView(names, secValues, firValues, sec, fir);
                    secMap.put(sec, secValues);
                    sec2Labels.put(sec, labels);
                    continue;
                }
                secMap.put(sec, new ArrayList());
            }
            firMap.put(fir, firValues);
        }
        paramMap.put("fir.label.map", firMap);
        paramMap.put("sec.label.map", secMap);
        paramMap.put("sec2Fir", sec2Fir);
        paramMap.put("sec2Labels", sec2Labels);
        showParameter.setCustomParams((Map)paramMap);
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.InContainer));
        this.getView().showForm(showParameter);
    }

    private Set<String> beGoodView(List<String> names, List<LabelBO> secValues, List<LabelBO> firValues, String sec, String fir) {
        HashSet labels = Sets.newHashSetWithExpectedSize((int)3);
        for (int i = 0; i < names.size(); ++i) {
            LabelBO labelBO = new LabelBO();
            if (HRStringUtils.isEmpty((String)names.get(i)) || HRStringUtils.equals((String)"null", (String)names.get(i))) continue;
            labelBO.setName(names.get(i));
            labelBO.setLabelCategory(fir + "-" + sec + "-" + i);
            secValues.add(labelBO);
            firValues.add(labelBO);
            labels.add(names.get(i));
        }
        return labels;
    }

    private double getRate(String jsonStr) {
        HashSet isSet = Sets.newHashSetWithExpectedSize((int)5);
        isSet.add("is_oversea_education");
        isSet.add("is_oversea_employment");
        isSet.add("is_full_time");
        isSet.add("is_management");
        isSet.add("is_avoid_relatives");
        HashSet noLimitSet = Sets.newHashSetWithExpectedSize((int)3);
        noLimitSet.add("work_duration");
        noLimitSet.add("salary");
        noLimitSet.add("age");
        JSONObject data = JSON.parseObject((String)jsonStr);
        Set keys = data.keySet();
        double hasValue = 1.0;
        double allCount = 31.0;
        for (String fir : keys) {
            JSONObject firJson = data.getJSONObject(fir);
            Set set = firJson.keySet();
            for (String sec : set) {
                String value;
                if (HRStringUtils.equals((String)sec, (String)"title") || HRStringUtils.equals((String)sec, (String)"certificate") || HRStringUtils.equals((String)sec, (String)"domain") || HRStringUtils.isEmpty((String)(value = firJson.getString(sec))) || HRStringUtils.equals((String)"null", (String)value)) continue;
                try {
                    JSONArray jsonArray = JSON.parseArray((String)value);
                    if (null == jsonArray || jsonArray.size() <= 0) continue;
                    hasValue += 1.0;
                }
                catch (JSONException ex) {
                    try {
                        JSONObject secJsonObj = JSON.parseObject((String)value);
                        if (HRStringUtils.equals((String)sec, (String)"job_category")) {
                            if (!HRStringUtils.isNotEmpty((String)secJsonObj.getString("third_class"))) continue;
                            hasValue += 1.0;
                            continue;
                        }
                        if (noLimitSet.contains(sec)) {
                            String unlimit = secJsonObj.getString("is_unlimited");
                            String up = secJsonObj.getString("up");
                            String down = secJsonObj.getString("down");
                            if (!HRStringUtils.equals((String)"true", (String)unlimit) && (!HRStringUtils.isNotEmpty((String)up) || HRStringUtils.equals((String)"0", (String)up)) && (!HRStringUtils.isNotEmpty((String)down) || HRStringUtils.equals((String)"0", (String)down))) continue;
                            hasValue += 1.0;
                            continue;
                        }
                        if (null == secJsonObj || secJsonObj.keySet().size() <= 0) continue;
                        hasValue += 1.0;
                    }
                    catch (JSONException evt) {
                        if (isSet.contains(sec)) {
                            if (!HRStringUtils.equals((String)value, (String)"Y")) continue;
                            hasValue += 1.0;
                            continue;
                        }
                        hasValue += 1.0;
                    }
                }
            }
        }
        double rate = 0.0;
        BigDecimal rateDecimal = BigDecimal.valueOf(hasValue / allCount * 100.0);
        rate = rateDecimal.setScale(2, RoundingMode.HALF_UP).doubleValue();
        return rate;
    }

    private void resetClick() {
        ConfirmCallBackListener listener = new ConfirmCallBackListener(BTN_RESET, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u6839\u636e\u62db\u8058\u804c\u4f4d\u4fe1\u606f\u91cd\u65b0\u751f\u6210\u804c\u4f4d\u753b\u50cf\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"PosPortraitPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
    }

    private void saveClick() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long posId = (Long)formShowParameter.getCustomParam(POS_ID);
        String posName = (String)formShowParameter.getCustomParam(POS_NAME);
        Boolean isClickedPortraitBtn = (Boolean)formShowParameter.getCustomParam("isClickedPortraitBtn");
        if (!isClickedPortraitBtn.booleanValue()) {
            TscMutexHelper.releaseMutex((String)"tsirm_posportrait", (Long)posId, (String)"donothing");
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_EDIT});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_RESET});
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SAVE});
        CACHE.put("portrait_status_" + posId, (Object)"view", Integer.MAX_VALUE, TimeUnit.DAYS);
        String data = this.getPageCache().get("portrait.data");
        if (HRStringUtils.isNotEmpty((String)data)) {
            double rate = this.getRate(data);
            Label rateLabel = (Label)this.getView().getControl("rate");
            rateLabel.setText(rate + "%");
        }
        CACHE.put("portrait_id_" + posId, (Object)data, Integer.MAX_VALUE, TimeUnit.DAYS);
        try {
            BizResult result = this.posPortraitHelper.getPortraitStatus(posId);
            if (result != null && result.getCode().equals(PosPortraitHelper.CODE_HAVE_PORTRAIT)) {
                PositionLabelServiceHelper.getInstance().savePositionLabelToAi(posId, data, Boolean.FALSE);
            }
        }
        catch (Exception ex) {
            logger.error("PosPortraitPlugin.saveClick() exception", (Throwable)ex);
        }
        this.setFlexShowForm(posName, MATA_TSIRM_POSPORTRAITVIEW, data);
    }

    private void editClick() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long posId = (Long)formShowParameter.getCustomParam(POS_ID);
        String posName = (String)formShowParameter.getCustomParam(POS_NAME);
        Boolean isClickedPortraitBtn = (Boolean)formShowParameter.getCustomParam("isClickedPortraitBtn");
        if (!isClickedPortraitBtn.booleanValue()) {
            ArrayList posIds = Lists.newArrayListWithExpectedSize((int)1);
            posIds.add(posId);
            DynamicObject[] mutexDts = TscMutexHelper.checkHasMutex((String)"tsirm_posportrait", (List)posIds, (String)"donothing");
            if (mutexDts != null && mutexDts.length > 0) {
                String name = mutexDts[0].getString("user.name");
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("", (IFormPlugin)this);
                String tip = ResManager.loadKDString((String)"{0} \u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"PosPortraitPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{name});
                this.getView().showConfirm(tip, MessageBoxOptions.None, confirmCallBackListener);
                return;
            }
            TscMutexHelper.requireMutex((String)"tsirm_posportrait", (Object)posId, (String)"donothing", (StringBuilder)new StringBuilder());
        }
        String porInfo = (String)CACHE.get("portrait_id_" + posId);
        this.setFlexShowForm(posName, MATA_TSIRM_POSPORTRAITEDIT, porInfo);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EDIT});
        BizResult result = null;
        try {
            result = this.posPortraitHelper.getPortraitStatus(posId);
        }
        catch (Exception exception) {
            logger.error("PosPortraitPlugin.editClick.getPortraitStatus() exception");
        }
        if (result != null && result.getCode().equals(PosPortraitHelper.CODE_HAVE_PORTRAIT)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_RESET});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_RESET});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SAVE});
        CACHE.put("portrait_status_" + posId, (Object)"edit", Integer.MAX_VALUE, TimeUnit.DAYS);
    }
}

