/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsrbd.business.domain.label.service.LabelBO;

public class PosPortraitViewPlugin
extends HRDynamicFormBasePlugin {
    private static final String KEY_LABEL_SHOW_PANEL = "labelshowpanel";
    private static final String KEY_PREFIX_LABEL = "label";
    private static final String KEY_PREFIX_LABEL_PANEL = "completelabelpanel";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs evt) {
        FormShowParameter formShowParameter = (FormShowParameter)evt.getSource();
        Map map = (Map)formShowParameter.getCustomParam("fir.label.map");
        for (Map.Entry entry : map.entrySet()) {
            HashMap params = Maps.newHashMapWithExpectedSize((int)2);
            FlexPanelAp labelShowPanel = this.createLabelShowPanel((List)entry.getValue());
            params.put("id", entry.getKey());
            params.put("items", labelShowPanel.createControl().get("items"));
            evt.getItems().add(params);
        }
    }

    private FlexPanelAp createLabelShowPanel(List<LabelBO> labelBOList) {
        FlexPanelAp labelShowPanelAp = new FlexPanelAp();
        labelShowPanelAp.setKey(KEY_LABEL_SHOW_PANEL);
        for (LabelBO labelBO : labelBOList) {
            FlexPanelAp completeLabelPanel = this.createCompleteLabelPanel(labelBO);
            labelShowPanelAp.getItems().add(completeLabelPanel);
        }
        return labelShowPanelAp;
    }

    private LabelAp createLabel(String labelName, String labelTagObjId) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(KEY_PREFIX_LABEL + labelTagObjId);
        labelAp.setName(new LocaleString(labelName));
        return labelAp;
    }

    private FlexPanelAp createCompleteLabelPanel(LabelBO labelBO) {
        FlexPanelAp completeLabelPanelAp = new FlexPanelAp();
        completeLabelPanelAp.setKey(KEY_PREFIX_LABEL_PANEL + labelBO.getLabelTagObjId());
        completeLabelPanelAp.setLazyLoad(false);
        completeLabelPanelAp.setGrow(0);
        completeLabelPanelAp.setCustomeStyles("eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjRDlEOUQ5O1xuICAgIHBhZGRpbmc6IDAgOHB4O1xuICAgIG1hcmdpbjogMCA4cHggOHB4IDA7XG4gICAgYm9yZGVyLXJhZGl1czogMTBweDtcbiAgICBjb2xvcjogIzY2NjY2NjtcbiAgICBoZWlnaHQ6IDIwcHg7XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICBtYXgtd2lkdGg6IDE0NHB4O1xuICAgIGZsZXgtd3JhcDogbm93cmFwO1xuICAgICB3b3JkLWJyZWFrOiBicmVhay1hbGw7XG59XG5cbiQgLlVTNlZyLWNpe1xuICAgZmxleC1zaHJpbms6IDA7XG59In0=");
        String idStr = String.valueOf(labelBO.getLabelTagObjId());
        LabelAp label = this.createLabel(labelBO.getName(), idStr);
        completeLabelPanelAp.getItems().add(label);
        return completeLabelPanelAp;
    }
}

