/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.tsc.tsirm.extpoint.position.IDynamicObjectCopyService;
import kd.tsc.tsirm.business.domain.position.service.PositionBaseInfoCopyService;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageService;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsirm.common.constants.position.PositionConstants;
import kd.tsc.tsirm.formplugin.web.position.service.PositionJdService;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleBizHelper;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbs.common.utils.CodeRuleUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PositionAddEdit
extends HRDataBaseEdit
implements TabSelectListener,
BeforeF7SelectListener,
AfterF7SelectListener,
UploadListener {
    private static final Log log = LogFactory.getLog(PositionAddEdit.class);
    private static final String NEXT_STEP_BUTTON = "nextbutton";
    private static final String LAST_STEP_BUTTON = "lastbutton";
    private static final String SAVE_TEMP = "savetemp";
    private static final String BAR_PORTRAIT = "bar_portrait";
    private static final String SUBMIT_ACTIVE = "submitactive";
    private static final String TAB_NAME = "tabap";
    private static final String TAB_BASE_MSG = "basemsg";
    private static final String TAB_MANAGE_MSG = "managemsg";
    private static final String TAB_RECPLAN = "recplan";
    private static final String SAVE_COMMIT = "saveandcommit";
    private static final String SAVE = "savewithoutvail";
    private static final String CACHE_KEY_F7SELECTADMINORGIDLIST = "f7SelectAdminOrgIdList";
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private static final TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();

    public void preOpenForm(PreOpenFormEventArgs event) {
        String caption;
        super.preOpenForm(event);
        if (!event.isCancel()) {
            log.info("PositionAddEdit.preOpenForm");
            Map verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
            if (!verifyCert.isEmpty() && verifyCert.containsKey("infoType")) {
                String infoType = (String)verifyCert.get("infoType");
                if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                    event.setCancelMessage((String)verifyCert.get("message"));
                    event.setCancel(true);
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)(caption = event.getFormShowParameter().getCaption()))) {
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u62db\u8058\u804c\u4f4d", (String)"PositionAddEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else {
            event.getFormShowParameter().setCaption(caption);
        }
        event.getFormShowParameter().setCustomParam("isFirstOpen", (Object)"1");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        log.info("PositionAddEdit.afterCreateNewData.begin");
        this.verifyCert();
        log.info("PositionAddEdit.afterCreateNewData.end");
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.showControl(LAST_STEP_BUTTON, Boolean.FALSE);
        this.showControl(BAR_PORTRAIT, Boolean.FALSE);
        this.showControl("bar_submit", Boolean.TRUE);
        this.getModel().setDataChanged(false);
        String copyId = (String)this.getView().getFormShowParameter().getCustomParam("copyId");
        if (HRStringUtils.isNotEmpty((String)copyId)) {
            HRPluginProxy proxy = HRPlugInProxyFactory.create((Object)new PositionBaseInfoCopyService(), IDynamicObjectCopyService.class, (String)"kd.sdk.tsc.tsirm.extpoint.position.IDynamicObjectCopyService", null);
            proxy.callAfter(service -> {
                if (service != null) {
                    service.copy(this.getView(), this.getModel());
                }
                return null;
            });
            this.getModel().setDataChanged(false);
            this.setAttachment(copyId);
            FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "createorg", null);
            fieldTip.setSuccess(true);
            this.getView().showFieldTip(fieldTip);
        }
        this.setInterViewer();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        Optional.of(propertyName).filter("name"::equals).ifPresent(key -> {
            LocaleDynamicObjectCollection newValueCollection = (LocaleDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            List list = newValueCollection.stream().filter(dynamicObject -> null != dynamicObject && HRStringUtils.isNotEmpty((String)dynamicObject.getString("name"))).collect(Collectors.toList());
            PositionJdService.getInstance().setGptEnable(this.getView(), CollectionUtils.isNotEmpty(list));
        });
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{NEXT_STEP_BUTTON, LAST_STEP_BUTTON, SAVE_TEMP, SUBMIT_ACTIVE, "bar_submit"});
        Tab tab = (Tab)this.getView().getControl(TAB_NAME);
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit adminOrg = (BasedataEdit)this.getControl("adminorg");
        adminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        adminOrg.addAfterF7SelectListener((AfterF7SelectListener)this);
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("createorg");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterRemove(UploadEvent evt) {
        super.afterRemove(evt);
        Object[] urls = evt.getUrls();
        LinkedHashMap url = (LinkedHashMap)urls[0];
        Object uid = url.get("uid");
        if (null == uid) {
            return;
        }
        AttachmentServiceHelper.removeTemp((String)"tsirm_positiontpl", (String)this.getView().getPageId(), uid);
        String strAttachments = this.getView().getPageCache().get("attachmentpanelap");
        if (HRStringUtils.isNotEmpty((String)strAttachments)) {
            List attachments = (List)SerializationUtils.fromJsonString((String)strAttachments, List.class);
            Optional.ofNullable(attachments).ifPresent(attachList -> {
                ArrayList newAttachments = Lists.newArrayListWithCapacity((int)attachList.size());
                ArrayList deleteAttachments = Lists.newArrayListWithCapacity((int)attachList.size());
                attachList.forEach(map -> {
                    if (!uid.equals(map.get("uid"))) {
                        newAttachments.add(map);
                    } else {
                        deleteAttachments.add(map.get("uid"));
                    }
                });
                this.getView().getPageCache().put("attachmentpanelap", SerializationUtils.toJsonString((Object)newAttachments));
                this.getView().getPageCache().put("attachmentpanelapDELETE", SerializationUtils.toJsonString((Object)deleteAttachments));
            });
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        PositionJdService.getInstance().customEvent(e, this.getView());
        String copyId = (String)this.getView().getFormShowParameter().getCustomParam("copyId");
        if (HRStringUtils.isNotEmpty((String)copyId)) {
            this.setAttachment(copyId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String currentTab = ((Tab)this.getView().getControl(TAB_NAME)).getCurrentTab();
        switch (key) {
            case "nextbutton": {
                this.nextStepButton(currentTab);
                break;
            }
            case "lastbutton": {
                this.lastStepButton(currentTab);
                break;
            }
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        if (TAB_BASE_MSG.equals(subTabKey)) {
            this.setBaseMsgButton();
        } else {
            this.setManageMsgButton();
        }
        PositionManageService.getInstance().setDefaultRecCategory(this.getView());
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        if (this.getView().getFormShowParameter().getCustomParam("isFirstOpen") == null) {
            this.getView().getFormShowParameter().setCustomParam("copyId", null);
        }
        this.getView().getFormShowParameter().setCustomParam("isFirstOpen", null);
        this.getView().cacheFormShowParameter();
        this.setF7SelectAdminOrgIdListInPageCache();
    }

    private void setF7SelectAdminOrgIdListInPageCache() {
        List adminOrgAllIdList;
        MulBasedataDynamicObjectCollection adminOrgAll = (MulBasedataDynamicObjectCollection)this.getModel().getValue("adminorgs");
        if (ObjectUtils.isNotEmpty((Object)adminOrgAll) && ObjectUtils.isNotEmpty(adminOrgAllIdList = adminOrgAll.stream().map(adminorg -> adminorg.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            this.getPageCache().put(CACHE_KEY_F7SELECTADMINORGIDLIST, SerializationUtils.serializeToBase64(adminOrgAllIdList));
        }
    }

    private void showPositionViewFromModify(String positionId, String operateKey) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tsirm_position_view");
        baseShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setCaption(this.getModel().getDataEntity().getString("name"));
        baseShowParameter.setCloseCallBack(new CloseCallBack("kd.tsc.tsirm.formplugin.web.position.PositionList", "tsirm_positiontpl"));
        baseShowParameter.setPkId((Object)positionId);
        baseShowParameter.setCustomParam("messageFlag", (Object)operateKey);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean cond1;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        String positionId = this.getModel().getDataEntity().getString("id");
        Boolean modify = (Boolean)this.getView().getFormShowParameter().getCustomParam("modify");
        boolean bl = cond1 = SAVE.equals(operateKey) || SAVE_COMMIT.equals(operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey);
        if (modify != null && modify.booleanValue() && cond1) {
            this.showPositionViewFromModify(positionId, operateKey);
        } else if ((SAVE_COMMIT.equals(operateKey) || HRStringUtils.equals((String)"submit", (String)operateKey)) && operationResult.isSuccess()) {
            BaseShowParameter baseShowParameter = new BaseShowParameter();
            baseShowParameter.setFormId("tsirm_position_view");
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.VIEW);
            baseShowParameter.setCaption(this.getModel().getDataEntity().getString("name"));
            baseShowParameter.setCloseCallBack(new CloseCallBack("kd.tsc.tsirm.formplugin.web.position.PositionList", "tsirm_positiontpl"));
            baseShowParameter.setPkId((Object)positionId);
            baseShowParameter.setCustomParam("messageFlag", (Object)operateKey);
            baseShowParameter.setPageId(this.getPageId(positionId));
            String copyParentViewId = (String)this.getView().getFormShowParameter().getCustomParam("copyParentViewId");
            if (HRStringUtils.isNotEmpty((String)copyParentViewId)) {
                baseShowParameter.setCustomParam("parentViewId", (Object)copyParentViewId);
                IFormView view = this.getView().getView(copyParentViewId);
                if (null != view) {
                    this.getView().sendFormAction(view);
                }
            } else {
                baseShowParameter.setCustomParam("parentViewId", (Object)this.getView().getParentView().getPageId());
            }
            this.getView().getFormShowParameter().getCustomParams().remove("copyId");
            this.getView().showForm((FormShowParameter)baseShowParameter);
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map verifyCert;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = formOperate.getOption();
        operateOption.setVariableValue("operationValue", "false");
        String operateKey = formOperate.getOperateKey();
        if (("submit".equals(operateKey) || SAVE_COMMIT.equals(operateKey)) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType") && VerifyCertTypeEnum.FORBIDDEN.getValue().equals(verifyCert.get("infoType"))) {
            this.getView().showErrorNotification((String)verifyCert.get("message"));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)"submit", (String)operateKey) && !PositionBillDataHelper.checkSubmitPerm().booleanValue()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7ba1\u7406\u7684\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355\u201d\u7684\u201c\u63d0\u4ea4\u201d\u7684\u529f\u80fd\u6743\u9650", (String)"PositionAddEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)SAVE_COMMIT, (String)operateKey) && !PositionBillDataHelper.checkCommitPerm().booleanValue()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7ba1\u7406\u7684\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355\u201d\u7684\u201c\u63d0\u4ea4\u5e76\u751f\u6548\u201d\u7684\u529f\u80fd\u6743\u9650", (String)"PositionAddEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        if (SAVE_COMMIT.equals(operateKey) || SAVE.equals(operateKey)) {
            if (this.getModel().getValue("adminorg") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u653f\u7ec4\u7ec7\u3002", (String)"PositionAddEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String copyId = (String)this.getView().getFormShowParameter().getCustomParam("copyId");
            if (HRStringUtils.isNotEmpty((String)copyId)) {
                CodeRuleUtils.generateOneCodeRule((String)"number", (String)"tsirm_position", (DynamicObject)this.getModel().getDataEntity());
                operateOption.setVariableValue("copyid", copyId);
                this.getView().getFormShowParameter().setCustomParam("copyId", (Object)"");
            }
        }
        if (SAVE_COMMIT.equals(operateKey) || SAVE.equals(operateKey) || "submit".equals(operateKey)) {
            String deleteAttachment = this.getView().getPageCache().get("attachmentpanelapDELETE");
            operateOption.setVariableValue("attachmentpanelapDELETE", deleteAttachment);
        }
        formOperate.setOption(operateOption);
    }

    private void setInterViewer() {
        Boolean positionInterviewFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("posInterviewerForm");
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (positionInterviewFlag != null && positionInterviewFlag.booleanValue() || HRStringUtils.isNotEmpty((String)source) && HRStringUtils.equals((String)source, (String)"recreq")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_PORTRAIT, "bar_save", "bar_submit", SUBMIT_ACTIVE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"recplanpanel", TAB_BASE_MSG, TAB_MANAGE_MSG, "managepanel"});
        }
    }

    public String getPageId(String positionId) {
        List idList;
        StringBuilder stringBuilder = new StringBuilder();
        String pageId = PageUtils.getPageId((String)positionId, (String)"tsirm", (String)"tsirm_position_view", (String)this.getView().getFormShowParameter().getRootPageId());
        stringBuilder.append(pageId);
        Object recReqIds = this.getView().getFormShowParameter().getCustomParam("recreqIds");
        if (!HRObjectUtils.isEmpty((Object)recReqIds) && (idList = (List)recReqIds).size() != 0) {
            stringBuilder.append(idList.get(0));
        }
        return stringBuilder.toString();
    }

    private void setBaseMsgButton() {
        this.showControl(NEXT_STEP_BUTTON, Boolean.TRUE);
        this.showControl(LAST_STEP_BUTTON, PositionConstants.IS_SHOW_RECRUITDEMAND != false ? Boolean.TRUE : Boolean.FALSE);
        this.showControl(BAR_PORTRAIT, Boolean.TRUE);
        this.showControl(SUBMIT_ACTIVE, Boolean.TRUE);
        this.showControl("bar_submit", Boolean.TRUE);
        this.setInterViewer();
    }

    private void setManageMsgButton() {
        this.showControl(NEXT_STEP_BUTTON, Boolean.FALSE);
        this.showControl(LAST_STEP_BUTTON, Boolean.TRUE);
        this.showControl(BAR_PORTRAIT, Boolean.FALSE);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (HRStringUtils.isNotEmpty((String)source) && HRStringUtils.equals((String)source, (String)"recreq")) {
            return;
        }
        Boolean modify = (Boolean)this.getView().getFormShowParameter().getCustomParam("modify");
        if (modify != null && modify.booleanValue()) {
            this.showControl(SUBMIT_ACTIVE, Boolean.FALSE);
        } else {
            this.showControl(SUBMIT_ACTIVE, Boolean.TRUE);
        }
        this.showControl("bar_submit", Boolean.TRUE);
    }

    private void nextStepButton(String currentTab) {
        if (TAB_RECPLAN.equals(currentTab)) {
            this.showNavigation(TAB_BASE_MSG);
        } else {
            this.showNavigation(TAB_MANAGE_MSG);
        }
    }

    private void lastStepButton(String currentTab) {
        if (TAB_BASE_MSG.equals(currentTab)) {
            if (PositionConstants.IS_SHOW_RECRUITDEMAND.booleanValue()) {
                this.showNavigation(TAB_RECPLAN);
            }
        } else {
            this.showNavigation(TAB_BASE_MSG);
        }
    }

    private void setAttachment(String copyId) {
        List attachments;
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        String strAttachments = this.getView().getPageCache().get("attachmentpanelap");
        if (HRStringUtils.isNotEmpty((String)strAttachments)) {
            attachments = (List)SerializationUtils.fromJsonString((String)strAttachments, List.class);
        } else {
            attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_positiontpl", (Object)copyId, (String)"attachmentpanelap");
            this.getView().getPageCache().put("attachmentpanelap", SerializationUtils.toJsonString((Object)attachments));
        }
        attachmentPanel.bindData(attachments);
    }

    private void showNavigation(String tabName) {
        ((Tab)this.getView().getControl(TAB_NAME)).activeTab(tabName);
    }

    private void showControl(String controlName, Boolean ifShow) {
        this.getView().setVisible(ifShow, new String[]{controlName});
    }

    public void setValByDyn(DynamicObject positionDyn, List<String> copyVal) {
        if (copyVal == null) {
            return;
        }
        copyVal.forEach(val -> this.getModel().setValue(val, positionDyn.get(val)));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        if ("adminorg".equals(property)) {
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            AuthorizedOrgResult authorizedOrgResult = PositionPermService.getInstance(null).getPositionHasPermAdminOrgs();
            if (!authorizedOrgResult.isHasAllOrgPerm()) {
                customQFilters.add(new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs()));
            }
        } else if ("createorg".equals(property)) {
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("range", (Object)RuleBizHelper.getOrgByUserId());
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String name = ((BasedataEdit)afterF7SelectEvent.getSource()).getProperty().getName();
        if ("adminorg".equals(name)) {
            DynamicObject adminorg = (DynamicObject)this.getModel().getValue("adminorg");
            if (adminorg != null) {
                String[] ids = new String[]{adminorg.getString("id")};
                this.getModel().setValue("adminorgs", (Object)ids);
            } else {
                this.getModel().setValue("adminorgs", null);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        if ("submit".equals(operationKey) || SAVE_COMMIT.equals(operationKey)) {
            this.verifyCert();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            parentView.getPageCache().remove("opCopyCache");
        }
    }

    private void verifyCert() {
        Map verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
        if (!verifyCert.isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (Lists.newArrayList((Object[])new String[]{VerifyCertTypeEnum.WARNING.getValue(), VerifyCertTypeEnum.EXCEED.getValue()}).contains(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            }
        }
    }
}

