/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionManageService;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;

public class PositionAddManageEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(PositionAddManageEdit.class);
    private static final String PANEL_MANAGE = "managepanel";
    public static final String SIMPLE_TYPE = "simpletype";
    private static final String SAVE_COMMIT = "saveandcommit";

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.openPositionManagePage();
        this.resetWidgetLockable();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String pageIdCache;
        String fieldKey = args.getProperty().getName();
        IFormView view = this.getView();
        IFormView childView = view.getView(pageIdCache = view.getPageCache().get("tsirm_positionmanage"));
        if (childView == null) {
            return;
        }
        if (SIMPLE_TYPE.equals(fieldKey)) {
            ChangeData changeData = args.getChangeSet()[0];
            childView.setVisible(Boolean.valueOf((Boolean)changeData.getNewValue() == false), new String[]{"flexpanelap1", "cfgresurule", "posprin"});
            view.sendFormAction(childView);
        } else if (HRStringUtils.equals((String)"recruscene", (String)fieldKey)) {
            this.clearIntvevlqunr();
            this.resetWidgetLockable();
            Long recCatrgory = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.getModel().getDataEntity(), (String)"reccategory");
            Long recruscene = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.getModel().getDataEntity(), (String)"recruscene");
            PositionManageService.getInstance().recCategoryChanged(recCatrgory, recruscene, childView, this.getModel());
            view.sendFormAction(childView);
        } else if (HRStringUtils.equals((String)"createorg", (String)fieldKey)) {
            ChangeData changeData = args.getChangeSet()[0];
            childView.setEnable(Boolean.valueOf(changeData.getNewValue() != null), new String[]{"recruproc"});
            view.sendFormAction(childView);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"savewithoutvail") || HRStringUtils.equals((String)"gptright", (String)operateKey)) {
            return;
        }
        IFormView view = this.getView();
        String pageIdCache = view.getPageCache().get("tsirm_positionmanage");
        IFormView childView = view.getView(pageIdCache);
        IDataModel childModel = childView.getModel();
        Object recruproc = childModel.getValue("recruproc");
        DynamicObjectCollection authorizer = (DynamicObjectCollection)childModel.getValue("authorizer");
        StringBuilder sb = new StringBuilder();
        if (HRObjectUtils.isEmpty((Object)recruproc)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u62db\u8058\u6d41\u7a0b\u201d\u3002", (String)"PositionAddManageEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)SAVE_COMMIT, (String)operateKey)) {
            OperateOption operateOption = formOperate.getOption();
            operateOption.setVariableValue(SAVE_COMMIT, "true");
            formOperate.setOption(operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            Long positionId = (Long)this.getModel().getValue("id");
            IFormView view = this.getView();
            String pageIdCache = view.getPageCache().get("tsirm_positionmanage");
            IFormView childView = view.getView(pageIdCache);
            childView.getModel().setValue("position", (Object)positionId);
            DynamicObjectCollection entryentity = childView.getModel().getEntryEntity("entryentity");
            entryentity.forEach(entry -> entry.set("mailposition", (Object)positionId));
            view.sendFormAction(childView);
            childView.invokeOperation("savewithoutvalidator");
            view.sendFormAction(childView);
            String currentTab = ((Tab)this.getView().getControl("tabap")).getCurrentTab();
            if (HRStringUtils.equals((String)currentTab, (String)"managemsg")) {
                args.getOperationResult().setShowMessage(false);
            }
            PositionManageService.getInstance().setPositionManageToPosition(positionId);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void openPositionManagePage() {
        Long positionId = (Long)this.getModel().getValue("id");
        HashMap parms = Maps.newHashMapWithExpectedSize((int)16);
        Long orgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.getModel().getDataEntity(), (String)"createorg");
        parms.put("createorg", String.valueOf(orgId));
        Object status = this.getModel().getValue("positionstatus");
        parms.put("positionstatus", status);
        if (positionId != null) {
            DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo((Long)positionId);
            if (manageInfo != null) {
                PositionManageService.getInstance().openPositionManagePage("tsirm_positionmanage", PANEL_MANAGE, this.getView(), BillOperationStatus.EDIT, OperationStatus.EDIT, Long.valueOf(manageInfo.getLong("id")), (Map)parms);
            } else {
                String copyId = (String)this.getView().getFormShowParameter().getCustomParam("copyId");
                if (HRStringUtils.isNotEmpty((String)copyId)) {
                    parms.put("copyId", copyId);
                }
                PositionManageService.getInstance().openPositionManagePage("tsirm_positionmanage", PANEL_MANAGE, this.getView(), (Map)parms);
            }
        }
    }

    public void registerListener(EventObject event) {
        BasedataEdit category;
        super.registerListener(event);
        BasedataEdit scene = (BasedataEdit)this.getControl("recruscene");
        if (scene != null) {
            scene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((category = (BasedataEdit)this.getControl("reccategory")) != null) {
            category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"recruscene") || HRStringUtils.equals((String)actionId, (String)"reccategory")) {
            Object returnData = closedCallBackEvent.getReturnData();
            Object currentData = this.getModel().getValue(actionId);
            Long returnId = null;
            Long currentId = null;
            if (returnData instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                ListSelectedRow row = listSelectedRows.get(0);
                returnId = (Long)row.getPrimaryKeyValue();
            }
            if (currentData != null) {
                DynamicObject obj = (DynamicObject)currentData;
                currentId = (Long)obj.getPkValue();
            }
            if (returnId != null) {
                this.getModel().setValue(actionId, returnId);
            }
        }
    }

    private IFormView getManageView() {
        String pageIdCache = this.getView().getPageCache().get("tsirm_positionmanage");
        if (StringUtils.isEmpty((String)pageIdCache)) {
            return null;
        }
        IFormView manageView = null;
        try {
            manageView = this.getView().getView(pageIdCache);
        }
        catch (KDException ex) {
            logger.error(ex.getMessage());
        }
        return manageView;
    }

    private void clearIntvevlqunr() {
    }

    private void resetWidgetLockable() {
        IFormView manageView = this.getManageView();
        if (manageView == null) {
            return;
        }
        Object createOrg = this.getModel().getValue("createorg");
        manageView.setEnable(Boolean.valueOf(createOrg != null), new String[]{"recruproc"});
        Object status = this.getModel().getValue("positionstatus");
        if (status != null && !Objects.equals(status, "B")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"adminorg"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"adminorgs"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"adminorg"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"adminorgs"});
        }
        this.getView().sendFormAction(manageView);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"recruscene") || HRStringUtils.equals((String)fieldKey, (String)"reccategory")) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, fieldKey);
            formShowParameter.setCloseCallBack(closeCallBack);
        }
    }
}

