/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;

public class PositionAuditRecordViewEdit
extends HRDataBaseEdit
implements TabSelectListener {
    private static final String RECENTAUDITPANEL = "recentauditpanel";
    private static final String HISTORYAUDITPANEL = "historyauditpanel";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Tab appTabs = (Tab)this.getView().getControl("tabap");
        appTabs.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (HRStringUtils.equals((String)tabKey, (String)"audtirecord")) {
            this.auditRecordListInit();
        }
    }

    private void auditRecordListInit() {
        String billPageId = "tsirm_position_view".equals(this.getView().getEntityId()) ? "tsirm_positionbill" : "tsirm_positionbill_del";
        Long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)billPageId, (String)"47150e89000000ac");
        if (hasPerm) {
            Long positionId = (Long)this.getModel().getValue("id");
            DynamicObject billDyn = PositionDataHelper.getPositionBill((DynamicObject)PositionDataHelper.getPositionObjByPositionId((Long)positionId));
            Long recentBillId = 0L;
            if (null == billDyn) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advnodataflex"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advnodataflex"});
                recentBillId = billDyn.getLong("id");
                ListShowParameter recentBillShowParameter = new ListShowParameter();
                recentBillShowParameter.setBillFormId(billPageId);
                recentBillShowParameter.setFormId("tsirm_positionbilllistform");
                recentBillShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                recentBillShowParameter.getOpenStyle().setTargetKey(RECENTAUDITPANEL);
                recentBillShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)recentBillId));
                this.getView().showForm((FormShowParameter)recentBillShowParameter);
            }
            DynamicObject[] his = PositionDataHelper.getHisPositionBills((DynamicObject)PositionDataHelper.getPositionObjByPositionId((Long)positionId), (Long)recentBillId);
            if (null != his && his.length > 0) {
                ListShowParameter historyBillShowParameter = new ListShowParameter();
                historyBillShowParameter.setBillFormId(billPageId);
                historyBillShowParameter.setFormId("tsirm_positionbilllistform");
                historyBillShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                historyBillShowParameter.getOpenStyle().setTargetKey(HISTORYAUDITPANEL);
                historyBillShowParameter.getListFilterParameter().setFilter(new QFilter("id", "!=", (Object)recentBillId).and(new QFilter("position", "=", (Object)positionId)));
                historyBillShowParameter.getListFilterParameter().setOrderBy("createtime DESC");
                this.getView().showForm((FormShowParameter)historyBillShowParameter);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advnodataflexhis"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advnodataflexhis"});
            }
        }
    }

    private boolean refreshTabChild() {
        String positionBillListPageId = this.getView().getPageCache().get("positionBillList");
        if (HRStringUtils.isNotEmpty((String)positionBillListPageId)) {
            List pageIds = (List)JSONObject.parseObject((String)positionBillListPageId, List.class);
            this.getView().getPageCache().put("positionBillList", null);
            for (String pageId : pageIds) {
                IFormView childrenView = this.getView().getView(pageId);
                childrenView.invokeOperation("refresh");
                this.getView().sendFormAction(childrenView);
            }
            return true;
        }
        return false;
    }
}

