/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageService;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsrbd.common.enums.TSRBDPreDataEnum;
import org.apache.commons.collections4.CollectionUtils;

public class PositionBatchImportPlugin
extends BatchImportPlugin {
    private static String[] MANAGEPULL_FIELD = new String[]{"seclevel", "posprin", "recruproc", "intvevlqunr"};

    public List<String> getDefaultLockUIs() {
        String[] fields = new String[]{"keyfields", "importtype"};
        return Arrays.asList(fields);
    }

    protected void resolveExcel() {
        super.resolveExcel();
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        DynamicObject[] manageResultDyns;
        ApiResult result = super.save(rowdatas, logger);
        Map<String, ImportEntityMapping.ColInfo> colIds = this.getColIds(rowdatas);
        ArrayList<DynamicObject> manageDyns = new ArrayList<DynamicObject>(rowdatas.size());
        int len = rowdatas.size();
        for (int index = 0; index < len; ++index) {
            HashMap resultMap = (HashMap)((ArrayList)result.getData()).get(index);
            if (resultMap.get("success").equals(false)) continue;
            ImportBillData importBillData = rowdatas.get(index);
            JSONObject jsonObject = importBillData.getData();
            this.otherAssignHandle(Long.valueOf(resultMap.get("id").toString()), jsonObject);
            HRBaseServiceHelper positionManageServiceHelper = new HRBaseServiceHelper("tsirm_positionmanage");
            DynamicObject manageDyn = positionManageServiceHelper.generateEmptyDynamicObject("tsirm_positionmanage");
            manageDyn.set("position", resultMap.get("id"));
            manageDyn.set("seclevel", (Object)"1070");
            for (String field : MANAGEPULL_FIELD) {
                if (colIds == null || jsonObject.get((Object)field) == null || colIds.get(field) == null) continue;
                this.setValueToManageDyn(manageDyn, field, (JSONObject)jsonObject.get((Object)field), colIds);
            }
            manageDyns.add(manageDyn);
        }
        for (DynamicObject manageResultDyn : manageResultDyns = PositionManageService.savePositionManageInfo((DynamicObject[])manageDyns.toArray(new DynamicObject[manageDyns.size()]))) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("manageinfo", Collections.singletonList(manageResultDyn.getLong("id")));
            PositionDataHelper.updatePositionInfo((String)"tsirm_position", Collections.singletonList(manageResultDyn.getLong("position")), (Map)map);
        }
        return result;
    }

    private void otherAssignHandle(Long positionId, JSONObject jsonObject) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_positiontpl");
        DynamicObject positionDyn = helper.queryOne((Object)positionId);
        positionDyn.set("reccategory", (Object)TSRBDPreDataEnum.RECRUTYP_INSIDERECRUITMENT.getId().toString());
        if (jsonObject.get((Object)"sex") != null) {
            positionDyn.set("issexlimit", (Object)0);
            positionDyn.set("sex", jsonObject.get((Object)"sex"));
        }
        if (jsonObject.get((Object)"ageup") != null || jsonObject.get((Object)"agedown") != null) {
            positionDyn.set("isagelimit", (Object)0);
            positionDyn.set("ageup", jsonObject.get((Object)"ageup"));
            positionDyn.set("agedown", jsonObject.get((Object)"agedown"));
        }
        if (jsonObject.get((Object)"education") != null) {
            positionDyn.set("isedulimit", (Object)0);
            JSONObject eduJson = (JSONObject)jsonObject.get((Object)"education");
            DynamicObject eduDyn = PositionManageServiceHelper.getFidFormProp((String)eduJson.getString("importprop"), (String)eduJson.getString(eduJson.getString("importprop")), (String)"hbss_diploma");
            positionDyn.set("education", (Object)eduDyn);
        }
        if (jsonObject.get((Object)"workexpup") != null || jsonObject.get((Object)"workexpdown") != null) {
            positionDyn.set("isworkexplimit", (Object)0);
            positionDyn.set("workexpup", jsonObject.get((Object)"workexpup"));
            positionDyn.set("workexpdown", jsonObject.get((Object)"workexpdown"));
        }
        if (jsonObject.get((Object)"recruitnum") == null || HRStringUtils.equals((String)jsonObject.getString("recruitnum"), (String)"0")) {
            positionDyn.set("recruitnum", (Object)0);
            positionDyn.set("isrecnumlimit", (Object)1);
        }
        helper.updateOne(positionDyn);
    }

    public Map<String, List<String>> getTemplatePreInsData(Long templateId) {
        return super.getTemplatePreInsData(templateId);
    }

    private Map<String, ImportEntityMapping.ColInfo> getColIds(List<ImportBillData> rowdatas) {
        HashMap stringImportEntityMappingHashMap = CollectionUtils.isNotEmpty(rowdatas) ? (HashMap)rowdatas.get(0).getEntityMapping().getCols() : null;
        return stringImportEntityMappingHashMap;
    }

    private void setValueToManageDyn(DynamicObject dynamicObject, String field, JSONObject value, Map<String, ImportEntityMapping.ColInfo> colIds) {
        String importProp = colIds.get(field).getBasedataProp();
        switch (field) {
            case "seclevel": {
                DynamicObject seclevelDyn = PositionManageServiceHelper.getFidFormProp((String)importProp, (String)((String)value.get(value.get((Object)"importprop"))), (String)"tsrbd_securitylevel");
                dynamicObject.set(field, (Object)seclevelDyn);
                break;
            }
            case "posprin": {
                String[] userNumbers = ((String)value.get(value.get((Object)"importprop"))).split(",");
                DynamicObjectCollection currencyColl = dynamicObject.getDynamicObjectCollection(field);
                for (String number : userNumbers) {
                    DynamicObject newCurrency = new DynamicObject(currencyColl.getDynamicObjectType());
                    HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_user");
                    QFilter qFilter = new QFilter("number", "=", (Object)number);
                    DynamicObject userDyn = hrBaseServiceHelper.queryOne(new QFilter[]{qFilter});
                    newCurrency.set("fbasedataId", userDyn.getPkValue());
                    currencyColl.add((Object)newCurrency);
                }
                dynamicObject.set(field, (Object)currencyColl);
                break;
            }
            case "recruproc": {
                DynamicObject recruprocDyn = PositionManageServiceHelper.getFidFormProp((String)importProp, (String)((String)value.get(value.get((Object)"importprop"))), (String)"tsrbd_rqmtproc");
                dynamicObject.set(field, (Object)recruprocDyn);
                break;
            }
            case "intvevlqunr": {
                DynamicObject intvevlqunrDyn = PositionManageServiceHelper.getFidFormProp((String)importProp, (String)((String)value.get(value.get((Object)"importprop"))), (String)"tsrbd_intvevlqunr");
                dynamicObject.set(field, (Object)intvevlqunrDyn);
                break;
            }
        }
    }
}

