/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionBillService;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.formplugin.web.position.service.PositionJdService;
import org.apache.commons.collections.CollectionUtils;

public class PositionBillViewEdit
extends HRDataBaseEdit
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(PositionBillViewEdit.class);
    private static final String GPT_CONTROL_JD = "gptjd";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        Long positionSnapId = (Long)this.getView().getFormShowParameter().getCustomParam("positionsnap");
        if (positionSnapId == null) {
            return;
        }
        DynamicObject positionSnapDyn = PositionDataHelper.getPositionSnapDynById((Long)positionSnapId);
        DataEntityPropertyCollection properties = positionSnapDyn.getDataEntityType().getProperties();
        IDataModel model = this.getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Collection values = dataEntityType.getFields().values();
        ArrayList keyList = Lists.newArrayListWithCapacity((int)values.size());
        for (IDataEntityProperty property2 : values) {
            String propertyName = property2.getName();
            keyList.add(propertyName);
        }
        properties.forEach(property -> {
            String key = property.getName();
            if (keyList.contains(key)) {
                this.getModel().setValue(key, positionSnapDyn.get(key));
            }
        });
    }

    public void afterLoadData(EventObject eventObject) {
        this.getModel().setValue("status", (Object)"A");
    }

    public void afterBindData(EventObject eventObject) {
        List attachments;
        super.afterBindData(eventObject);
        this.tabStatusHandle();
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        Long positionSnapId = (Long)this.getView().getFormShowParameter().getCustomParam("positionsnap");
        if (positionSnapId == null) {
            Long positionId = (Long)this.getView().getParentView().getFormShowParameter().getCustomParam("positionid");
            attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_positiontpl", (Object)positionId, (String)"attachmentpanelap", (boolean)false);
            attachments.forEach(attachment -> {
                attachment.put("attPkId", ID.genLongId());
                attachment.put("uid", PositionBillService.getInstance().encryId(String.valueOf(attachment.get("uid"))));
            });
        } else {
            attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_positionsnaptpl", (Object)positionSnapId, (String)"attachmentpanelap", (boolean)false);
            LOGGER.info("positionSnapId:{}", (Object)positionSnapId);
        }
        this.setAttPageCache(attachments);
        attachmentPanel.bindData(attachments);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Optional.of(propertyName).filter("name"::equals).ifPresent(key -> {
            List list = ((LocaleDynamicObjectCollection)e.getChangeSet()[0].getNewValue()).stream().filter(dynamicObject -> null != dynamicObject && HRStringUtils.isNotEmpty((String)dynamicObject.getString("name"))).collect(Collectors.toList());
            PositionJdService.getInstance().setGptEnable(this.getView(), CollectionUtils.isNotEmpty(list));
        });
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        PositionJdService.getInstance().customEvent(e, this.getView());
    }

    private void setAttPageCache(List<Map<String, Object>> tempAtts) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
        Map<String, List<Map<String, Object>>> attachmentInfo = new HashMap<String, List<Map<String, Object>>>(11);
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
        }
        attachmentInfo.put("attachmentpanelap", tempAtts);
        cacheJsonString = SerializationUtils.toJsonString(attachmentInfo);
        cache.put("TampAttCache" + this.getView().getPageId(), cacheJsonString);
    }

    private void tabStatusHandle() {
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) || OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap132", "flexpanelap14", "ageflex", "flexpanelap13111"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap24", "edu_text", "age_text", "workexp_text"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap132", "flexpanelap14", "ageflex", "flexpanelap13111"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap24", "edu_text", "age_text", "workexp_text"});
            BigDecimal recruitnum = (BigDecimal)this.getModel().getValue("recruitnum");
            boolean isLimit = (Boolean)this.getModel().getValue("isrecnumlimit");
            this.getModel().setValue("recruitnum_text", (Object)PositionDataHelper.recruitnumTras((long)recruitnum.longValue(), (boolean)isLimit));
            DynamicObject eduDyn = this.getModel().getDataEntity().getDynamicObject("education");
            boolean eduLimit = (Boolean)this.getModel().getValue("isedulimit");
            this.getModel().setValue("edu_text", (Object)PositionDataHelper.eduTras((DynamicObject)eduDyn, (boolean)eduLimit));
            long ageDown = this.getModel().getDataEntity().getLong("agedown");
            long ageUp = this.getModel().getDataEntity().getLong("ageUp");
            boolean ageLimit = (Boolean)this.getModel().getValue("isagelimit");
            this.getModel().setValue("age_text", (Object)PositionDataHelper.ageTras((long)ageDown, (long)ageUp, (boolean)ageLimit));
            long workExpDown = this.getModel().getDataEntity().getLong("workexpdown");
            long workExpUp = this.getModel().getDataEntity().getLong("workexpup");
            boolean workexpLimit = (Boolean)this.getModel().getValue("isworkexplimit");
            this.getModel().setValue("workexp_text", (Object)PositionDataHelper.workexpTras((long)workExpDown, (long)workExpUp, (boolean)workexpLimit));
        }
    }
}

