/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.fieldtip.DeleteRule;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.formplugin.web.position.service.PositionJdService;
import kd.tsc.tsrbd.common.utils.NotDataChangeUtils;

public class PositionEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final int MUL_BASE_DATA_MAX_SIZE = 10;
    private static final int SYS_PRE_SET_STATUS = 1;
    private static final Long SALARY_MAX_VALUE = 9999999999L;
    private static final Long HUNDRED_MAX_VALUE = 100L;
    private static final long RECRUIT_NUM_MAX_VALUE = 10000L;
    private static final String WORK_COUNTRY_PAGE_ID = "workCountryPageId";
    private static final String[] CREATEORG_RELATEFIELDS = new String[]{"adminorg", "workaddrs", "jobscm"};
    private static final String GPT_CONTROL_JD = "gptjd";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit education = (BasedataEdit)this.getControl("education");
        BasedataEdit createOrg = (BasedataEdit)this.getControl("createorg");
        BasedataEdit lowJobLevel = (BasedataEdit)this.getControl("lowjoblevel");
        BasedataEdit highJobLevel = (BasedataEdit)this.getControl("highjoblevel");
        BasedataEdit lowJobGrade = (BasedataEdit)this.getControl("lowjobgrade");
        BasedataEdit highJobGrade = (BasedataEdit)this.getControl("highjobgrade");
        BasedataEdit recruscene = (BasedataEdit)this.getControl("recruscene");
        BasedataEdit jobScm = (BasedataEdit)this.getControl("jobscm");
        BasedataEdit workaddrs = (BasedataEdit)this.getControl("workaddrs");
        jobScm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        education.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        createOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        lowJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        highJobLevel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        lowJobGrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        highJobGrade.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        recruscene.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        workaddrs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getPageCache().put(WORK_COUNTRY_PAGE_ID, this.getModel().getValue("workcountry") == null ? null : "b");
        this.setRecrusceneEnable();
        this.rangeCheck();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        boolean visibleGpt = (OperationStatus.EDIT.equals((Object)status) || OperationStatus.ADDNEW.equals((Object)status)) && AiConfigHelper.getInstance().getIfOpen("positionjd");
        this.getView().setVisible(Boolean.valueOf(visibleGpt), new String[]{GPT_CONTROL_JD});
        String positionName = this.getModel().getDataEntity(true).getString("name");
        boolean gptEnable = visibleGpt && !HRStringUtils.isBlank((CharSequence)positionName);
        PositionJdService.getInstance().setGptEnable(this.getView(), gptEnable);
    }

    public void afterCreateNewData(EventObject event) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String property = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (property) {
            case "recruscene": {
                DynamicObject categoryDyn = (DynamicObject)this.getModel().getValue("reccategory");
                if (categoryDyn == null) break;
                QFilter qFilter = new QFilter("recruitmentcategory.fbasedataid", "in", (Object)new Long[]{categoryDyn.getLong("id")});
                formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
        HashMap qFilterMap = PositionDataHelper.generateQFilterMap((IDataModel)this.getModel());
        QFilter qFilter = (QFilter)qFilterMap.get(property);
        if (qFilter != null) {
            formShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String propertyName = event.getProperty().getName();
        this.personNumCheck(propertyName);
        this.checkBoxPropertyChange(propertyName);
        this.rangeCheck(propertyName);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        NotDataChangeUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"modifytime"});
    }

    private void checkBoxPropertyChange(String propertyName) {
        Map<String, List<String>> checkBoxChangedFields = this.getCheckBoxChangedFields();
        List<String> fields = checkBoxChangedFields.get(propertyName);
        if (fields != null && ((Boolean)this.getModel().getValue(propertyName)).booleanValue()) {
            for (String field : fields) {
                this.getModel().setValue(field, null);
            }
        }
    }

    private Map<String, List<String>> getCheckBoxChangedFields() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("issalarynego", Lists.newArrayList((Object[])new String[]{"salarydown", "salaryup"}));
        result.put("isagelimit", Lists.newArrayList((Object[])new String[]{"agedown", "ageup"}));
        result.put("isworkexplimit", Lists.newArrayList((Object[])new String[]{"workexpdown", "workexpup"}));
        result.put("issexlimit", Collections.singletonList("sex"));
        result.put("isedulimit", Collections.singletonList("education"));
        return result;
    }

    private void personNumCheck(String propertyName) {
        if ("recruitnum".equals(propertyName) && !Boolean.parseBoolean(this.getModel().getValue("isrecnumlimit").toString())) {
            DynamicObject positionDynObj = this.getModel().getDataEntity();
            long recruitNum = positionDynObj.getLong(propertyName);
            if (recruitNum <= 0L || recruitNum > 10000L) {
                FieldTip salaryTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, propertyName, ResManager.loadKDString((String)"\u8bf7\u8f93\u51651-10000\u6574\u6570", (String)"PositionEdit_15", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.getView().showFieldTip(salaryTip);
                this.getModel().setValue("recruitnum", (Object)(recruitNum <= 0L ? 0L : 10000L));
            } else {
                FieldTip rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, propertyName, null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
            }
        }
        if ("isrecnumlimit".equals(propertyName) && Boolean.parseBoolean(this.getModel().getValue("isrecnumlimit").toString())) {
            this.getModel().setValue("recruitnum", null);
        }
        if ("isrecnumlimit".equals(propertyName) && !Boolean.parseBoolean(this.getModel().getValue("isrecnumlimit").toString())) {
            this.getModel().setValue("recruitnum", (Object)1);
        }
    }

    private void rangeCheck(String propertyName) {
        if ("salaryup".equals(propertyName) || "salarydown".equals(propertyName)) {
            if (((Boolean)this.getModel().getValue("issalarynego")).booleanValue()) {
                this.getModel().setValue("salaryup", null);
                this.getModel().setValue("salarydown", null);
            }
            this.validRangeField("salaryup", "salarydown", propertyName, ResManager.loadKDString((String)"\u85aa\u8d44\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u85aa\u8d44\u4e0a\u9650", (String)"PositionEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), SALARY_MAX_VALUE);
        }
        if ("workexpdown".equals(propertyName) || "workexpup".equals(propertyName)) {
            if (((Boolean)this.getModel().getValue("isworkexplimit")).booleanValue()) {
                this.getModel().setValue("workexpdown", null);
                this.getModel().setValue("workexpup", null);
            }
            this.validRangeField("workexpup", "workexpdown", propertyName, ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\u4e0b\u9650\u5e94\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"PositionEdit_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), HUNDRED_MAX_VALUE);
        }
        if ("agedown".equals(propertyName) || "ageup".equals(propertyName)) {
            if (((Boolean)this.getModel().getValue("isagelimit")).booleanValue()) {
                this.getModel().setValue("agedown", null);
                this.getModel().setValue("ageup", null);
            }
            this.validRangeField("ageup", "agedown", propertyName, ResManager.loadKDString((String)"\u5e74\u9f84\u4e0b\u9650\u5e94\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"PositionEdit_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), HUNDRED_MAX_VALUE);
        }
    }

    private void rangeCheck() {
        this.validRangeField("salaryup", "salarydown", "salaryup", ResManager.loadKDString((String)"\u85aa\u8d44\u4e0b\u9650\u5e94\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"PositionEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), SALARY_MAX_VALUE);
        this.validRangeField("workexpup", "workexpdown", "workexpup", ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\u4e0b\u9650\u5e94\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"PositionEdit_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), HUNDRED_MAX_VALUE);
        this.validRangeField("ageup", "agedown", "ageup", ResManager.loadKDString((String)"\u5e74\u9f84\u4e0b\u9650\u5e94\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"PositionEdit_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), HUNDRED_MAX_VALUE);
    }

    private void validRangeField(String rangeUpField, String rangeDownField, String propertyName, String description, Long maxValue) {
        FieldTip rangeUpTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, rangeUpField, null);
        rangeUpTip.setSuccess(true);
        this.getView().showFieldTip(rangeUpTip);
        FieldTip rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, rangeDownField, null);
        rangeDownTip.setSuccess(true);
        this.getView().showFieldTip(rangeDownTip);
        DeleteRule deleteRule = new DeleteRule();
        deleteRule.setAction("isChange");
        deleteRule.setFields(Arrays.asList(rangeUpField, rangeDownField));
        DynamicObject positionDynObj = this.getModel().getDataEntity();
        long rangeUp = positionDynObj.getLong(rangeUpField);
        long rangeDown = positionDynObj.getLong(rangeDownField);
        if (rangeUp < 0L) {
            FieldTip salaryTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, rangeUpField, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u6574\u6570", (String)"PositionEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            salaryTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(salaryTip);
            this.getModel().setValue(rangeUpField, (Object)1);
        } else if (rangeDown < 0L) {
            FieldTip salaryTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, rangeDownField, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u6574\u6570", (String)"PositionEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            salaryTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(salaryTip);
            this.getModel().setValue(rangeDownField, (Object)1);
        } else if (rangeUp > maxValue) {
            FieldTip salaryTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, rangeUpField, ResManager.loadKDString((String)"\u6700\u5927\u503c\u4e3a{0},\u8bf7\u91cd\u65b0\u8f93\u5165", (String)"PositionEdit_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{maxValue}));
            salaryTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(salaryTip);
            this.getModel().setValue(rangeUpField, (Object)100);
        } else if (rangeDown > maxValue) {
            FieldTip salaryTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, rangeDownField, ResManager.loadKDString((String)"\u6700\u5927\u503c\u4e3a%tF,\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PositionEdit_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{maxValue}));
            salaryTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(salaryTip);
            this.getModel().setValue(rangeDownField, (Object)100);
        } else if (rangeDown > rangeUp && rangeUp != 0L) {
            FieldTip salaryRangeTip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, propertyName, description);
            salaryRangeTip.setDeleteRule(deleteRule);
            this.getView().showFieldTip(salaryRangeTip);
        }
    }

    private void setRecrusceneEnable() {
        Object recReqIds = this.getView().getFormShowParameter().getCustomParam("recreqIds");
        if (recReqIds != null && ((List)recReqIds).size() == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"reccategory", "recruscene"});
            return;
        }
        Object recCategory = this.getModel().getValue("reccategory");
        if (HRObjectUtils.isEmpty((Object)recCategory)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"recruscene"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"recruscene"});
        }
    }
}

