/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterKeyValue;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.business.domain.workaddress.service.WorkAddressDataHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.AdminAndOrgHelper;

public class PositionFilterContainerList
extends HRDataBaseList {
    private final Map<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>(16);

    public void filterColumnSetFilter(SetFilterEvent args) {
        AuthorizedOrgResult authorizedOrgResult;
        String fieldName;
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null && this.filterDataMap.isEmpty()) {
            FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
            this.handleFilterValues(otherFilterValues);
        }
        if ("manageinfo.recruproc.name".equals(fieldName = args.getFieldName())) {
            List<Object> orgIds = this.filterDataMap.get("createorg.id");
            long useOrgId = orgIds != null && !orgIds.isEmpty() && !"".equals(orgIds.get(0)) ? Long.parseLong((String)orgIds.get(0)) : 0L;
            args.getQFilters().add(new QFilter("id", "in", (Object)PositionDataHelper.getAllRecProcId((Long)useOrgId)));
        }
        if ("createorg.name".equals(fieldName)) {
            ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
            args.getQFilters().add(new QFilter("id", "in", this.getPermHROrgs(listParameter)));
        }
        if (this.checkAdminOrg(fieldName) && !PermissionServiceHelper.isSuperUser((long)TSCRequestContext.getUserId()) && !(authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)"47150e89000000ac", (String)"adminorg", null)).isHasAllOrgPerm()) {
            QFilter adminOrgFilter = new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs());
            args.getQFilters().add(adminOrgFilter);
        }
    }

    private boolean checkAdminOrg(String fieldName) {
        return HRStringUtils.equals((String)"adminorgs.fbasedataid.name", (String)fieldName) || HRStringUtils.equals((String)"adminorgs.fbasedataid.number", (String)fieldName);
    }

    private List<Long> getAdminOrgs() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String adminOrgStr = this.getPageCache().get("adminorg");
        if (HRStringUtils.isNotEmpty((String)adminOrgStr)) {
            return SerializationUtils.fromJsonStringToList((String)adminOrgStr, Long.class);
        }
        List currentUserAdminOrg = AdminAndOrgHelper.getCurrentUserAdminOrg((String)listShowParameter.getAppId(), (String)listShowParameter.getBillFormId());
        this.getPageCache().put("adminorg", SerializationUtils.toJsonString((Object)currentUserAdminOrg));
        return currentUserAdminOrg;
    }

    private List<Long> getPermHROrgs(ListShowParameter listParameter) {
        AppInfo appInfo;
        String appNumber;
        String createOrgIdsStr = this.getView().getPageCache().get("createorg");
        if (HRStringUtils.isNotEmpty((String)createOrgIdsStr)) {
            List createOrgIds = SerializationUtils.fromJsonStringToList((String)createOrgIdsStr, Long.class);
            return createOrgIds;
        }
        String entityName = listParameter.getBillFormId();
        String appId = listParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appId) && HRStringUtils.isNotEmpty((String)(appNumber = listParameter.getAppId())) && (appInfo = AppMetadataCache.getAppInfo((String)appNumber)) != null) {
            appId = appInfo.getId();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        long userId = TSCRequestContext.getUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"24", (String)appId, (String)entityName, (String)"47150e89000000ac");
        List createOrgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"24") : result.getHasPermOrgs();
        this.getView().getPageCache().put("createorg", SerializationUtils.toJsonString((Object)createOrgIds));
        return createOrgIds;
    }

    private void handleFilterValues(FilterKeyValueCollections otherFilterValues) {
        if (otherFilterValues != null) {
            String filterKey = otherFilterValues.getFilterKey();
            for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                String fieldName = (String)((FilterKeyValue)filterKeyValues.get(0)).getValue().get(0);
                List value = ((FilterKeyValue)filterKeyValues.get(1)).getValue();
                if ("relevantdata".equals(fieldName) && "schemefilter".equals(filterKey)) {
                    value = ((FilterKeyValue)filterKeyValues.get(2)).getValue();
                }
                this.filterDataMap.put(fieldName, value);
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        Long userId = TSCRequestContext.getUserId();
        List<Object> changeRanges = this.filterDataMap.get("relevantdata");
        List<Object> workCityIds = this.filterDataMap.get("workcity.id");
        int filterSize = event.getQFilters().size();
        if (changeRanges != null && !changeRanges.isEmpty()) {
            for (int tag = 0; tag < filterSize; ++tag) {
                QFilter qFilter = (QFilter)event.getQFilters().get(tag);
                this.convertQFilter(qFilter, event, changeRanges, workCityIds, tag, userId);
            }
        }
        this.mainPageSetFilter(filterSize, event, userId);
    }

    public void convertQFilter(QFilter qFilter, SetFilterEvent event, List<Object> changeRanges, List<Object> workCityIds, int tag, Long userId) {
        if (qFilter != null && "relevantdata".equals(qFilter.getProperty())) {
            event.getQFilters().remove(qFilter);
            QFilter qFilterTemp = new QFilter("id", "is null", (Object)"");
            for (Object object : changeRanges) {
                if ("0".equals(object)) {
                    qFilterTemp.or("creator", "=", (Object)userId);
                    continue;
                }
                if (!"1".equals(object)) continue;
                qFilterTemp.or("manageinfo.posprin.fbasedataid", "=", (Object)userId);
            }
            event.getQFilters().add(tag, qFilterTemp);
        } else if (qFilter != null && "workcity.id".equals(qFilter.getProperty())) {
            List workCityList = workCityIds.stream().map(num -> Long.parseLong(num.toString())).collect(Collectors.toList());
            List allWorkAddressPkId = WorkAddressDataHelper.getAllWorkAddressPkId(workCityList);
            event.getQFilters().remove(qFilter);
            event.getQFilters().add(tag, new QFilter("workaddr.fbasedataid", "in", (Object)allWorkAddressPkId));
        }
    }

    public void mainPageSetFilter(int filterSize, SetFilterEvent event, Long userId) {
        if (this.getView().getPageCache().get(AppFileListConstants.CUSTOM_FILTER_IS_OWNER) != null && "true".equals(this.getView().getPageCache().get(AppFileListConstants.CUSTOM_FILTER_IS_OWNER))) {
            for (int i = 0; i < filterSize; ++i) {
                QFilter qFilter = (QFilter)event.getQFilters().get(i);
                if (qFilter == null || !"relevantdata".equals(qFilter.getProperty())) continue;
                event.getQFilters().remove(qFilter);
                QFilter qFilterRelevant = new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)userId);
                event.getQFilters().add(i, qFilterRelevant);
            }
        }
    }
}

