/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionJobHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PositionJobLinkageEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private final Map<String, Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>> JOB_PAIR_MAP = new LinkedHashMap<String, Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>>();

    public PositionJobLinkageEdit() {
        this.JOB_PAIR_MAP.put("joborg", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::jobOrgHandle, this::jobScmHandle));
        this.JOB_PAIR_MAP.put("jobscm", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::jobScmHandle, this::jobScmHandle));
        this.JOB_PAIR_MAP.put("jobseq", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::jobSeqHandle, this::jobSeqHandle));
        this.JOB_PAIR_MAP.put("jobfamily", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::jobFamilyHandle, this::jobFamilyHandle));
        this.JOB_PAIR_MAP.put("jobclass", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::jobClassHandle, this::jobClassHandle));
        this.JOB_PAIR_MAP.put("lowjobgrade", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::lowJobGradeHandle, this::lowJobGradeHandle));
        this.JOB_PAIR_MAP.put("highjobgrade", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::highJobGradeHandle, this::highJobGradeHandle));
        this.JOB_PAIR_MAP.put("lowjoblevel", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::lowJobLevelHandle, this::lowJobLevelHandle));
        this.JOB_PAIR_MAP.put("highjoblevel", (Pair<Consumer<DynamicObject>, UnaryOperator<QFilter>>)Pair.of(this::highJobLevelHandle, this::highJobLevelHandle));
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.JOB_PAIR_MAP.keySet().forEach(key -> {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl((String)key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        });
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        ArrayList jobList = new ArrayList();
        this.JOB_PAIR_MAP.forEach((key, value) -> jobList.add(key));
        for (int index = 0; index < jobList.size(); ++index) {
            if (index > 2) {
                return;
            }
            if (!Objects.isNull(this.getModel().getValue((String)jobList.get(index)))) continue;
            this.getView().setEnable(Boolean.FALSE, jobList.subList(index + 1, jobList.size()).toArray(new String[0]));
        }
        if (Objects.isNull(this.getModel().getValue("createorg"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"jobseq"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String keyName = args.getProperty().getName();
        Object newValue = args.getChangeSet()[0].getNewValue();
        DynamicObject propertyValue = null;
        if (newValue instanceof DynamicObject) {
            propertyValue = (DynamicObject)newValue;
        }
        if (this.JOB_PAIR_MAP.containsKey(keyName)) {
            ((Consumer)this.JOB_PAIR_MAP.get(keyName).getLeft()).accept(propertyValue);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String keyName = evt.getProperty().getName();
        if (this.JOB_PAIR_MAP.containsKey(keyName)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            qFilter = (QFilter)((UnaryOperator)this.JOB_PAIR_MAP.get(keyName).getRight()).apply(qFilter);
            evt.setCustomQFilters(Collections.singletonList(qFilter));
            this.jobClassF7TreeHandle(keyName, evt, qFilter);
        }
    }

    private void jobClassF7TreeHandle(String keyName, BeforeF7SelectEvent evt, QFilter qFilter) {
        if ("jobclass".equals(keyName)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            Long jobFamilyId = this.getModel().getDataEntity().getLong("jobfamily.id");
            Long jobSeqId = this.getModel().getDataEntity().getLong("jobseq.id");
            Long scmId = this.getModel().getDataEntity().getLong("jobscm.id");
            showParameter.getShowParameter().setCustomParam("selectedJobFamilyId", (Object)jobFamilyId);
            showParameter.getShowParameter().setCustomParam("selectedScmId", (Object)scmId);
            showParameter.getShowParameter().setCustomParam("selectedJobSeqId", (Object)jobSeqId);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void jobScmHandle(DynamicObject obj) {
        this.getModel().setValue("jobseq", null);
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(obj)), new String[]{"jobseq"});
    }

    private void jobOrgHandle(DynamicObject obj) {
        this.getModel().setValue("jobscm", null);
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(obj)), new String[]{"jobscm"});
    }

    private void jobSeqHandle(DynamicObject obj) {
        this.getModel().setValue("jobfamily", null);
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(obj)), new String[]{"jobfamily"});
    }

    private void jobFamilyHandle(DynamicObject obj) {
        this.getModel().setValue("jobclass", null);
        this.getModel().setValue("lowjobgrade", null);
        this.getModel().setValue("highjobgrade", null);
        this.getModel().setValue("lowjoblevel", null);
        this.getModel().setValue("highjoblevel", null);
        this.getView().setEnable(Boolean.valueOf(Objects.nonNull(obj)), new String[]{"jobclass", "lowjobgrade", "highjobgrade", "lowjoblevel", "highjoblevel"});
    }

    private void jobClassHandle(DynamicObject obj) {
        this.getModel().setValue("lowjobgrade", null);
        this.getModel().setValue("highjobgrade", null);
        this.getModel().setValue("lowjoblevel", null);
        this.getModel().setValue("highjoblevel", null);
    }

    private void highJobGradeHandle(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        DynamicObject lowGrade = (DynamicObject)this.getModel().getValue("lowjobgrade");
        if (Objects.isNull(lowGrade)) {
            this.getModel().setValue("lowjobgrade", (Object)obj);
        }
    }

    private void lowJobGradeHandle(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        DynamicObject highGrade = (DynamicObject)this.getModel().getValue("highjobgrade");
        if (Objects.isNull(highGrade)) {
            this.getModel().setValue("highjobgrade", (Object)obj);
        }
    }

    private void highJobLevelHandle(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        DynamicObject lowLevel = (DynamicObject)this.getModel().getValue("lowjoblevel");
        if (Objects.isNull(lowLevel)) {
            this.getModel().setValue("lowjoblevel", (Object)obj);
        }
    }

    private void lowJobLevelHandle(DynamicObject obj) {
        if (Objects.isNull(obj)) {
            return;
        }
        DynamicObject highLevel = (DynamicObject)this.getModel().getValue("highjoblevel");
        if (Objects.isNull(highLevel)) {
            this.getModel().setValue("highjoblevel", (Object)obj);
        }
    }

    private QFilter highJobLevelHandle(QFilter qFilter) {
        DynamicObject jobScm = (DynamicObject)this.getModel().getValue("jobscm");
        DynamicObject jobFamily = (DynamicObject)this.getModel().getValue("jobfamily");
        DynamicObject jobClass = (DynamicObject)this.getModel().getValue("jobclass");
        DynamicObject lowJobLevel = (DynamicObject)this.getModel().getValue("lowjoblevel");
        if (Objects.nonNull(lowJobLevel)) {
            qFilter.and("joblevelseq", ">=", (Object)lowJobLevel.getInt("joblevelseq"));
        }
        List jobLevelIdList = PositionJobHelper.getJobLevelIdListByJobScmAndJobClass((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass);
        return qFilter.and("id", "in", (Object)jobLevelIdList);
    }

    private QFilter lowJobLevelHandle(QFilter qFilter) {
        DynamicObject jobScm = (DynamicObject)this.getModel().getValue("jobscm");
        DynamicObject jobFamily = (DynamicObject)this.getModel().getValue("jobfamily");
        DynamicObject jobClass = (DynamicObject)this.getModel().getValue("jobclass");
        DynamicObject highJobLevel = (DynamicObject)this.getModel().getValue("highjoblevel");
        if (Objects.nonNull(highJobLevel)) {
            qFilter.and("joblevelseq", "<=", (Object)highJobLevel.getInt("joblevelseq"));
        }
        List jobLevelIdList = PositionJobHelper.getJobLevelIdListByJobScmAndJobClass((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass);
        return qFilter.and("id", "in", (Object)jobLevelIdList);
    }

    private QFilter highJobGradeHandle(QFilter qFilter) {
        DynamicObject jobScm = (DynamicObject)this.getModel().getValue("jobscm");
        DynamicObject jobFamily = (DynamicObject)this.getModel().getValue("jobfamily");
        DynamicObject jobClass = (DynamicObject)this.getModel().getValue("jobclass");
        DynamicObject lowJobGrade = (DynamicObject)this.getModel().getValue("lowjobgrade");
        if (Objects.nonNull(lowJobGrade)) {
            qFilter.and("jobgradeseq", ">=", (Object)lowJobGrade.getInt("jobgradeseq"));
        }
        List jobGradeIdList = PositionJobHelper.getJobGradeIdListByJobScmAndJobClass((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass);
        return qFilter.and("id", "in", (Object)jobGradeIdList);
    }

    private QFilter lowJobGradeHandle(QFilter qFilter) {
        DynamicObject jobScm = (DynamicObject)this.getModel().getValue("jobscm");
        DynamicObject jobFamily = (DynamicObject)this.getModel().getValue("jobfamily");
        DynamicObject jobClass = (DynamicObject)this.getModel().getValue("jobclass");
        DynamicObject highJobGrade = (DynamicObject)this.getModel().getValue("highjobgrade");
        if (Objects.nonNull(highJobGrade)) {
            qFilter.and("jobgradeseq", "<=", (Object)highJobGrade.getInt("jobgradeseq"));
        }
        List jobGradeIdList = PositionJobHelper.getJobGradeIdListByJobScmAndJobClass((DynamicObject)jobScm, (DynamicObject)jobFamily, (DynamicObject)jobClass);
        return qFilter.and("id", "in", (Object)jobGradeIdList);
    }

    private QFilter jobClassHandle(QFilter qFilter) {
        DynamicObject jobFamily = (DynamicObject)this.getModel().getValue("jobfamily");
        List jobClassIdList = PositionJobHelper.getJobClassIdListByJobFamily((DynamicObject)jobFamily);
        if (CollectionUtils.isEmpty((Collection)jobClassIdList)) {
            return qFilter;
        }
        return qFilter.and("id", "in", (Object)jobClassIdList);
    }

    private QFilter jobFamilyHandle(QFilter qFilter) {
        DynamicObject jobSeq = (DynamicObject)this.getModel().getValue("jobseq");
        List jobFamilyIdList = PositionJobHelper.getJobFamilyIdListByJobScm((DynamicObject)jobSeq);
        if (CollectionUtils.isEmpty((Collection)jobFamilyIdList)) {
            return qFilter;
        }
        return qFilter.and("id", "in", (Object)jobFamilyIdList);
    }

    private QFilter jobSeqHandle(QFilter qFilter) {
        DynamicObject jobScm = (DynamicObject)this.getModel().getValue("jobscm");
        List jobSeqIdList = PositionJobHelper.getJobSeqIdListByJobScm((DynamicObject)jobScm);
        if (CollectionUtils.isEmpty((Collection)jobSeqIdList)) {
            return qFilter;
        }
        return qFilter.and("id", "in", (Object)jobSeqIdList);
    }

    private QFilter jobScmHandle(QFilter qFilter) {
        return qFilter;
    }
}

