/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPermHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHomeDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tsirm.business.domain.position.service.PositionOperateService;
import kd.tsc.tsirm.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsirm.common.constants.position.PositionConstants;
import kd.tsc.tsirm.common.util.HrtMethodUtil;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbs.business.domain.common.service.ListFilterCommonHelper;
import kd.tsc.tsrbs.common.utils.ListViewUtils;
import org.apache.commons.lang3.ObjectUtils;

public class PositionList
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(PositionList.class);
    private static final String OP_EDIT_POSITION = "edit_donothing";
    private static final String OP_COPY_POSITION = "copy";
    private static final String COUNTRY_ID = "workcountry.id";
    private static final String USE_ORG_ID = "createorg.id";
    private static final String ADMIN_ORG_ID = "adminorg.id";
    private static final String CITY_ID = "workcity.id";
    private static final String COUNTRY_ID_CACHE = "countryIdCache";
    private static final String POSITION_RECRUIT_NUM = "recruitnum";
    private static final String POSITION_RECRUIT_IS_LIMIT = "isrecnumlimit";
    private static final int LIST_SELECTED_DATA_SIZE = 1;
    private static final String CUSTOM_CACHE = "customCache";
    private static final String OP_COPY_CACHE = "opCopyCache";
    private static final int BATCH_SIZE = 500;
    private Map<Long, Integer> appfileNums;
    private Map<Long, Integer> changeNums;
    private static final String VIEW_RIGHT = "47150e89000000ac";
    private static final QFilter HOLDOFFTYPQ_FILTER = new QFilter("id", "in", Arrays.asList(PositionConstants.HOLD_OFFICE_TYPE_FULL_TIME, PositionConstants.HOLD_OFFICE_TYPE_PART_TIME));
    private final Map<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>(16);
    public static final String KEY_LAST_LABORRELTYPE = "last_laborreltype";
    private static final HashMap<String, String> HANDLE_FILTER = new HashMap(16);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"tblrefresh", "stop_donothing", "posstart_donothing", "saveandcommitlist", "posclose_donothing"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        this.getPageCache().put(KEY_LAST_LABORRELTYPE, "");
        this.getPageCache().put("updateState", "0");
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (!AdvertPermHelper.getInstance().verifyHasAdvViewPerm()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mergelistcolumnap"});
        }
        IFormView rootView = this.getView().getView(this.getView().getFormShowParameter().getRootPageId());
        rootView.getPageCache().put("positionListPageId", this.getView().getPageId());
        if (Objects.nonNull(this.getView().getFormShowParameter().getCustomParam("deletePosition"))) {
            String message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PositionList_21", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(message);
            this.getView().getFormShowParameter().setCustomParam("deletePosition", null);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        ((IListColumn)listColumns.get(3)).setFixed(true);
        ((IListColumn)listColumns.get(2)).setFixed(true);
        ((IListColumn)listColumns.get(1)).setFixed(true);
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        boolean lookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        if (lookUp) {
            List qFilters = evt.getQFilters();
            ArrayList enableFilters = Lists.newArrayListWithExpectedSize((int)qFilters.size());
            for (QFilter qFilter : qFilters) {
                String property;
                if (qFilter == null || !HRStringUtils.equals((String)(property = qFilter.getProperty()), (String)"enable") && !HRStringUtils.equals((String)property, (String)"status")) continue;
                enableFilters.add(qFilter);
            }
            evt.getQFilters().removeAll(enableFilters);
        }
        this.setCategoryFilter(evt);
        this.setPermissionFilter(evt);
        evt.setOrderBy("positionpriority desc,modifytime desc,createtime desc");
    }

    private void setPermissionFilter(SetFilterEvent evt) {
        String billFormId = this.getBillList().getBillFormId();
        ImmutableList positionPermEnums = null;
        boolean lookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        if (!lookUp) {
            QFilter qFilter;
            if ("tsirm_position".equals(billFormId)) {
                positionPermEnums = ImmutableList.of((Object)PositionPermEnum.ADMIN_ORG, (Object)PositionPermEnum.ORG, (Object)PositionPermEnum.SEV_LEVEL);
            } else if ("tsirm_position_delivery".equals(billFormId)) {
                positionPermEnums = ImmutableList.of((Object)PositionPermEnum.DELIVERY);
            }
            List qFilters = evt.getQFilters();
            boolean isAllAdminOrg = true;
            boolean isAllCreateOrg = true;
            if (ObjectUtils.isNotEmpty((Object)qFilters)) {
                for (QFilter qFilter2 : qFilters) {
                    String property = qFilter2.getProperty();
                    if ("adminorgs.fbasedataid.id".equals(property)) {
                        isAllAdminOrg = false;
                        continue;
                    }
                    if (!USE_ORG_ID.equals(property)) continue;
                    isAllCreateOrg = false;
                }
            }
            if (ObjectUtils.isNotEmpty((Object)(qFilter = PositionPermService.getInstance((List)positionPermEnums).getHavePermPositionQFilter())) && "tsirm_position".equals(billFormId)) {
                if (isAllAdminOrg) {
                    qFilter.or(new QFilter("adminorg", "=", (Object)0L));
                }
                if (isAllCreateOrg) {
                    qFilter.or(new QFilter("createorg", "=", (Object)0L));
                }
            }
            evt.getQFilters().add(qFilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        QFilter qFilter = (QFilter)PositionDataHelper.generatePositionListFilterMap((IFormView)this.getView()).get(fieldName);
        if (qFilter != null) {
            args.setQfilters(Collections.singletonList(qFilter));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int i, int i1) {
                DynamicObjectCollection data = super.getData(i, i1);
                ArrayList positionIds = new ArrayList(data.size());
                data.forEach(positionRow -> positionIds.add(positionRow.getLong("id")));
                log.info("beforeCreateListDataProvider");
                PositionList.this.appfileNums = PositionModelAdapter.getCountByPositionId(positionIds);
                log.info("PositionModelAdapter.getCountByPositionId End");
                PositionList.this.changeNums = PositionModelAdapter.getChangedCountByPositionIds(positionIds);
                log.info("PositionModelAdapter.getChangedCountByPositionIds End");
                return data;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (POSITION_RECRUIT_NUM.equals(fieldKey) && "0".equals(String.valueOf(rowData.get(POSITION_RECRUIT_NUM)))) {
            evt.setFormatValue((Object)ResManager.loadKDString((String)"\u82e5\u5e72", (String)"PositionList_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        if ("candidatornum".equals(fieldKey)) {
            evt.setFormatValue((Object)this.appfileNums.get((Long)rowData.getPkValue()));
        } else if ("candidatechanged".equals(fieldKey)) {
            evt.setFormatValue((Object)this.changeNums.get((Long)rowData.getPkValue()));
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        AuthorizedOrgResult authorizedOrgResult;
        long currUserId;
        boolean superUser;
        String fieldName;
        super.filterColumnSetFilter(args);
        try {
            String methodName = HANDLE_FILTER.get(args.getFieldName());
            if (!HRStringUtils.isEmpty((String)methodName) && !"handleHoldofftyp".equals(methodName)) {
                List invoke = (List)HrtMethodUtil.invoke((Object)((Object)this), (String)methodName);
                args.getQFilters().addAll(invoke);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException evt) {
            log.error("PositionMethodException:", (Throwable)evt);
        }
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        if (HRStringUtils.equals((String)"adminorgs.fbasedataid.name", (String)(fieldName = args.getFieldName())) && !(superUser = PermissionServiceHelper.isSuperUser((long)(currUserId = RequestContext.get().getCurrUserId()))) && !(authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgs((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_position", (String)VIEW_RIGHT, (String)"adminorg", null)).isHasAllOrgPerm()) {
            QFilter idFilter = new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs());
            args.getQFilters().add(idFilter);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Object countryId = args.getFilterValue(COUNTRY_ID);
        if (args.getSearchClickEvent().getCurrentCommonFilter() == null) {
            return;
        }
        List fieldName = (List)args.getSearchClickEvent().getCurrentCommonFilter().get("FieldName");
        if (fieldName.contains(COUNTRY_ID)) {
            ListFilterCommonHelper.clearCustomFilterOnSearchClick((FilterContainerSearchClickArgs)args, (String)CITY_ID);
            this.getView().getPageCache().put(COUNTRY_ID_CACHE, countryId == null ? null : countryId.toString());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setDefaultValueToFilterValueMap(args);
        IPageCache pageCache = this.getView().getPageCache();
        if (HRStringUtils.isBlank((CharSequence)pageCache.get(CUSTOM_CACHE))) {
            String recObj;
            pageCache.put(CUSTOM_CACHE, "1");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String string = recObj = customParams.get(AppFileListConstants.CUSTOM_FILTER_RECRUIT_PROC_ID) != null ? customParams.get(AppFileListConstants.CUSTOM_FILTER_RECRUIT_PROC_ID).toString() : null;
            if (recObj != null) {
                args.getFilterColumn("positionstatus").setDefaultValue("A");
                if (!"0".equals(recObj)) {
                    args.getFilterColumn("manageinfo.recruproc.name").setDefaultValue(recObj);
                }
                List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
                for (FilterColumn filterColumn : filterColumns) {
                    if (!"createorg.name".equals(filterColumn.getFieldName())) continue;
                    filterColumn.setDefaultValues(this.getOrgIdsFromParam().toArray());
                }
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (this.getOrgIdsFromParam().size() > 0) {
            this.getPageCache().put("createOrg", JSONObject.toJSONString(this.getOrgIdsFromParam()));
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        int size = evt.getListSelectedRowCollection().size();
        if (size > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u590d\u5236\u3002", (String)"PositionList_15", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.validateQueryRight()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62db\u8058\u804c\u4f4d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionList_16", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long positionId = (Long)evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        this.openEditPositionFormView(this.getView(), positionId);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        IListView iListView = (IListView)this.getView();
        String fieldName = args.getFieldName();
        if (this.validateQueryRight()) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u62db\u8058\u804c\u4f4d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionList_16", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long positionId = (Long)iListView.getFocusRowPkId();
        if ("number".equals(fieldName)) {
            args.setCancel(true);
            this.openEditPositionFormView(this.getView(), positionId);
        } else if ("candidatornum".equals(fieldName)) {
            args.setCancel(true);
            Long candidateNum = PositionModelAdapter.getCountBySinglePositionId((Long)positionId);
            if (candidateNum <= 0L) {
                return;
            }
            long useOrgId = PositionDataHelper.getPositionUseOrgIdByPositionId((Long)positionId);
            this.openAddFileFormView(this.getView(), positionId, useOrgId, null);
        } else if ("candidatechanged".equals(fieldName)) {
            args.setCancel(true);
            Long candidateChangedNum = PositionModelAdapter.getChangedCountBySinglePositionId((Long)positionId);
            if (candidateChangedNum <= 0L) {
                return;
            }
            long useOrgId = PositionDataHelper.getPositionUseOrgIdByPositionId((Long)positionId);
            this.openAddFileFormView(this.getView(), positionId, useOrgId, "1");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"posoperationconfirm_callback")) {
            String result = (String)closedCallBackEvent.getReturnData();
            if (HRStringUtils.equals((String)result, (String)"yes")) {
                OperationResult operationResult = this.getView().invokeOperation("posclose_notips");
                if (operationResult.isSuccess()) {
                    String message = ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u5173\u95ed", (String)"PositionList_23", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(message);
                }
                this.getView().invokeOperation("refresh");
            } else if (HRStringUtils.equals((String)result, (String)"closeadv")) {
                ListSelectedRowCollection selectedRows = this.getBillList().getSelectedRows();
                List positionIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("tsirm_advertstoplist");
                showParameter.setFormId("tsirm_advtreelist");
                showParameter.setCustomParam("positionstatus", (Object)"D");
                showParameter.setCustomParam("position", positionIds);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"posstopopresult_callback")) {
            String result = (String)closedCallBackEvent.getReturnData();
            if (HRStringUtils.equals((String)result, (String)"yes")) {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("tsirm_advertstoplist");
                showParameter.setFormId("tsirm_advtreelist");
                showParameter.setCustomParam("positionstatus", (Object)"C");
                ListSelectedRowCollection selectedRows = this.getBillList().getSelectedRows();
                List positionIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                showParameter.setCustomParam("position", positionIds);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
            this.getView().invokeOperation("refresh");
        } else if ("tsirm_positiontpl".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String message;
        ListSelectedRowCollection selectedRows;
        Map verifyCert;
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if (("new".equals(operationKey) || OP_COPY_POSITION.equals(operationKey) || "posstart_donothing".equals(operationKey)) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            }
        }
        if ((HRStringUtils.equals((String)operationKey, (String)"stop_donothing") || HRStringUtils.equals((String)operationKey, (String)"posstart_donothing") || HRStringUtils.equals((String)operationKey, (String)"finish_donothing") || HRStringUtils.equals((String)operationKey, (String)"posclose_donothing")) && (selectedRows = this.getBillList().getSelectedRows()).size() > 10) {
            evt.setCancel(true);
            message = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u6700\u591a\u9009\u62e910\u6761\u6570\u636e", (String)"PositionList_17", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        if (HRStringUtils.equals((String)itemKey, (String)"tblposclose") || HRStringUtils.equals((String)itemKey, (String)"tblposend")) {
            selectedRows = this.getBillList().getSelectedRows();
            if (selectedRows.size() == 0) {
                evt.setCancel(true);
                message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PositionList_18", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            List positionIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            Map result = AdvertBizService.getInstance().getPubAdvertByPositionId(positionIds, null);
            if (result.size() > 0) {
                evt.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tsirm_posoperationconfirm");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("positionIds", positionIds);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "posoperationconfirm_callback"));
                this.getView().showForm(showParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int size;
        Map verifyCert;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("operationValue", "true");
        formOperate.setOption(operateOption);
        String operaKey = formOperate.getOperateKey();
        if (("new".equals(operaKey) || OP_COPY_POSITION.equals(operaKey) || "posstart_donothing".equals(operaKey)) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
                args.setCancel(true);
            }
        }
        if ((size = args.getListSelectedData().size()) > 1 && OP_COPY_POSITION.equals(operaKey)) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u590d\u5236\u3002", (String)"PositionList_19", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else if (OP_COPY_POSITION.equals(operaKey)) {
            Long positionId;
            DynamicObject positionDyn;
            DynamicObject createOrg;
            List orgIds = PositionHomeDataHelper.getHasPermViewOrgs((FormShowParameter)this.getView().getFormShowParameter());
            if (!orgIds.contains((createOrg = (positionDyn = PositionDataHelper.getPositionObjByPositionId((Long)(positionId = (Long)args.getListSelectedData().getPrimaryKeyValues()[0]))).getDynamicObject("createorg")).getLong("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u62db\u8058\u804c\u4f4d\u201d\u7684\u6570\u636e\u6743\u9650", (String)"PositionList_20", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.getView().getPageCache().put(OP_COPY_CACHE, "exist");
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        IListView iListView = (IListView)this.getView();
        String opCopyCache = this.getView().getPageCache().get(OP_COPY_CACHE);
        if (StringUtils.isNotEmpty((String)opCopyCache)) {
            Long positionId = (Long)iListView.getFocusRowPkId();
            if (null != positionId) {
                evt.getParameter().setCustomParam("copyId", (Object)positionId.toString());
            }
            this.getView().getPageCache().remove(OP_COPY_CACHE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        IListView iListView = (IListView)this.getView();
        Long positionId = (Long)iListView.getFocusRowPkId();
        if (OP_EDIT_POSITION.equals(operateKey)) {
            this.openEditPositionFormView(this.getView(), positionId);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"posstart_donothing") || HRStringUtils.equals((String)operateKey, (String)"posclose_donothing") || HRStringUtils.equals((String)operateKey, (String)"posclose_notips") || HRStringUtils.equals((String)operateKey, (String)"saveandcommitlist") || HRStringUtils.equals((String)operateKey, (String)"finish_donothing")) {
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)operateKey, (String)"stop_donothing")) {
            OperationResult operationResult = args.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds.size() > 0) {
                List positionIds = successPkIds.stream().map(id -> (Long)id).collect(Collectors.toList());
                Map result = AdvertBizService.getInstance().getPubAdvertByPositionId(positionIds, null);
                if (result.size() > 0) {
                    PositionOperateService.getInstance().showOperationResult(operationResult, this.getView(), (IFormPlugin)this);
                } else {
                    this.getView().invokeOperation("refresh");
                }
            }
        } else if (OP_COPY_POSITION.equals(operateKey) && args.getOperationResult().isSuccess()) {
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.setFormId("tsirm_position");
            Object pkId = this.getSelectedRows().get(0).getPrimaryKeyValue();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("copyId", (Object)pkId.toString());
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public BillList getBillList() {
        return (BillList)this.getView().getControl("billlistap");
    }

    public void setCategoryFilter(SetFilterEvent evt) {
        List qFilters = evt.getQFilters();
        ArrayList<Long> posCategoryList = new ArrayList<Long>(10);
        for (QFilter qFilter : qFilters) {
            if (qFilter == null || !"poscategory.id".equals(qFilter.getProperty())) continue;
            if (qFilter.getValue() instanceof List) {
                for (Object obj : (List)qFilter.getValue()) {
                    posCategoryList.add(Long.parseLong(obj.toString()));
                }
            } else {
                posCategoryList.add(Long.parseLong(qFilter.getValue().toString()));
            }
            qFilters.set(qFilters.indexOf(qFilter), new QFilter(qFilter.getProperty(), "in", (Object)PositionDataHelper.getChildPosCategoryId(posCategoryList)));
        }
    }

    private List<String> getOrgIdsFromParam() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<String> orgIds = new ArrayList<String>();
        if (customParams.get(AppFileListConstants.DEFAULT_FILTER_ORG_ID) != null) {
            orgIds.add(String.valueOf(customParams.get(AppFileListConstants.DEFAULT_FILTER_ORG_ID)));
        }
        if (customParams.get("orgIds") != null) {
            List orgIntIds = (List)customParams.get("orgIds");
            for (Object orgId : orgIntIds) {
                orgIds.add(String.valueOf(orgId));
            }
        }
        return orgIds;
    }

    private void showPositionFormViewByStatus(IFormView iFormView, Long positionId, String positionStatus, String postionName, DynamicObject billDyn) {
        Boolean isDeaftAndNoBill = "B".equals(positionStatus) && billDyn == null;
        String editFormId = "tsirm_position_delivery".equals(iFormView.getFormShowParameter().getCustomParam("billFormId")) ? "tsirm_positiondel_view" : "tsirm_position_view";
        String formId = isDeaftAndNoBill != false ? "tsirm_position" : editFormId;
        String billFormId = this.getBillList().getBillFormId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(formId);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d-{0}", (String)"PositionList_22", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{postionName}));
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(isDeaftAndNoBill != false ? OperationStatus.EDIT : OperationStatus.VIEW);
        baseShowParameter.setCustomParam("positionid", (Object)positionId.toString());
        baseShowParameter.setPkId((Object)positionId.toString());
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_positiontpl"));
        String pageId = PageUtils.getPageId((String)positionId.toString(), (String)"tsirm", (String)billFormId, (String)this.getView().getFormShowParameter().getRootPageId());
        baseShowParameter.setCustomParam("billFormId", (Object)billFormId);
        if (HRStringUtils.equals((String)formId, (String)"tsirm_position")) {
            baseShowParameter.setPageId(pageId + "new");
        } else {
            baseShowParameter.setPageId(pageId);
        }
        iFormView.showForm((FormShowParameter)baseShowParameter);
    }

    private void openAddFileFormView(IFormView iFormView, Long positionId, long useOrgId, String flag) {
        String billFormId = this.getBillList().getBillFormId();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        if ("tsirm_position".equals(billFormId) || "tsirm_position_f7view".equals(billFormId)) {
            showParameter.setBillFormId("tsirm_appfile_viewm");
        } else if ("tsirm_position_delivery".equals(billFormId)) {
            showParameter.setBillFormId("tsirm_appfile_viewc");
        }
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put(AppFileListConstants.DEFAULT_FILTER_POSITION_ID, positionId.toString());
        param.put(AppFileListConstants.DEFAULT_FILTER_ORG_ID, String.valueOf(useOrgId));
        if (!HRStringUtils.isEmpty((String)flag)) {
            param.put("statusFilter", AppFileConstants.APP_FILE_STATUS_INVALID);
        }
        param.put("positionSkip", "1");
        showParameter.setCustomParams(param);
        iFormView.showForm((FormShowParameter)showParameter);
    }

    private void openEditPositionFormView(IFormView iFormView, Long positionId) {
        DynamicObject positionDyObj = BusinessDataServiceHelper.loadSingle((Object)positionId, (String)"tsirm_positiontpl");
        if (positionDyObj != null) {
            String positionStatus = positionDyObj.getString("positionstatus");
            String positionName = positionDyObj.getString("name");
            DynamicObject billDyn = PositionDataHelper.getPositionBill((DynamicObject)positionDyObj);
            this.showPositionFormViewByStatus(iFormView, positionId, positionStatus, positionName, billDyn);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868", (String)"PositionList_24", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setDefaultValueToFilterValueMap(FilterContainerInitArgs args) {
        if (this.filterDataMap.isEmpty()) {
            for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
                this.filterDataMap.put(commonFilterColumn.getFilterField().getFieldName(), commonFilterColumn.getDefaultValues());
            }
        }
    }

    private void handleFilterValues() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
        if (otherFilterValues != null) {
            for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                ListViewUtils.handleFilterKeyValue((List)filterKeyValues, this.filterDataMap);
            }
        }
    }

    private boolean validateQueryRight() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object billFormIdObj = customParams.get("billFormId");
        long currUserId = RequestContext.get().getCurrUserId();
        if ("tsirm_position_delivery".equals(billFormIdObj)) {
            return !PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_position_delivery", (String)VIEW_RIGHT);
        }
        return !PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_position", (String)VIEW_RIGHT);
    }

    static {
        HANDLE_FILTER.put("holdofftyp.name", "handleHoldofftyp");
        HANDLE_FILTER.put("workcity.name", "handleWorkCity");
        HANDLE_FILTER.put("poscategory.name", "handlePosCategory");
    }
}

