/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class PositionListF7Plugin
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(PositionListF7Plugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object isVisible = this.getView().getFormShowParameter().getCustomParam("is_visible");
        if (Objects.isNull(isVisible)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"iseliminated"});
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        long sTime = System.currentTimeMillis();
        super.setFilter(setFilterEvent);
        ArrayList<String> positionStatusList = new ArrayList<String>();
        positionStatusList.add("A");
        positionStatusList.add("C");
        positionStatusList.add("D");
        positionStatusList.add("G");
        QFilter qFilter = new QFilter("positionstatus", "in", positionStatusList);
        setFilterEvent.addCustomQFilter(qFilter);
        long eTime = System.currentTimeMillis();
        logger.info("PositionListF7Plugin.setFilter.duration->{}", (Object)(eTime - sTime));
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        Object isVisible = this.getView().getFormShowParameter().getCustomParam("is_visible");
        if (Objects.isNull(isVisible)) {
            return;
        }
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            boolean isEliminated = this.getView().getModel().getDataEntity().getBoolean("iseliminated");
            parentView.getPageCache().put("istpeliminate", String.valueOf(isEliminated));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        int maxSelectRowLimit;
        super.beforeClick(evt);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object selectMaxRowObj = this.getView().getFormShowParameter().getCustomParam("maxSelectRow");
        int n = maxSelectRowLimit = selectMaxRowObj == null ? 0 : Integer.parseInt(selectMaxRowObj.toString());
        if (maxSelectRowLimit != 0 && selectedRows.size() > maxSelectRowLimit) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u4ee5\u9009\u62e910\u4e2a\u804c\u4f4d\u8fdb\u884c\u63a8\u8350\u3002", (String)"PositionListF7Plugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }
}

