/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.lock.service.LockService;
import kd.tsc.tsirm.business.domain.position.service.PositionManageService;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.common.constants.position.PositionManageConstants;

public class PositionManageViewEdit
extends HRDataBaseEdit
implements ItemClickListener {
    private static final String MANAGEMODIFY_FLEX = "managemodifyflex";
    private static final String KEY_POSITIONEDIT = "positionedit";
    private static final String KEY_POSITIONSAVE = "positionsave";
    private static final String KEY_POSITIONCANCLE = "positioncancle";
    private static final String KEY_PROCESSEDIT = "processedit";
    private static final String KEY_PROCESSSAVE = "processsave";
    private static final String KEY_PROCESSCANCLE = "processcancle";
    private static final String PANEL_POSITIONMANAGE = "positionpanel";
    private static final String PANEL_PROCESSMANAGE = "processpanel";
    private static final String ITEM_POSITIONITEM = "positionitem";
    private static final String ITEM_PROCESSITEM = "processitem";
    private LockService lockService = new LockService("positionmanage");

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.positionManageInit();
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{ITEM_POSITIONITEM, ITEM_PROCESSITEM});
        this.addClickListeners(new String[]{KEY_POSITIONEDIT, KEY_POSITIONSAVE, KEY_POSITIONCANCLE});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (KEY_POSITIONCANCLE.equals(key)) {
            this.positionCancleClick();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "managemodify_donothing": {
                this.positionEditClick();
                break;
            }
            case "managesave_donothing": {
                this.positionSaveClick();
                break;
            }
        }
    }

    public void pageRelease(EventObject evt) {
        String positionIdString;
        if (HRStringUtils.equals((String)"true", (String)this.getPageCache().get(KEY_POSITIONEDIT))) {
            positionIdString = this.getPageCache().get("positioneditid");
            this.lockService.releaseLock(Long.valueOf(positionIdString), KEY_POSITIONEDIT);
        }
        if (HRStringUtils.equals((String)"true", (String)this.getPageCache().get(KEY_PROCESSEDIT))) {
            positionIdString = this.getPageCache().get("processeditid");
            this.lockService.releaseLock(Long.valueOf(positionIdString), KEY_PROCESSEDIT);
        }
    }

    private void refreshPage() {
        this.getModel().setDataChanged(false);
        this.getView().updateView();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabpageap1");
    }

    private void positionEditClick() {
        boolean lock = this.lockService.getLock((Long)this.getModel().getValue("id"), KEY_POSITIONEDIT);
        if (!lock) {
            String message = ResManager.loadKDString((String)"\u8be5\u62db\u8058\u804c\u4f4d\u7ba1\u7406\u5df2\u5728\u7f16\u8f91\u4e2d\u3002", (String)"PositionManageViewEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        this.getPageCache().put(KEY_POSITIONEDIT, "true");
        this.getPageCache().put("positioneditid", this.getModel().getValue("id").toString());
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONEDIT});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_POSITIONSAVE});
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_POSITIONCANCLE});
        IFormView childView = this.viewStatusChange("tsirm_positionmanageview", OperationStatus.EDIT);
        if (childView != null) {
            childView.invokeOperation("refresh");
        }
    }

    private void positionSaveClick() {
        boolean lock = this.lockService.getLock((Long)this.getModel().getValue("id"), KEY_POSITIONEDIT);
        if (!lock) {
            String message = ResManager.loadKDString((String)"\u8be5\u62db\u8058\u804c\u4f4d\u7ba1\u7406\u5df2\u5728\u7f16\u8f91\u4e2d\u3002", (String)"PositionManageViewEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String pageId = this.getPageCache().get("tsirm_positionmanageview");
        IFormView childView = this.getView().getView(pageId);
        if (this.checkMustInput(childView).booleanValue()) {
            OperationResult result = childView.invokeOperation("save");
            if (result.isSuccess()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_POSITIONEDIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONSAVE});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONCANCLE});
                this.viewStatusChange("tsirm_positionmanageview", OperationStatus.VIEW);
                this.refreshPage();
            } else {
                for (IOperateInfo operateInfo : result.getAllErrorOrValidateInfo()) {
                    String message = operateInfo.getMessage();
                    this.getView().showTipNotification(message);
                }
            }
        }
        this.lockService.releaseLock((Long)this.getModel().getValue("id"), KEY_POSITIONEDIT);
        this.getPageCache().put(KEY_POSITIONEDIT, "false");
    }

    private Boolean checkMustInput(IFormView childView) {
        DynamicObjectCollection authorizer;
        DynamicObject dataEntity = childView.getModel().getDataEntity();
        Long seclevel = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dataEntity, (String)"seclevel");
        if (PositionManageConstants.SECLEVEL_PRIVATE.equals(seclevel) && (authorizer = dataEntity.getDynamicObjectCollection("authorizer")).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6388\u6743\u4eba", (String)"PositionManageViewEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void positionCancleClick() {
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_POSITIONEDIT});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONSAVE});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONCANCLE});
        this.viewStatusChange("tsirm_positionmanageview", OperationStatus.VIEW);
        this.lockService.releaseLock((Long)this.getModel().getValue("id"), KEY_POSITIONEDIT);
        this.getPageCache().put(KEY_POSITIONEDIT, "false");
    }

    private IFormView viewStatusChange(String pageNumber, OperationStatus operationStatus) {
        String pageId = this.getPageCache().get(pageNumber);
        IFormView childView = this.getView().getView(pageId);
        if (childView == null) {
            return null;
        }
        childView.setStatus(operationStatus);
        childView.updateView();
        childView.invokeOperation("refresh");
        this.getView().sendFormAction(childView);
        return childView;
    }

    private void positionManageInit() {
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITIONSAVE, KEY_PROCESSSAVE, KEY_PROCESSCANCLE, KEY_POSITIONCANCLE, KEY_POSITIONEDIT, KEY_PROCESSEDIT, MANAGEMODIFY_FLEX});
        Long positionId = (Long)this.getModel().getValue("id");
        String positionstaus = (String)this.getModel().getValue("positionstatus");
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)16);
        customParams.put("positionstatus", positionstaus);
        Long orgId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)this.getModel().getDataEntity(), (String)"createorg");
        customParams.put("createorg", String.valueOf(orgId));
        if (positionId != null) {
            Long manageInfoId;
            DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo((Long)positionId);
            Long l = manageInfoId = manageInfo == null ? null : Long.valueOf(manageInfo.getLong("id"));
            if (!"D".equals(positionstaus) && !"G".equals(positionstaus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_POSITIONEDIT, KEY_PROCESSEDIT, MANAGEMODIFY_FLEX});
            }
            PositionManageService.getInstance().openPositionManagePage("tsirm_positionmanageview", PANEL_POSITIONMANAGE, this.getView(), BillOperationStatus.VIEW, OperationStatus.VIEW, manageInfoId, (Map)customParams);
        }
    }
}

