/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.position.service.PosPortraitHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.enums.PosPortraitOperateEnum;
import net.sf.json.JSONObject;

public class PositionPortraitShowPlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(PositionPortraitShowPlugin.class);
    private static final String PORTRAIT_PANEL = "portraitpanel";
    private static final String PORTRAIT_BAR = "bar_portrait";
    private static final String PAGE_PORTRAIT = "tsirm_posportrait";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Long positionId = (Long)this.getModel().getValue("id");
        if (positionId != null && !positionId.equals(0L)) {
            PosPortraitHelper posPortraitHelper = new PosPortraitHelper();
            BizResult result = null;
            try {
                result = posPortraitHelper.getPortraitStatus(positionId);
                if (result != null) {
                    logger.error("PosPortraitHelper.getPortraitStatus result:{};boolean:{}", (Object)JSONObject.fromObject((Object)result).toString(), (Object)result.getCode().equals(PosPortraitHelper.CODE_HAVE_PORTRAIT));
                }
            }
            catch (Exception exception) {
                logger.error("PosPortraitHelper.getPortraitStatus error", (Throwable)exception);
            }
            if (result != null && result.getCode().equals(PosPortraitHelper.CODE_HAVE_PORTRAIT)) {
                logger.error("PosPortraitHelper.getPortraitStatus if->:{}", (Object)result.getCode());
                this.getView().setVisible(Boolean.TRUE, new String[]{PORTRAIT_PANEL});
                this.showPortraitPage(Boolean.FALSE);
                Boolean positionInterviewFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("posInterviewerForm");
                if (positionInterviewFlag != null && Boolean.TRUE.equals(positionInterviewFlag)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{PORTRAIT_PANEL});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{PORTRAIT_PANEL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{PORTRAIT_PANEL});
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{PORTRAIT_BAR});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (HRStringUtils.equals((String)itemKey, (String)PORTRAIT_BAR)) {
            String nameObj = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
            if (!HRStringUtils.isEmpty((String)nameObj)) {
                this.showPortraitPage(Boolean.TRUE);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u804c\u4f4d\u540d\u79f0\u540e\uff0c\u8fdb\u884c\u8be5\u64cd\u4f5c", (String)"PositionPortraitShowPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"savewithoutvail") || HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"saveandcommit")) {
            Long positionId = (Long)this.getModel().getValue("id");
            if (positionId == null || positionId.equals(0L)) {
                return;
            }
            PosPortraitHelper helper = new PosPortraitHelper();
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            String positionJsonString = PositionDataHelper.generatePositionJsonString((DynamicObject)dynamicObject);
            BizResult operate = helper.operate(positionId, positionJsonString, PosPortraitOperateEnum.SAVE);
            if (operate.getCode().equals(PosPortraitHelper.CODE_SAVE_PORTRAIT_FIRST)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u6b65\u9aa4\u4e2d\u804c\u4f4d\u753b\u50cf\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u804c\u4f4d\u753b\u50cf", (String)"PositionPortraitShowPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void showPortraitPage(Boolean isClickedPortraitBtn) {
        String positionJsonString = PositionDataHelper.generatePositionJsonString((DynamicObject)this.getModel().getDataEntity());
        this.getView().setVisible(Boolean.TRUE, new String[]{PORTRAIT_PANEL});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(PAGE_PORTRAIT);
        showParameter.getOpenStyle().setTargetKey(PORTRAIT_PANEL);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        Long positionId = (Long)this.getModel().getValue("id");
        if (positionId == null || positionId.equals(0L)) {
            positionId = ORM.create().genLongId("tsirm_position");
        }
        showParameter.setCustomParam("posId", (Object)positionId);
        showParameter.setCustomParam("posName", (Object)((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue());
        showParameter.setCustomParam("positionstatus", this.getModel().getValue("positionstatus"));
        showParameter.setCustomParam("positionInfo", (Object)positionJsonString);
        showParameter.setCustomParam("isClickedPortraitBtn", (Object)isClickedPortraitBtn);
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put(PAGE_PORTRAIT, showParameter.getPageId());
    }
}

