/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.ORM;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class PositionRecPlanEdit
extends HRDataBaseEdit {
    private static final String RECREQIDS = "recreqIds";
    private static final String PAGE_REQPLAN = "tsrpm_reqplan";
    private static final String PANEL_REQPLAN = "recplanpanel";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.openRecReqPlanPage();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"saveandcommit") || HRStringUtils.equals((String)operateKey, (String)"savewithoutvail") || HRStringUtils.equals((String)operateKey, (String)"submit")) {
            if (!args.getOperationResult().isSuccess()) {
                return;
            }
            String pageId = this.getPageCache().get(PAGE_REQPLAN);
            IFormView childView = this.getView().getViewNoPlugin(pageId);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("positionid", this.getModel().getValue("id").toString());
            childView.invokeOperation("save", operateOption);
        }
    }

    private void openRecReqPlanPage() {
        Object recReqIds = this.getView().getFormShowParameter().getCustomParam(RECREQIDS);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId(PAGE_REQPLAN);
        parameter.getOpenStyle().setTargetKey(PANEL_REQPLAN);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setBillStatus(BillOperationStatus.ADDNEW);
        parameter.setStatus(OperationStatus.EDIT);
        Long positionId = (Long)this.getModel().getValue("id");
        if (positionId == null || positionId.equals(0L)) {
            positionId = ORM.create().genLongId("tsirm_position");
            this.getModel().setValue("id", (Object)positionId);
        }
        parameter.getCustomParams().put("positionid", positionId);
        parameter.getCustomParams().put("posreqstatus", this.getView().getFormShowParameter().getStatus());
        parameter.getCustomParams().put("parentpageid", this.getView().getPageId());
        if (recReqIds instanceof List) {
            List idList = (List)recReqIds;
            parameter.getCustomParams().put(RECREQIDS, idList);
        }
        String pageId = parameter.getPageId();
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().getPageCache().put(PAGE_REQPLAN, pageId);
    }
}

