/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionResumeRuleHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionRuleHelper;
import kd.tsc.tsirm.common.util.FormShowUtils;
import kd.tsc.tsrbs.common.enums.rsm.RsmAssignTypeEnum;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tsrbs.common.utils.PublishMsgUtil;
import org.springframework.util.StringUtils;

public class PositionRuleEdit
extends HRDataBaseEdit
implements SearchEnterListener {
    private PositionRuleHelper positionRuleHelper = new PositionRuleHelper();
    private static final Integer MAX_KEYWORD_LENGTH = 50;
    private static final Integer MAX_KEYWORDLIST_SIZE = 10;

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterBindData(EventObject evt) {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Long positionRuleId = showParameter.getPkId() != null ? Long.valueOf(showParameter.getPkId().toString()) : null;
        DynamicObject positionRule = TsrbsHelper.selectById((Long)positionRuleId, (String)"tsirm_positionrule");
        if (Objects.isNull(positionRule)) {
            return;
        }
        this.setKeyword(positionRule);
    }

    private Long getPositionId() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        return (Long)customParams.get("positionid");
    }

    private void setKeyword(DynamicObject positionRule) {
        String keyword = positionRule.getString("keyword");
        if (StringUtils.isEmpty((Object)keyword)) {
            return;
        }
        this.getPageCache().put("key_keyword_str", keyword);
        this.getModel().setValue("keyword", (Object)keyword);
        List<String> keywordList = Arrays.stream(keyword.split("\u3001")).collect(Collectors.toList());
        if (keywordList.size() == MAX_KEYWORDLIST_SIZE.intValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"searchap"});
        }
        keywordList.forEach(this::setKeywordStyle);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName = evt.getProperty().getName();
        DynamicObject data = this.getModel().getDataEntity();
        if ("keyword".equals(propertyName)) {
            BizResult bizResult = this.positionRuleHelper.saveCheck(Long.valueOf(data.getLong("id")), data.getString("distrimode"), data.getString("keyword"), this.getPositionId());
            Integer code = bizResult.getCode();
            if (code.equals(PositionResumeRuleHelper.KEYWORD_REPEAT_CODE)) {
                String confirmTip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8be5\u5206\u914d\u6761\u4ef6\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"PositionRuleEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), new Object[0]);
                FieldTip tip = new FieldTip(FieldTip.FieldTipsLevel.Warning, FieldTip.FieldTipsTypes.backCard, "textfield", confirmTip);
                tip.setSuccess(false);
                this.getView().showFieldTip(tip);
            } else {
                FieldTip rangeDownTip = new FieldTip(FieldTip.FieldTipsLevel.Info, FieldTip.FieldTipsTypes.others, "textfield", null);
                rangeDownTip.setSuccess(true);
                this.getView().showFieldTip(rangeDownTip);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject data = this.getModel().getDataEntity();
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("save")) {
            String keyword = data.getString("keyword");
            if (StringUtils.isEmpty((Object)keyword)) {
                return;
            }
            Long position = this.getPositionId();
            this.getModel().setValue("positionid", (Object)position);
            String distriMode = data.getString("distrimode");
            BizResult bizResult = this.positionRuleHelper.saveCheck(Long.valueOf(data.getLong("id")), distriMode, keyword, position);
            Integer code = bizResult.getCode();
            if (code.equals(PositionResumeRuleHelper.KEYWORD_REPEAT_CODE)) {
                args.setCancel(true);
                return;
            }
            if (code.equals(PositionResumeRuleHelper.KEYWORD_INCLUDE_CODE)) {
                args.setCancel(true);
                String keywordDB = (String)bizResult.getData();
                String titleMsg = ResManager.loadKDString((String)"\u5df2\u6709\u6761\u4ef6\u5df2\u8986\u76d6\u5f53\u524d\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u6216\u5df2\u6709\u6761\u4ef6\u540e\u4fdd\u5b58", (String)"PositionRuleEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.showForm(keywordDB, distriMode, titleMsg);
                return;
            }
            if (code.equals(PositionResumeRuleHelper.KEYWORD_INCLUDED_CODE)) {
                args.setCancel(true);
                String keywordDB = (String)bizResult.getData();
                String titleMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u5df2\u8986\u76d6\u5df2\u6709\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u6216\u5df2\u6709\u6761\u4ef6\u540e\u4fdd\u5b58", (String)"PositionRuleEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.showForm(keywordDB, distriMode, titleMsg);
                return;
            }
            this.getPageCache().remove("key_keyword_str");
            DynamicObject[] dynamicObjects = this.positionRuleHelper.listByPosition(position);
            if (dynamicObjects.length > 0) {
                String statusDB = dynamicObjects[0].getString("enable");
                data.set("enable", (Object)statusDB);
                data.set("issyspreset", (Object)Character.valueOf('0'));
                if (HRStringUtils.equals((String)statusDB, (String)"1")) {
                    PublishMsgUtil.positionRulePublishMsg((DynamicObject[])new DynamicObject[]{data}, (int)2);
                }
            }
            IFormView view = this.getView().getParentView().getParentView();
            view.invokeOperation("refresh");
            this.getView().sendFormAction(view);
        }
    }

    public void showForm(String keywordDB, String distrimode, String titleMsg) {
        String errorMsg = "";
        if (HRStringUtils.equals((String)RsmAssignTypeEnum.EMAIL.getCode(), (String)distrimode)) {
            if (!keywordDB.contains("\u3001")) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u6709\u6761\u4ef6\uff1a\u90ae\u4ef6\u4e3b\u9898\u5305\u542b\"{0}\"", (String)"PositionRuleEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{keywordDB});
            }
            if (keywordDB.contains("\u3001")) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u6709\u6761\u4ef6\uff1a\u90ae\u4ef6\u4e3b\u9898\u540c\u65f6\u5305\u542b\"{0}\"", (String)"PositionRuleEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{keywordDB});
            }
        }
        if (HRStringUtils.equals((String)RsmAssignTypeEnum.Attachment.getCode(), (String)distrimode)) {
            if (!keywordDB.contains("\u3001")) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u6709\u6761\u4ef6\uff1a\u9644\u4ef6\u5185\u5bb9\u5305\u542b\"{0}\"", (String)"PositionRuleEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{keywordDB});
            }
            if (keywordDB.contains("\u3001")) {
                errorMsg = ResManager.loadKDString((String)"\u5df2\u6709\u6761\u4ef6\uff1a\u9644\u4ef6\u5185\u5bb9\u540c\u65f6\u5305\u542b\"{0}\"", (String)"PositionRuleEdit_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{keywordDB});
            }
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)errorMsg, (boolean)false);
        this.getView().showForm(formShowParameter);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = StringUtils.trimAllWhitespace((String)searchEnterEvent.getText());
        if (StringUtils.isEmpty((Object)text)) {
            return;
        }
        String keyword = StringUtils.delete((String)text, (String)"\u3001");
        if (keyword.length() > MAX_KEYWORD_LENGTH) {
            return;
        }
        this.setKeyword(keyword);
    }

    private void setKeyword(String text) {
        Search search = (Search)this.getControl("searchap");
        IPageCache pageCache = this.getPageCache();
        String keyword = pageCache.get("key_keyword_str");
        List<Object> keywordList = StringUtils.isEmpty((Object)keyword) ? new ArrayList() : Arrays.stream(keyword.split("\u3001")).collect(Collectors.toList());
        if (keywordList.contains(text)) {
            return;
        }
        if (keywordList.size() == MAX_KEYWORDLIST_SIZE.intValue()) {
            search.setSearchKey("");
            return;
        }
        keywordList.add(text);
        if (keywordList.size() == MAX_KEYWORDLIST_SIZE.intValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"searchap"});
        }
        String newKeyword = Joiner.on((String)"\u3001").join(keywordList);
        pageCache.put("key_keyword_str", newKeyword);
        search.setSearchKey("");
        this.getModel().setValue("keyword", (Object)newKeyword);
        this.setKeywordStyle(text);
    }

    private void setKeywordStyle(String text) {
        Container flexPanel = (Container)this.getControl("keywordflex");
        FormShowParameter showParameter = FormShowUtils.setFormShow((Container)flexPanel, (String)text, (String)"tsirm_keyword");
        HashMap<String, Integer> map = new HashMap<String, Integer>(16);
        map.put("gr", 0);
        map.put("sk", 0);
        this.getView().updateControlMetadata(text, map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "key_word"));
        showParameter.setCustomParam("keyword_text", (Object)text);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("key_word".equals(actionId)) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            IPageCache pageCache = this.getPageCache();
            String keyword = pageCache.get("key_keyword_str");
            List keywordList = Arrays.stream(keyword.split("\u3001")).collect(Collectors.toList());
            keywordList.remove(returnData);
            if (keywordList.size() < MAX_KEYWORDLIST_SIZE) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"searchap"});
            }
            String newKeyword = Joiner.on((String)"\u3001").join(keywordList);
            pageCache.put("key_keyword_str", newKeyword);
            this.getModel().setValue("keyword", (Object)newKeyword);
        }
    }
}

