/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionRuleHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionRuleServiceHelper;
import kd.tsc.tsirm.common.util.PositionRulePermUtil;
import kd.tsc.tsrbs.common.utils.PublishMsgUtil;

public class PositionRuleList
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(PositionRuleList.class);
    private PositionRuleHelper positionRuleHelper = new PositionRuleHelper();
    private Integer count = 1;
    private String BTN_ADDNEW = "addbtn";

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long positionId = (Long)customParams.get("positionid");
        if ("1".equals(this.getStatus(positionId))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblenable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tbldisable"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldisable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblenable"});
        }
        if (!PositionRulePermUtil.verifyHasPerm((String)"tsirm_positionrule", (String)"execute", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"execute"});
        }
    }

    private String getStatus(Long positionId) {
        QFilter qFilter = new QFilter("positionid", "=", (Object)positionId);
        List positionRuleList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_positionrule");
        if (CollectionUtils.isEmpty((Collection)positionRuleList)) {
            return "";
        }
        return ((DynamicObject)positionRuleList.get(0)).getString("enable");
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long positionId = (Long)customParams.get("positionid");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("positionid", "=", (Object)positionId));
        evt.setCustomQFilters(qFilterList);
    }

    public void afterBindData(EventObject evt) {
        HashMap<String, String> cstylesMap = new HashMap<String, String>(16);
        cstylesMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiLmFnLXBpbm5lZC1sZWZ0LWhlYWRlciB7XG4gIGRpc3BsYXk6IG5vbmUgIWltcG9ydGFudDtcbn1cbi5hZy1waW5uZWQtbGVmdC1jb2xzLWNvbnRhaW5lciB7XG4gIGRpc3BsYXk6IG5vbmUgIWltcG9ydGFudDtcbn1cbi5fMm9BRUlraXkge1xuICBkaXNwbGF5OiBub25lICFpbXBvcnRhbnQ7XG59In0=");
        this.getView().updateControlMetadata("flexpanelap1", cstylesMap);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String positionStatus = (String)customParams.get("positionStatus");
        if (!HRStringUtils.equals((String)positionStatus, (String)"A") && !HRStringUtils.equals((String)positionStatus, (String)"C")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"execute", "tbldisable", "tblenable"});
            if (!HRStringUtils.equals((String)positionStatus, (String)"E")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{this.BTN_ADDNEW});
            }
        }
        if (HRStringUtils.equals((String)positionStatus, (String)"D")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "execute", "tbldisable", this.BTN_ADDNEW});
        }
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String positionStatus = (String)customParams.get("positionStatus");
        DynamicObject positionRule = evt.getRowData();
        if ("keyword".equals(fieldKey)) {
            String keyWord = positionRule.getString("keyword");
            if (StringUtils.isEmpty((String)keyWord)) {
                log.warn("keyword is empty!");
                return;
            }
            List<String> keyWordList = Arrays.asList(keyWord.split("\u3001"));
            String concatStr = keyWordList.size() > 1 ? ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u540c\u65f6\u5305\u542b", (String)"PositionRuleList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5173\u952e\u8bcd\u5305\u542b", (String)"PositionRuleList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            evt.setFormatValue((Object)concatStr.concat(Joiner.on((String)"\u3001").join(keyWordList)));
        } else if ("update".equals(fieldKey)) {
            evt.setFormatValue((Object)this.getText(positionStatus, positionRule.getString("issyspreset"), ResManager.loadKDString((String)"\u4fee\u6539", (String)"PositionRuleList_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        } else if ("delete".equals(fieldKey)) {
            evt.setFormatValue((Object)this.getText(positionStatus, positionRule.getString("issyspreset"), ResManager.loadKDString((String)"\u5220\u9664", (String)"PositionRuleList_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        } else if ("count".equals(fieldKey)) {
            Integer n = this.count;
            Integer n2 = this.count = Integer.valueOf(this.count + 1);
            evt.setFormatValue((Object)n);
        }
    }

    private String getText(String positionStatus, String isSysPreset, String text) {
        String ret = "";
        if ((HRStringUtils.equals((String)positionStatus, (String)"A") || HRStringUtils.equals((String)positionStatus, (String)"D") || HRStringUtils.equals((String)positionStatus, (String)"E")) && HRStringUtils.equals((String)isSysPreset, (String)"false")) {
            ret = text;
        }
        return ret;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("execute".equals(itemKey)) {
            Long positionId = (Long)customParams.get("positionid");
            this.execute(positionId);
        }
        if ("addbtn".equals(itemKey)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("tsirm_positionrule");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParams(customParams);
            OpenStyle openStyle = showParameter.getOpenStyle();
            Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void execute(Long positionId) {
        int count;
        List positionRuleList = PositionRuleServiceHelper.getInstance().selectPositionRuleByPositionId(positionId);
        if (CollectionUtils.isEmpty((Collection)positionRuleList)) {
            return;
        }
        if ("0".equals(((DynamicObject)positionRuleList.get(0)).getString("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u89c4\u5219\u540e\u6267\u884c", (String)"PositionRuleList_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] positionRules = PositionRuleServiceHelper.getInstance().getRsmObjsByPositionId(positionId);
        int n = count = ArrayUtils.isEmpty((Object[])positionRules) ? 0 : positionRules.length;
        if (0 == count) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u5f85\u5206\u914d\u7684\u7b80\u5386", (String)"PositionRuleList_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        String message = ResManager.loadKDString((String)"\u5206\u914d\u4efb\u52a1\u6b63\u5728\u540e\u53f0\u6267\u884c\u4e2d\uff0c\u5171{0}\u4efd\u7b80\u5386\uff0c\u9884\u8ba1\u9700\u8981{1}\u79d2\u5de6\u53f3", (String)"PositionRuleList_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{count, 30});
        this.getView().showConfirm(message, MessageBoxOptions.OK);
        PublishMsgUtil.positionRulePublishMsg((DynamicObject[])this.positionRuleHelper.listByPosition(positionId), (int)2);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.showForm(args.getFieldName(), this.getPrimaryKey());
    }

    private void showForm(String column, Long primaryKey) {
        if ("update".equals(column)) {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.setFormId("tsirm_positionrule");
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId((Object)primaryKey);
            showParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            OpenStyle openStyle = showParameter.getOpenStyle();
            Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("delete".equals(column)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u5f52\u6863\u6761\u4ef6\u5417\uff1f", (String)"PositionRuleList_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            this.getPageCache().put(this.getView().getPageId(), String.valueOf(primaryKey));
        }
    }

    private Long getPrimaryKey() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        return (Long)baseDataListRow.getPrimaryKeyValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Integer code;
        BizResult bizResult;
        Long position;
        Map customParams;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("donothing_disable")) {
            args.setCancel(true);
            customParams = this.getView().getFormShowParameter().getCustomParams();
            position = (Long)customParams.get("positionid");
            bizResult = this.positionRuleHelper.setStatus(position, "0");
            if (bizResult.getSuccess().booleanValue()) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("tbldisable", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u7981\u7528\u540e\u90ae\u7bb1\u6536\u53d6\u7684\u7b80\u5386\u5c06\u65e0\u6cd5\u5f52\u6863\u81f3\u5f53\u524d\u804c\u4f4d\uff0c\u786e\u5b9a\u8981\u7981\u7528\u5417\uff1f", (String)"PositionRuleList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                return;
            }
            code = bizResult.getCode();
            if (code.equals(PositionRuleHelper.STATUS_HAS_DISABLED_CODE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u6863\u89c4\u5219\u5df2\u4e3a\u7981\u7528\u72b6\u6001", (String)"PositionRuleList_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        }
        if (key.equalsIgnoreCase("donothing_enable")) {
            args.setCancel(true);
            customParams = this.getView().getFormShowParameter().getCustomParams();
            position = (Long)customParams.get("positionid");
            bizResult = this.positionRuleHelper.setStatus(position, "1");
            if (bizResult.getSuccess().booleanValue()) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("tblenable", (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u542f\u7528\u540e\u90ae\u7bb1\u6536\u53d6\u7684\u7b80\u5386\u5c06\u901a\u8fc7\u5f52\u6863\u89c4\u5219\u5f52\u6863\u81f3\u5f53\u524d\u804c\u4f4d\uff0c\u786e\u5b9a\u8981\u91cd\u542f\u5417\uff1f", (String)"PositionRuleList_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBackListener);
                return;
            }
            code = bizResult.getCode();
            if (code.equals(PositionRuleHelper.STATUS_HAS_ENABLED_CODE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f52\u6863\u89c4\u5219\u5df2\u4e3a\u542f\u7528\u72b6\u6001", (String)"PositionRuleList_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (code.equals(PositionRuleHelper.NO_EMAIL_CODE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u7b80\u5386\u6536\u53d6\u90ae\u7bb1\u540e\uff0c\u518d\u8fdb\u884c\u5f52\u6863\u89c4\u5219\u7684\u542f\u7528", (String)"PositionRuleList_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        int result = evt.getResult().getValue();
        if (HRStringUtils.equals((String)"tbldisable", (String)evt.getCallBackId()) && result == MessageBoxResult.Yes.getValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\"\u5f52\u6863\u89c4\u5219\"\u7981\u7528\u6210\u529f", (String)"PositionRuleList_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            IFormView positionListView = this.getView().getParentView();
            if (positionListView != null) {
                positionListView.invokeOperation("refresh");
                this.getView().sendFormAction(positionListView);
            }
        }
        if (HRStringUtils.equals((String)"tblenable", (String)evt.getCallBackId()) && result == MessageBoxResult.Yes.getValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\"\u5f52\u6863\u89c4\u5219\"\u542f\u7528\u6210\u529f", (String)"PositionRuleList_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Long position = (Long)customParams.get("positionid");
            PublishMsgUtil.positionRulePublishMsg((DynamicObject[])this.positionRuleHelper.listByPosition(position), (int)2);
            IFormView positionListView = this.getView().getParentView();
            if (positionListView != null) {
                positionListView.invokeOperation("refresh");
                this.getView().sendFormAction(positionListView);
            }
        }
        if ("delete".equals(evt.getCallBackId()) && MessageBoxResult.Yes.getValue() == result) {
            PositionRuleServiceHelper.getInstance().deleteById(Long.valueOf(this.getPageCache().get(this.getView().getPageId())));
            this.getView().invokeOperation("refresh");
        }
    }
}

