/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsrbs.common.utils.CacheUtils;

public class PositionRuleListViewEdit
extends HRDynamicFormBasePlugin {
    private static final String SLIDE_MOTION = "afterShowSlideBill";

    public void customEvent(CustomEventArgs evt) {
        if (SLIDE_MOTION.equals(evt.getKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject evt) {
        String sessionId = RequestContext.get().getGlobalSessionId();
        DistributeSessionlessCache cache = CacheUtils.getDistributeSessionlessCache();
        String count = (String)cache.get("count".concat(RequestContext.get().getGlobalSessionId()));
        if (count != null) {
            String positionId = (String)cache.get("positionid".concat(sessionId).concat(count));
            String positionStatus = (String)cache.get("positionStatus".concat(sessionId).concat(count));
            this.processStatus(this.getStatus(Long.valueOf(positionId)));
            this.setFlexShowForm(Long.valueOf(positionId), positionStatus);
        }
    }

    public void setFlexShowForm(Long positionId, String positionStatus) {
        ListShowParameter showParameter = new ListShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.getOpenStyle().setTargetKey("positionrulelistflex");
        showParameter.setBillFormId("tsirm_positionrule");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("positionid", positionId);
        paramMap.put("positionStatus", positionStatus);
        showParameter.setCustomParams(paramMap);
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.InContainer));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public String getStatus(Long positionId) {
        QFilter qFilter = new QFilter("positionid", "=", (Object)positionId);
        List positionRuleList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_positionrule");
        if (CollectionUtils.isEmpty((Collection)positionRuleList)) {
            return "";
        }
        return ((DynamicObject)positionRuleList.get(0)).getString("enable");
    }

    public void processStatus(String status) {
        if (StringUtils.isEmpty((String)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enable", "disable"});
        }
        if ("1".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"disable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"enable"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"enable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"disable"});
        }
    }
}

