/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tsirm.common.constants.position.PositionManageConstants;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecConfHelper;

public class PositionSecLevelList
extends HRDataBaseList {
    Map<Long, String> secLevelMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<Long, Integer> recruitnumMap = Maps.newHashMapWithExpectedSize((int)16);
    Map<Long, DynamicObjectCollection> posPrinMap = Maps.newHashMapWithExpectedSize((int)16);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObject[] manageInfos;
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                List positionIds = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
                PositionSecLevelList.this.recruitnumMap = PositionModelAdapter.getCountByPositionId(positionIds);
                for (DynamicObject manageInfo : manageInfos = PositionManageServiceHelper.getManageInfoByPositionIds(positionIds)) {
                    Long positionId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)manageInfo, (String)"position");
                    Object secLevel = manageInfo.get("seclevel");
                    if (secLevel != null) {
                        String secLevelString = ((DynamicObject)secLevel).getString("codelevel");
                        PositionSecLevelList.this.secLevelMap.put(positionId, secLevelString);
                    }
                    DynamicObjectCollection posprin = manageInfo.getDynamicObjectCollection("posprin");
                    PositionSecLevelList.this.posPrinMap.put(positionId, posprin);
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = evt.getRowData();
        long positionId = rowData.getLong("id");
        if (HRStringUtils.equals((String)fieldKey, (String)"manageinfo.seclevel.number")) {
            String secLevel = this.secLevelMap.get(positionId);
            if (HRStringUtils.isNotEmpty((String)secLevel)) {
                evt.setFormatValue((Object)secLevel);
            }
        } else if ("posprin.name".equals(fieldKey)) {
            DynamicObjectCollection collection = this.posPrinMap.get(positionId);
            if (collection != null) {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : collection) {
                    String name = dynamicObject.getString("fbasedataid.name");
                    sb.append(name).append(';');
                }
                String names = sb.toString();
                evt.setFormatValue((Object)HRStringUtils.substringBeforeLast((String)names, (String)";"));
            }
        } else if ("candidatornum".equals(fieldKey)) {
            String positionStatus;
            Integer recNum = this.recruitnumMap.get(positionId);
            if (recNum != null) {
                evt.setFormatValue(null);
                evt.setFormatValue((Object)recNum);
            }
            if ("B".equals(positionStatus = rowData.getString("positionstatus")) || HRStringUtils.equals((String)"E", (String)positionStatus)) {
                evt.setFormatValue((Object)"");
            }
        }
    }

    public void afterBindData(EventObject evt) {
        boolean flag = SecConfHelper.querySecurityConf((Long)PositionManageConstants.SECLEVEL_NUMBER);
        if (flag) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"manageinfo.seclevel.number", "manageinfo_seclevel_number"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"manageinfo.seclevel.number", "manageinfo_seclevel_number"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setSecLevelFilterColumn(args);
    }

    private void setSecLevelFilterColumn(FilterContainerInitArgs args) {
        boolean flag = SecConfHelper.querySecurityConf((Long)PositionManageConstants.SECLEVEL_NUMBER);
        FilterColumn seclevel = args.getFilterColumn("manageinfo.seclevel.name");
        if (!flag) {
            args.getCommonFilterColumns().remove(seclevel);
            args.getSchemeFilterColumns().remove(seclevel);
        } else {
            DynamicObject[] dynamicObjects = SecConfHelper.querySecLevel();
            Map<String, String> codeLevelMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> String.valueOf(dyn.getLong("id")), dyn -> dyn.getString("codelevel")));
            List comboItems = ((CommonBaseDataFilterColumn)seclevel).getComboItems();
            for (ComboItem comboItem : comboItems) {
                String value = comboItem.getValue();
                String codeLevel = codeLevelMap.get(value);
                comboItem.setCaption(new LocaleString(codeLevel));
            }
        }
    }
}

