/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertPermHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillService;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHomeDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionModelAdapter;
import kd.tsc.tsirm.business.domain.position.service.PositionOperateService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import org.apache.commons.lang3.StringUtils;

public class PositionViewEdit
extends HRDataBaseEdit {
    private static final String KEY_LABELPOSNAME = "labelposname";
    private static final String KEY_LABELPOSNUM = "labelposnum";
    private static final String KEY_LABELSTATUS = "labelstatus";
    private static final String LABEL_STATUS1 = "label_status1";
    private static final String LABEL_STATUS2 = "label_status2";
    private static final String LABEL_STATUS3 = "label_status3";
    public static final String KEY_LABEL_CANDIDATE = "labelcandidate";
    public static final String KEY_LABEL_COMPLETEDATE = "completedate";
    private static final String KEY_BARCOPY = "barcopy";
    private static final String KEY_BARCOPYEDIT = "barcopyedit";
    private static final String KEY_EDITDONOTHINGOP = "edit_donothing";
    private static final String KEY_CHARGEPERLBL = "chargeperlbl";
    private static final String KEY_POSPRIN = "posprin";
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_MINIMODECK = "flexpanelap16";
    private static final String KEY_POSITIONBILL = "bar_positionbill";
    private static final String MODIFY_FLEX = "modifyflex";
    private static final String KEY_BARMODIFYADD = "barmodifyadd";
    private static final String KEY_SCELEVEL_LBL = "seclevellbl";
    private static final int STRING_SLPIT_LEN = 6;
    private static String KEY_POSITION_DETAIL_OPEN = "imageap1";
    private static String KEY_POSITION_DETAIL_CLOSE = "imageap11";
    private static String POSITION_DETAIL_FLEX = "flexpanelap4";
    private static String CHANNEL_ADVERT_TAB = "channeladverttab";
    private static String POSITION_ADVERT_FLEX = "flexpanelap39";
    private static String POSITION_NO_LINK = "jobprocesspl1";
    private static String POSITION_HAVE_LINK = "jobprocesspl2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        long pkId = Long.parseLong(billShowParameter.getPkId().toString());
        DynamicObject position = PositionDataHelper.getPositionObjByPositionId((Long)pkId);
        String positionName = position.getString("name");
        String caption = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d-%s", (String)"PositionViewEdit_40", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), positionName);
        e.getFormShowParameter().setCaption(caption);
    }

    public void customEvent(CustomEventArgs event) {
        if (HRStringUtils.isNotEmpty((String)event.getEventArgs()) && HRStringUtils.equals((String)event.getKey(), (String)"customcontrolap") && "processId".equals(event.getEventName())) {
            String id = event.getEventArgs();
            Long positionId = this.getView().getModel().getDataEntity().getLong("id");
            long useOrgId = PositionDataHelper.getPositionUseOrgIdByPositionId((Long)positionId);
            this.openAppFileList(positionId.toString(), useOrgId, id, null);
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addItemClickListeners(new String[]{KEY_BARCOPY});
        this.addClickListeners(new String[]{KEY_LABEL_CANDIDATE, "labelispubadv", KEY_POSITION_DETAIL_OPEN, KEY_POSITION_DETAIL_CLOSE, "labelchanged"});
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        this.initPanel();
    }

    public void afterBindData(EventObject event) {
        String billFormId;
        super.afterBindData(event);
        this.positionTopInfoInit();
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tabpageap");
        if (PositionHelper.isPositionSimpleView((IFormView)this.getView())) {
            // empty if block
        }
        if ("tsirm_position_delivery".equals(billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BARCOPYEDIT});
        }
        this.getView().setVisible(Boolean.valueOf(!this.isDeaftAndBillwait()), new String[]{POSITION_DETAIL_FLEX, CHANNEL_ADVERT_TAB});
        if (!AdvertPermHelper.getInstance().verifyHasAdvViewPerm()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{POSITION_ADVERT_FLEX, CHANNEL_ADVERT_TAB});
        }
    }

    private boolean isDeaftAndBillwait() {
        String positionStatus = this.getModel().getDataEntity(true).getString("positionstatus");
        String billStatus = this.getModel().getDataEntity(true).getString("billstatus");
        return "B".equals(positionStatus) && billStatus != null && "A".equals(billStatus);
    }

    public void onGetControl(OnGetControlArgs event) {
        super.onGetControl(event);
        if (event.getKey() != null && event.getKey().startsWith("lblnnc")) {
            Label label = new Label();
            label.setKey(event.getKey());
            label.setView(this.getView());
            label.addClickListener((ClickListener)this);
            event.setControl((Control)label);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        Long positionId = this.getView().getModel().getDataEntity().getLong("id");
        long useOrgId = PositionDataHelper.getPositionUseOrgIdByPositionId((Long)positionId);
        if (control.getKey().startsWith("lblnnc")) {
            String recruitStageId = control.getKey().substring(6);
            this.openAppFileList(positionId.toString(), useOrgId, recruitStageId, null);
        } else if (KEY_LABEL_CANDIDATE.equals(control.getKey())) {
            Long candidateNum = PositionModelAdapter.getCountBySinglePositionId((Long)positionId);
            if (candidateNum > 0L) {
                this.openAppFileList(positionId.toString(), useOrgId, null, null);
            }
        } else if ("labelchanged".equals(control.getKey())) {
            Long candidateChangedNum = PositionModelAdapter.getChangedCountBySinglePositionId((Long)positionId);
            if (candidateChangedNum > 0L) {
                this.openAppFileList(positionId.toString(), useOrgId, null, "1");
            }
        } else if ("labelispubadv".equals(control.getKey())) {
            long pubAdvNum = Long.parseLong(String.valueOf(this.getModel().getValue("succadvcount")));
            if (pubAdvNum > 0L) {
                Tab tab = (Tab)this.getControl("tabap");
                tab.activeTab("channeladverttab");
            }
        } else if (KEY_POSITION_DETAIL_CLOSE.equals(control.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{POSITION_DETAIL_FLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_POSITION_DETAIL_OPEN});
        } else if (KEY_POSITION_DETAIL_OPEN.equals(control.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITION_DETAIL_OPEN});
            this.getView().setVisible(Boolean.TRUE, new String[]{POSITION_DETAIL_FLEX});
            this.loadCustomProcess();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"posoperationconfirm_callback")) {
            String result2 = (String)closedCallBackEvent.getReturnData();
            if (HRStringUtils.equals((String)result2, (String)"yes")) {
                OperationResult operationResult = this.getView().invokeOperation("posclose_notips");
                if (operationResult.isSuccess()) {
                    String message = ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u5173\u95ed", (String)"PositionViewEdit_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(message);
                }
                this.getView().invokeOperation("refresh");
            } else if (HRStringUtils.equals((String)result2, (String)"closeadv")) {
                List<Long> positionIds = Collections.singletonList((Long)this.getModel().getValue("id"));
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("tsirm_advertstoplist");
                showParameter.setFormId("tsirm_advtreelist");
                showParameter.setCustomParam("positionstatus", (Object)"D");
                showParameter.setCustomParam("position", positionIds);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        } else if (HRStringUtils.equals((String)actionId, (String)"posstopopresult_callback") && HRStringUtils.equals((String)(result = (String)closedCallBackEvent.getReturnData()), (String)"yes")) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("tsirm_advertstoplist");
            showParameter.setFormId("tsirm_advtreelist");
            showParameter.setCustomParam("positionstatus", (Object)"C");
            showParameter.setCustomParam("position", Collections.singletonList(this.getModel().getValue("id")));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        Map verifyCert;
        String itemKey = evt.getItemKey();
        String operationKey = evt.getOperationKey();
        if (("copy".equals(operationKey) || "posstart_donothing".equals(operationKey) || "publishadvert".equals(operationKey)) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            }
        }
        if (HRStringUtils.equals((String)itemKey, (String)"barclosepos") || HRStringUtils.equals((String)itemKey, (String)"barfinishpos")) {
            List<Long> positionIds = Collections.singletonList((Long)this.getModel().getValue("id"));
            Map result = AdvertBizService.getInstance().getPubAdvertByPositionId(positionIds, null);
            if (result.size() > 0) {
                evt.setCancel(true);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tsirm_posoperationconfirm");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("positionIds", positionIds);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "posoperationconfirm_callback"));
                this.getView().showForm(showParameter);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        if (KEY_BARCOPY.equals(itemKey) || KEY_BARCOPYEDIT.equals(itemKey)) {
            DynamicObject positionDyn;
            DynamicObject createOrg;
            List orgIds = PositionHomeDataHelper.getHasPermViewOrgs((FormShowParameter)this.getView().getFormShowParameter());
            if (!orgIds.contains((createOrg = (positionDyn = this.getModel().getDataEntity(true)).getDynamicObject("createorg")).getLong("id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u62db\u8058\u804c\u4f4d\u201d\u7684\u6570\u636e\u6743\u9650", (String)"PositionViewEdit_38", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.setFormId("tsirm_position");
            Object pkId = model.getValue("id");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("copyId", (Object)pkId.toString());
            String copyParentViewId = (String)this.getView().getFormShowParameter().getCustomParam("parentViewId");
            if (StringUtils.isNotBlank((CharSequence)copyParentViewId)) {
                formShowParameter.setCustomParam("copyParentViewId", (Object)copyParentViewId);
            } else if (this.getView().getParentView() != null) {
                formShowParameter.setCustomParam("copyParentViewId", (Object)this.getView().getParentView().getPageId());
            }
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        boolean isEdit = OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
        this.getView().setEnable(Boolean.valueOf(isEdit), new String[]{KEY_ATTACHMENTPANELAP});
        this.getView().setVisible(Boolean.valueOf(isEdit), new String[]{KEY_MINIMODECK});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map verifyCert;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (("copy".equals(operateKey) || "posstart_donothing".equals(operateKey) || "publishadvert".equals(operateKey)) && !(verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm")).isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
                args.setCancel(true);
            }
        }
        this.checkModifyPositionPerm(operateKey, args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        this.getView().getFormShowParameter().getCustomParams().remove("messageFlag");
        this.getView().cacheFormShowParameter();
        switch (evt.getOperateKey()) {
            case "posclose_donothing": 
            case "finish_donothing": 
            case "posstart_donothing": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "modifyposition": {
                this.openPositionBill(evt);
                break;
            }
        }
        if (HRStringUtils.equals((String)evt.getOperateKey(), (String)"stop_donothing")) {
            OperationResult operationResult = evt.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds.size() > 0) {
                List positionIds = successPkIds.stream().map(id -> (Long)id).collect(Collectors.toList());
                Map result = AdvertBizService.getInstance().getPubAdvertByPositionId(positionIds, null);
                if (result.size() > 0) {
                    PositionOperateService.getInstance().showOperationResult(operationResult, this.getView(), (IFormPlugin)this);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void checkModifyPositionPerm(String operateKey, BeforeDoOperationEventArgs args) {
        long currUserId;
        boolean hasPerm;
        if (HRStringUtils.equals((String)operateKey, (String)"modifyposition") && !(hasPerm = PermissionServiceHelper.hasSpecificPerm((long)(currUserId = RequestContext.get().getCurrUserId()), (String)"tsirm", (String)"tsirm_position", (String)"4715a0df000000ac"))) {
            String message = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6211\u7ba1\u7406\u7684\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionViewEdit_51", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            args.setCancel(true);
        }
    }

    private void loadCustomProcess() {
        BaseShowParameter showParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        String pkIdString = String.valueOf(showParameter.getPkId());
        List data = PositionDataHelper.getRecruprocData((Long)Long.valueOf(pkIdString));
        if (data == null || data.size() == 0) {
            showParameter.setCustomParam("flexVisible", (Object)Boolean.TRUE);
            this.getView().setVisible(Boolean.TRUE, new String[]{POSITION_NO_LINK});
            this.getView().setVisible(Boolean.FALSE, new String[]{POSITION_HAVE_LINK});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{POSITION_NO_LINK});
            this.getView().setVisible(Boolean.TRUE, new String[]{POSITION_HAVE_LINK});
            CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
            HashMap<String, String> customParam = new HashMap<String, String>(3);
            Gson gson = new Gson();
            String evlJson = data == null || data.size() == 0 ? "[]" : gson.toJson((Object)data, List.class);
            customParam.put("initData", evlJson);
            customParam.put("random", new SecureRandom().nextInt() + "");
            customcontrol.setData(customParam);
            showParameter.setCustomParam("flexVisible", (Object)Boolean.FALSE);
        }
    }

    private void openAppFileList(String positionId, long useOrgId, String recruitStageId, String flag) {
        ListShowParameter showParameter = new ListShowParameter();
        IFormView parentView = this.getView().getParentView();
        String formId = "tsirm_appfile_viewm";
        if (parentView instanceof ListView) {
            String billFormId = ((ListView)parentView).getBillFormId();
            if (billFormId.equals("tsirm_appfile_otherlist")) {
                formId = ((BaseView)parentView.getParentView()).getFormId();
            } else if ("tsirm_position".equals(billFormId)) {
                formId = "tsirm_appfile_viewm";
            } else if ("tsirm_position_delivery".equals(billFormId)) {
                formId = "tsirm_appfile_viewc";
            }
        }
        showParameter.setBillFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("bos_list");
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put(AppFileListConstants.DEFAULT_FILTER_POSITION_ID, positionId);
        param.put(AppFileListConstants.DEFAULT_FILTER_ORG_ID, String.valueOf(useOrgId));
        param.put(AppFileListConstants.DEFAULT_FILTER_RECRUSTG_ID, recruitStageId);
        if (!HRStringUtils.isEmpty((String)flag)) {
            param.put("statusFilter", AppFileConstants.APP_FILE_STATUS_INVALID);
        }
        param.put("positionSkip", "1");
        showParameter.setCustomParams(param);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void barmodifyaddInit() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MODIFY_FLEX});
        Long positionId = (Long)this.getModel().getValue("id");
        String positionStatus = this.getModel().getDataEntity().getString("positionstatus");
        String billNo = (String)this.getModel().getValue("billno");
        if (billNo == null) {
            return;
        }
        DynamicObject positionBill = PositionBillDataHelper.getPositionBillByBillNo((Long)positionId, (String)billNo);
        if (positionBill == null) {
            return;
        }
        String billStatus = positionBill.getString("billstatus");
        boolean condition1 = this.statusCheck(positionStatus, billStatus, new String[]{"E"}, new String[]{"B", "D"});
        boolean condition2 = this.statusCheck(positionStatus, billStatus, new String[]{"A", "C"}, new String[]{"B", "D"});
        boolean condition3 = this.statusCheck(positionStatus, billStatus, new String[]{"D", "G"}, null);
        if (!(condition1 || condition2 || condition3)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MODIFY_FLEX});
        }
    }

    private boolean statusCheck(String positionStatus, String billStatus, String[] positionStatusList, String[] billStatusList) {
        boolean positionStatusCheck = positionStatusList == null || Arrays.asList(positionStatusList).contains(positionStatus);
        boolean billStatusCheck = billStatusList == null || Arrays.asList(billStatusList).contains(billStatus);
        return positionStatusCheck && billStatusCheck;
    }

    public void positionTopInfoInit() {
        String showMessageFlag = (String)this.getView().getFormShowParameter().getCustomParam("messageFlag");
        if ("savewithoutvail".equals(showMessageFlag)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PositionViewEdit_30", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().getCustomParams().remove("messageFlag");
            this.getView().cacheFormShowParameter();
        } else if ("submit".equals(showMessageFlag)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"PositionViewEdit_62", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().getCustomParams().remove("messageFlag");
            this.getView().cacheFormShowParameter();
        } else if ("saveandcommit".equals(showMessageFlag)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548\u6210\u529f\u3002", (String)"PositionViewEdit_61", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().getCustomParams().remove("messageFlag");
            this.getView().cacheFormShowParameter();
        }
        String positionStatus = this.getModel().getDataEntity().getString("positionstatus");
        if (HRStringUtils.equals((String)positionStatus, (String)"D") || HRStringUtils.equals((String)positionStatus, (String)"G")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFY_FLEX, "barsuspendpos", "barenablepos", "barfinishpos", "barclosepos", "barpublishadvert"});
        } else if (HRStringUtils.equals((String)positionStatus, (String)"E") || HRStringUtils.equals((String)positionStatus, (String)"B")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"barsuspendpos", "barenablepos", "barfinishpos", "barclosepos", "barpublishadvert"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"barsuspendpos", "barenablepos", "barfinishpos", "barclosepos", "barpublishadvert"});
        }
        this.isShowControl(Boolean.TRUE);
        this.loadCustomProcess();
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITION_DETAIL_OPEN});
        this.getView().setVisible(Boolean.TRUE, new String[]{POSITION_DETAIL_FLEX});
        this.barmodifyaddInit();
        Boolean positionInterviewFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("posInterviewerForm");
        if (Boolean.TRUE.equals(positionInterviewFlag)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap4", "imageap1", "baredit", "barsubmit", "barsuspendpos", "baraddcand", KEY_BARCOPYEDIT, "recplan", "tabpageap1", "audtirecord", "channeladverttab", "flex_state", "vectorap", "labelstatuspic", "labelstatuspic2", "portraitpanel", MODIFY_FLEX, "barpublishadvert", KEY_BARMODIFYADD});
        }
    }

    private void initPanel() {
        String number;
        this.setViewStatus(OperationStatus.VIEW);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        PositionHelper.setMulAttrToLbl((IFormView)this.getView(), (String)KEY_POSPRIN, (String)KEY_CHARGEPERLBL);
        String name = dataEntity.getString("name");
        if (!HRStringUtils.isEmpty((String)name)) {
            Label posName = (Label)this.getControl(KEY_LABELPOSNAME);
            posName.setText(name);
        }
        if (!HRStringUtils.isEmpty((String)(number = dataEntity.getString("number")))) {
            Label posNum = (Label)this.getControl(KEY_LABELPOSNUM);
            posNum.setText(number);
        }
        this.setPositionStatusLabel();
        this.setCandidateNum(dataEntity);
        this.setCandidateChangedNum(dataEntity);
        this.setPubAdvNum();
        this.setCompleteDate();
        this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ATTACHMENTPANELAP});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_MINIMODECK});
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_POSITION_DETAIL_OPEN});
        this.getView().setVisible(Boolean.TRUE, new String[]{POSITION_DETAIL_FLEX});
    }

    private void setPositionStatusLabel() {
        String positionStatus = this.getModel().getDataEntity(true).getString("positionstatus");
        if ("A".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_a"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_b", "label_status_c", "label_status_d", "label_status_e", "label_status_g"});
        } else if ("B".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_b"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_a", "label_status_c", "label_status_d", "label_status_e", "label_status_g"});
        } else if ("C".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_c"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_b", "label_status_a", "label_status_d", "label_status_e", "label_status_g"});
        } else if ("D".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_d"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_b", "label_status_c", "label_status_a", "label_status_e", "label_status_g"});
        } else if ("E".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_e"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_b", "label_status_c", "label_status_d", "label_status_a", "label_status_g"});
        } else if ("G".equals(positionStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"label_status_g"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"label_status_b", "label_status_c", "label_status_d", "label_status_e", "label_status_a"});
        }
    }

    private void setCandidateNum(DynamicObject dataEntity) {
        HashMap<String, String> labelDataMap = new HashMap<String, String>(3);
        Label labelCandidate = (Label)this.getControl(KEY_LABEL_CANDIDATE);
        Long candidateNum = PositionModelAdapter.getCountBySinglePositionId((Long)dataEntity.getLong("id"));
        labelCandidate.setText(ResManager.loadKDString((String)"{0}\u4eba", (String)"PositionViewEdit_63", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{candidateNum}));
        labelDataMap.put("fc", candidateNum > 0L ? "#5582f3" : "#999999");
        this.getView().updateControlMetadata(KEY_LABEL_CANDIDATE, labelDataMap);
    }

    private void setCandidateChangedNum(DynamicObject dataEntity) {
        HashMap<String, String> labelDataMap = new HashMap<String, String>(3);
        Label labelCandidate = (Label)this.getControl("labelchanged");
        Long CandidateChangedNum = PositionModelAdapter.getChangedCountBySinglePositionId((Long)dataEntity.getLong("id"));
        labelCandidate.setText(ResManager.loadKDString((String)"{0}\u4eba", (String)"PositionViewEdit_63", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{CandidateChangedNum}));
        labelDataMap.put("fc", CandidateChangedNum > 0L ? "#5582f3" : "#999999");
        this.getView().updateControlMetadata("labelchanged", labelDataMap);
    }

    private void setPubAdvNum() {
        if ("tsirm_positiondel_view".equals(this.getView().getEntityId())) {
            return;
        }
        PositionDataHelper.setPubAdvNum((IFormView)this.getView());
    }

    private void setCompleteDate() {
        String text;
        HashMap<String, String> labelDataMap = new HashMap<String, String>(16);
        Label completeLabel = (Label)this.getControl(KEY_LABEL_COMPLETEDATE);
        String positionStatus = String.valueOf(this.getModel().getValue("positionstatus"));
        if (this.getModel().getValue("arrivaltime") == null || "D".equals(positionStatus) || "G".equals(positionStatus)) {
            text = "-";
            labelDataMap.put("fc", "#999999");
        } else {
            Date completeDateNum = (Date)this.getModel().getValue("arrivaltime");
            LocalDate completeDate = completeDateNum.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            long dayDiffs = completeDate.toEpochDay() - LocalDate.now().toEpochDay();
            int range7 = Long.compare(dayDiffs, 7L);
            int range0 = Long.compare(dayDiffs, 0L);
            if (range0 == -1) {
                text = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u903e\u671f%s\u5929", (String)"PositionViewEdit_42", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), Math.abs(dayDiffs));
                labelDataMap.put("fc", "#FF991C");
            } else if (range7 != -1) {
                text = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5929", (String)"PositionViewEdit_43", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), Math.abs(dayDiffs));
                labelDataMap.put("fc", "#5582F3");
            } else {
                text = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5929", (String)"PositionViewEdit_43", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), Math.abs(dayDiffs));
                labelDataMap.put("fc", "#FF991C");
            }
        }
        completeLabel.setText(text);
        this.getView().updateControlMetadata(KEY_LABEL_COMPLETEDATE, labelDataMap);
    }

    private void openPositionBill(AfterDoOperationEventArgs evt) {
        OperationResult operationResult = evt.getOperationResult();
        boolean success = operationResult.isSuccess();
        if (success) {
            DynamicObject positionDyn = PositionDataHelper.getPositionObjByPositionId((Long)this.getModel().getDataEntity(true).getLong("id"));
            String positionStatus = positionDyn.getString("positionstatus");
            String billStatus = positionDyn.getString("billstatus");
            if (positionStatus.isEmpty() || billStatus.isEmpty()) {
                return;
            }
            if (!this.modifyCheck(positionStatus, billStatus)) {
                return;
            }
            boolean condition1 = this.statusCheck(positionStatus, billStatus, new String[]{"B"}, new String[]{"A"});
            boolean condition2 = this.statusCheck(positionStatus, billStatus, new String[]{"E"}, new String[]{"G"});
            boolean condition3 = this.statusCheck(positionStatus, billStatus, new String[]{"A", "C"}, new String[]{"A", "G"});
            boolean condition4 = this.statusCheck(positionStatus, billStatus, new String[]{"A", "C"}, new String[]{"C", "E", "F", "H"});
            if (condition1 || condition2 || condition3) {
                String billNo = positionDyn.getString("billno");
                DynamicObject[] positionBillDys = PositionBillDataHelper.getPositionBillByBillNo((String)"tsirm_positionbill", Collections.singletonList(billNo));
                if (positionBillDys.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u804c\u4f4d\u5ba1\u6279\u5355\u636e\u201d\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"PositionViewEdit_45", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                PositionBillService.getInstance().openPositionBillEditPage("tsirm_positionbill", positionBillDys[0], this.getView());
            } else if (condition4) {
                HashMap parms = Maps.newHashMapWithExpectedSize((int)16);
                parms.put("positionid", this.getModel().getValue("id"));
                PositionBillService.getInstance().openNewPositionBillPage("tsirm_positionbill", (Map)parms, this.getView());
            }
        }
    }

    private boolean modifyCheck(String positionStatus, String billStatus) {
        boolean condition2;
        if ("D".equals(positionStatus) || "G".equals(positionStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u72b6\u6001\u4e3a\u201c\u8349\u7a3f/\u5f85\u751f\u6548/\u62db\u8058\u4e2d/\u5df2\u6682\u505c\u201d\u7684\u62db\u8058\u804c\u4f4d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionViewEdit_41", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean condition1 = "E".equals(positionStatus) || "A".equals(positionStatus) || "C".equals(positionStatus);
        boolean bl = condition2 = "B".equals(billStatus) || "D".equals(billStatus);
        if (condition1 && condition2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u7533\u8bf7\u5355\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionViewEdit_46", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setViewStatus(OperationStatus status) {
        this.getView().setStatus(status);
        this.getPageCache().put(FormShowParameter.class.getSimpleName(), FormShowParameter.toJsonString((FormShowParameter)this.getView().getFormShowParameter()));
    }

    private void isShowControl(Object isShow) {
        this.isShowRecruitNum();
        this.isShowAge();
        this.isShowEducation();
        this.isShowWorkExp();
        this.getView().setVisible((Boolean)isShow, new String[]{"baritemap"});
    }

    private void isShowRecruitNum() {
        BigDecimal recruitnum = (BigDecimal)this.getModel().getValue("recruitnum");
        boolean isLimit = (Boolean)this.getModel().getValue("isrecnumlimit");
        this.getModel().setValue("recruitnum_text", (Object)PositionDataHelper.recruitnumTras((long)recruitnum.longValue(), (boolean)isLimit));
    }

    private void isShowAge() {
        long ageDown = this.getModel().getDataEntity().getLong("agedown");
        long ageUp = this.getModel().getDataEntity().getLong("ageUp");
        boolean isLimit = (Boolean)this.getModel().getValue("isagelimit");
        this.getModel().setValue("age_text", (Object)PositionDataHelper.ageTras((long)ageDown, (long)ageUp, (boolean)isLimit));
    }

    private void isShowEducation() {
        DynamicObject eduDyn = this.getModel().getDataEntity().getDynamicObject("education");
        boolean eduLimit = (Boolean)this.getModel().getValue("isedulimit");
        this.getModel().setValue("edu_text", (Object)PositionDataHelper.eduTras((DynamicObject)eduDyn, (boolean)eduLimit));
    }

    private void isShowWorkExp() {
        long workExpDown = this.getModel().getDataEntity().getLong("workexpdown");
        long workExpUp = this.getModel().getDataEntity().getLong("workexpup");
        boolean isLimit = (Boolean)this.getModel().getValue("isworkexplimit");
        this.getModel().setValue("workexp_text", (Object)PositionDataHelper.workexpTras((long)workExpDown, (long)workExpUp, (boolean)isLimit));
    }
}

