/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position.bill;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillService;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionJobHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionManageServiceHelper;

public class PositionBillEdit
extends HRCoreBaseBillEdit {
    public void afterLoadData(EventObject event) {
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"position", "positionsnap"});
        Object value = this.getModel().getValue("positionsnap");
        PositionBillService posBillService = PositionBillService.getInstance();
        IFormView view = this.getView();
        if (value != null && !value.equals(0L)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            this.modifyOrViewBillHandle(value, view, posBillService);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            this.newBillHandle(view, posBillService);
        }
        Long positionId = this.getPositionId();
        if (positionId == null) {
            return;
        }
        this.cachePositionStatus();
        DynamicObject manageInfo = PositionManageServiceHelper.getManageInfoByPositionBo((Long)positionId);
        if (manageInfo != null) {
            DynamicObjectCollection posprin = manageInfo.getDynamicObjectCollection("posprin");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : posprin) {
                String name = dynamicObject.getDynamicObject("fbasedataid").getString("name");
                sb.append(name).append(';');
            }
            String posprinString = sb.toString();
            this.setPosprinLbl(posprinString);
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        this.setbillStatus(billStatus);
        PositionBillService.getInstance().setBillStatusLbl(this.getView(), billStatus);
        PositionBillService.getInstance().setButtonVisableNew(this.getView(), billStatus, positionId);
        if (Boolean.parseBoolean((String)view.getFormShowParameter().getCustomParam("hideApprovalRecord")) || this.getView().getParentView() != null && this.getView().getParentView().getEntityId().startsWith("wf_")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap6"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap6"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String pageIdCache;
        IFormView view;
        IFormView childView;
        IDataModel childModel;
        String validateStr;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (!(HRStringUtils.equals((String)operateKey, (String)"refresh") || HRStringUtils.equals((String)operateKey, (String)"close") || HRStringUtils.equals((String)operateKey, (String)"viewflowchart"))) {
            DynamicObject positionNewDyn = PositionDataHelper.getPositionObjByPositionId((Long)this.getPositionId());
            if (!this.beforeSaveBillCheck(this.getView(), positionNewDyn)) {
                args.setCancel(true);
            }
        }
        if ((HRStringUtils.equals((String)operateKey, (String)"submit") || HRStringUtils.equals((String)operateKey, (String)"submiteffect")) && HRStringUtils.isNotEmpty((String)(validateStr = this.validatorData(childModel = (childView = (view = this.getView()).getView(pageIdCache = view.getPageCache().get("tsirm_position_billview"))).getModel())))) {
            this.getView().showTipNotification(validateStr);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        String pageId = view.getPageCache().get("tsirm_position_billview");
        IFormView childView = view.getView(pageId);
        OperationResult operationResult = args.getOperationResult();
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            DynamicObject dynamicObject = childView.getModel().getDataEntity(true);
            DynamicObject billDyn = this.getModel().getDataEntity();
            PositionJobHelper.jobSetGradeLevelHandle((DynamicObject)dynamicObject);
            PositionBillService.getInstance().savePositionBill(view, billDyn, dynamicObject);
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)"submit", (String)operateKey)) {
            DynamicObject billDyn = this.getModel().getDataEntity();
            DynamicObject dynamicObject = childView.getModel().getDataEntity(true);
            PositionJobHelper.jobSetGradeLevelHandle((DynamicObject)dynamicObject);
            PositionBillService.getInstance().submitPositionBill(view, billDyn, dynamicObject);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.SUBMIT);
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.setEnable(operationResult);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)"unsubmit", (String)operateKey)) {
            DynamicObject dynamicObject = childView.getModel().getDataEntity();
            String positionStatus = dynamicObject.getString("positionstatus");
            this.afterUnsubmit(positionStatus);
        } else if (HRStringUtils.equals((String)"discard", (String)operateKey)) {
            DynamicObject dynamicObject = childView.getModel().getDataEntity();
            DynamicObject billDyn = this.getModel().getDataEntity();
            PositionBillService.getInstance().updatePositionStatus(billDyn, dynamicObject);
            this.setDiscardEnable(operationResult);
        } else if (HRStringUtils.equals((String)"modify", (String)operateKey)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)"submiteffect", (String)operateKey)) {
            DynamicObject billDyn = this.getModel().getDataEntity();
            DynamicObject dynamicObject = childView.getModel().getDataEntity(true);
            PositionJobHelper.jobSetGradeLevelHandle((DynamicObject)dynamicObject);
            PositionBillService.getInstance().submitEffectPositionBill(view, billDyn, dynamicObject);
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.setEnable(operationResult);
            this.getView().invokeOperation("refresh");
        } else if (HRStringUtils.equals((String)"delete", (String)operateKey)) {
            ListShowParameter positionShowParameter = new ListShowParameter();
            positionShowParameter.setFormId("bos_list");
            positionShowParameter.setBillFormId("tsirm_position");
            String positionListId = this.getView().getView(this.getView().getFormShowParameter().getRootPageId()).getPageCache().get("positionListPageId");
            if (Objects.nonNull(positionListId)) {
                positionShowParameter.setPageId(positionListId);
                IFormView listView = this.getView().getView(positionListId);
                listView.updateView();
                String message = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"PositionList_21", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                listView.showSuccessNotification(message);
                this.getView().sendFormAction(listView);
            }
            positionShowParameter.setCustomParam("deletePosition", (Object)true);
            positionShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)positionShowParameter);
            this.getView().close();
            return;
        }
        this.cachePositionStatus();
    }

    private String validatorData(IDataModel childModel) {
        Object anoposrequirement;
        Object posrespon;
        BigDecimal recruitNumBig;
        StringBuilder validateSb = new StringBuilder();
        boolean validateFlag = false;
        validateSb.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"PositionBillEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        Object name = childModel.getValue("name");
        if (HRStringUtils.isEmpty((String)name.toString())) {
            validateSb.append(ResManager.loadKDString((String)"\u201c\u62db\u8058\u804c\u4f4d\u540d\u79f0\u201d", (String)"PositionBillEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            validateFlag = true;
        }
        long recruitNum = (recruitNumBig = (BigDecimal)childModel.getValue("recruitnum")) == null ? 0L : recruitNumBig.longValue();
        Boolean isRecruitNumLimit = (Boolean)childModel.getValue("isrecnumlimit");
        if (!(isRecruitNumLimit.booleanValue() || recruitNum > 0L && recruitNum <= 10000L)) {
            validateSb.append(ResManager.loadKDString((String)"\u201c\u62db\u8058\u4eba\u6570\u201d", (String)"PositionBillEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            validateFlag = true;
        }
        if (HRStringUtils.isEmpty((String)(posrespon = childModel.getValue("posrespon")).toString())) {
            validateSb.append(ResManager.loadKDString((String)"\u201c\u5de5\u4f5c\u804c\u8d23\u201d", (String)"PositionBillEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            validateFlag = true;
        }
        if (HRStringUtils.isEmpty((String)(anoposrequirement = childModel.getValue("anoposrequirement")).toString())) {
            validateSb.append(ResManager.loadKDString((String)"\u201c\u4efb\u804c\u8981\u6c42\u201d", (String)"PositionBillEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            validateFlag = true;
        }
        if (validateFlag) {
            return validateSb.toString();
        }
        return null;
    }

    private void cachePositionStatus() {
        Long positionId = this.getPositionId();
        if (positionId == null) {
            return;
        }
        DynamicObject positionDyn = PositionDataHelper.getPositionObjByPositionId((Long)positionId);
        this.getView().getPageCache().put("cache_recently_billno", positionDyn.getString("billno"));
        this.getView().getPageCache().put("cache_recently_billstatus", positionDyn.getString("billstatus"));
    }

    private boolean beforeSaveBillCheck(IFormView view, DynamicObject positionDyn) {
        String newBillNo = positionDyn.getString("billno");
        String newBillStatus = positionDyn.getString("billstatus");
        String oldBillNo = view.getPageCache().get("cache_recently_billno");
        String oldBillStatus = view.getPageCache().get("cache_recently_billstatus");
        String positionStatus = positionDyn.getString("positionstatus");
        if (!HRStringUtils.equals((String)newBillStatus, (String)oldBillStatus) || !HRStringUtils.equals((String)newBillNo, (String)oldBillNo)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u9000\u51fa\u5237\u65b0\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionBillEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("D".equals(positionStatus) || "G".equals(positionStatus)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8349\u7a3f\u201d\u3001\u201c\u5f85\u751f\u6548\u201d\u3001\u201c\u62db\u8058\u4e2d\u201d\u3001\u201c\u5df2\u6682\u505c\u201d\u72b6\u6001\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PositionBillEdit_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setDiscardEnable(OperationResult operationResult) {
        if (operationResult != null && operationResult.isSuccess()) {
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.AUDIT);
            this.getView().setEnable(Boolean.FALSE, new String[]{"positionpanel"});
            this.getView().invokeOperation("refresh");
        }
    }

    public void setEnable(OperationResult operationResult) {
        if (operationResult != null && operationResult.isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"positionpanel"});
        }
    }

    public void setbillStatus(String billStatus) {
        if (!HRStringUtils.equals((String)billStatus, (String)"A") && !HRStringUtils.equals((String)billStatus, (String)"G")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"positionpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"positionpanel"});
        }
    }

    public Long getPositionId() {
        Long positionId = (Long)this.getView().getFormShowParameter().getCustomParam("positionid");
        if (positionId == null || positionId.equals(0L)) {
            DynamicObject positionDyn = (DynamicObject)this.getModel().getValue("position");
            if (positionDyn == null) {
                return null;
            }
            positionId = positionDyn.getLong("id");
        }
        return positionId;
    }

    public void setPosprinLbl(String posprinString) {
        if (HRStringUtils.isNotEmpty((String)posprinString)) {
            Label posprinlbl = (Label)this.getView().getControl("posprinlbl");
            posprinlbl.setText(HRStringUtils.substringBeforeLast((String)posprinString, (String)";"));
        }
    }

    public void afterUnsubmit(String positionStatus) {
        this.getView().setEnable(Boolean.TRUE, new String[]{"positionpanel"});
        if ("B".equals(positionStatus) || "E".equals(positionStatus)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.VIEW);
        } else {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.EDIT);
        }
        this.getView().updateView();
    }

    private void newBillHandle(IFormView view, PositionBillService positionBillService) {
        Long positionId = (Long)view.getFormShowParameter().getCustomParam("positionid");
        this.getModel().setValue("position", (Object)positionId);
        view.setVisible(Boolean.valueOf(false), new String[]{"position"});
        positionBillService.openPositionPage("tsirm_position_billview", "positionpanel", view, BillOperationStatus.ADDNEW, OperationStatus.ADDNEW, positionId);
    }

    public void modifyOrViewBillHandle(Object positionSnapObj, IFormView view, PositionBillService positionBillService) {
        Long positionSnapId = positionSnapObj instanceof DynamicObject ? Long.valueOf(((DynamicObject)positionSnapObj).getLong("id")) : (Long)positionSnapObj;
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        HashMap parms = Maps.newHashMapWithExpectedSize((int)16);
        parms.put("positionsnap", positionSnapId);
        BillOperationStatus billStatus = billShowParameter.getBillStatus();
        OperationStatus status = billShowParameter.getStatus();
        if (BillOperationStatus.VIEW.equals((Object)billStatus)) {
            positionBillService.openPositionPage("tsirm_position_billview", "positionpanel", view, billStatus, OperationStatus.VIEW, null, (Map)parms);
        } else {
            positionBillService.openPositionPage("tsirm_position_billview", "positionpanel", view, billStatus, status, null, (Map)parms);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        Long pkId = (Long)((BillShowParameter)formShowParameter).getPkId();
        DynamicObject bill = PositionBillDataHelper.getPositionBillByBillId((String)"tsirm_positionbill", (Long)pkId);
        if (Objects.isNull(bill) || Objects.isNull(bill.getDynamicObject("position"))) {
            return;
        }
        String positionName = bill.getDynamicObject("position").getString("name");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u7533\u8bf7\u5355-{0}", (String)"PositionBillEdit_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{positionName}));
    }
}

