/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tsc.tsirm.business.domain.position.service.PositionBillDataHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionBillService;
import kd.tsc.tsirm.business.domain.position.service.PositionLockService;

public class PositionBillViewList
extends HRCoreBaseBillList {
    private static final String KEY_OP_MODIFYBILL = "modify";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"delete", KEY_OP_MODIFYBILL});
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            List<String> pageIds;
            String pageIdStr = parentView.getPageCache().get("positionBillList");
            List list = pageIds = pageIdStr == null ? new ArrayList(3) : (List)JSONObject.parseObject((String)pageIdStr, List.class);
            if (!pageIds.contains(this.getView().getPageId())) {
                pageIds.add(this.getView().getPageId());
            }
            parentView.getPageCache().put("positionBillList", JSONObject.toJSONString(pageIds));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long focusRowPkId = (Long)this.getFocusRowPkId();
        args.setCancel(true);
        DynamicObject positionBill = PositionBillDataHelper.getPositionBillByBillId((String)"tsirm_positionbill", (Long)focusRowPkId);
        if (positionBill == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"PositionBillViewList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else {
            String billPage = "tsirm_position_view".equals(this.getView().getParentView().getEntityId()) ? "tsirm_positionbill" : "tsirm_positionbill_del";
            PositionBillService.getInstance().openPositionBillPage(billPage, positionBill, this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (("delete".equals(operateKey) || "unsubmit".equals(operateKey) || "discard".equals(operateKey)) && !CollectionUtils.isEmpty((Collection)(successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()))) {
            Long billId = (Long)successPkIds.get(0);
            DynamicObject bill = PositionBillDataHelper.getPositionBillByBillId((String)"tsirm_positionbill", (Long)billId);
            if (Objects.isNull(bill)) {
                this.getView().getParentView().invokeOperation("close");
            } else {
                this.getView().getParentView().invokeOperation("refresh");
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long billId;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (KEY_OP_MODIFYBILL.equals(key) && this.positionTokenIsExist(billId = (Long)args.getListSelectedData().get(0).getPrimaryKeyValue())) {
            args.setCancel(true);
        }
    }

    private boolean positionTokenIsExist(Long billId) {
        DynamicObject billDyn = PositionBillDataHelper.getPositionBillByBillId((String)"tsirm_positionbill", (Long)billId);
        Long positionId = billDyn.getDynamicObject("position").getLong("id");
        if (PositionLockService.getInstance().positionTokenIsExist(positionId)) {
            String msg = ResManager.loadKDString((String)"\u8be5\u62db\u8058\u804c\u4f4d\u5f53\u524d\u5df2\u5728\u7f16\u8f91\u4e2d", (String)"PositionBillViewList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return true;
        }
        return false;
    }
}

