/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position.bill;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.position.service.PositionLockService;
import org.apache.commons.lang3.StringUtils;

public class PositionLockBillEdit
extends HRDataBaseEdit {
    private static final Set<String> VERIFY_LOCK_CLICK = Sets.newHashSet();
    private static final String KEY_CACHE_POSITIONID = "[cachepositionid]";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (VERIFY_LOCK_CLICK.contains(key) && !this.verifyLockAuth()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u62db\u8058\u804c\u4f4d\u5f53\u524d\u5df2\u5728\u7f16\u8f91\u4e2d", (String)"PositionLockBillEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("submit".equals(key) && operationResult != null && operationResult.isSuccess()) {
            this.releasePositionLock();
        }
    }

    private boolean verifyLockAuth() {
        String positionId = this.getView().getPageCache().get(KEY_CACHE_POSITIONID);
        return !StringUtils.isBlank((CharSequence)positionId);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        DynamicObject positionDy = (DynamicObject)this.getModel().getValue("position");
        if (positionDy != null) {
            Long positionId = positionDy.getLong("id");
            this.getView().getPageCache().put(KEY_CACHE_POSITIONID, positionId + "");
        }
    }

    public void pageRelease(EventObject evt) {
        this.releasePositionLock();
    }

    private void releasePositionLock() {
        Long positionIdForRelease;
        String cachePositionId = this.getView().getPageCache().get(KEY_CACHE_POSITIONID);
        Long l = positionIdForRelease = HRStringUtils.isEmpty((String)cachePositionId) ? null : Long.valueOf(cachePositionId);
        if (positionIdForRelease != null && this.verifyLockAuth()) {
            PositionLockService.getInstance().releaseLock(positionIdForRelease);
        }
    }

    static {
        VERIFY_LOCK_CLICK.add("bar_save");
        VERIFY_LOCK_CLICK.add("bar_modify");
        VERIFY_LOCK_CLICK.add("bar_submit");
        VERIFY_LOCK_CLICK.add("discard");
    }
}

