/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.position.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiCommonService;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsrbd.business.domain.gpt.GptCustomParamService;

public class PositionJdService
extends AiCommonService {
    private static final Log LOG = LogFactory.getLog(PositionJdService.class);
    private static final PositionJdService POSITION_JD_INPUT_SERVICE = new PositionJdService();
    private static final Map<String, String> COLUMN_KEY_DESC = Maps.newHashMapWithExpectedSize((int)8);
    private static final Map<String, String> COLUMN_EXT_KEY = Maps.newHashMapWithExpectedSize((int)2);
    private static final Long POSITION_GPT_ID = 1861063171830203392L;
    private static final String WORK_YEAR = "workexpdown;workexpup";
    private static final String NUM = "recruitnum";
    private static final String REC_CATEGORY = "reccategory";
    private static final String REC_SCENE = "recruscene";
    private static final String EDUCATION = "education";
    private static final String ADMIN_ORGS_DPT = "adminorgsdpt";
    private static final String WORK_ADDRS = "workaddrs";
    private static final Long DEFAULT_GPT = 1861063171830203392L;
    public static final String GENERATE_EVENT = "generate";
    private static final String CHANGE_PAGE_STATUS = "changePageStatus";
    private static final String GPT_CONTROL_JD = "gptjd";
    private static final String FBASEDATAID = "fbasedataid";
    private static final String JOB_DUTY_KEY = "jobduty";
    private static final String JOB_REQUIRE_KEY = "jobrequire";
    private static final String GPT_RIGHT_OP = "gptright";
    private static final long GPT_TASK_ID = 1931212345359480832L;

    private void init() {
        COLUMN_KEY_DESC.put(REC_CATEGORY, ResManager.loadKDString((String)"\u62db\u8058\u7c7b\u578b\uff1a", (String)"PositionJdInputService_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(REC_SCENE, ResManager.loadKDString((String)"\u62db\u8058\u573a\u666f\uff1a", (String)"PositionJdInputService_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put("name", ResManager.loadKDString((String)"\u62db\u8058\u804c\u4f4d\u540d\u79f0\uff1a", (String)"PositionJdInputService_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(NUM, ResManager.loadKDString((String)"\u62db\u8058\u4eba\u6570\uff1a", (String)"PositionJdInputService_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(ADMIN_ORGS_DPT, ResManager.loadKDString((String)"\u7528\u4eba\u7ec4\u7ec7\uff1a", (String)"PositionJdInputService_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(WORK_ADDRS, ResManager.loadKDString((String)"\u5de5\u4f5c\u5730\uff1a", (String)"PositionJdInputService_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(EDUCATION, ResManager.loadKDString((String)"\u5b66\u5386\u8981\u6c42\uff1a", (String)"PositionJdInputService_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_KEY_DESC.put(WORK_YEAR, ResManager.loadKDString((String)"\u5de5\u4f5c\u5e74\u9650\u8981\u6c42\uff1a", (String)"PositionJdInputService_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        COLUMN_EXT_KEY.put(EDUCATION, "isedulimit");
        COLUMN_EXT_KEY.put(WORK_YEAR, "isworkexplimit");
    }

    private PositionJdService() {
    }

    public static PositionJdService getInstance() {
        return POSITION_JD_INPUT_SERVICE;
    }

    public Map<String, String> getParamDesc(DynamicObject dynamicObject) {
        this.init();
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        StringBuilder paramBuilder = new StringBuilder();
        COLUMN_KEY_DESC.forEach((key, value) -> {
            String titleValue = this.getTitleValue(dynamicObject, (String)key);
            if (HRStringUtils.isBlank((CharSequence)titleValue)) {
                return;
            }
            titleValue = titleValue.replace(";", "");
            paramBuilder.append((String)value).append(titleValue).append(";");
        });
        param.put("var001", paramBuilder.toString());
        GptCustomParamService instance = GptCustomParamService.getInstance();
        long gptId = instance.getGptId(dynamicObject);
        if (0L == gptId) {
            gptId = DEFAULT_GPT;
        }
        instance.toExtGptCustomParam(gptId, (Map)param, dynamicObject);
        return param;
    }

    private String getTitleValue(DynamicObject dynamicObject, String key) {
        boolean containKey;
        String titleValue = "";
        boolean bl = containKey = dynamicObject.containsProperty(key) || dynamicObject.containsProperty(key.split(";")[0]) || dynamicObject.containsProperty(key.split(";")[1]);
        if (!containKey) {
            return titleValue;
        }
        switch (key) {
            case "workexpdown;workexpup": {
                String[] column = key.split(";");
                long workExpDown = dynamicObject.getLong(column[0]);
                long workExpUp = dynamicObject.getLong(column[1]);
                boolean workExpLimit = dynamicObject.getBoolean(COLUMN_EXT_KEY.get(key));
                titleValue = PositionDataHelper.workexpTras((long)workExpDown, (long)workExpUp, (boolean)workExpLimit);
                break;
            }
            case "recruitnum": {
                titleValue = "0".endsWith(dynamicObject.getString(key)) ? "" : ResManager.loadKDString((String)"{0}\u4eba", (String)"PositionJdInputService_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{dynamicObject.getString(key)});
                break;
            }
            case "reccategory": 
            case "recruscene": 
            case "education": {
                DynamicObject baseDataObject = dynamicObject.getDynamicObject(key);
                if (null == baseDataObject && HRStringUtils.isNotEmpty((String)COLUMN_EXT_KEY.get(key))) {
                    String extKey = COLUMN_EXT_KEY.get(key);
                    boolean educationLimit = dynamicObject.getBoolean(extKey);
                    titleValue = PositionDataHelper.eduTras((DynamicObject)dynamicObject, (boolean)educationLimit);
                    break;
                }
                titleValue = null == baseDataObject ? "" : baseDataObject.getLocaleString("name").getLocaleValue();
                break;
            }
            case "adminorgsdpt": 
            case "workaddrs": {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(key);
                StringBuilder name = new StringBuilder();
                collection.forEach(dy -> name.append(dy.getDynamicObject(FBASEDATAID).getLocaleString("name").getLocaleValue()).append(";"));
                titleValue = name.toString();
                break;
            }
            default: {
                titleValue = dynamicObject.getString(key);
                if (!HRStringUtils.isBlank((CharSequence)titleValue) || HRStringUtils.isBlank((CharSequence)COLUMN_EXT_KEY.get(key))) break;
                titleValue = dynamicObject.getString(COLUMN_EXT_KEY.get(key));
            }
        }
        return titleValue;
    }

    public Map<String, Object> customEventParam(String eventName, String type, JSONObject resultObject, String pageStatus) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("code", 200);
        result.put("success", true);
        result.put("eventName", eventName);
        result.put("times", System.currentTimeMillis());
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        if (null != resultObject) {
            dataMap.put("result", resultObject);
        }
        dataMap.put("type", type);
        dataMap.put("pageStatus", pageStatus);
        result.put("data", dataMap);
        return result;
    }

    public void getCustomEventParamFromPage(IFormView view) {
        this.showAssistant(view);
    }

    private void showAssistant(IFormView view) {
        if (!AiConfigHelper.getInstance().getIfOpen("positionjd")) {
            LOG.error("showAssistant fail by position jd config is closed");
            return;
        }
        IFormView iFormView = view.getMainView();
        if (iFormView == null) {
            iFormView = view.getParentView();
        }
        String rootPageId = iFormView.getPageId();
        PositionJdService.openAssistant(rootPageId);
        HashMap<String, String> gaiInitConfig = new HashMap<String, String>();
        gaiInitConfig.put("pageId", view.getPageId());
        LOG.info("start startProcessInSideBar by param map = {}", (Object)SerializationUtils.toJsonString(gaiInitConfig));
        String defaultInput = ResManager.loadKDString((String)"\u751f\u6210\u62db\u8058JD\u4fe1\u606f", (String)"PositionJdService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{1931212345359480832L, rootPageId, gaiInitConfig, defaultInput});
    }

    private static void openAssistant(String rootPageId) {
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>(2);
        map.put("switchSide", Boolean.valueOf(true));
        map.put("lockSide", Boolean.valueOf(true));
        map.put("selectedProcessId", Long.valueOf(1931212345359480832L));
        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"sideBarInit", (Object[])new Object[]{rootPageId, JSON.toJSONString(map)});
    }

    public void customEvent(CustomEventArgs e, IFormView view) {
        String key = e.getKey();
        if (!GPT_CONTROL_JD.equals(key)) {
            return;
        }
        this.getCustomEventParamFromPage(view);
    }

    public void setGptEnable(IFormView view, boolean enable) {
        Map<String, Object> data = this.customEventParam(CHANGE_PAGE_STATUS, "0", null, enable ? "edit" : "view");
        CustomControl control = (CustomControl)view.getControl(GPT_CONTROL_JD);
        if (null != control) {
            control.setData(data);
        }
    }
}

