/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.hr.metadata.edit.MulPersonEdit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.SecurityUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFilePermissionHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumefilterBusinessHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FilterRecommendEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private ResumeFilterHelper resumeFilterHelper = ResumeFilterHelper.getInstance();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        MulPersonEdit userEdit = (MulPersonEdit)this.getView().getControl("filterhrperson");
        userEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        List appFileIds = ResumefilterBusinessHelper.getAppFileIds((IFormView)this.getView());
        if (appFileIds.isEmpty()) {
            return;
        }
        FormShowParameter selectedAppfileParam = ResumefilterBusinessHelper.getSelectedAppFileShowParameter((List)appFileIds);
        this.getView().getPageCache().put("tsirm_selectedappfile", selectedAppfileParam.getPageId());
        this.getView().showForm(selectedAppfileParam);
        FormShowParameter msgTplParam = ResumefilterBusinessHelper.getResumeFilterMsgTpl((List)appFileIds);
        msgTplParam.setCustomParam("businessObject", (Object)this.getModel().getDataEntity(true));
        this.getView().getPageCache().put("cache_msg_tpl_page_id", msgTplParam.getPageId());
        this.getView().showForm(msgTplParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("txtfilterremarks", (Object)" ");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter formShowPatameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("bos_usertreelistf7".equals(formShowPatameter.getFormId())) {
            formShowPatameter.setMultiSelect(true);
            formShowPatameter.setLookUp(true);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "userListCloseCallBack");
            formShowPatameter.setCloseCallBack(closeCallBack);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "userListCloseCallBack": {
                this.handlePresenteeClosedCallBackEvent(closedCallBackEvent);
                break;
            }
            case "checkemail": {
                this.handleCheckEmailClosedCallBackEvt(closedCallBackEvent);
                break;
            }
            case "repeatRecommend": {
                this.handleRepeatRecommClosedClassBackEvt(closedCallBackEvent);
                break;
            }
            case "lockAppfileTip": {
                this.handleLockAppfileClosedClassBackEvt(closedCallBackEvent);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        DynamicObjectCollection presenteeList;
        String presenteeWithoutEmail;
        super.itemClick(evt);
        if (!"btnok".equals(evt.getItemKey())) {
            return;
        }
        if (CfgMessageService.isSendChannelMsg((IFormView)this.getView(), (CfmMsgChannel)CfmMsgChannel.EMAIL) && HRStringUtils.isNotEmpty((String)(presenteeWithoutEmail = this.resumeFilterHelper.getPresenteeWithoutEmail(presenteeList = (DynamicObjectCollection)this.getModel().getValue("presentee"))))) {
            FormShowParameter checkEmailForm = this.generateCheckEmailForm(presenteeWithoutEmail);
            this.getView().showForm(checkEmailForm);
            return;
        }
        this.checkAppfileAndRepeatThenSend();
    }

    public void checkAppfileAndRepeatThenSend() {
        Pair oprParam = ResumefilterBusinessHelper.checkAppfileLocked((List)ResumefilterBusinessHelper.getAppFileIds((IFormView)this.getView()));
        Object rightParam = oprParam.getRight();
        if (null != rightParam && rightParam instanceof FormShowParameter) {
            FormShowParameter parameter = (FormShowParameter)rightParam;
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "lockAppfileTip"));
            this.getView().showForm(parameter);
        } else if (((Boolean)oprParam.getLeft()).booleanValue()) {
            List appFileIds = ResumefilterBusinessHelper.getAppFileIds((IFormView)this.getView());
            Pair<Boolean, FormShowParameter> pair = this.checkRepeatRecommend(appFileIds);
            if (((Boolean)pair.getLeft()).booleanValue()) {
                this.getView().showForm((FormShowParameter)pair.getRight());
            } else {
                ResumefilterBusinessHelper.saveModelAndClosePage(null, (IFormView)this.getView());
            }
        } else {
            this.getView().showTipNotification(String.valueOf(oprParam.getRight()));
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        evt.setCheckDataChange(false);
    }

    public void handlePresenteeClosedCallBackEvent(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            return;
        }
        if (listSelectedRows.size() > 10) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u9009\u62e910\u4e2a\u8981\u63a8\u8350\u7ed9\u7684\u4eba", (String)"FilterRecommendEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            long userFid = (Long)listSelectedRow.getPrimaryKeyValue();
            userIds.add(userFid);
        }
        DynamicObject[] dynamicObjects = this.resumeFilterHelper.queryBosUserByQFilter(userIds);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            dynamicObjectCollection.add((Object)dynamicObjects[i]);
        }
        this.getModel().setValue("presentee", (Object)dynamicObjectCollection);
    }

    public void handleRepeatRecommClosedClassBackEvt(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        String successPkIdStr = (String)returnData.get("successPkIds");
        List notRepeatRecommendList = (List)returnData.get("repeatRecommendList");
        if (HRStringUtils.isNotEmpty((String)successPkIdStr)) {
            ResumefilterBusinessHelper.saveModelAndClosePage((List)notRepeatRecommendList, (IFormView)this.getView(), (List)SerializationUtils.fromJsonStringToList((String)successPkIdStr, Long.class));
        } else {
            ResumefilterBusinessHelper.saveModelAndClosePage((List)notRepeatRecommendList, (IFormView)this.getView());
        }
    }

    public void handleCheckEmailClosedCallBackEvt(ClosedCallBackEvent closedCallBackEvent) {
        if (!"btnok".equals(closedCallBackEvent.getReturnData())) {
            return;
        }
        this.checkAppfileAndRepeatThenSend();
    }

    public void handleLockAppfileClosedClassBackEvt(ClosedCallBackEvent closedCallBackEvent) {
        List appfileList = (List)closedCallBackEvent.getReturnData();
        if (null == appfileList) {
            return;
        }
        Pair<Boolean, FormShowParameter> pair = this.checkRepeatRecommend(appfileList);
        if (((Boolean)pair.getLeft()).booleanValue()) {
            FormShowParameter parameter = (FormShowParameter)pair.getRight();
            parameter.setCustomParam("successPkIds", (Object)SerializationUtils.toJsonString((Object)appfileList));
            this.getView().showForm(parameter);
        } else {
            ResumefilterBusinessHelper.saveModelAndClosePage(null, (IFormView)this.getView(), (List)appfileList);
        }
    }

    public FormShowParameter generateCheckEmailForm(String presenteeWithoutEmail) {
        List presenteeIdList = ResumefilterBusinessHelper.getPresenteeIds((IFormView)this.getView());
        List appFileIds = ResumefilterBusinessHelper.getAppFileIds((IFormView)this.getView());
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(16);
        customParamMap.put("presenteeWithoutEmailList", presenteeWithoutEmail);
        customParamMap.put("presenteeIdList", presenteeIdList);
        customParamMap.put("appfileids", appFileIds);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "checkemail");
        FormShowParameter checkEmailForm = GenerateFormShowParamUtils.generateFormShowParameter((String)"tsirm_notifynoemail", (boolean)true, customParamMap, (ShowType)ShowType.Modal, (CloseCallBack)closeCallBack);
        return checkEmailForm;
    }

    public Pair<Boolean, FormShowParameter> checkRepeatRecommend(List<Long> appFileIds) {
        List presenteeIdList = ResumefilterBusinessHelper.getPresenteeIds((IFormView)this.getView());
        if (null == presenteeIdList) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        List repeatRecommendList = this.resumeFilterHelper.generateRepeatRecommendList(presenteeIdList, appFileIds);
        if (!repeatRecommendList.isEmpty()) {
            HashMap<String, String> customParam = new HashMap<String, String>(16);
            customParam.put("repeatRecommendList", SerializationUtils.toJsonString((Object)repeatRecommendList));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "repeatRecommend");
            FormShowParameter checkRepeatRecomForm = GenerateFormShowParamUtils.generateFormShowParameter((String)"tsirm_notifyrepeatrecom", (boolean)true, customParam, (ShowType)ShowType.Modal, (CloseCallBack)closeCallBack);
            return Pair.of((Object)Boolean.TRUE, (Object)checkRepeatRecomForm);
        }
        return Pair.of((Object)Boolean.FALSE, null);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String name = evt.getProperty().getName();
        ChangeData changeData = evt.getChangeSet()[0];
        if (HRStringUtils.equals((String)name, (String)"txtfilterremarks")) {
            if (changeData.getNewValue() == null || HRStringUtils.isBlank((CharSequence)changeData.getNewValue().toString())) {
                this.getModel().setValue("txtfilterremarks", (Object)" ");
            }
            FormShowParameter msgTplParameter = CfgMessageService.getMsgTplParameter((IFormView)this.getView());
            msgTplParameter.setCustomParam("filtermark", (Object)(HRStringUtils.isBlank((CharSequence)SecurityUtils.htmlEncode((String)changeData.getNewValue().toString())) ? " " : SecurityUtils.htmlEncode((String)changeData.getNewValue().toString())));
            msgTplParameter.setCustomParam("businessObject", (Object)this.getModel().getDataEntity(true));
            IFormView msgTplView = this.getView().getView(msgTplParameter.getPageId());
            msgTplView.cacheFormShowParameter();
        } else if (HRStringUtils.equals((String)name, (String)"presentee")) {
            DynamicObjectCollection newValue = (DynamicObjectCollection)this.getModel().getValue("presentee");
            String processorName = ResManager.loadKDString((String)"{\u7b5b\u9009\u5904\u7406\u4eba\u59d3\u540d}", (String)"FilterRecommendEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            if (CollectionUtils.isNotEmpty((Collection)newValue)) {
                DynamicObject user = (DynamicObject)((DynamicObject)newValue.get(0)).get("fbasedataid");
                processorName = user.getString("name");
            }
            FormShowParameter msgTplParameter = CfgMessageService.getMsgTplParameter((IFormView)this.getView());
            msgTplParameter.setCustomParam("filterprocessor", (Object)processorName);
            msgTplParameter.setCustomParam("businessObject", (Object)this.getModel().getDataEntity(true));
            IFormView msgTplView = this.getView().getView(msgTplParameter.getPageId());
            msgTplView.cacheFormShowParameter();
            if (this.getModel().getValue("txtfilterremarks") == null || HRStringUtils.isBlank((CharSequence)this.getModel().getValue("txtfilterremarks").toString())) {
                this.getModel().setValue("txtfilterremarks", (Object)" ");
            }
            this.getView().sendFormAction(msgTplView);
        } else if (HRStringUtils.equals((String)name, (String)"filterhrperson")) {
            DynamicObjectCollection presenteeList = (DynamicObjectCollection)this.getModel().getValue("filterhrperson");
            List ids = presenteeList.stream().map(presentHr -> presentHr.getLong("fbasedataid_id")).collect(Collectors.toList());
            HashMap idMaps = Maps.newHashMapWithExpectedSize((int)16);
            idMaps.put("employee", ids);
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
            if (((Boolean)result.get("success")).booleanValue()) {
                Map data = (Map)result.get("data");
                List intverIds = data.values().stream().map(stringLongMap -> (Long)stringLongMap.get("user")).collect(Collectors.toCollection(() -> Lists.newArrayListWithCapacity((int)10)));
                this.getModel().setValue("presentee", (Object)intverIds.toArray());
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btnok".equals(itemKey)) {
            evt.setCancel(!AppFileHelper.hasPerm((AppFileOperateEnum)AppFileOperateEnum.FILTER, (IFormView)this.getView()));
            List appFileIds = ResumefilterBusinessHelper.getAppFileIds((IFormView)this.getView());
            List msgList = AppFileFlowLockHelper.checkAppFileIsGrayLock((List)appFileIds, (String)AppFileOperateEnum.FILTER.getOpName().loadKDString());
            if (ObjectUtils.isNotEmpty((Object)msgList)) {
                evt.setCancel(true);
                if (msgList.size() > 1) {
                    this.getView().showConfirm((String)msgList.get(0), (String)msgList.get(1), MessageBoxOptions.Toast, ConfirmTypes.Default, null);
                } else {
                    this.getView().showErrorNotification((String)msgList.get(0));
                }
            } else {
                String myHandle = (String)this.getView().getFormShowParameter().getCustomParam("chanrgrange");
                if (HRStringUtils.isNotEmpty((String)myHandle) && HRStringUtils.equals((String)"1", (String)myHandle) && !AppFilePermissionHelper.inMyHandPermission((List)appFileIds)) {
                    evt.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ea4\u4ed8\u4eba\u6743\u9650\u53d1\u751f\u53d8\u5316\uff0c\u65e0\u6cd5\u6267\u884c\u63a8\u8350\u7b5b\u9009\u3002", (String)"FilterRecommendEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                }
            }
            String childViewPageId = this.getView().getPageCache().get("cache_msg_tpl_page_id");
            if (HRStringUtils.isBlank((CharSequence)childViewPageId)) {
                return;
            }
            IFormView childView = this.getView().getView(childViewPageId);
            if (null == childView) {
                return;
            }
            Object msgTemplate = childView.getModel().getValue("msgtemplate");
            if (null == msgTemplate) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u901a\u77e5\u6a21\u677f\u201d\u3002", (String)"FilterRecommendEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object msgChannelList = childView.getModel().getValue("msgchannellist");
            if (null == msgChannelList) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u901a\u77e5\u65b9\u5f0f\u201d\u3002", (String)"FilterRecommendEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Object emailTheme = childView.getModel().getValue("emailtheme");
            if (null == emailTheme || HRStringUtils.isBlank((CharSequence)emailTheme.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u90ae\u4ef6\u4e3b\u9898\u201d\u3002", (String)"FilterRecommendEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

