/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicListBasePlugin;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.common.constants.resumefilter.ResumeFilterConstants;

public class RepeatFilterRecommendPlugin
extends HRDynamicListBasePlugin {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Button button = (Button)this.getControl("btnok");
        button.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter repeatFilterForm = this.getView().getFormShowParameter();
        String repeatRecommendListStr = (String)repeatFilterForm.getCustomParam("repeatRecommendList");
        if (HRStringUtils.isEmpty((String)repeatRecommendListStr)) {
            return;
        }
        List repeatRecommendList = SerializationUtils.fromJsonStringToList((String)repeatRecommendListStr, Long.class);
        this.initEntryEntity(repeatRecommendList);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        int[] indexs = new int[entrys.size()];
        for (int i = 0; i < entrys.size(); ++i) {
            indexs[i] = i;
        }
        entryGrid.selectRows(indexs, 1);
    }

    private void initEntryEntity(List<Long> repeatRecommendList) {
        DynamicObject[] resumeFilterTasks = ResumeFilterHelper.queryResumeFilterTasks(repeatRecommendList, (String[])new String[]{"appfile", "recruitmentposition", "filterhandlepeople", "filterfeedbackconclusion", "resscr.dtfilterrecommendtime"});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("txtcandidate", new Object[0]);
        setter.addField("txt_positionname", new Object[0]);
        setter.addField("txt_presenteename", new Object[0]);
        setter.addField("dtfilterrecommendtime", new Object[0]);
        setter.addField("filterfeedbackconclusion", new Object[0]);
        setter.addField("resscrtaskid", new Object[0]);
        for (DynamicObject resumeFilterTask : resumeFilterTasks) {
            String conclusion = resumeFilterTask.getString("filterfeedbackconclusion");
            setter.addRow(new Object[]{resumeFilterTask.getDynamicObject("appfile").getString("name"), resumeFilterTask.getDynamicObject("recruitmentposition").getString("name"), resumeFilterTask.getDynamicObject("filterhandlepeople").getString("name"), HRInteDateTimeUtil.formatDate((String)"tsirm_filterrecommendtpl", (String)"dtfilterrecommendtime", (Date)resumeFilterTask.getDate("resscr.dtfilterrecommendtime")), ResumeFilterConstants.ConclusionStatus.getEnum((String)conclusion).getStatusName().loadKDString(), resumeFilterTask.getLong("id")});
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void afterCreateNewData(EventObject evt) {
        Label label = (Label)this.getControl("lbl_repeatrecomnum");
        label.setText(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5019\u9009\u4eba\u5df2\u7ecf\u63a8\u8350\u8fc7\u76f8\u540c\u7684\u9762\u8bd5\u5b98\uff0c\u662f\u5426\u91cd\u590d\u63a8\u8350\uff1f", (String)"RepeatFilterRecommendPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        if ("btnok".equals(button.getKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Long> stillRecommendIdList = new ArrayList<Long>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[i]);
                stillRecommendIdList.add(entryRowEntity.getLong("resscrtaskid"));
            }
            String repeatRecommendListStr = (String)this.getView().getFormShowParameter().getCustomParam("repeatRecommendList");
            String notLockDataStr = (String)this.getView().getFormShowParameter().getCustomParam("successPkIds");
            List repeatRecommendList = SerializationUtils.fromJsonStringToList((String)repeatRecommendListStr, Long.class);
            int notRepeatRecommendListSize = repeatRecommendList.size() - stillRecommendIdList.size();
            ArrayList<Long> notRepeatRecommendList = new ArrayList<Long>(notRepeatRecommendListSize);
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            for (Long id : repeatRecommendList) {
                if (stillRecommendIdList.contains(id)) continue;
                notRepeatRecommendList.add(id);
            }
            returnData.put("repeatRecommendList", notRepeatRecommendList);
            returnData.put("successPkIds", notLockDataStr);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

