/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.operate.service.AppfileOpRecordService;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.common.enums.resumefilter.ResumeFilterConclusionEnum;
import kd.tsc.tsrbs.common.utils.PageUtils;
import org.apache.commons.lang3.StringUtils;

public class ResumeFilterFeedbackIREdit
extends AbstractFormPlugin {
    private static final String RES_TASK_ID = "resTaskId";
    private static final String SUBMIT = "submit";
    private static final String FILTERREMARKTITLE = "filterremarktitle";
    private static final String FILTERREMARK = "filterremark";
    private static final String REMARKCONCLUSION = "remarkconclusionradio";
    private static final String FILTEROPINION = "filteropinion";
    private static final String RESTASKID = "restaskid";
    private static Map<String, Consumer> clickEventMap = new HashMap<String, Consumer>(16);

    public ResumeFilterFeedbackIREdit() {
        clickEventMap.put(SUBMIT, evt -> this.submitData());
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        Object resTaskId = evt.getFormShowParameter().getCustomParam(RES_TASK_ID);
        if (resTaskId == null || !ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.isExists(resTaskId)) {
            evt.setCancel(true);
            evt.setCancelMessage(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b5b\u9009\u4efb\u52a1", (String)"ResumeFilterBillEdit_13", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{SUBMIT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Button)evt.getSource()).getKey();
        Consumer consumer = clickEventMap.get(key);
        consumer.accept(evt);
    }

    private void submitData() {
        String remarkConclusion = (String)this.getModel().getValue(REMARKCONCLUSION);
        boolean hasType = ResumeFilterConclusionEnum.checkType((String)remarkConclusion);
        if (remarkConclusion == null || !hasType) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u53cd\u9988\u201c\u7b5b\u9009\u7ed3\u8bba\u201d\u3002", (String)"ResumeFilterBillEdit_12", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        DynamicObject resFiTaskObject = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.queryOne(this.getModel().getValue(RES_TASK_ID));
        if ("3".equals(resFiTaskObject.getString("filterfeedbackstatus"))) {
            this.showTips("tsirm_rsmflconfirmpopir");
            return;
        }
        resFiTaskObject.set("filterfeedbackstatus", (Object)"3");
        resFiTaskObject.set("filterfeedbackconclusion", (Object)remarkConclusion);
        resFiTaskObject.set(FILTEROPINION, this.getModel().getValue(FILTEROPINION));
        resFiTaskObject.set("filterfeedbackcontime", (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        ResumerFilterBiz.init().completeTask(resFiTaskObject);
        Long appFileId = resFiTaskObject.getDynamicObject("appfile").getLong("id");
        AppFileDataHelper.updateAppFileFilterFeedBackData(Collections.singletonList(appFileId));
        AppfileOpRecordService.getInstance().addResumeFilterFeedback(Collections.singletonList(resFiTaskObject));
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"FilterFeedbackEdit_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        ResumeFilterHelper.getInstance().lockRightResume(remarkConclusion, Collections.singletonList(resFiTaskObject));
        if (HRStringUtils.equals((String)"1", (String)remarkConclusion)) {
            ResumeFilterHelper resumeFilterHelper = ResumeFilterHelper.getInstance();
            resumeFilterHelper.showInterviewTimeForm(this.getView(), "tsirm_intvcalendarir", "tsirm_filtersuccpopir", new CloseCallBack((IFormPlugin)this, "close_intvcalendar_or_filtersuccpop"));
        } else {
            this.refreshParentPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("close_intvcalendar_or_filtersuccpop".equals(closedCallBackEvent.getActionId())) {
            IFormView parentView;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null && HRStringUtils.equals((String)returnData.toString(), (String)"success") && (parentView = PageUtils.getParentView((IFormView)this.getView())) != null) {
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9762\u8bd5\u65f6\u95f4\u6210\u529f\u3002", (String)"ResumeFilterFeedbackIREdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(parentView);
            }
            if (returnData != null && HRStringUtils.equals((String)returnData.toString(), (String)"wait_tsirm_intvcalendarir")) {
                return;
            }
            this.refreshParentPage();
        }
    }

    private void showTips(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("message", (Object)ResManager.loadKDString((String)"\u4f60\u5df2\u7ecf\u64cd\u4f5c\u8fc7\u8fd9\u4efd\u7b80\u5386\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"FilterFeedbackEdit_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Object resTaskId = this.getView().getFormShowParameter().getCustomParam(RES_TASK_ID);
        DynamicObject resFiTaskObject = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.queryOne(resTaskId);
        if (resFiTaskObject.getInt("filterfeedbackstatus") == Integer.parseInt("3")) {
            return;
        }
        DynamicObject filterRecommendObject = resFiTaskObject.getDynamicObject("resscr");
        if (filterRecommendObject == null || StringUtils.isEmpty((CharSequence)filterRecommendObject.getString("txtfilterremarks"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTERREMARKTITLE});
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTERREMARK});
        } else {
            ((Label)this.getControl(FILTERREMARK)).setText(filterRecommendObject.getString("txtfilterremarks"));
        }
        this.getModel().setValue(RESTASKID, resTaskId);
    }

    private void refreshParentPage() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }
}

