/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileService;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeFormHelper;
import kd.tsc.tsirm.common.constants.resumefilter.ResumeFilterConstants;
import kd.tsc.tsirm.common.util.IntvMailUtils;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class ResumeFilterFeedbackListIRPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(ResumeFilterFeedbackListIRPlugin.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static String RESUME_TASK_SELECT_FIELD;
    private static final String SORT_ORDER = " desc";
    private static final String FL_FEEBACK_STATUS = "flfeebackstatus";
    private static final String DTEXT = "d";
    private static final String HTEXT = "h";
    private static final String MINTEXT = "min";
    private static final String KEY_FILETIME = "filetime";
    private static final String KEY_INTERVIEW = "interview";
    private static final String KEY_PRESSFILETER = "pressfilter";
    private static final String OP_FLEX = "cardentryflexpanelap1";
    private static final String KEY_PRESSFILETERED = "pressfiltered";
    private static final String TXT_FILTERREMARKS = "txtfilterremarks";
    private static final int LIMIT_SIZE = 50;
    private static final String APP_FILE_ID = "appFileId";
    private static final String TIMESTRS = "12.5h";
    private static final String PAGE_TIPSTAG_PROPERTIES = "tipstag";
    private static final String SELECTQFilter = "id,name,email,phone";
    private static final String MESSURL = "/?formId=tsirm_resumefilterir&type=list&list_formId=bos_list";
    private static final String BR = "<br>";
    private static final String TIMESTR = " 23:59:59";
    private static final String CUSTOMREGION = "customRegion";
    private static final String FILENAME = "${fileName}";
    private static final String RECOMMENDMSG = "${recommendMsg}";
    private static final String NAMEMSG = "${name}";
    private static final String POSITION = "${position}";
    private static final String GROUPNAME = "${groupName}";
    private static final String SEX = "${sex}";
    private static final String YEARS = "${years}";
    private static final String EDUCATION = "${education}";
    private static final String UNIVERSITY = "${university}";
    private static final String MAJOR = "${major}";
    private static final String CURTIME = "${curTime}";
    private static final String URL = "${url}";
    private static final String URLIVP = "${urlivp}";
    public static final HRBaseServiceHelper userHelper;
    private static final String[] LEFT_FIELD;
    private static final String[] RIGHT_FIELD;

    public String getTodayReply() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u5df2\u53cd\u9988", (String)"ResumeFilterFeedbackListIRPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public String getNotReply() {
        return ResManager.loadKDString((String)"\u672a\u53cd\u9988", (String)"ResumeFilterFeedbackListIRPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public String getSuit() {
        return ResManager.loadKDString((String)"\u5408\u9002", (String)"ResumeFilterFeedbackListIRPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public String getOutReply() {
        return ResManager.loadKDString((String)"\u8d85\u671f\u672a\u53cd\u9988", (String)"ResumeFilterFeedbackListIRPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public String getNotKnow() {
        return ResManager.loadKDString((String)"\u672a\u77e5", (String)"ResumeFilterFeedbackListIRPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public String getHtmlContent() {
        return "<!doctype html><html>  <head>   <title></title>   <style>a:link,a:visited{text-decoration:none;color:#5582F3}body{margin:2px 0px;line-height:140%;overflow-wrap:break-word}.emphasis_black{color:#000;font-weight:bold}.emphasis_blue{color:#5582F3;font-weight:bold}.emphasis_red{color:red;font-weight:bold}a.replay_a{float:right;height:32px;line-height:32px;background:#5582F3;border-radius:2px;display:block;text-decoration:none;font-size:14px;outline:none;color:white;width:88px;text-align:center}.float_right{float:right}.tbl_candidate{text-align:left;border:1px solid#CCCCCC;font-size:12px;margin:18px auto;width:100%}.interview_table{margin-top:12px}.tbl_candidate tr td{width:12.5%;border-right:1px solid#CCCCCC}</style>  </head>  <body>   <div style=\"font-size: 14px;width: 90%;color:#333333;border-radius: 8px;overflow: hidden;box-shadow: 2px 5px 14px 5px rgba(0, 0, 0, 0.1);margin: auto;\">    <div id=\"business_type\" style=\"height:54px;background: linear-gradient(225deg, #55E2EE 0%, #437FEC 100%);line-height: 54px;padding-left:30px;font-size: 18px;color: #fff;font-weight: bold;\">     \u7b5b\u9009\u50ac\u4fc3\u901a\u77e5    </div>    <div style=\"padding: 20px 30px;background: #fff\">     <div id=\"header\"> <span id=\"intv_name_sender\">${fileName}\uff0c\u60a8\u597d</span>    </div>     <div id=\"main_content\">      <p></p>      <p>\u8bf7\u60a8\u5c3d\u5feb\u53cd\u9988\u5982\u4e0b\u7b80\u5386\uff0c\u82e5\u89c9\u5f97\u5408\u9002\uff0c\u6211\u4eec\u5c06\u5b89\u6392\u9762\u8bd5\uff0c\u8c22\u8c22\uff01 </p>      <p>${recommendMsg}</p>      <div class=\"interview_table\">       <div class=\"interview_table_onetable\">        <div>        <div>          <table class=\"tbl_candidate\" cellpadding=\"10\" cellspacing=\"3\" rules=\"rows\">           <tbody>            <tr style=\"background: #F3F3F5;height: 34px\">             <td class=\"intv_user_name\">\u59d3\u540d</td>             <td class=\"intv_position_name\">\u5e94\u8058\u804c\u4f4d</td>             <td class=\"intv_sex\">\u6027\u522b</td>             <td class=\"intv_education\">\u5b66\u5386</td>             <td class=\"intv_university\">\u6bd5\u4e1a\u9662\u6821</td>             <td class=\"intv_major\">\u4e13\u4e1a</td>             <td class=\"intv_work_years\">\u5de5\u4f5c\u5e74\u9650</td><td class=\"intv_work_years\">\u64cd\u4f5c</td>            </tr>            <tr>             <td>${name}<br></td>             <td>${position}<br></td>             <td>${sex}<br></td>             <td>${education}<br></td>             <td>${university} <br></td>             <td>${major}<br></td>             <td>${years}<br></td><td><a href=\"${url}\"  id=\"replay_a\">\u53cd\u9988</a><br></td>             </tr>          </tbody>          </table>         </div>        </div>       </div>       <p></p>       <p style=\"text-align: right;\">${groupName}</p>       <p style=\"text-align: right;\">${curTime}</p>      </div>     </div>     <div id=\"footer\"></div>    </div>   </div>   </body></html>";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_PRESSFILETER});
        this.addClickListeners(new String[]{KEY_INTERVIEW});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long appFileId = (Long)formShowParameter.getCustomParam(APP_FILE_ID);
        DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)appFileId);
        ArrayList<Long> appFileIds = new ArrayList<Long>(2);
        appFileIds.add(appFileId);
        ValidateResult validateResult = AppFileService.getInstance().validateAppFileInProcessAndLocked(appFileIds);
        List allErrorInfo = validateResult.getAllErrorInfo();
        String filestatus = appFile.getString("filestatus");
        if (KEY_PRESSFILETER.equals(key)) {
            if (!"A".equals(filestatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6d41\u7a0b\u4e2d\u7684\u5019\u9009\u4eba\u8fdb\u884c\u50ac\u4fc3\u53cd\u9988\u3002", (String)"ResumeFilterBillList_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!allErrorInfo.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c\u50ac\u4fc3\u53cd\u9988\u3002", (String)"ResumeFilterBillList_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject intvEvl = this.getModel().getEntryRowEntity("entryentity", index);
            long interviewid = ((DynamicObject)intvEvl.get("filterhandlepeople")).getLong("id");
            String title = ResManager.loadKDString((String)"\u7b80\u5386\u7b5b\u9009\u50ac\u4fc3-\u6765\u81ea{0}", (String)"ResumeFilterFeedbackListIRPlugin_16", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()});
            DynamicObject userDynamicObject = userHelper.queryOne(SELECTQFilter, new QFilter[]{new QFilter("id", "=", (Object)interviewid)});
            String email = userDynamicObject.getString("email");
            String resscrtaskid = intvEvl.get("resscrtaskid").toString();
            if (!HRStringUtils.isEmpty((String)email)) {
                ArrayList<String> emails = new ArrayList<String>();
                emails.add(email);
                String fileName = userDynamicObject.getString("name");
                Object recommendMsg = intvEvl.get(TXT_FILTERREMARKS);
                String contentHtml = this.getContentHtml(fileName, recommendMsg, appFile, resscrtaskid);
                ResumeFilterFeedbackListIRPlugin.sendMail(title, contentHtml, emails);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9762\u8bd5\u5b98\u7684\u90ae\u7bb1\u5730\u5740\u3002", (String)"ResumeFilterFeedbackListIRPlugin_17", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
            MessageInfo message = new MessageInfo();
            message.setType("notice");
            String titleMsg = ResManager.loadKDString((String)"\u7b80\u5386\u7b5b\u9009\u50ac\u4fc3", (String)"ResumeFilterFeedbackListIRPlugin_18", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            message.setTitle(titleMsg);
            ArrayList<Long> interviewids = new ArrayList<Long>();
            interviewids.add(interviewid);
            message.setUserIds(interviewids);
            message.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
            message.setSenderName(RequestContext.get().getUserName());
            message.setTag(title);
            message.setContent(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\uff1a{0}</br>\u8bf7\u4f60\u5c3d\u5feb\u53cd\u9988\u7b80\u5386\u7b5b\u9009\u7ed3\u679c\uff0c\u82e5\u89c9\u5f97\u5408\u9002\uff0c\u6211\u4eec\u5c06\u5b89\u6392\u9762\u8bd5\uff0c\u8c22\u8c22\u3002", (String)"ResumeFilterFeedbackListIRPlugin_19", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{RequestContext.get().getUserName()}));
            String contentUrl = UrlService.getDomainContextUrl() + MESSURL;
            message.setContentUrl(contentUrl);
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            long curTime = System.currentTimeMillis();
            LocalDateTime endOfDay = LocalDateTime.now().with(LocalTime.MAX);
            Date todayDate = Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
            DistributeSessionlessCache cache = ResumeFilterFeedbackListIRPlugin.getDistributeSessionlessCache();
            cache.put(resscrtaskid + "" + interviewid, (Object)this.getTodayReply(), (int)(todayDate.getTime() / 1000L - curTime / 1000L));
            this.getView().invokeOperation("refresh");
        } else if (KEY_INTERVIEW.equals(key)) {
            if (!"A".equals(filestatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u6d41\u7a0b\u4e2d\u7684\u5019\u9009\u4eba\u8fdb\u884c\u5b89\u6392\u9762\u8bd5", (String)"ResumeFilterFeedbackListIRPlugin_20", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (allErrorInfo.size() != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u9501\u5b9a\uff0c\u65e0\u6cd5\u8fdb\u884c\u5b89\u6392\u9762\u8bd5", (String)"ResumeFilterFeedbackListIRPlugin_21", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject intvEvl = this.getModel().getEntryRowEntity("entryentity", index);
            long interviewid = ((DynamicObject)intvEvl.get("filterhandlepeople")).getLong("id");
            SetAbleInterviewTimeFormHelper.openSetInterviewTimePage((IFormView)this.getView(), (String)"tsirm_intvcalendar", (InterviewTimeWayEnum)InterviewTimeWayEnum.ENTRANCE_IRM, (Long)interviewid, (Long)appFile.getLong("id"));
        }
    }

    public String getContentHtml(String fileName, Object recommendMsg, DynamicObject appFile, String resscrtaskid) {
        String contentHtml = this.getHtmlContent();
        contentHtml = contentHtml.replace(FILENAME, fileName);
        String recommendMsgStr = "";
        if (recommendMsg != null && !recommendMsg.equals("")) {
            recommendMsgStr = ResManager.loadKDString((String)"\u63a8\u8350\u7559\u8a00\uff1a{0}", (String)"ResumeFilterFeedbackListIRPlugin_22", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{recommendMsg});
        }
        contentHtml = contentHtml.replace(RECOMMENDMSG, recommendMsgStr);
        String name = appFile.getString("name");
        contentHtml = contentHtml.replace(NAMEMSG, name);
        DynamicObject position = (DynamicObject)appFile.get("position");
        String positionStr = "";
        String groupName = "";
        if (position != null) {
            positionStr = position.get("name").toString();
            if (appFile.getDynamicObject("position").getDynamicObject("createorg") != null) {
                groupName = appFile.getDynamicObject("position").getDynamicObject("createorg").get("name").toString();
            }
        }
        contentHtml = contentHtml.replace(POSITION, positionStr);
        contentHtml = contentHtml.replace(GROUPNAME, groupName);
        String sexStr = this.getNotKnow();
        String workingyearsStr = "";
        String highesteducationStr = "";
        String highesteduschoolStr = "";
        String highestspecialtyStr = "";
        if (appFile.get("appres") != null) {
            Object highestspecialty;
            if (appFile.getDynamicObject("appres").getDynamicObject("gender") != null) {
                sexStr = appFile.getDynamicObject("appres").getDynamicObject("gender").getString("name");
            }
            int workingyears = ((DynamicObject)appFile.get("appres")).getInt("workingyears");
            workingyearsStr = ResumeAnalysisHelper.getWorkYearShow((int)workingyears);
            Object highesteducation = null;
            DynamicObject highesteducationObj = ((DynamicObject)appFile.get("appres")).getDynamicObject("highesteducation");
            if (highesteducationObj != null) {
                highesteducation = highesteducationObj.get("name");
            }
            if (highesteducation != null) {
                highesteducationStr = highesteducation.toString();
            }
            Object highesteduschool = null;
            DynamicObject highesteduschoolObj = ((DynamicObject)appFile.get("appres")).getDynamicObject("highesteduschool");
            if (highesteduschoolObj != null) {
                highesteduschool = highesteduschoolObj.get("name");
            }
            if (highesteduschool != null) {
                highesteduschoolStr = highesteduschool.toString();
            }
            if ((highestspecialty = ((DynamicObject)appFile.get("appres")).get("highestspecialty")) != null) {
                highestspecialtyStr = highestspecialty.toString();
            }
        }
        contentHtml = contentHtml.replace(SEX, sexStr);
        contentHtml = contentHtml.replace(YEARS, workingyearsStr);
        contentHtml = contentHtml.replace(EDUCATION, highesteducationStr);
        contentHtml = contentHtml.replace(UNIVERSITY, highesteduschoolStr);
        contentHtml = contentHtml.replace(MAJOR, highestspecialtyStr);
        contentHtml = contentHtml.replace(CURTIME, LocalDate.now().toString());
        String url = IntvMailUtils.getFormDetailUrl((String)"tsirm_resumefilterir", (String)resscrtaskid);
        String allUrl = IntvMailUtils.getListUrl((String)"tsirm_resumefilterir");
        contentHtml = contentHtml.replace(URL, url);
        contentHtml = contentHtml.replace(URLIVP, allUrl);
        return contentHtml;
    }

    public static void sendMail(String title, String content, List<String> receiver) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        messageInfo.setNotifyType(MessageChannels.EMAIL.getNumber());
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("email", receiver);
        messageInfo.setParams((Map)map);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static DistributeSessionlessCache getDistributeSessionlessCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(CUSTOMREGION);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long appFileId = (Long)formShowParameter.getCustomParam(APP_FILE_ID);
        this.initView(appFileId);
    }

    private void initView(Long appFileId) {
        DataSet fcDataSet;
        QFilter[] filterCondition = new QFilter[]{new QFilter("appfile", "=", (Object)appFileId)};
        DataSet rtDataSet = QueryServiceHelper.queryDataSet((String)"tsirm_resumefilter", (String)"tsirm_resumefilter", (String)RESUME_TASK_SELECT_FIELD, (QFilter[])filterCondition, (String)"createtime desc");
        DataSet pageSet = rtDataSet.join(fcDataSet = QueryServiceHelper.queryDataSet((String)"tsirm_filterrecommend", (String)"tsirm_filterrecommend", (String)"id,dtfilterrecommendtime,txtfilterremarks", null, null), JoinType.LEFT).on("resscr", "id").select(LEFT_FIELD, RIGHT_FIELD).finish();
        DataSet dataSet = pageSet.copy();
        int size = Iterators.size((Iterator)dataSet);
        if (size == 0) {
            ((Label)this.getControl(PAGE_TIPSTAG_PROPERTIES)).setText(ResManager.loadKDString((String)"\u6682\u65e0\u7b5b\u9009\u6570\u636e", (String)"FilterFeedbackListPlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", size);
        AtomicInteger defIndex = new AtomicInteger(0);
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        String beforeTime = "";
        while (pageSet.hasNext()) {
            Row row = pageSet.next();
            beforeTime = this.setViewData(row, rowIndex, defIndex, cardEntry, appFileId, beforeTime);
        }
    }

    private <T> void setItemViewData(String propertiesKey, T t, int[] rowIndex, AtomicInteger defIndex, CardEntry cardEntry, Object ignore, String ext) {
        if (t == null || ignore instanceof Number && (Long)ignore == 0L) {
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{propertiesKey});
            return;
        }
        if (t instanceof Date) {
            this.getModel().setValue(propertiesKey, (Object)HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)((Date)t)), rowIndex[defIndex.get()]);
            return;
        }
        if (t instanceof LocalDateTime) {
            this.getModel().setValue(propertiesKey, (Object)(DateTimeFormatter.ofPattern(DATE_PATTERN).format(((LocalDateTime)t).withNano(0)) + ext), rowIndex[defIndex.get()]);
            return;
        }
        this.getModel().setValue(propertiesKey, t, rowIndex[defIndex.get()]);
    }

    private String setViewData(Row row, int[] rowIndex, AtomicInteger defIndex, CardEntry cardEntry, long appFileId, String beforeTime) {
        String filteropinion;
        String entityId;
        IFormView parentView;
        long filterrecommendId;
        QFilter[] commend;
        DynamicObject commendobj;
        Date createTime = row.getDate("dtfilterrecommendtime");
        long resscrtaskId = row.getLong("id");
        this.setItemViewData("resscrtaskid", resscrtaskId, rowIndex, defIndex, cardEntry, null, "");
        QFilter[] filterCondition = new QFilter[]{new QFilter("id", "=", (Object)resscrtaskId)};
        DynamicObject dobj = QueryServiceHelper.queryOne((String)"tsirm_resumefilter", (String)"resscr", (QFilter[])filterCondition);
        String txtfilterremarks = "";
        if (dobj != null && (commendobj = QueryServiceHelper.queryOne((String)"tsirm_filterrecommend", (String)TXT_FILTERREMARKS, (QFilter[])(commend = new QFilter[]{new QFilter("id", "=", (Object)(filterrecommendId = dobj.getLong(0)))}))) != null) {
            txtfilterremarks = commendobj.getString(0);
        }
        if (createTime != null) {
            String createStr = HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)createTime);
            if (beforeTime.equals(createStr)) {
                cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{"labelap41"});
                cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{"cardentryflexpanelap8"});
            } else {
                cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{"cardentryflexpanelap11"});
            }
            beforeTime = createStr;
        }
        this.setItemViewData("recruitmentstage", row.getLong("recruitmentstage") + "", rowIndex, defIndex, cardEntry, null, "");
        if (row.getDate("dtfilterrecommendtime") != null) {
            this.setItemViewData("dtfilterrecommendtime", HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)row.getDate("dtfilterrecommendtime")), rowIndex, defIndex, cardEntry, null, "");
        }
        this.setItemViewData("filterhandlepeople", row.getLong("filterhandlepeople"), rowIndex, defIndex, cardEntry, null, "");
        ResumeFilterConstants.ConclusionStatus conclusionStatus = "2".equals(row.get("filterfeedbackstatus")) ? ResumeFilterConstants.ConclusionStatus.CONCLUSION_OUTTIME : ResumeFilterConstants.ConclusionStatus.getEnum((String)row.getString("filterfeedbackconclusion"));
        this.setItemViewData("filterfeedbackstatus", ResManager.loadKDString((String)conclusionStatus.getStatusName().loadKDString(), (String)conclusionStatus.getTag(), (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), rowIndex, defIndex, cardEntry, null, "");
        this.setItemViewData(FL_FEEBACK_STATUS, conclusionStatus.getCode(), rowIndex, defIndex, cardEntry, null, "");
        String feebackTime = TIMESTRS;
        Date filterfeedbackcontime = row.getDate("filterfeedbackcontime");
        if (filterfeedbackcontime == null) {
            filterfeedbackcontime = new Date();
        }
        if (row.getDate("dtfilterrecommendtime") != null) {
            long nh = 3600000L;
            long nd = 86400000L;
            long nm = 60000L;
            long diff = filterfeedbackcontime.getTime() - row.getDate("dtfilterrecommendtime").getTime();
            long hour = diff / nh;
            feebackTime = hour % 24L == 0L && hour != 0L ? hour / 24L + DTEXT : (hour < 24L ? diff / nh + HTEXT + diff % nh / nm + MINTEXT : diff / nd + DTEXT + diff % nd / nh + HTEXT + diff % nd % nh / nm + MINTEXT);
        }
        this.setItemViewData(KEY_FILETIME, feebackTime, rowIndex, defIndex, cardEntry, null, "");
        String feedbackStatuss = ResManager.loadKDString((String)conclusionStatus.getStatusName().loadKDString(), (String)conclusionStatus.getTag(), (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String formId = this.getView().getFormShowParameter().getParentFormId();
        if (OperationStatus.VIEW.equals((Object)operationStatus) || "tsirm_resumefilterir".equals(formId)) {
            if (this.getNotReply().equals(feedbackStatuss) || this.getOutReply().equals(feedbackStatuss)) {
                this.setItemViewData("filterfeedbackcontime", "-", rowIndex, defIndex, cardEntry, null, "");
            } else {
                this.setItemViewData("filterfeedbackcontime", filterfeedbackcontime, rowIndex, defIndex, cardEntry, null, "");
            }
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETER});
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETERED});
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_INTERVIEW});
        } else if (this.getSuit().equals(feedbackStatuss)) {
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETER});
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETERED});
            this.setItemViewData("filterfeedbackcontime", filterfeedbackcontime, rowIndex, defIndex, cardEntry, null, "");
        } else if (this.getNotReply().equals(feedbackStatuss) || this.getOutReply().equals(feedbackStatuss)) {
            DistributeSessionlessCache cache = ResumeFilterFeedbackListIRPlugin.getDistributeSessionlessCache();
            String cacheValue = (String)cache.get(resscrtaskId + "" + row.getLong("filterhandlepeople"));
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_INTERVIEW});
            if (HRStringUtils.isEmpty((String)cacheValue)) {
                cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETERED});
            } else {
                cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETER});
            }
            this.setItemViewData("filterfeedbackcontime", "-", rowIndex, defIndex, cardEntry, null, "");
        } else {
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETER});
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_INTERVIEW});
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{KEY_PRESSFILETERED});
            this.setItemViewData("filterfeedbackcontime", filterfeedbackcontime, rowIndex, defIndex, cardEntry, null, "");
        }
        if (null != this.getView().getParentView() && null != (parentView = this.getView().getParentView().getParentView()) && "tsirm_hireapprovalsg".equals(entityId = parentView.getEntityId())) {
            cardEntry.setChildVisible(false, rowIndex[defIndex.get()], new String[]{OP_FLEX});
        }
        if ("".equals(filteropinion = row.getString("filteropinion"))) {
            filteropinion = "-";
        }
        if (!"".equals(txtfilterremarks)) {
            this.setItemViewData(TXT_FILTERREMARKS, txtfilterremarks, rowIndex, defIndex, cardEntry, null, "");
        }
        this.setItemViewData("filteropinion", filteropinion, rowIndex, defIndex, cardEntry, null, "");
        defIndex.getAndIncrement();
        return beforeTime;
    }

    static {
        userHelper = new HRBaseServiceHelper("bos_user");
        LEFT_FIELD = new String[]{"id", "recruitmentstage", "filterhandlepeople", "filterfeedbackstatus", "filterfeedbackcontime", "filteropinion", "filterfeedbackconclusion"};
        RIGHT_FIELD = new String[]{"dtfilterrecommendtime"};
        RESUME_TASK_SELECT_FIELD = "id,resscr,recruitmentstage,filterfeedbackconclusion,filterhandlepeople,filterfeedbackstatus,filterfeedbackcontime,filteropinion";
    }
}

