/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.operate.service.AppfileOpRecordService;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.common.enums.resumefilter.ResumeFilterSourceEnum;

public class ResumeFilterIRBillList
extends AbstractListPlugin {
    private static final String PAGE_RECRUIT_TYPE = "hbss_recrutyp";
    private static final String BTN_FEEDBACK = "btn_feedback";
    private static final String COL_CANDIDATENAME = "appfile_name";
    private static final String SOURCE = "source";
    private static final String KEY_FILTERRECOMMEND_MSG = "resscr.txtfilterremarks";
    private static final String CLOSE_KEY_PLATFORM = "close_key_platform";
    private ResumeFilterHelper resumeFilterHelper = ResumeFilterHelper.getInstance();

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        IFormView parentView = this.getView().getParentView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object source = customParams.get(SOURCE);
        if (ResumeFilterSourceEnum.EMAIL.type.equals(source)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblclose"});
        }
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filterDataQFilterForCurrentUser = this.resumeFilterHelper.getFilterDataQFilterForCurrentUser();
        e.addCustomQFilter(filterDataQFilterForCurrentUser);
        List qFilters = e.getQFilters();
        qFilters.stream().filter(qFilter -> HRStringUtils.equals((String)qFilter.getProperty(), (String)"txtfilterremarks")).findFirst().ifPresent(filterRemarkQFilter -> {
            filterRemarkQFilter.__setProperty(KEY_FILTERRECOMMEND_MSG);
            filterRemarkQFilter.getNests(true).forEach(qFilterNest -> qFilterNest.getFilter().__setProperty(KEY_FILTERRECOMMEND_MSG));
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Boolean isHomeFlag = (Boolean)this.getView().getFormShowParameter().getCustomParam("isHomeFlag");
        String timeCode = (String)this.getView().getFormShowParameter().getCustomParam("homeTimeCode");
        List commonFilterColumnList = args.getCommonFilterColumns();
        commonFilterColumnList.forEach(commonFilterColumn -> {
            if ("filterfeedbackstatus".equals(commonFilterColumn.getFieldName()) && isHomeFlag != null && isHomeFlag.booleanValue()) {
                commonFilterColumn.setDefaultValues(new Object[]{"1", "2"});
            }
            if ("createtime".equals(commonFilterColumn.getFieldName()) && timeCode != null) {
                commonFilterColumn.setDefaultValue("all".equals(timeCode) ? null : timeCode);
            }
        });
        super.filterContainerInit(args);
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject dynamicObject = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (HRStringUtils.equals((String)fieldKey, (String)"txtfilterremarks")) {
            DynamicObject filterRecommend = dynamicObject.getDynamicObject("resscr");
            if (null == filterRecommend) {
                return;
            }
            String recommendMsg = filterRecommend.getString("txtfilterremarks");
            e.setFormatValue((Object)recommendMsg);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IFormView parentView;
        super.itemClick(evt);
        String key = evt.getOperationKey();
        if (BTN_FEEDBACK.equals(evt.getItemKey())) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
            if (listSelectedRows.isEmpty()) {
                listView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u9988\u7684\u5019\u9009\u4eba\u3002", (String)"ResumeFilterBillList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object[] pkValues = listSelectedRows.getPrimaryKeyValues();
            boolean allAreadyFeedBack = this.resumeFilterHelper.verifyIfAllAreadyFeedBack(pkValues);
            if (allAreadyFeedBack) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u53cd\u9988\u72b6\u6001\u4e3a\u201c\u672a\u53cd\u9988/\u8d85\u671f\u672a\u53cd\u9988\u201d\u7684\u6570\u636e\u8fdb\u884c\u53cd\u9988\u3002", (String)"ResumeFilterBillList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                FormShowParameter feedBackForm = new FormShowParameter();
                feedBackForm.setFormId("tsirm_dofilterfeedbackir");
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "resumeFilterFeedBack");
                feedBackForm.setCloseCallBack(closeCallBack);
                feedBackForm.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(feedBackForm);
            }
        } else if ("close".equals(key) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null) {
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("resumeFilterFeedBack".equals(closedCallBackEvent.getActionId())) {
            Map feedBackMap = (Map)closedCallBackEvent.getReturnData();
            if (feedBackMap == null) {
                return;
            }
            this.handleFeedBackReturnData(feedBackMap);
        } else if ("close_intvcalendar_or_filtersuccpop".equals(closedCallBackEvent.getActionId()) || CLOSE_KEY_PLATFORM.equals(closedCallBackEvent.getActionId())) {
            String returnData = (String)closedCallBackEvent.getReturnData();
            if (HRStringUtils.equals((String)returnData, (String)"success")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9762\u8bd5\u65f6\u95f4\u6210\u529f\u3002", (String)"ResumeFilterBillList_19", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if (COL_CANDIDATENAME.equals(args.getFieldName())) {
            IListView listView = (IListView)this.getView();
            ListSelectedRow listSelectedRow = listView.getCurrentSelectedRowInfo();
            FormShowParameter resumeFilterInfoParam = this.generateResumeFilterInfoParam(listSelectedRow.getPrimaryKeyValue());
            this.getView().showForm(resumeFilterInfoParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFeedBackReturnData(Map<String, String> feedBackMap) {
        List<Long> resumeFilterIdList = this.getResumeFilterIdList();
        DynamicObject[] resumeFilterTasks = this.resumeFilterHelper.queryResumeFilterTasksByPks(resumeFilterIdList.toArray());
        if (resumeFilterTasks == null || resumeFilterTasks.length == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u53cd\u9988\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ResumeFilterBillList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Tuple feedBackListTuple = this.resumeFilterHelper.getAlreadyFeedbackAndNotFeedBackList(feedBackMap, resumeFilterTasks);
        List alreadyFeedBackList = (List)feedBackListTuple.item2;
        List notFeedBackTaskList = (List)feedBackListTuple.item1;
        String feedbackResult = feedBackMap.get("filterfeedbackconclusion");
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject[] notFeedBackArr = notFeedBackTaskList.toArray(new DynamicObject[notFeedBackTaskList.size()]);
            this.resumeFilterHelper.updateResumeFilterTask(notFeedBackArr);
            AppFileDataHelper.updateAppFileFilterFeedBackData(notFeedBackTaskList.stream().map(filterTask -> {
                DynamicObject appFile = filterTask.getDynamicObject("appfile");
                return appFile.getLong("id");
            }).collect(Collectors.toList()));
            ResumerFilterBiz.init().completeBatchTask(notFeedBackTaskList);
            this.resumeFilterHelper.lockRightResume(feedbackResult, notFeedBackTaskList);
        }
        AppfileOpRecordService.getInstance().addResumeFilterFeedback(notFeedBackTaskList);
        this.showFeedBackConclusion(notFeedBackTaskList, alreadyFeedBackList, feedbackResult);
    }

    public void showFeedBackConclusion(List<DynamicObject> notFeedBackTaskList, List<String> failFeedBackList, String feedbackResult) {
        if (failFeedBackList.size() > 0) {
            int resumeFilterTasks = notFeedBackTaskList.size() + failFeedBackList.size();
            if (resumeFilterTasks > 1) {
                String titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u4e2a\u53cd\u9988\uff0c\u53cd\u9988\u6210\u529f%s\u4e2a\uff0c\u5931\u8d25%s\u4e2a\u3002", (String)"ResumeFilterBillList_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), resumeFilterTasks, notFeedBackTaskList.size(), failFeedBackList.size());
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("tsirm_operationresultir");
                formShowParameter.setShowTitle(false);
                formShowParameter.setCustomParam("title", (Object)titleMsg);
                formShowParameter.setCustomParam("errorMsg", failFeedBackList);
                formShowParameter.setCustomParam("filterfeedbackconclusion", (Object)feedbackResult);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_KEY_PLATFORM));
                this.getView().showForm(formShowParameter);
            } else {
                this.getView().showErrorNotification(failFeedBackList.get(0));
            }
        } else if (HRStringUtils.equals((String)feedbackResult, (String)"1")) {
            this.resumeFilterHelper.showInterviewTimeForm(this.getView(), "tsirm_intvcalendarir", "tsirm_filtersuccpopir", new CloseCallBack((IFormPlugin)this, "close_intvcalendar_or_filtersuccpop"));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u9988\u6210\u529f", (String)"ResumeFilterBillList_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public FormShowParameter generateResumeFilterInfoParam(Object pkId) {
        DynamicObject resumeFilterTask = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.queryOne("appfile", pkId);
        DynamicObject appfile = resumeFilterTask.getDynamicObject("appfile");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tsirm_resumefilterir");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7b80\u5386\u7b5b\u9009-{0}", (String)"ResumeFilterBillList_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{appfile.getString("name")}));
        formShowParameter.setCustomParam("id", pkId);
        formShowParameter.setPageId(this.getView().getPageId() + "_" + pkId);
        return formShowParameter;
    }

    private List<Long> getResumeFilterIdList() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pkIdList = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            pkIdList.add((Long)listSelectedRow.getPrimaryKeyValue());
        }
        return pkIdList;
    }
}

