/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.formplugin.web.intv.service.InterviewerService;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class ResumeFilterInfoIRPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String CANDPIC = "candpic";
    private static final String LBLNAME = "lblname";
    private static final String LBLNUMBER = "lblnumber";
    private static final String LBLBASICINFO = "lblbasicinfo";
    private static final String LBLPOSNAME = "lblposname";
    private static final String LBLPOSBUNAME = "lblposbuname";
    private static final String LBLADMIN = "lbladmin";
    private static final String LBLCURLINKSTATUS = "lblcurlinkstatus";
    private static final String TABPAGEAP = "tabpageap";
    private static final String APPRESUME = "appresume";
    private static final String EVALUATEDINFO = "evaluatedinfo";
    private static final String ADMINORG = "adminorg";
    private static final String RESUMESTOADD = "resumestoadd";
    private static final String FILTERFEEDBACK = "filterfeedback";
    private static final String FILTERHANDLEPEOPLE_ID = "filterhandlepeople_id";
    private static final String TOOLBARP = "tbmain";
    private static final String APPFILEID = "appFileId";
    private static final String RESTASKID = "resTaskId";
    private static final String PKID = "pkId";
    private static final String TASKID = "taskId";
    private static final String KEY_HEAD_LAP = "head_lap";
    private static final Integer INITIAL_CAPACITY = 16;
    private static final String WF_APPID = "wftask";
    private static final String AI_HIGHLIGHT_FLEX = "aihighlightflex";
    private static final String RESUME_LIGHT_CONCERN_CUSTOM_KEY = "resumesummary";
    private static Map<String, Consumer> clickEventMap = new HashMap<String, Consumer>(INITIAL_CAPACITY);

    public ResumeFilterInfoIRPlugin() {
        clickEventMap.put("tblrefresh", evt -> this.refreshPage());
    }

    public void afterCreateNewData(EventObject e) {
        Long resTaskId = this.getTaskId();
        if (null == resTaskId || 0L == resTaskId) {
            return;
        }
        DynamicObject resFiTaskObject = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.queryOne((Object)resTaskId);
        if (null == resFiTaskObject) {
            return;
        }
        DynamicObject appfileObject = resFiTaskObject.getDynamicObject("appfile");
        if (null == appfileObject) {
            return;
        }
        DynamicObject appFile = AppFileHelper.queryOne((long)appfileObject.getLong("id"));
        InterviewerService.getInstance().setHeadValue(this.getView(), appFile);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Toolbar)this.getControl(TOOLBARP)).addItemClickListener((ItemClickListener)this);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{"applypositionflex"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        Consumer consumer = clickEventMap.get(evt.getItemKey());
        if (consumer == null) {
            return;
        }
        consumer.accept(evt);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Tab tab = (Tab)this.getControl("tabap");
        tab.activeTab(APPRESUME);
        Long resTaskId = this.getTaskId();
        if (resTaskId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b5b\u9009\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ResumeFilterInfoPlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject resFiTaskObject = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.queryOne((Object)resTaskId);
        if (resFiTaskObject == null || TSCRequestContext.getUserId() != resFiTaskObject.getLong(FILTERHANDLEPEOPLE_ID)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b5b\u9009\u4efb\u52a1\u6570\u636e\u4e0d\u5b58\u5728\uff01", (String)"ResumeFilterInfoPlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.initView(resFiTaskObject);
        DynamicObject appfileObject = resFiTaskObject.getDynamicObject("appfile");
        if (null == appfileObject) {
            return;
        }
        DynamicObject appFile = AppFileHelper.queryOne((long)appfileObject.getLong("id"));
        InterviewerService.getInstance().setHeadValue(this.getView(), appFile);
        String light = appFile.getString("talenthighlight_tag");
        String concern = appFile.getString("talentconcern_tag");
        DynamicObjectCollection lightLabelCollection = appFile.getDynamicObjectCollection("talenthighlightlabel");
        DynamicObjectCollection concernLabelCollection = appFile.getDynamicObjectCollection("talentconcernlabel");
        boolean lightOrConcernLabelEmpty = HRStringUtils.isNotEmpty((String)light) || HRStringUtils.isNotEmpty((String)concern) || !CollectionUtils.isEmpty((Collection)lightLabelCollection) || !CollectionUtils.isEmpty((Collection)concernLabelCollection);
        boolean showAi = AiConfigHelper.getInstance().getIfOpen("interviewerairesume") && lightOrConcernLabelEmpty;
        this.getView().setVisible(Boolean.valueOf(showAi), new String[]{AI_HIGHLIGHT_FLEX});
        if (showAi) {
            InterviewerService.getInstance().showResumeConcernAndLight(this.getView(), RESUME_LIGHT_CONCERN_CUSTOM_KEY, concern, concernLabelCollection, light, lightLabelCollection);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Long resTaskId = this.getTaskId();
        this.getView().getPageCache().put("intvTaskId", String.valueOf(resTaskId));
        InterviewerService.getInstance().showPosition(this.getView(), evt, "resumeFilter");
    }

    public Long getTaskId() {
        String appId;
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        Long taskId = null;
        if (id != null) {
            taskId = Long.valueOf(String.valueOf(id));
        }
        if (taskId != null) {
            return taskId;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            String pkId = Optional.ofNullable(String.valueOf(((BillShowParameter)this.getView().getFormShowParameter()).getPkId())).orElse("0");
            taskId = Long.valueOf(pkId);
        } else {
            taskId = 0L;
        }
        if (taskId != 0L) {
            return taskId;
        }
        Long freeTaskId = (Long)this.getView().getFormShowParameter().getCustomParam(TASKID);
        if (freeTaskId != null) {
            taskId = ResumerFilterBiz.init().getNodeIdByBusinesskey(freeTaskId);
        }
        if (WF_APPID.equals(appId = this.getView().getFormShowParameter().getAppId()) && taskId == 0L) {
            taskId = this.getModel().getDataEntity().getLong("id");
        }
        return taskId == 0L ? null : taskId;
    }

    public void initView(DynamicObject resFiTaskObject) {
        long resumeObjectId = resFiTaskObject.getLong("candidate");
        DynamicObject resumeObject = ResumeFilterHelper.getInstance().getRsmById(Long.valueOf(resumeObjectId));
        if (resumeObject == null) {
            throw new KDBizException("Candidate data is null");
        }
        DynamicObject appfileObject = resFiTaskObject.getDynamicObject("appfile");
        if (appfileObject == null) {
            throw new KDBizException("AppFile data is null");
        }
        this.getView().getPageCache().put(APPFILEID, appfileObject.getString("id"));
        DynamicObject referencesObject = resFiTaskObject.getDynamicObject("filterrecommender");
        this.initHead(appfileObject.getLong("id"), referencesObject, resFiTaskObject.getPkValue());
        this.initTab(resumeObject, appfileObject.getLong("id"));
        int filterfeedbackstatus = resFiTaskObject.getInt("filterfeedbackstatus");
        this.initFormShowParameter(resFiTaskObject.getString("id"), RESTASKID, FILTERFEEDBACK, filterfeedbackstatus == Integer.parseInt("3") ? "tsirm_rsmflfeedbackinfoir" : "tsirm_rsmflfeedbackir");
    }

    public void initHead(long appFileId, DynamicObject referencesObject, Object pkValue) {
        if (referencesObject == null) {
            return;
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String org = (String)cache.get("RESSCR_REFERENCES_ID:" + referencesObject.getLong("id"));
        Long orgId = null;
        if (HRStringUtils.isNotEmpty((String)org)) {
            orgId = Long.parseLong(org);
        }
    }

    private void refreshPage() {
    }

    public void initTab(DynamicObject resumeObject, long appFileId) {
        String resumeUrl = resumeObject.getString(RESUMESTOADD);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{TABPAGEAP});
        this.initAppPage(resumeObject);
        this.initFormShowParameter(appFileId, APPFILEID, EVALUATEDINFO, "tsirm_rsmflfeedbacklistir");
    }

    public void initAppPage(DynamicObject resumeObject) {
        BaseShowParameter appResShowParameter = new BaseShowParameter();
        appResShowParameter.setPkId((Object)resumeObject.getLong("id"));
        appResShowParameter.setFormId("tsirm_srrsm_layout");
        appResShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appResShowParameter.getOpenStyle().setTargetKey(APPRESUME);
        appResShowParameter.setStatus(OperationStatus.VIEW);
        appResShowParameter.setCustomParam("pagestatussign", (Object)"see");
        this.getView().showForm((FormShowParameter)appResShowParameter);
    }

    public void initFormShowParameter(Object value, String name, String targetKey, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam(name, value);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm(showParameter);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }
}

