/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.resumefilter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.business.domain.resumefilter.service.SelectedAppFileService;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;

public class SelectedAppFilePlugin
extends HRDynamicFormBasePlugin {
    private SelectedAppFileService selectedAppFileService = SelectedAppFileService.getInstance();

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label = (Label)this.getControl("labelap");
        label.addClickListener((ClickListener)this);
        Button btnAdd = (Button)this.getControl("btn_add");
        btnAdd.addClickListener((ClickListener)this);
        Button btnDelete = (Button)this.getControl("deleteap");
        btnDelete.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        this.selectedAppFileService.initAppFileInfo(this.getView());
        List selectedAppFileIds = this.selectedAppFileService.getSelectedAppFileIds(this.getView());
        this.setViewBtnVisible(selectedAppFileIds != null ? selectedAppFileIds.size() : 0);
        this.updateSelectAppFileNumberLabel();
    }

    public void click(EventObject eventObject) {
        super.click(eventObject);
        Button button = (Button)eventObject.getSource();
        switch (button.getKey()) {
            case "labelap": {
                this.showViewSelectedAppFilePage();
                break;
            }
            case "btn_add": {
                this.showAddAppFileF7Page();
                break;
            }
            case "deleteap": {
                this.selectedAppFileService.deleteAppFiles(this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"viewAllappFilePage")) {
            String appFileIdStr = (String)returnData;
            this.selectedAppFileService.updateAppFileInfo(this.getView(), appFileIdStr);
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"addAppFilePage")) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
            ArrayList<Long> appFileIds = new ArrayList<Long>(listSelectedRows.size());
            for (ListSelectedRow selectRow : listSelectedRows) {
                appFileIds.add((Long)selectRow.getPrimaryKeyValue());
            }
            IFormView msgTplView = CfgMessageService.getMsgTplView((IFormView)this.getView().getParentView());
            DynamicObject[] appFileInfos = AppFileDataHelper.queryAppFileNameAndPhoto(appFileIds);
            ArrayList<Map> dataList = new ArrayList<Map>(appFileInfos.length);
            for (DynamicObject appFileInfo : appFileInfos) {
                DynamicObject candidate = appFileInfo.getDynamicObject("appres");
                Map tableDataMap = ResumerFilterBiz.init().setCandidateMap(candidate, appFileInfo.getDynamicObject("position"), null);
                dataList.add(tableDataMap);
            }
            String tableDataStr = JSON.toJSONString(dataList);
            msgTplView.getFormShowParameter().setCustomParam("filterrsmlist", (Object)tableDataStr);
            msgTplView.getFormShowParameter().setCustomParam("filterrsmcount", (Object)dataList.size());
            msgTplView.cacheFormShowParameter();
            String appFileIdStr = SerializationUtils.toJsonString(appFileIds);
            this.selectedAppFileService.updateAppFileInfo(this.getView(), appFileIdStr);
        }
        this.getView().invokeOperation("refresh");
    }

    private void updateSelectAppFileNumberLabel() {
        Label label = (Label)this.getView().getControl("selectlabel");
        int size = this.selectedAppFileService.getSelectedAppFileIds(this.getView()).size();
        String text = ResManager.loadKDString((String)"\u5df2\u9009\u5019\u9009\u4eba(\u5171{0}\u4eba)", (String)"SelectedAppFilePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{size});
        label.setText(text);
    }

    public void setViewBtnVisible(int size) {
        Boolean showViewBtnFlag = size > 10;
        this.getView().setVisible(showViewBtnFlag, new String[]{"labelap"});
    }

    private void showViewSelectedAppFilePage() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tsirm_viewallappfile");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("appFileIds", (Object)this.selectedAppFileService.getSelectedAppFileIdListStr(this.getView()));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "viewAllappFilePage");
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    private void showAddAppFileF7Page() {
        ListShowParameter listShowParameter = GenerateFormShowParamUtils.listShowParameterF7((String)"tsirm_appfile_view", (String)"tsirm_appfilelistf7", (String)this.getAddAppfileCaptureMultiLanguage(), (boolean)true, (boolean)false, (boolean)true);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "addAppFilePage");
        listShowParameter.setCloseCallBack(closeCallBack);
        Object[] selectAppFileIds = this.selectedAppFileService.getSelectedAppFileIds(this.getView()).toArray(new Long[0]);
        listShowParameter.setSelectedRows(selectAppFileIds);
        String formId = this.getView().getParentView().getFormShowParameter().getFormId();
        ListFilterParameter selectF7Filter = new ListFilterParameter();
        if (formId.equals("tsirm_messagepush")) {
            selectF7Filter.setFilter(AppFileListHelper.getPushMessageQFilter());
        } else {
            selectF7Filter.setFilter(AppFileListHelper.getIsInProcessQFilter());
        }
        listShowParameter.setListFilterParameter(selectF7Filter);
        listShowParameter.setCustomParam("maxSelectNumber", (Object)200);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private String getAddAppfileCaptureMultiLanguage() {
        return ResManager.loadKDString((String)"\u6dfb\u52a0\u5019\u9009\u4eba", (String)"SelectedAppFilePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
    }
}

