/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.rsmupdate;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.rsmupdate.service.RsmUpdateService;
import kd.tsc.tsirm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;

public class RsmUpdateEdit
extends HRDataBaseEdit
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(RsmUpdateEdit.class);

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"btn_addeduexp", "btn_addworkexp", "btn_addprjexp", "iconopenclose", "btn_addworkrelaexp", "btn_addlangexp", "btn_uploadrsmlocal"});
        this.addItemClickListeners(new String[]{"bar_per", "bar_self", "bar_jobintention"});
        Vector vector = (Vector)this.getControl("iconuploadresume");
        vector.addUploadListener((UploadListener)this);
        Label label = (Label)this.getControl("uploadresume");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        RsmUpdateService.initRsmData((IFormView)this.getView());
        RsmUpdateService.loadAnchor((IFormView)this.getView(), (String)"anchor_preinfo");
        RsmUpdateService.editPreInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
        RsmUpdateService.editJobIntentionInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
        RsmUpdateService.editSelfButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
    }

    public void beforeBindData(EventObject eventObject) {
        RsmUpdateService.loadChildPage((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_addworkrelaexp": {
                this.showRsmExpForm("tsirm_srrsmupdateworkrela", SrRsmKDString.workRelaExp());
                break;
            }
            case "btn_addeduexp": {
                this.showRsmExpForm("tsirm_srrsmupdateeduexp", SrRsmKDString.eduExp());
                break;
            }
            case "btn_addlangexp": {
                this.showRsmExpForm("tsirm_srrsmupdatelangabl", SrRsmKDString.langAblExp());
                break;
            }
            case "btn_addworkexp": {
                this.showRsmExpForm("tsirm_srrsmupdateworkexp", SrRsmKDString.workExp());
                break;
            }
            case "btn_addprjexp": {
                this.showRsmExpForm("tsirm_srrsmupdateprjexp", SrRsmKDString.prjExp());
                break;
            }
            case "btn_uploadrsmlocal": {
                this.handleClickUploadLocalResume();
                break;
            }
        }
    }

    private void handleClickUploadLocalResume() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("btn_uploadrsmlocal", (IFormPlugin)this);
        RsmUpdateService.loadLocalRsmFile((IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBackListener);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_peredit": {
                this.handleItemClickPreEdit();
                break;
            }
            case "bar_percancel": {
                this.checkInfoChange("panel_perinfo");
                break;
            }
            case "bar_persave": {
                this.handleItemClickPreSave();
                break;
            }
            case "bar_jobintentionedit": {
                this.handleItemClickJobIntentionEdit();
                break;
            }
            case "bar_jobintentioncancel": {
                this.checkInfoChange("panel_jobintention");
                break;
            }
            case "bar_jobintentionsave": {
                this.handleItemClickJobIntentionSave();
                break;
            }
            case "bar_selfedit": {
                this.handleItemClickSelfEdit();
                break;
            }
            case "bar_selfcancel": {
                this.checkInfoChange("panel_selfdesc");
                break;
            }
            case "bar_selfsave": {
                RsmUpdateService.editSelfButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
                RsmUpdateService.removePageCache((IFormView)this.getView(), (String)"panel_selfdesc");
                break;
            }
        }
    }

    private void handleItemClickSelfEdit() {
        RsmUpdateService.editSelfButtonClick((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        IPageCache pageCache = this.getPageCache();
        RsmUpdateService.cacheDataModel((IPageCache)pageCache, (String)"panel_selfdesc", (DynamicObject)this.getModel().getDataEntity());
    }

    private void handleItemClickPreEdit() {
        RsmUpdateService.editPreInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        RsmUpdateService.cacheDataModel((IPageCache)this.getPageCache(), (String)"panel_perinfo", (DynamicObject)this.getModel().getDataEntity());
    }

    private void handleItemClickPreSave() {
        if (RsmUpdateService.validData((IFormView)this.getView())) {
            RsmUpdateService.refreshHeadPage((IFormView)this.getView());
            RsmUpdateService.removePageCache((IFormView)this.getView(), (String)"panel_perinfo");
            RsmUpdateService.editPreInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
        }
    }

    private void handleItemClickJobIntentionEdit() {
        RsmUpdateService.editJobIntentionInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.TRUE);
        RsmUpdateService.cacheDataModel((IPageCache)this.getPageCache(), (String)"panel_jobintention", (DynamicObject)this.getModel().getDataEntity());
    }

    private void handleItemClickJobIntentionSave() {
        RsmUpdateService.editJobIntentionInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
        RsmUpdateService.removePageCache((IFormView)this.getView(), (String)"panel_jobintention");
    }

    public void afterUpload(UploadEvent evt) {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("cache_resume_url", (IFormPlugin)this);
        RsmUpdateService.handleAfterUpload((UploadEvent)evt, (IFormView)this.getView(), (ConfirmCallBackListener)confirmCallBackListener);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        String opKey;
        if (args.getSource() instanceof FormOperate && "submit".equals(opKey = (operate = (FormOperate)args.getSource()).getOperateKey())) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String objType = (String)parameter.getCustomParam("objtype");
            if ("stdrsmdeliver".equals(objType)) {
                args.setCancel(!RsmUpdateService.checkDeliverStatus((IFormView)this.getView()));
            } else {
                args.setCancel(!RsmUpdateService.checkUpdateStatus((IFormView)this.getView()));
            }
            if (!args.isCancel()) {
                args.setCancel(!RsmUpdateService.validData((IFormView)this.getView()));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(opKey)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("submit", (IFormPlugin)this);
            this.getView().showConfirm(SrRsmKDString.confirmSubmit(), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    private void checkInfoChange(String key) {
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        if (!RsmHelper.showDataChangeForm((IFormView)this.getView(), null, (String)key, (ConfirmCallBackListener)callBackListener)) {
            RsmUpdateService.removePageCache((IFormView)this.getView(), (String)key);
            if ("panel_perinfo".equals(key)) {
                RsmUpdateService.editPreInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
            } else if ("panel_jobintention".equals(key)) {
                RsmUpdateService.editJobIntentionInfoButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
            } else if ("panel_selfdesc".equals(key)) {
                RsmUpdateService.editSelfButtonClick((IFormView)this.getView(), (Boolean)Boolean.FALSE);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            switch (callBackId) {
                case "panel_perinfo": {
                    RsmUpdateService.resetPreInfo((IFormView)this.getView());
                    break;
                }
                case "advpanel_workrelaexp": {
                    RsmUpdateService.resetJobIntentionInfo((IFormView)this.getView());
                    break;
                }
                case "panel_selfdesc": {
                    RsmUpdateService.resetSelfDesc((IFormView)this.getView());
                    break;
                }
                case "submit": {
                    this.handleConfirmCallBackSubmit();
                    break;
                }
                case "cache_resume_url": {
                    RsmUpdateService.confirmUploadResume((IFormView)this.getView());
                    break;
                }
                case "btn_uploadrsmlocal": {
                    break;
                }
            }
        }
    }

    private void handleConfirmCallBackSubmit() {
        RsmUpdateService.submitData((IFormView)this.getView());
        IFormView parentView = this.getView().getParentView();
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propName = propertyChangedArgs.getProperty().getName();
        String displayName = propertyChangedArgs.getProperty().getDisplayName().getLocaleValue();
        String entityName = this.getView().getEntityId();
        if (!RsmConstants.NOT_CHECK_FIELD.contains(propName)) {
            String cacheKey = "selfevaluation".equals(propName) ? "panel_selfdesc" + entityName : "panel_perinfo" + entityName;
            ResumeUtilsHelper.cacheChangeDisplayName((String)displayName, (IPageCache)this.getView().getPageCache(), (String)cacheKey);
        }
        switch (propName) {
            case "partwt": {
                RsmHelper.handlerPartwtChange((Date)((Date)propertyChangedArgs.getChangeSet()[0].getNewValue()), (IFormView)this.getView());
                break;
            }
            case "birthday": {
                RsmUpdateService.handlerBirthdayChange((Date)((Date)propertyChangedArgs.getChangeSet()[0].getNewValue()), (IFormView)this.getView());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tsirm_srrsmupdateworkrela": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_workrela", (IFormView)this.getView());
                break;
            }
            case "tsirm_srrsmupdateeduexp": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_eduexp", (IFormView)this.getView());
                break;
            }
            case "tsirm_srrsmupdatelangabl": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_langexp", (IFormView)this.getView());
                break;
            }
            case "tsirm_srrsmupdateworkexp": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_workexp", (IFormView)this.getView());
                break;
            }
            case "tsirm_srrsmupdateprjexp": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_prjexp", (IFormView)this.getView());
                break;
            }
            case "tsirm_srrsmposorgrel": {
                RsmUpdateService.reloadRsmExpView((String)actionId, (String)"flexpanelcontent_posorgre", (IFormView)this.getView());
                break;
            }
        }
    }

    private void showRsmExpForm(String entityId, String caption) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityId);
        RsmUpdateService.showBaseForm((String)entityId, null, (String)caption, (CloseCallBack)closeCallBack, (IFormView)this.getView());
    }
}

