/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.rsmupdate;

import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.common.constants.rsm.rsmupdate.RsmUpdateConstants;
import kd.tsc.tsirm.formplugin.web.rsm.rsmupdate.RsmUpdateEdit;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;

public class RsmUpdateExpEdit
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(RsmUpdateEdit.class);
    private boolean dealDateTime;

    private void setCheckUpdate(boolean status) {
        this.getPageCache().put("checkupdatestatus", status ? "1" : "0");
    }

    public void createNewData(BizDataEventArgs bizDataEventArgs) {
        IFormView view = this.getView();
        Object pkId = view.getFormShowParameter().getCustomParam("pkId");
        if (pkId == null) {
            return;
        }
        Long expExpId = (Long)pkId;
        String entityId = view.getEntityId();
        IPageCache pageCache = view.getParentView().getPageCache();
        DynamicObject expDy = ResumeUtilsHelper.findExpById((IPageCache)pageCache, (Long)expExpId, (String)((String)RsmUpdateConstants.RSMUPDATE_RSM.get(entityId)));
        DynamicObject toExpDy = ServiceHelperCache.getHrBaseServiceHelper((String)entityId).generateEmptyDynamicObject();
        ResumeUtilsHelper.copyObj((DynamicObject)expDy, (DynamicObject)toExpDy, (Set)Sets.newHashSet());
        bizDataEventArgs.setDataEntity((Object)toExpDy);
    }

    public void afterBindData(EventObject eventObject) {
        this.dealDateTime = RsmHelper.dealDateTime((IDataModel)this.getModel());
        if (this.dealDateTime) {
            RsmHelper.handleRsmExpAfterBindData((IFormView)this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        if (this.dealDateTime) {
            RsmHelper.handleExpEditPropertyChange((PropertyChangedArgs)ee, (IFormView)this.getView());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperateKey().equals("save")) {
            this.setCheckUpdate(false);
            DynamicObject rsmExp = this.getModel().getDataEntity();
            rsmExp.set("modifytime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
            String entityId = (String)RsmUpdateConstants.RSMUPDATE_RSM.get(this.getView().getEntityId());
            DynamicObject objDy = ServiceHelperCache.getHrBaseServiceHelper((String)entityId).generateEmptyDynamicObject();
            ResumeUtilsHelper.copyObj((DynamicObject)rsmExp, (DynamicObject)objDy, (Set)Sets.newHashSet());
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            int opStatus = showParameter.getStatusValue();
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            if (opStatus == OperationStatus.ADDNEW.getValue()) {
                objDy.set("id", (Object)ID.genLongId());
                ResumeUtilsHelper.serializeDynamicObject((IPageCache)pageCache, (String)entityId, (DynamicObject)objDy);
            } else if (opStatus == OperationStatus.EDIT.getValue()) {
                objDy.set("id", showParameter.getCustomParam("pkId"));
                ResumeUtilsHelper.editCacheRsmExpData((IPageCache)pageCache, (String)entityId, (DynamicObject)objDy);
            }
            this.getView().returnDataToParent((Object)entityId);
        }
    }

    public void beforeClosed(BeforeClosedEvent ee) {
        String checkUpdateStatus = this.getPageCache().get("checkupdatestatus");
        boolean isDataChange = HRStringUtils.isNotEmpty((String)checkUpdateStatus) && "0".equals(checkUpdateStatus);
        ee.setCheckDataChange(!isDataChange);
    }
}

