/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.NumberGenerater;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmPositionHelper;
import kd.tsc.tsirm.business.domain.rsm.service.AddResumeBizServiceHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeUtilsHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeHandleService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.AddResumeService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.BlacklistHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.common.constants.rsm.ResumeConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.entity.ResumeInfo;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;
import kd.tsc.tsrbs.common.enums.rsm.RsmSourceEnum;
import kd.tsc.tsrbs.common.enums.rsm.YesOrNotEnum;
import org.apache.commons.lang3.time.StopWatch;

public class AddResumePlugin
extends HRDynamicFormBasePlugin
implements UploadListener,
HyperLinkClickListener,
Consumer<BeforeF7ViewDetailEvent>,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AddResumePlugin.class);
    private AddResumeBizServiceHelper addResumeBizServiceHelper = AddResumeBizServiceHelper.getInstance();

    public void registerListener(EventObject eo) {
        Label label = (Label)this.getView().getControl("uploadresume");
        label.addClickListener((ClickListener)this);
        label.addUploadListener((UploadListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit telentPoolMgtBd = (BasedataEdit)this.getControl("talentpoolmgt");
        telentPoolMgtBd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"buttonap", "btn_mainaddrsm", "position"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject eo) {
        TextEdit positionEdit = (TextEdit)this.getControl("position");
        BasedataEdit talentPoolMgt = (BasedataEdit)this.getControl("talentpoolmgt");
        boolean isFromTalentPool = this.checkIsFromTalentPool();
        positionEdit.setMustInput(!isFromTalentPool);
        talentPoolMgt.setMustInput(isFromTalentPool);
        this.getView().setVisible(Boolean.valueOf(isFromTalentPool), new String[]{"talentpoolmgt"});
    }

    private boolean checkIsFromTalentPool() {
        String openFormSource = (String)this.getView().getFormShowParameter().getCustomParam("openFormSource");
        return "tsirm_talentpoolmgt".equals(openFormSource);
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent positionViewDetailEvent) {
        BasedataEdit source = (BasedataEdit)positionViewDetailEvent.getSource();
        String fieldKey = source.getFieldKey();
        if ("position".equals(fieldKey)) {
            positionViewDetailEvent.setCancel(true);
            BaseShowParameter baseShow = new BaseShowParameter();
            baseShow.setFormId("tsirm_position_view");
            baseShow.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShow.setStatus(OperationStatus.VIEW);
            baseShow.setPkId(positionViewDetailEvent.getPkId());
            this.getView().showForm((FormShowParameter)baseShow);
        }
    }

    public void afterCreateNewData(EventObject eo) {
        super.afterCreateNewData(eo);
        RsmService.setPositionData((IFormView)this.getView());
    }

    public void afterUpload(UploadEvent evt) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int resumeCount = evt.getUrls().length;
        if (resumeCount > 20) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, SrRsmKDString.rsmMost20(), 20));
            return;
        }
        ArrayList<ResumeInfo> resumeInfoList = new ArrayList<ResumeInfo>(resumeCount);
        for (Object url : evt.getUrls()) {
            String resumeUrl = url.toString();
            ResumeInfo resumeInfo = this.addResumeBizServiceHelper.getInputStreamByResumeUrl(resumeUrl);
            resumeInfoList.add(resumeInfo);
        }
        this.generateResumeFileList(resumeInfoList);
        stopWatch.stop();
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void generateResumeFileList(List<ResumeInfo> resumeInfoList) {
        for (ResumeInfo resumeInfo : resumeInfoList) {
            AppResumeBo resumeBo;
            DynamicObject rsm;
            if (resumeInfo.getResultStatus() == 200) {
                rsm = this.addResumeBizServiceHelper.generateResumeInfo(resumeInfo);
                resumeBo = new AppResumeBo(rsm);
                this.addResumeBizServiceHelper.loadExpEntity(resumeInfo, resumeBo);
                this.loadResumeResult(resumeBo, resumeInfo);
                continue;
            }
            rsm = this.addResumeBizServiceHelper.generateResumeInfo(resumeInfo);
            resumeBo = new AppResumeBo(rsm);
            this.loadResumeResult(resumeBo, resumeInfo);
        }
        this.validate();
    }

    private void loadResumeResult(AppResumeBo resumeBo, ResumeInfo resumeInfo) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("pagecacheid", new Object[0]);
        vs.addField("resultstatus", new Object[0]);
        vs.addField("resumestoadd", new Object[0]);
        vs.addField("id", new Object[0]);
        vs.addField("filename", new Object[0]);
        vs.addField("fullname", new Object[0]);
        vs.addField("phone", new Object[0]);
        vs.addField("email", new Object[0]);
        vs.addField("result", new Object[0]);
        vs.addField("viewresume", new Object[0]);
        String operationName = AddResumePlugin.getOperationName(resumeInfo);
        String cacheString = SerializationUtils.serializeToBase64((Object)resumeBo);
        String cacheId = NumberGenerater.getInstance().generaterNextNumber(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()), "TR");
        this.getPageCache().put(cacheId, cacheString);
        DynamicObject rsm = resumeBo.getRsm();
        vs.addRow(new Object[]{cacheId, String.valueOf(resumeInfo.getResultStatus()), rsm.get("resumestoadd"), rsm.get("id"), resumeInfo.getFileName(), rsm.get("fullname"), rsm.get("phone"), rsm.get("email"), resumeInfo.getResult(), operationName});
        model.batchCreateNewEntryRow("resumelistlentryentity", vs);
        model.endInit();
        this.getView().updateView("resumelistlentryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] dynamicObject = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        String pageCacheId = dynamicObject[rowIndex].getString("pagecacheid");
        String resumePath = dynamicObject[rowIndex].getString("resumestoadd");
        String resultstatus = dynamicObject[rowIndex].getString("resultstatus");
        if (resultstatus.equals(String.valueOf(200))) {
            if (HRStringUtils.equals((String)"viewresume", (String)arg0.getFieldName())) {
                String cacheStringNew = this.getPageCache().get(pageCacheId);
                AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)cacheStringNew);
                Map<String, Object> returnData = AddResumePlugin.generateReviewHeadData(rowIndex, pageCacheId, resumeBo);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("tsirm_previewresume");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParams(returnData);
                showParameter.setCustomParam("dataSource", (Object)"1");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_previewresume"));
                this.getView().showForm(showParameter);
            }
        } else if (HRStringUtils.equals((String)"viewresume", (String)arg0.getFieldName())) {
            if (HRStringUtils.isEmpty((String)resumePath)) {
                return;
            }
            ResumeInfo newResumeInfo = this.addResumeBizServiceHelper.getInputStreamByResumeUrl(resumePath);
            DynamicObject newRsm = this.addResumeBizServiceHelper.generateResumeInfo(newResumeInfo);
            AppResumeBo resumeBo = new AppResumeBo(newRsm);
            if (newResumeInfo.getResultStatus() == 200) {
                this.updatePageCacheAndPageData(rowIndex, pageCacheId, resumePath, newResumeInfo, resumeBo);
            } else {
                this.getModel().setValue("result", (Object)newResumeInfo.getResult(), rowIndex);
                this.getModel().setValue("viewresume", (Object)SrRsmKDString.reAnalysis(), rowIndex);
            }
        }
        if (HRStringUtils.equals((String)"removeresume", (String)arg0.getFieldName())) {
            this.getPageCache().put("^delete_pageCacheId", pageCacheId);
            this.getPageCache().put("delete_rowIndex", String.valueOf(rowIndex));
            this.getPageCache().put("delete_resumePath", resumePath);
            this.getView().showConfirm(SrRsmKDString.rsmDeleteTips(), MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("removeresume", (IFormPlugin)this));
        }
    }

    private void updatePageCacheAndPageData(int rowIndex, String pageCacheId, String resumePath, ResumeInfo newResumeInfo, AppResumeBo resumeBo) {
        this.addResumeBizServiceHelper.loadExpEntity(newResumeInfo, resumeBo);
        DynamicObject rsm = resumeBo.getRsm();
        this.getPageCache().remove(pageCacheId);
        String newCacheString = SerializationUtils.serializeToBase64((Object)resumeBo);
        String newPageCacheId = NumberGenerater.getInstance().generaterNextNumber(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()), "TR");
        this.getPageCache().put(newPageCacheId, newCacheString);
        this.getModel().setValue("pagecacheid", (Object)newPageCacheId, rowIndex);
        this.getModel().setValue("resumestoadd", (Object)resumePath, rowIndex);
        this.getModel().setValue("resultstatus", (Object)newResumeInfo.getResultStatus(), rowIndex);
        this.getModel().setValue("filename", (Object)newResumeInfo.getFileName(), rowIndex);
        this.getModel().setValue("fullname", (Object)rsm.getString("fullname"), rowIndex);
        this.getModel().setValue("phone", (Object)rsm.getString("phone"), rowIndex);
        this.getModel().setValue("email", (Object)rsm.getString("email"), rowIndex);
        this.getModel().setValue("result", (Object)newResumeInfo.getResult(), rowIndex);
        String operationName = AddResumePlugin.getOperationName(newResumeInfo);
        this.getModel().setValue("viewresume", (Object)operationName, rowIndex);
    }

    private static String getOperationName(ResumeInfo resumeInfo) {
        String operationName = resumeInfo.getResultStatus() == 200 ? SrRsmKDString.rsmPreview() : SrRsmKDString.reAnalysis();
        return operationName;
    }

    private static Map<String, Object> generateReviewHeadData(int rowIndex, String pageCacheId, AppResumeBo resumeBo) {
        DynamicObject highestEduCation;
        HashMap<String, Object> returnData = new HashMap<String, Object>(1);
        returnData.put("pagecacheid", pageCacheId);
        returnData.put("rowIndex", rowIndex);
        DynamicObject rsm = resumeBo.getRsm();
        returnData.put("fullname", rsm.getString("fullname"));
        returnData.put("age", rsm.getString("age"));
        returnData.put("gender", rsm.getString("gender"));
        returnData.put("workingyears", rsm.getString("workingyears"));
        returnData.put("photo", rsm.getString("photo"));
        returnData.put("resumestoadd", rsm.getString("resumestoadd"));
        DynamicObject highestEduSchool = rsm.getDynamicObject("highesteduschool");
        if (highestEduSchool != null) {
            returnData.put("schoolname", highestEduSchool.getString("name"));
        }
        if ((highestEduCation = rsm.getDynamicObject("highesteducation")) != null) {
            returnData.put("education", highestEduCation.getString("name"));
        }
        returnData.put("specialtyname", rsm.getString("highestspecialty"));
        returnData.put("companyname", rsm.getString("recentcompany"));
        returnData.put("positionname", rsm.getString("recentposition"));
        return returnData;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        messageBoxClosedEvent.getCustomVaule();
        switch (callBackId) {
            case "removeresume": {
                this.deleteConfirmCallBack(messageBoxClosedEvent);
                break;
            }
            case "close": {
                this.pageCloseConfirmCallBack(messageBoxClosedEvent);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String closeActionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)"tsirm_position", (String)closeActionId)) {
            RsmService.selectedPositionClosedCallBack((IFormView)this.getView(), (Object)returnData);
            return;
        }
        if (HRObjectUtils.isEmpty((Object)returnData)) {
            if ("tsirm_addcandidateresult".equals(closedCallBackEvent.getActionId())) {
                this.getView().close();
            }
            return;
        }
        JSONObject map = JSON.parseObject((String)JSON.toJSONString((Object)returnData));
        String btnSign = map.getString("btnsign");
        RsmService.previewResumeExit((IFormView)this.getView(), (JSONObject)map);
        RsmService.previewResumeDelete((IFormView)this.getView(), (JSONObject)map);
        if (HRStringUtils.equals((String)btnSign, (String)"againaddcandidate")) {
            RsmService.cleanEntryData((IDataModel)this.getModel());
            this.getModel().createNewData();
            this.getPageCache().remove("pagecacheid");
        }
        if (HRStringUtils.equals((String)btnSign, (String)"endaddcandidate")) {
            this.getView().close();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.getView().showLoading(new LocaleString(SrRsmKDString.pleaseWait()));
        try {
            this.handleAfterDoOperation(afterDoOperationEventArgs);
        }
        finally {
            this.getView().hideLoading();
            stopWatch.stop();
        }
    }

    public void handleAfterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && HRStringUtils.equals((String)opKey, (String)"submit")) {
            if (this.judgeResumeEmpty()) {
                this.getView().hideLoading();
                LOG.warn("AddResumePlugin.judgeResumeEmpty() false return");
                return;
            }
            if (!this.validate()) {
                this.getView().hideLoading();
                LOG.warn("AddResumePlugin.validate() false return");
                return;
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity();
            Long positionId = dataEntity.getLong("positionid");
            DynamicObject positionDt = RsmPositionHelper.queryOneById((Long)positionId);
            if (!this.checkIsFromTalentPool() && HRObjectUtils.isEmpty((Object)positionDt)) {
                this.getView().showTipNotification(SrRsmKDString.needPosition());
                this.getView().hideLoading();
                return;
            }
            this.handleAfterCheck(dataEntity, positionDt);
        }
    }

    private void handleAfterCheck(DynamicObject dataEntity, DynamicObject positionDt) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] analysisResultArrays = entryData.getDataEntitys();
        ArrayList<AppResumeBo> resumeBoList = new ArrayList<AppResumeBo>(analysisResultArrays.length);
        for (DynamicObject entryEntity : analysisResultArrays) {
            if (!HRStringUtils.equals((String)String.valueOf(200), (String)entryEntity.get("resultstatus").toString())) continue;
            String pageCacheId = entryEntity.getString("pagecacheid");
            AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(pageCacheId));
            resumeBo = ResumeUtilsHelper.copyResumeBo((AppResumeBo)resumeBo);
            DynamicObject deliveryDt = this.generateDeliveryDt();
            if (HRObjectUtils.isEmpty((Object)positionDt)) {
                deliveryDt.set("isfiledisplay", (Object)YesOrNotEnum.NON.toString());
            }
            resumeBo.setDelivery(deliveryDt);
            RsmService.handlerRsmExpInfo((AppResumeBo)resumeBo);
            resumeBoList.add(resumeBo);
        }
        DynamicObject telentPool = dataEntity.getDynamicObject("talentpoolmgt");
        Long telentPoolId = 0L;
        if (null != telentPool) {
            telentPoolId = telentPool.getLong("id");
        }
        List<DynamicObject> analysisResultListResult = AddResumePlugin.saveResumeAndGenerateResult(analysisResultArrays, resumeBoList, positionDt, telentPoolId);
        String analysisResultListBase64 = SerializationUtils.serializeToBase64(analysisResultListResult);
        this.openAddResumeResult(analysisResultListBase64, positionDt);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (HRStringUtils.equals((String)itemKey, (String)"close")) {
            this.judgeIsUnSubmitResume();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("talentpoolmgt".equals(beforeF7SelectEvent.getProperty().getName())) {
            ArrayList qFilterList = new ArrayList(1);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCaption(SrRsmKDString.addToTalentPool());
            listShowParameter.getTreeFilterParameter().setQFilters(qFilterList);
            ArrayList<QFilter> listFilter = new ArrayList<QFilter>(1);
            QFilter qFilter = new QFilter("issyspreset", "!=", (Object)"1");
            listFilter.add(qFilter);
            listShowParameter.getListFilterParameter().setQFilters(listFilter);
            listShowParameter.setCustomParam("pageNumber", (Object)"tsirm_stdrsm");
            listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX");
        }
    }

    private boolean judgeResumeEmpty() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] analysisResultArrays = entryData.getDataEntitys();
        if (analysisResultArrays.length == 0) {
            this.getView().showTipNotification(SrRsmKDString.pleaseUploadRsm());
            return true;
        }
        return false;
    }

    private void judgeIsUnSubmitResume() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] analysisResultArrays = entryData.getDataEntitys();
        boolean flag = false;
        for (DynamicObject entryEntity : analysisResultArrays) {
            if (!HRStringUtils.equals((String)String.valueOf(200), (String)entryEntity.getString("resultstatus"))) continue;
            flag = true;
            break;
        }
        if (flag) {
            this.getView().showConfirm(SrRsmKDString.rsmCloseTips(), MessageBoxOptions.YesNo, ConfirmTypes.Delete, new ConfirmCallBackListener("close", (IFormPlugin)this));
        } else {
            this.getView().close();
        }
    }

    private void openAddResumeResult(String analysisResultListBase64, DynamicObject positionDy) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_addcandidateresult");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("resumelistlentryentity", (Object)analysisResultListBase64);
        long positionId = null == positionDy ? 0L : positionDy.getLong("id");
        showParameter.setCustomParam("position", (Object)String.valueOf(positionId));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_addcandidateresult"));
        this.getView().showForm(showParameter);
    }

    private static List<DynamicObject> saveResumeAndGenerateResult(DynamicObject[] analysisResultArrays, List<AppResumeBo> resumeBoList, DynamicObject positionDt, Long telentPoolId) {
        HashMap analysisResultMap = Maps.newHashMapWithExpectedSize((int)resumeBoList.size());
        for (AppResumeBo resumeBo : resumeBoList) {
            analysisResultMap.put(resumeBo.getRsm().getLong("id"), resumeBo);
        }
        List<DynamicObject> analysisResultList = Arrays.asList(analysisResultArrays);
        for (DynamicObject analysisResult : analysisResultArrays) {
            if (HRStringUtils.equals((String)String.valueOf(200), (String)analysisResult.getString("resultstatus"))) {
                AddResumePlugin.handleRsmAnalysisSuccess(analysisResultMap, analysisResult, positionDt, telentPoolId);
                continue;
            }
            if (!HRStringUtils.equals((String)String.valueOf(500), (String)analysisResult.getString("resultstatus"))) continue;
            LOG.error("AddResumePlugin.saveResumeAndGenerateResult() analysis fail,so add fail");
            analysisResult.set("resultstatus", (Object)500);
            analysisResult.set("result", (Object)ResumeConstants.RESULTFAIL);
            analysisResult.set("appfile", null);
        }
        if (positionDt != null) {
            AddResumeService.updatePositionCandidateNumber((DynamicObject)positionDt);
        }
        return analysisResultList;
    }

    private static void handleRsmAnalysisSuccess(Map<Long, AppResumeBo> analysisResultMap, DynamicObject analysisResult, DynamicObject positionDt, Long telentPoolId) {
        AppResumeBo resumeBo = analysisResultMap.get(analysisResult.getLong("id"));
        if (telentPoolId != null && telentPoolId != 0L) {
            resumeBo.getRsm().set("rsmsource", (Object)RsmSourceEnum.TALENT.getCode());
            resumeBo.setTalentId(telentPoolId);
        } else {
            resumeBo.getRsm().set("rsmsource", (Object)RsmSourceEnum.ANALYSIS.getCode());
        }
        SaveCandidateResult saveCandidateResult = AddResumeHandleService.getInstance().handle(resumeBo, positionDt, Boolean.TRUE, ResumeTypeEnum.ANALYSIS);
        if (saveCandidateResult.isSuccess()) {
            analysisResult.set("resultstatus", (Object)200);
            boolean isBlackList = BlacklistHelper.isBlacklist((long)saveCandidateResult.getStdRsmId());
            String result = isBlackList ? ResumeConstants.RESULT_SUCCESS_BLACK_LIST : ResumeConstants.RESULTSUCCESS;
            analysisResult.set("result", (Object)result);
            analysisResult.set("appfile", (Object)saveCandidateResult.getAppFileId());
        } else {
            LOG.error("AddResumePlugin.saveResumeAndGenerateResult() fail");
            analysisResult.set("resultstatus", (Object)500);
            analysisResult.set("result", (Object)ResumeConstants.RESULTFAIL);
            analysisResult.set("appfile", (Object)saveCandidateResult.getAppFileId());
        }
    }

    public void propertyChanged(PropertyChangedArgs eo) {
        ChangeData[] changeDataArr = eo.getChangeSet();
        if (changeDataArr == null || changeDataArr.length == 0) {
            return;
        }
        String propertyName = eo.getProperty().getName();
        if (HRStringUtils.equals((String)"email", (String)propertyName)) {
            String pageCacheId = changeDataArr[0].getDataEntity().getString("pagecacheid");
            Object emailO = changeDataArr[0].getNewValue();
            String email = Objects.toString(emailO, "");
            this.validate();
            this.putChangedIntoChche(pageCacheId, "email", email);
        } else if (HRStringUtils.equals((String)"phone", (String)propertyName)) {
            String pageCacheId = changeDataArr[0].getDataEntity().getString("pagecacheid");
            Object phoneO = changeDataArr[0].getNewValue();
            String phoneStr = Objects.toString(phoneO, "");
            this.validate();
            this.putChangedIntoChche(pageCacheId, "phone", phoneStr);
        } else if (HRStringUtils.equals((String)"fullname", (String)propertyName)) {
            String pageCacheId = changeDataArr[0].getDataEntity().getString("pagecacheid");
            Object fullNameO = changeDataArr[0].getNewValue();
            String fullName = Objects.toString(fullNameO, "");
            this.validate();
            this.putChangedIntoChche(pageCacheId, "fullname", fullName);
        }
    }

    private void pageCloseConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getResult().toString(), (String)MessageBoxResult.Yes.toString())) {
            this.getView().close();
        }
    }

    private void deleteConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryRow("resumelistlentryentity", Integer.parseInt(this.getPageCache().get("delete_rowIndex")));
            this.getPageCache().remove(this.getPageCache().get("^delete_pageCacheId"));
            FileService fs = FileServiceFactory.getAttachmentFileService();
            fs.delete(this.getPageCache().get("delete_resumePath"));
            this.getView().showSuccessNotification(SrRsmKDString.deleteSuccess());
        }
    }

    private DynamicObject generateDeliveryDt() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject recruchnlMedia = dataEntity.getDynamicObject("recruchnlmedia");
        DynamicObject appMthd = dataEntity.getDynamicObject("appmthd");
        DynamicObject resacqMthd = dataEntity.getDynamicObject("resacqmthd");
        DynamicObject recruchnlnm = dataEntity.getDynamicObject("recruchnlnm");
        return AddResumeService.generateDeliveryDt((Object)recruchnlMedia, (Object)appMthd, (Object)resacqMthd, (Object)recruchnlnm);
    }

    private boolean validate() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] analysisResultArrays = entryData.getDataEntitys();
        boolean validResult = true;
        int rowIndex = -1;
        String tip = "";
        for (DynamicObject entryEntity : analysisResultArrays) {
            String fullName;
            String checkFullNameTip;
            String resultStatus = entryEntity.getString("resultstatus");
            if (0L == entryEntity.getLong("id") || !this.checkStatucAndSetColor(resultStatus, ++rowIndex, entryGrid)) continue;
            String email = entryEntity.getString("email");
            String phone = entryEntity.getString("phone");
            String checkContactTip = this.checkContact(rowIndex, email.trim(), phone.trim());
            if (HRStringUtils.isNotEmpty((String)checkContactTip) && HRStringUtils.isEmpty((String)tip)) {
                tip = checkContactTip;
            }
            if (!HRStringUtils.isNotEmpty((String)(checkFullNameTip = this.checkFullName(rowIndex, entryEntity, fullName = entryEntity.getString("fullname")))) || !HRStringUtils.isEmpty((String)tip)) continue;
            tip = checkFullNameTip;
        }
        if (HRStringUtils.isNotEmpty((String)tip)) {
            this.getView().showTipNotification(tip);
            validResult = false;
        }
        return validResult;
    }

    private boolean checkStatucAndSetColor(String resultStatus, int rowIndex, EntryGrid entryGrid) {
        if (HRStringUtils.equals((String)String.valueOf(500), (String)resultStatus)) {
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
            int[] rowIndexs = new int[]{rowIndex};
            entryGrid.setRowLock(true, rowIndexs);
            return false;
        }
        this.changeResultForeColor(rowIndex, YesOrNotEnum.YES.value());
        return true;
    }

    private String checkFullName(int rowIndex, DynamicObject entryEntity, String fullName) {
        if (HRStringUtils.isEmpty((String)fullName)) {
            this.getModel().setValue("result", (Object)ResumeConstants.RESULT_NOTFULL, rowIndex);
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
            return SrRsmKDString.nameNull();
        }
        String fileName = entryEntity.getString("filename");
        if (AddResumePlugin.getWordCount(fileName) > RsmConstants.MAX_FILENAME_LENGTH) {
            return SrRsmKDString.fileNameTooLength();
        }
        return "";
    }

    private String checkContact(int rowIndex, String email, String phone) {
        String tip = "";
        if (HRStringUtils.isEmpty((String)email) && HRStringUtils.isEmpty((String)phone)) {
            this.getModel().setValue("result", (Object)ResumeConstants.RESULT_NOTFULL, rowIndex);
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
            tip = SrRsmKDString.phoneOrEmailMust();
        }
        if (HRStringUtils.isNotEmpty((String)phone) && !ResumeAnalysisHelper.checkPhone((String)phone)) {
            tip = SrRsmKDString.phoneError();
            this.getModel().setValue("result", (Object)tip, rowIndex);
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
        }
        if (HRStringUtils.isNotEmpty((String)email) && !ResumeAnalysisHelper.checkEmail((String)email)) {
            tip = SrRsmKDString.emailError();
            this.getModel().setValue("result", (Object)tip, rowIndex);
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
        }
        if (HRStringUtils.isNotEmpty((String)email) && email.length() > RsmConstants.MAX_EMAIL_LENGTH) {
            tip = SrRsmKDString.emailLengthError();
            this.getModel().setValue("result", (Object)tip, rowIndex);
            this.changeResultForeColor(rowIndex, YesOrNotEnum.NON.value());
        }
        if (HRStringUtils.isNotEmpty((String)tip)) {
            return tip;
        }
        this.getModel().setValue("result", (Object)ResumeConstants.RESULT_SUCCESS, rowIndex);
        this.changeResultForeColor(rowIndex, YesOrNotEnum.YES.value());
        return "";
    }

    private void changeResultForeColor(int rowIndex, int flag) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("resumelistlentryentity");
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>();
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey("result");
        cellStyle.setRow(rowIndex);
        if (flag == YesOrNotEnum.YES.value()) {
            cellStyle.setForeColor("#26B175");
        } else {
            cellStyle.setForeColor("#FD6C6A");
        }
        cellStyleList.add(cellStyle);
        entryGrid.setCellStyle(cellStyleList);
    }

    private static int getWordCount(String inputStr) {
        inputStr = inputStr.replaceAll("[^\\x00-\\xff]", "**");
        return inputStr.length();
    }

    private void putChangedIntoChche(String pageCacheId, String fieldName, String newValue) {
        AppResumeBo resumeBo = (AppResumeBo)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(pageCacheId));
        if (resumeBo != null) {
            DynamicObject resumeDt = resumeBo.getRsm();
            if (HRStringUtils.equals((String)"email", (String)fieldName)) {
                resumeDt.set("email", (Object)newValue);
            }
            if (HRStringUtils.equals((String)"phone", (String)fieldName)) {
                resumeDt.set("phone", (Object)newValue);
            }
            if (HRStringUtils.equals((String)"fullname", (String)fieldName)) {
                resumeDt.set("fullname", (Object)newValue);
            }
            String cacheString = SerializationUtils.serializeToBase64((Object)resumeBo);
            this.getPageCache().put(pageCacheId, cacheString);
        }
    }
}

