/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmCommonHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;
import kd.tsc.tsirm.business.domain.rsm.sr.service.PreRsmService;
import kd.tsc.tsirm.business.domain.rsm.sr.service.RsmService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.RsmConstants;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeUtilsHelper;

public class RsmCompleteEdit
extends HRDataBaseEdit {
    private static final String KEY_ADDEDUEXPFLEX = "flexpanelap";
    private static final String KEY_ADDWORKEXPFLEX = "flexpanelap1";
    private static final String KEY_ADDPRJEXPFLEX = "flexpanelap11";
    private static final String KEY_ADDWORKRELAFLEX = "addworkrrelaflexpanelap";
    private static final String KEY_ADDLANGABLFLEX = "addlangablflexpanelap";
    private static final String KEY_ATTACHMENT = "attachmentpanelap";

    public void preOpenForm(PreOpenFormEventArgs ef) {
    }

    public void beforeBindData(EventObject eo) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        int status = showParameter.getStatusValue();
        IPageCache pageCache = this.getPageCache();
        if (status == OperationStatus.ADDNEW.getValue()) {
            pageCache.put("key_checkchange_cache", "1");
            RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"panel_applyinfo"});
        } else {
            pageCache.put("key_checkchange_cache", "0");
            RsmCommonHelper.showSimpleRsm((IFormView)this.getView(), (boolean)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"panel_applyinfo"});
            if (status == OperationStatus.EDIT.getValue()) {
                this.setPerInfoDisEdit();
                this.setConInfoDisEdit();
                this.setAttachmentDisEdit();
            } else if (status == OperationStatus.VIEW.getValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_peredit", "bar_percancel", "bar_persave", "bar_concancel", "bar_conedit", "bar_consave", "bar_selfedit", "bar_selfsave", "bar_selfcancel", KEY_ADDEDUEXPFLEX, KEY_ADDWORKEXPFLEX, KEY_ADDPRJEXPFLEX, KEY_ADDWORKRELAFLEX, KEY_ADDLANGABLFLEX, "bar_jobintentionedit", "bar_jobintentioncancel", "bar_jobintentionsave", "bar_attachedit", "bar_attachcancel", "bar_attachsave"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ATTACHMENT});
            }
        }
    }

    public void afterBindData(EventObject eo) {
        Map attachments;
        DynamicObject cvDy;
        PageUtils.setFlexCollapsible((List)ImmutableList.of((Object)"panel_perinfo", (Object)"advpanel_tkofcexp", (Object)"advpanel_eduexp", (Object)"panel_contactinfo"), (boolean)false, (IFormView)this.getView());
        RsmHelper.reloadExpList((IFormView)this.getView());
        IDataModel model = this.getModel();
        int workMonths = model.getDataEntity().getInt("workingyears");
        RsmCommonHelper.setShowWorkYears((int)workMonths, (IFormView)this.getView());
        DynamicObject rsmEntity = this.getModel().getDataEntity();
        ResumeUtilsHelper.serialize((IPageCache)this.getPageCache(), (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)rsmEntity), (DynamicObject)rsmEntity);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(KEY_ATTACHMENT);
        if (attachmentPanel.getAttachmentData().size() == 0 && (cvDy = StdRsmServiceHelper.getCVDy((Long)rsmEntity.getLong("stdrsm"))) != null && !(attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_empcv", (Object[])new Object[]{cvDy.getLong("id")}, (String)KEY_ATTACHMENT, (boolean)true)).isEmpty()) {
            String attachmentStr = SerializationUtils.toJsonString((Object)attachments);
            this.getPageCache().put("TampAttCache" + this.getView().getPageId(), attachmentStr);
            attachmentPanel.bindData((List)attachments.values().iterator().next());
        }
    }

    public void registerListener(EventObject eo) {
        this.addClickListeners(new String[]{"btn_addeduexp", "btn_addworkexp", "btn_addprjexp", "position", "btn_addworkrelaexp", "btn_addlangexp", "btn_addposorgrel"});
        this.addItemClickListeners(new String[]{"bar_per", "bar_con", "bar_jobintention", "bar_self", "bar_attachment"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_peredit": {
                this.setPerInfoEdit();
                break;
            }
            case "bar_percancel": {
                this.checkInfoChange("panel_per");
                break;
            }
            case "bar_persave": {
                this.savePreInfo();
                break;
            }
            case "bar_attachedit": {
                this.setAttachmentEdit();
                break;
            }
            case "bar_attachcancel": {
                this.setAttachmentDisEdit();
                break;
            }
            case "bar_attachsave": {
                this.saveAttachment();
                break;
            }
            default: {
                this.handleItemClick(key);
            }
        }
    }

    private void handleItemClick(String key) {
        switch (key) {
            case "bar_conedit": {
                this.setConInfoEdit();
                break;
            }
            case "bar_concancel": {
                this.checkInfoChange("panel_contact");
                break;
            }
            case "bar_consave": {
                this.saveConInfo();
                break;
            }
        }
    }

    private void setPerInfoEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_peredit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_percancel", "bar_persave"});
            this.getView().setEnable(Boolean.TRUE, RsmConstants.KEY_PREINFO_FIELDS);
            this.cachePreInfo();
        }
    }

    private void setConInfoEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_conedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_concancel", "bar_consave"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"phone", "email"});
            this.cacheConInfo();
        }
    }

    private void setAttachmentEdit() {
        if (RsmHelper.appFileValidCanEdit((IFormView)this.getView())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_ATTACHMENT});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_attachedit"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_attachcancel", "bar_attachsave"});
        }
    }

    private void setPerInfoDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_peredit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_percancel", "bar_persave"});
        this.getView().setEnable(Boolean.FALSE, RsmConstants.KEY_PREINFO_FIELDS);
    }

    private void setConInfoDisEdit() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_conedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_concancel", "bar_consave"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"phone", "email"});
    }

    private void setAttachmentDisEdit() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ATTACHMENT});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_attachedit"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_attachcancel", "bar_attachsave"});
    }

    private void cachePreInfo() {
        IDataModel model = this.getModel();
        JSONObject preInfoJson = new JSONObject();
        for (String field : RsmConstants.KEY_PREINFO_FIELDS) {
            Object value = model.getValue(field);
            if (value instanceof Date) {
                preInfoJson.put(field, (Object)String.valueOf(((Date)value).getTime()));
                continue;
            }
            if (value instanceof DynamicObject) {
                preInfoJson.put(field, ((DynamicObject)value).get("id"));
                continue;
            }
            preInfoJson.put(field, value);
        }
        this.getView().getPageCache().put("preinfo_data_cache", preInfoJson.toJSONString());
    }

    private void cacheConInfo() {
        IDataModel model = this.getModel();
        JSONObject conInfoJson = new JSONObject();
        conInfoJson.put("phone", model.getValue("phone"));
        conInfoJson.put("email", model.getValue("email"));
        this.getView().getPageCache().put("coninfo_data_cache", conInfoJson.toJSONString());
    }

    private void checkInfoChange(String key) {
        String entityName = this.getView().getEntityId();
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(key, (IFormPlugin)this);
        if (!RsmHelper.showDataChangeForm((IFormView)this.getView(), null, (ConfirmCallBackListener)confirmCallBackListener)) {
            if (key.equals("panel_per")) {
                this.setPerInfoDisEdit();
                this.getPageCache().remove("preinfo_data_cache");
            } else if (key.equals("panel_contact")) {
                this.setConInfoDisEdit();
                this.getPageCache().remove("coninfo_data_cache");
            }
            this.getPageCache().remove(entityName);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String entityName = this.getView().getEntityId();
        if (messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.handleConfirmCallBack(messageBoxClosedEvent, entityName);
            this.getPageCache().remove(entityName);
        }
    }

    private void handleConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, String entityName) {
        String callBackId;
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "panel_per": {
                RsmService.resetPreInfo((IFormView)this.getView());
                this.setPerInfoDisEdit();
                break;
            }
            case "panel_contact": {
                RsmService.resetConInfo((IFormView)this.getView());
                this.setConInfoDisEdit();
                break;
            }
        }
    }

    private void savePreInfo() {
        if (this.validPreInfoData()) {
            this.setPerInfoDisEdit();
            IFormView formView = this.getView();
            String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
            if (!"1".equals(dataSource)) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                this.executeUpdateRsm(dataEntity);
                RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
            } else if ("1".equals(dataSource)) {
                PreRsmService.refreshPreViewOfBasic((IFormView)this.getView(), (IDataModel)this.getModel());
            }
            IPageCache pageCache = this.getPageCache();
            pageCache.remove("preinfo_data_cache");
            pageCache.remove(formView.getEntityId());
            this.showSaveSuccessTips();
            formView.sendFormAction(this.getView().getParentView());
        }
    }

    private boolean validPreInfoData() {
        IFormView view;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tips = RsmCommonHelper.checkMustInput((DynamicObject)dataEntity, (IFormView)(view = this.getView()));
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.checkAdminDivision((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().getParentView().showTipNotification(tips);
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        return true;
    }

    public boolean validConInfoData() {
        IFormView view;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String tips = RsmCommonHelper.checkPhoneEmail((DynamicObject)dataEntity, (IFormView)(view = this.getView()), (String)"phone", (String)"email");
        if (HRStringUtils.isEmpty((String)tips)) {
            tips = RsmCommonHelper.validPhoneEmail((DynamicObject)dataEntity, (IFormView)view);
        }
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.getView().getParentView().showTipNotification(tips);
            this.getView().sendFormAction(this.getView().getParentView());
            return false;
        }
        return true;
    }

    private void saveConInfo() {
        String cacheConInfoStr;
        if (!this.validConInfoData()) {
            return;
        }
        this.setConInfoDisEdit();
        IFormView formView = this.getView();
        IPageCache pageCache = formView.getPageCache();
        String dataSource = (String)formView.getFormShowParameter().getCustomParam("dataSource");
        if (!"1".equals(dataSource) && HRStringUtils.isNotEmpty((String)(cacheConInfoStr = pageCache.get("coninfo_data_cache")))) {
            JSONObject conInfoJson = JSON.parseObject((String)cacheConInfoStr);
            String cachePhone = conInfoJson.getString("phone");
            String cacheEmail = conInfoJson.getString("email");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String phone = dataEntity.getString("phone");
            String email = dataEntity.getString("email");
            if (!Objects.equals(cachePhone, phone) || !Objects.equals(cacheEmail, email)) {
                this.executeUpdateRsm(dataEntity);
                IFormView parentView = formView.getParentView();
                RsmService.refreshAppFileHeader((DynamicObject)dataEntity, (IFormView)formView.getParentView(), (IFormView)this.getView());
                parentView.getModel().setValue("phone", (Object)phone);
                parentView.getModel().setValue("email", (Object)email);
            }
        }
        pageCache.remove("coninfo_data_cache");
        pageCache.remove(formView.getEntityId());
        this.showSaveSuccessTips();
        formView.sendFormAction(this.getView().getParentView());
    }

    private void saveAttachment() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        AppResumeBo resumeBo = RsmCommonHelper.getUpdateResumeBo((DynamicObject)dataEntity, null, null);
        AttachmentPanel panel = (AttachmentPanel)this.getControl(KEY_ATTACHMENT);
        List attachmentData = panel.getAttachmentData();
        resumeBo.setAttachmentData(attachmentData);
        RsmCommonHelper.updateRsmInfo((DynamicObject)dataEntity, (AppResumeBo)resumeBo, (Boolean)Boolean.TRUE, (Boolean)Boolean.TRUE, (IPageCache)this.getPageCache());
        DynamicObject rsmEntity = this.getModel().getDataEntity();
        ResumeUtilsHelper.serialize((IPageCache)this.getPageCache(), (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)rsmEntity), (DynamicObject)rsmEntity);
        this.setAttachmentDisEdit();
    }

    private void showSaveSuccessTips() {
        this.getView().getParentView().showSuccessNotification(SrRsmKDString.saveSuccess());
    }

    public void beforeClosed(BeforeClosedEvent ec) {
        ec.setCheckDataChange(false);
        if ("1".equals(this.getPageCache().get("key_checkchange_cache"))) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("tsirm_srrsm", (IFormPlugin)this);
            ec.setCancel(RsmHelper.showDataChangeForm((IFormView)this.getView(), null, (ConfirmCallBackListener)confirmCallBackListener));
        }
    }

    private void executeUpdateRsm(DynamicObject dataEntity) {
        AppResumeBo resumeBo = RsmCommonHelper.getUpdateResumeBo((DynamicObject)dataEntity, null, null);
        boolean isDiffUpdateStdRsm = RsmCommonHelper.dataIsChanged((IPageCache)this.getPageCache(), (DynamicObject)dataEntity);
        RsmCommonHelper.updateRsmInfo((DynamicObject)dataEntity, (AppResumeBo)resumeBo, (Boolean)Boolean.TRUE, (Boolean)isDiffUpdateStdRsm, (IPageCache)this.getPageCache());
        DynamicObject rsmEntity = this.getModel().getDataEntity();
        ResumeUtilsHelper.serialize((IPageCache)this.getPageCache(), (String)RsmCommonHelper.getCacheEntityKey((DynamicObject)rsmEntity), (DynamicObject)rsmEntity);
    }
}

