/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class RsmDeliveryEdit
extends HRDataBaseEdit {
    private static final Log log = LogFactory.getLog(RsmDeliveryEdit.class);
    private static final String TAB_ORIGINALRES = "tab_originalres";
    private static final String BUTTON_PANEL = "panel_btn";

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        Button button = (Button)this.getView().getControl("btn_refresh");
        button.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btn_refresh", (String)source.getKey())) {
            this.initTab();
        }
    }

    public void afterBindData(EventObject ee) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tab_resume");
        this.initTab();
    }

    private void initTab() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_srrsm");
        long id = this.getCustomParamId();
        QFilter qFilter = new QFilter("delivery", "=", (Object)id);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(qFilter);
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            log.warn("RsmDeliveryEdit.initTab rsmDy is null");
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_ORIGINALRES});
            return;
        }
        this.loadResumeInfo(dynamicObject);
        this.getView().setVisible(Boolean.FALSE, new String[]{TAB_ORIGINALRES});
    }

    public void afterCreateNewData(EventObject ee) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BUTTON_PANEL});
        this.loadDeliveryInfo();
    }

    private void loadResumeInfo(DynamicObject dynamicObject) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_srrsm_layout");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("tab_resume");
        if (dynamicObject != null) {
            showParameter.setPkId(dynamicObject.get("id"));
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void loadOriginalResumeInfo() {
        long id = this.getCustomParamId();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_srrsm");
        QFilter qFilter = new QFilter("delivery", "=", (Object)id);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(qFilter);
        FormShowParameter showOriginalParameter = new FormShowParameter();
        showOriginalParameter.setFormId("tsirm_originalresume");
        if (dynamicObject != null && dynamicObject.get("resumestoadd") != null) {
            showOriginalParameter.setCustomParam("resumestoadd", (Object)dynamicObject.getString("resumestoadd"));
        }
        showOriginalParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showOriginalParameter.getOpenStyle().setTargetKey(TAB_ORIGINALRES);
        this.getView().showForm(showOriginalParameter);
    }

    private void loadDeliveryInfo() {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_srrdelivery");
        long id = this.getCustomParamId();
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = hrBaseServiceHelper.loadDynamicObject(qFilter);
        if (dynamicObject != null) {
            this.getModel().setValue("applytime", dynamicObject.get("applytime"));
            this.getModel().setValue("recruchnlmedia", dynamicObject.get("recruchnlmedia"));
            this.getModel().setValue("appmthd", dynamicObject.get("appmthd"));
            this.getModel().setValue("resacqmthd", dynamicObject.get("resacqmthd"));
            this.getModel().setValue("recruchnlnm", dynamicObject.get("recruchnlnm"));
            this.getModel().setValue("isfiledisplay", dynamicObject.get("isfiledisplay"));
        }
    }

    private long getCustomParamId() {
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (id instanceof Integer) {
            return Long.parseLong(String.valueOf(id));
        }
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof String) {
            return Long.parseLong((String)id);
        }
        return 0L;
    }
}

