/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.events.ChatEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RDeliveryHelper;
import kd.tsc.tsirm.common.constants.rsm.sr.SrRsmKDString;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class RsmDeliveryListEdit
extends AbstractListPlugin
implements HyperLinkClickListener,
Consumer<BeforeF7ViewDetailEvent> {
    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Button button = (Button)this.getView().getControl("btn_refresh");
        button.addClickListener((ClickListener)this);
        BasedataEdit recruposi = (BasedataEdit)this.getControl("recruposi");
        recruposi.addBeforeF7ViewDetailListener((Consumer)this);
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        BasedataEdit source = (BasedataEdit)beforeF7ViewDetailEvent.getSource();
        String fieldKey = source.getFieldKey();
        if ("recruposi".equals(fieldKey)) {
            this.popPosition(beforeF7ViewDetailEvent);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        this.openDeliveryDetails(arg0);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"btn_refresh", (String)source.getKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void chat(ChatEvent ee) {
        ee.setCancel(true);
        super.chat(ee);
    }

    public void afterCreateNewData(EventObject ee) {
        Map returnData = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Map)returnData)) {
            return;
        }
        this.initDeliveryList(returnData);
    }

    private void openDeliveryDetails(HyperLinkClickEvent arg0) {
        Long userId = TSCRequestContext.getUserId();
        EntryGrid entryGrid = (EntryGrid)arg0.getSource();
        DynamicObject[] deliveryArr = entryGrid.getEntryData().getDataEntitys();
        int rowIndex = arg0.getRowIndex();
        Long deliveryId = deliveryArr[rowIndex].getLong("id");
        HashMap<String, Long> returnData = new HashMap<String, Long>(1);
        returnData.put("id", deliveryId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_rdeliverydetails");
        showParameter.setCustomParams(returnData);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(userId + deliveryId + this.getView().getPageId());
        this.getView().showForm(showParameter);
    }

    private void popPosition(BeforeF7ViewDetailEvent beforeF7ViewDetailEvent) {
        beforeF7ViewDetailEvent.setCancel(true);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("tssrm_position_view");
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setCustomParam("name", (Object)"0");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setPkId(beforeF7ViewDetailEvent.getPkId());
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void initDeliveryList(Map<String, Object> returnData) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.setValue("number", returnData.get("number"));
        model.setValue("fullname", returnData.get("fullname"));
        model.setValue("recruposi", returnData.get("recruposi"));
        model.setValue("repeatdelnum", returnData.get("repeatdelnum"));
        DynamicObject[] deliveryArr = RDeliveryHelper.getDeliveryListByAppFileId((Long)((Long)returnData.get("id")));
        TableValueSetter tvs = new TableValueSetter(new String[]{"id", "applytime", "deliveryper", "recruchnlmedia", "appmthd", "resacqmthd", "recruchnlnm", "isfiledisplay"});
        String dotName = ".name";
        for (DynamicObject dy : deliveryArr) {
            String deliveryName = SrRsmKDString.candidate();
            DynamicObject deliveryperDy = dy.getDynamicObject("deliveryper");
            if (deliveryperDy != null) {
                deliveryName = deliveryperDy.getString("name");
            }
            tvs.addRow(new Object[]{dy.get("id"), dy.get("applytime"), deliveryName, dy.getString("recruchnlmedia" + dotName), dy.getString("appmthd" + dotName), dy.getString("resacqmthd" + dotName), dy.getString("recruchnlnm" + dotName), dy.getBoolean("isfiledisplay") ? SrRsmKDString.yes() : SrRsmKDString.no()});
        }
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.clearNoDataRow();
        model.endInit();
    }
}

