/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr.empcv;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class EmpCvBillList
extends HRDataBaseList {
    private static final Map<String, Consumer<PackageDataEvent>> PACKAGE_DATA_MAP = new HashMap<String, Consumer<PackageDataEvent>>(16);

    public EmpCvBillList() {
        PACKAGE_DATA_MAP.put("fullname", this::setFullNameHandle);
        PACKAGE_DATA_MAP.put("rsmremark", this::setRsmRemarkHandle);
        PACKAGE_DATA_MAP.put("rsmupdatetime", this::setRsmUpdateTimeHandle);
        PACKAGE_DATA_MAP.put("rsmpubscopestr", this::setRsmPubScopeHandle);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lab_setrsmremark", "lab_setrsmpubscope"});
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        Long empCvId = EmpCVHelper.getEmpCVId((Long)RequestContext.get().getCurrUserId());
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("id", "=", (Object)empCvId));
        evt.setCustomQFilters(qFilterList);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        String key = ((AbstractColumnDesc)evt.getSource()).getKey();
        if (PACKAGE_DATA_MAP.containsKey(key)) {
            PACKAGE_DATA_MAP.get(key).accept(evt);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        this.showEmpFormHandle("tsirm_empcv");
    }

    public void click(EventObject evt) {
        Label label;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label && "lab_setrsmpubscope".equals((label = (Label)source).getKey())) {
            this.showFormHandle("tsirm_setrsmpubscope");
        }
    }

    private Long getPrimaryKey() {
        return EmpCVHelper.getEmpCVId((Long)RequestContext.get().getCurrUserId());
    }

    private void setRsmPubScopeHandle(PackageDataEvent evt) {
        Optional.ofNullable(evt.getRowData().getString("rsmpubscope")).ifPresent(rsmPubScope -> {
            String rsmPubScopeStr = "A".equals(rsmPubScope) ? ResManager.loadKDString((String)"\u5bf9\u6240\u6709\u7ec4\u7ec7\u516c\u5f00", (String)"EmpCvBillList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]).concat(" >") : ("B".equals(rsmPubScope) ? ResManager.loadKDString((String)"\u5bf9\u6307\u5b9a\u7ec4\u7ec7\u516c\u5f00", (String)"EmpCvBillList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]).concat(" >") : ResManager.loadKDString((String)"\u4e0d\u516c\u5f00", (String)"EmpCvBillList_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]).concat(" >"));
            evt.setFormatValue((Object)rsmPubScopeStr);
        });
    }

    private void setRsmUpdateTimeHandle(PackageDataEvent evt) {
        Optional.ofNullable(evt.getRowData().getDate("rsmupdatetime")).ifPresent(rsmUpdateTime -> {
            String formatDate = DateUtils.formatDate((Date)rsmUpdateTime, (String)"yyyy-MM-dd");
            evt.setFormatValue((Object)(StringUtils.isEmpty((CharSequence)formatDate) ? "-" : formatDate));
        });
    }

    private void setRsmRemarkHandle(PackageDataEvent evt) {
        String rsmRemark = evt.getRowData().getString("rsmremark");
        evt.setFormatValue((Object)(StringUtils.isEmpty((CharSequence)rsmRemark) ? "-" : rsmRemark));
    }

    private void setFullNameHandle(PackageDataEvent evt) {
        Optional.ofNullable(evt.getRowData().getString("fullname")).ifPresent(fullName -> {
            String concatStr = ResManager.loadKDString((String)"{0}\u7684\u7b80\u5386", (String)"EmpCvBillList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{fullName});
            evt.setFormatValue((Object)concatStr);
        });
    }

    private void showFormHandle(String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParam("empCvId", (Object)this.getPrimaryKey());
        if ("tsirm_empcv".equals(formId)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        this.getView().showForm(showParameter);
    }

    private void showEmpFormHandle(String formId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)this.getPrimaryKey());
        if ("tsirm_empcv".equals(formId)) {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

