/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr.empcv;

import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.common.vo.BizResult;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.helper.RsmPubScopeHelper;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;

public class EmpCvHeadPlugin
extends HRDynamicFormBasePlugin
implements TipsListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"updatersm", "setpubscope"});
        Label rsmPubScope = (Label)this.getControl("rsmpubscope");
        rsmPubScope.addTipsListener((TipsListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setHeadHandle();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control vector = (Control)evt.getSource();
        if ("updatersm".equals(vector.getKey())) {
            this.updateRsmHandle();
        } else {
            this.setRsmPubScopeHandle();
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        Label label = (Label)evt.getSource();
        DynamicObject empCv = RsmPubScopeHelper.selectEmpCvById((Long)empCvId);
        String rsmPubScope = empCv.getString("rsmpubscope");
        if ("rsmpubscope".equals(label.getKey()) && !"B".equals(rsmPubScope)) {
            evt.setCancel(true);
            return;
        }
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (Objects.isNull(formshowParameter)) {
            formshowParameter = new FormShowParameter();
        }
        formshowParameter.setCustomParam("empCvId", (Object)empCvId);
        evt.setFormshowParameter(formshowParameter);
    }

    public void afterShowTips(AfterShowTipsEvent evt) {
    }

    public void updateRsmHandle() {
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
        BizResult bizResult = empCVService.updateCVFormPersonInfo(empCvId);
        if (bizResult.getSuccess().booleanValue()) {
            String message = ResManager.loadKDString((String)"\u7b80\u5386\u66f4\u65b0\u6210\u529f\u3002", (String)"EmpCvHeadPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().getParentView().showSuccessNotification(message);
        } else {
            this.getView().getParentView().showTipNotification(bizResult.getMessage());
        }
        IFormView argView = this.getView().getParentView();
        argView.invokeOperation("refresh");
        this.getView().sendFormAction(argView);
    }

    public void setRsmPubScopeHandle() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_setrsmpubscope");
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        showParameter.setCustomParam("empCvId", (Object)empCvId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        this.getView().showForm(showParameter);
    }

    private void setHeadHandle() {
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        DynamicObject empCv = RsmPubScopeHelper.selectEmpCvById((Long)empCvId);
        this.getModel().setValue("fullname", (Object)empCv.getString("fullname"));
        this.getModel().setValue("number", (Object)empCv.getString("employeenum"));
        Image image = (Image)this.getControl("photo");
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)empCv.getString("photo")));
        Optional.ofNullable(RsmPubScopeHelper.selectEmpCvPosOrgRel((Long)empCvId)).ifPresent(posOrgRel -> {
            this.getModel().setValue("compony", (Object)posOrgRel.getString("company.name"));
            this.getModel().setValue("org", (Object)posOrgRel.getString("adminorg.name"));
            this.getModel().setValue("post", (Object)posOrgRel.getString("position.name"));
        });
        String rsmPubScope = empCv.getString("rsmpubscope");
        String rsmPubScopeStr = "A".equals(rsmPubScope) ? ResManager.loadKDString((String)"\u5bf9\u6240\u6709\u7ec4\u7ec7\u516c\u5f00", (String)"EmpCvBillList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : ("B".equals(rsmPubScope) ? ResManager.loadKDString((String)"\u5bf9\u6307\u5b9a\u7ec4\u7ec7\u516c\u5f00", (String)"EmpCvBillList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u516c\u5f00", (String)"EmpCvBillList_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.valueOf("B".equals(rsmPubScope)), new String[]{"arrow"});
        Label label = (Label)this.getView().getControl("rsmpubscope");
        label.setText(rsmPubScopeStr);
    }
}

