/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr.empcv;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.helper.RsmPubScopeHelper;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;

public class EmpCvInfoPlugin
extends HRDataBaseEdit {
    private static List<Map<String, Object>> attachmentDataList = new ArrayList<Map<String, Object>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_att"});
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (args.getFormShowParameter() instanceof BillShowParameter) {
            BillShowParameter formShowParameter = (BillShowParameter)args.getFormShowParameter();
            Long cvId = Long.parseLong(formShowParameter.getPkId().toString());
            DynamicObject empCv = RsmPubScopeHelper.selectEmpCvById((Long)cvId);
            String fullName = empCv.getString("fullname");
            String concatStr = ResManager.loadKDString((String)"%s\u7684\u7b80\u5386", (String)"EmpCvInfoPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            args.getFormShowParameter().setCaption(String.format(concatStr, fullName));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setHeadHandle();
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentDataList = panel.getAttachmentData();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancel", "save"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmentpanelap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("save".equals(key)) {
            this.getModel().setValue("rsmupdatetime", (Object)new Date());
            this.getView().invokeOperation("save");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("save".equals(evt.getItemKey())) {
            AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
            attachmentDataList = panel.getAttachmentData();
            this.getModel().setValue("rsmupdatetime", (Object)new Date());
            this.getView().invokeOperation("save");
            AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
            String rsmPubScope = String.valueOf(this.getModel().getValue("rsmpubscope"));
            if (!"C".equals(rsmPubScope)) {
                DeliveryParam deliveryParam = new DeliveryParam(EmpDeliveryTypeEnum.DELIVTYPE_UPDATE, Long.valueOf(RequestContext.get().getCurrUserId()));
                empCVService.deliveryCV(deliveryParam);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "save"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        } else if ("edit".equals(evt.getItemKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancel", "save"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"attachmentpanelap"});
        } else if ("cancel".equals(evt.getItemKey())) {
            AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanelap");
            List newAttachmentDataList = panel.getAttachmentData();
            List uidList = attachmentDataList.stream().map(attachmentData -> String.valueOf(attachmentData.get("uid"))).collect(Collectors.toList());
            newAttachmentDataList.removeIf(attachmentData -> uidList.contains(String.valueOf(attachmentData.get("uid"))));
            newAttachmentDataList.forEach(arg_0 -> ((AttachmentPanel)panel).remove(arg_0));
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancel", "save"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanelap"});
        }
    }

    private void setHeadHandle() {
        Long empCvId = (Long)this.getModel().getValue("id");
        FormShowParameter showParameter = new FormShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.getOpenStyle().setTargetKey("flex_head");
        showParameter.setFormId("tsirm_empcvhead");
        showParameter.setCustomParam("empCvId", (Object)empCvId);
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.InContainer));
        this.getView().showForm(showParameter);
    }
}

