/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.rsm.sr.empcv;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.RsmPubScopeHelper;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SetRsmPubScopePlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
    private static final Map<String, Consumer<ChangeData>> ORG_MAP = new HashMap<String, Consumer<ChangeData>>(16);
    private static final Map<String, Consumer<DynamicObject>> RSMPUBSCOPE_MAP = new HashMap<String, Consumer<DynamicObject>>(16);

    public SetRsmPubScopePlugin() {
        ORG_MAP.put("pub2all", this::pub2AllHandle);
        ORG_MAP.put("pub2specify", this::pub2SpecifyHandle);
        ORG_MAP.put("notpub", this::notPubHandle);
        RSMPUBSCOPE_MAP.put("A", this::pub2AllHandle);
        RSMPUBSCOPE_MAP.put("B", this::pub2SpecifyHandle);
        RSMPUBSCOPE_MAP.put("C", this::notPubHandle);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit edit = (MulBasedataEdit)this.getView().getControl("org");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObj) {
        this.setDataHandle();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        this.setVisibleHandle(args);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
        formShowParameter.setFormId("haos_adminorghrlistf7");
        String titleStr = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7", (String)"SetRsmPubScopePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(titleStr);
        beforeF7SelectEvent.setFormShowParameter(formShowParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Donothing && args.getOperationResult().isSuccess()) {
            this.empCvHandle();
            if (this.getView().getParentView() != null && null != this.getView().getParentView().getParentView()) {
                IFormView parentView = this.getView().getParentView().getParentView();
                parentView.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SetRsmPubScopePlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.refreshParentViewHandle();
            }
        }
    }

    private void setDataHandle() {
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        DynamicObject empCv = RsmPubScopeHelper.selectEmpCvById((Long)empCvId);
        String rsmPubScope = empCv.getString("rsmpubscope");
        rsmPubScope = StringUtils.isEmpty((CharSequence)rsmPubScope) ? "C" : rsmPubScope;
        this.getModel().setValue("rsmpubscope", (Object)rsmPubScope);
        RSMPUBSCOPE_MAP.get(rsmPubScope).accept(empCv);
    }

    private void notPubHandle(DynamicObject empCv) {
        this.notPubVisibleHandle();
    }

    private void pub2SpecifyHandle(DynamicObject empCv) {
        this.pub2SpecifyVisibleHandle();
        this.getModel().setValue("pub2specify", (Object)Boolean.TRUE);
        List rsmPubScopeList = RsmPubScopeHelper.selectRsmPubScopeListByEmpCvId((Long)empCv.getLong("id"));
        DynamicObjectCollection orgList = new DynamicObjectCollection();
        rsmPubScopeList.forEach(rsmPubScope -> orgList.add((Object)rsmPubScope.getDynamicObject("org")));
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            this.getModel().setValue("org", (Object)orgList);
        }
    }

    private void pub2AllHandle(DynamicObject empCv) {
        this.pub2AllVisibleHandle();
        this.getModel().setValue("pub2all", (Object)Boolean.TRUE);
        this.getModel().setValue("isshldctorg", (Object)empCv.getBoolean("isshldctorg"));
    }

    private void refreshParentViewHandle() {
        IFormView view = this.getView().getParentView();
        view.invokeOperation("refresh");
        this.getView().sendFormAction(view);
        IFormView parentView = view.getParentView();
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private void empCvHandle() {
        Long empCvId = (Long)this.getView().getFormShowParameter().getCustomParam("empCvId");
        DynamicObject empCv = RsmPubScopeHelper.selectEmpCvById((Long)empCvId);
        empCv.set("rsmpubscope", this.getModel().getValue("rsmpubscope"));
        if ("A".equals(this.getModel().getValue("rsmpubscope"))) {
            empCv.set("isshldctorg", this.getModel().getValue("isshldctorg"));
        }
        empCv.set("rsmupdatetime", (Object)new Date());
        RsmPubScopeHelper.updateEmpCv((DynamicObject)empCv);
        String pubScope = (String)this.getModel().getValue("rsmpubscope");
        if ("B".equals(pubScope)) {
            DynamicObjectCollection selOrgList = (DynamicObjectCollection)this.getModel().getValue("org");
            if (CollectionUtils.isEmpty((Collection)selOrgList)) {
                return;
            }
            DynamicObject[] rsmPubScopes = (DynamicObject[])selOrgList.stream().map(org -> {
                DynamicObject rsmPubScope = RsmPubScopeHelper.generateRsmPubScope();
                rsmPubScope.set("org", org.get("fbasedataid"));
                rsmPubScope.set("rsm", (Object)empCvId);
                return rsmPubScope;
            }).toArray(DynamicObject[]::new);
            RsmPubScopeHelper.deleteRsmPubScopeByEmpCvId((Long)empCvId);
            RsmPubScopeHelper.insertRsmPubScope((DynamicObject[])rsmPubScopes);
        }
        if (!"C".equals(pubScope)) {
            DynamicObject empCvRel = EmpCVHelper.queryEmpCVRel((String)"entryentity.cvid", (Long)empCvId);
            long userId = empCvRel.getLong("account.id");
            DeliveryParam deliveryParam = new DeliveryParam(EmpDeliveryTypeEnum.DELIVTYPE_OPENCV, Long.valueOf(userId));
            deliveryParam.setCvId(empCvId);
            empCVService.deliveryCV(deliveryParam);
        } else {
            DynamicObject empCVRelDy = EmpCVHelper.queryEmpCVRel((String)"entryentity.cvid", (Long)empCvId);
            HRBaseServiceHelper stdRsmServiceHelper = new HRBaseServiceHelper("tsirm_stdrsm");
            QFilter qFilter = new QFilter("empid", "=", (Object)empCVRelDy.getLong("empid"));
            qFilter.and("iscurrentversion", "=", (Object)"1");
            DynamicObject stdRsmDy = stdRsmServiceHelper.queryOne("rsmpubscope", qFilter);
            if (ObjectUtils.isNotEmpty((Object)stdRsmDy)) {
                stdRsmDy.set("rsmpubscope", (Object)"C");
                stdRsmServiceHelper.updateOne(stdRsmDy);
            }
        }
    }

    private void setVisibleHandle(PropertyChangedArgs args) {
        String keyName = args.getProperty().getName();
        if (ORG_MAP.containsKey(keyName)) {
            ORG_MAP.get(keyName).accept(args.getChangeSet()[0]);
        }
    }

    private void notPubHandle(ChangeData changeData) {
        Boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue.booleanValue()) {
            this.notPubVisibleHandle();
        } else {
            Boolean isPub2All = (Boolean)this.getModel().getValue("pub2all");
            Boolean isPub2Specify = (Boolean)this.getModel().getValue("pub2specify");
            if (!isPub2All.booleanValue() && !isPub2Specify.booleanValue()) {
                this.getModel().setValue("notpub", (Object)Boolean.TRUE);
            }
        }
    }

    private void notPubVisibleHandle() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"notpub_lab"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pub2all_lab", "pub2specify_lab", "isshldctorg", "org"});
        this.getModel().setValue("pub2all", (Object)Boolean.FALSE);
        this.getModel().setValue("pub2specify", (Object)Boolean.FALSE);
        this.getModel().setValue("rsmpubscope", (Object)"C");
    }

    private void pub2SpecifyHandle(ChangeData changeData) {
        Boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue.booleanValue()) {
            this.pub2SpecifyVisibleHandle();
        } else {
            Boolean isPub2All = (Boolean)this.getModel().getValue("pub2all");
            Boolean isNotPub = (Boolean)this.getModel().getValue("notpub");
            if (!isPub2All.booleanValue() && !isNotPub.booleanValue()) {
                this.getModel().setValue("pub2specify", (Object)Boolean.TRUE);
                return;
            }
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("org");
            mulBasedataEdit.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"org"});
        }
    }

    private void pub2SpecifyVisibleHandle() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"org", "pub2specify_lab"});
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("org");
        mulBasedataEdit.setMustInput(true);
        this.getView().setVisible(Boolean.FALSE, new String[]{"pub2all_lab", "notpub_lab", "isshldctorg"});
        this.getModel().setValue("pub2all", (Object)Boolean.FALSE);
        this.getModel().setValue("notpub", (Object)Boolean.FALSE);
        this.getModel().setValue("rsmpubscope", (Object)"B");
    }

    private void pub2AllHandle(ChangeData changeData) {
        Boolean newValue = (Boolean)changeData.getNewValue();
        if (newValue.booleanValue()) {
            this.pub2AllVisibleHandle();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isshldctorg"});
            Boolean isPub2Specify = (Boolean)this.getModel().getValue("pub2specify");
            Boolean isNotPub = (Boolean)this.getModel().getValue("notpub");
            if (!isPub2Specify.booleanValue() && !isNotPub.booleanValue()) {
                this.getModel().setValue("pub2all", (Object)Boolean.TRUE);
            }
        }
    }

    private void pub2AllVisibleHandle() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"isshldctorg", "pub2all_lab"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"pub2specify_lab", "notpub_lab", "org"});
        this.getModel().setValue("pub2specify", (Object)Boolean.FALSE);
        this.getModel().setValue("notpub", (Object)Boolean.FALSE);
        this.getModel().setValue("rsmpubscope", (Object)"A");
    }
}

